/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.jlibtorrent;

import com.frostwire.jlibtorrent.AnnounceEntry;
import com.frostwire.jlibtorrent.Entry;
import com.frostwire.jlibtorrent.FileSlice;
import com.frostwire.jlibtorrent.FileStorage;
import com.frostwire.jlibtorrent.Files;
import com.frostwire.jlibtorrent.Logger;
import com.frostwire.jlibtorrent.Pair;
import com.frostwire.jlibtorrent.PeerRequest;
import com.frostwire.jlibtorrent.Sha1Hash;
import com.frostwire.jlibtorrent.Sha256Hash;
import com.frostwire.jlibtorrent.Vectors;
import com.frostwire.jlibtorrent.WebSeedEntry;
import com.frostwire.jlibtorrent.swig.announce_entry;
import com.frostwire.jlibtorrent.swig.announce_entry_vector;
import com.frostwire.jlibtorrent.swig.bdecode_node;
import com.frostwire.jlibtorrent.swig.byte_vector;
import com.frostwire.jlibtorrent.swig.create_torrent;
import com.frostwire.jlibtorrent.swig.error_code;
import com.frostwire.jlibtorrent.swig.info_hash_t;
import com.frostwire.jlibtorrent.swig.libtorrent;
import com.frostwire.jlibtorrent.swig.libtorrent_jni;
import com.frostwire.jlibtorrent.swig.sha1_hash;
import com.frostwire.jlibtorrent.swig.sha1_hash_vector;
import com.frostwire.jlibtorrent.swig.sha256_hash;
import com.frostwire.jlibtorrent.swig.string_int_pair;
import com.frostwire.jlibtorrent.swig.string_int_pair_vector;
import com.frostwire.jlibtorrent.swig.string_string_pair_vector;
import com.frostwire.jlibtorrent.swig.string_vector;
import com.frostwire.jlibtorrent.swig.torrent_info;
import com.frostwire.jlibtorrent.swig.web_seed_entry_vector;
import java.io.File;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.util.ArrayList;
import java.util.List;

public final class TorrentInfo {
    private static Logger LOG = Logger.getLogger(TorrentInfo.class);
    private final torrent_info ti;

    public TorrentInfo(torrent_info ti) {
        this.ti = ti;
    }

    public TorrentInfo(File torrent) {
        this(TorrentInfo.bdecode0(torrent));
    }

    public TorrentInfo(byte[] data) {
        this(TorrentInfo.bdecode0(data));
    }

    public TorrentInfo(MappedByteBuffer buffer) {
        try {
            long ptr = libtorrent_jni.directBufferAddress(buffer);
            long size = libtorrent_jni.directBufferCapacity(buffer);
            error_code ec = new error_code();
            this.ti = new torrent_info(ptr, (int)size, ec);
            if (ec.value() != 0) {
                throw new IllegalArgumentException("Can't decode data: " + ec.message());
            }
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Can't decode data mapped buffer: " + e.getMessage(), e);
        }
    }

    public torrent_info swig() {
        return this.ti;
    }

    public FileStorage files() {
        return new FileStorage(this.ti.files(), this.ti);
    }

    public FileStorage origFiles() {
        return new FileStorage(this.ti.orig_files(), this.ti);
    }

    public void renameFile(int index, String newFilename) {
        this.ti.rename_file(index, newFilename);
    }

    public void remapFiles(FileStorage f) {
        this.ti.remap_files(f.swig());
    }

    public void addTracker(String url) {
        this.ti.add_tracker(url);
    }

    public void addTracker(String url, int tier) {
        this.ti.add_tracker(url, tier);
    }

    public ArrayList<AnnounceEntry> trackers() {
        return TorrentInfo.trackers(this.ti.trackers());
    }

    public ArrayList<Sha1Hash> similarTorrents() {
        sha1_hash_vector vec = this.ti.similar_torrents();
        ArrayList<Sha1Hash> result = new ArrayList<Sha1Hash>(vec.size());
        for (int i = 0; i < vec.size(); ++i) {
            result.add(new Sha1Hash(vec.get(i)));
        }
        return result;
    }

    public ArrayList<String> collections() {
        string_vector v = this.ti.collections();
        int size = v.size();
        ArrayList<String> l = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            l.add(v.get(i));
        }
        return l;
    }

    public void clearTrackers() {
        this.ti.trackers().clear();
    }

    public void addUrlSeed(String url) {
        this.ti.add_url_seed(url);
    }

    public void addUrlSeed(String url, String externAuth) {
        this.ti.add_url_seed(url, externAuth);
    }

    public void addUrlSeed(String url, String externAuth, List<Pair<String, String>> extraHeaders) {
        string_string_pair_vector v = new string_string_pair_vector();
        for (Pair<String, String> p : extraHeaders) {
            v.add(p.to_string_string_pair());
        }
        this.ti.add_url_seed(url, externAuth, v);
    }

    public void addHttpSeed(String url) {
        this.ti.add_url_seed(url);
    }

    public void addHttpSeed(String url, String externAuth) {
        this.ti.add_url_seed(url, externAuth);
    }

    public void addHttpSeed(String url, String externAuth, List<Pair<String, String>> extraHeaders) {
        string_string_pair_vector v = new string_string_pair_vector();
        for (Pair<String, String> p : extraHeaders) {
            v.add(p.to_string_string_pair());
        }
        this.ti.add_url_seed(url, externAuth, v);
    }

    public ArrayList<WebSeedEntry> webSeeds() {
        web_seed_entry_vector v = this.ti.web_seeds();
        int size = v.size();
        ArrayList<WebSeedEntry> l = new ArrayList<WebSeedEntry>(size);
        for (int i = 0; i < size; ++i) {
            l.add(new WebSeedEntry(v.get(i)));
        }
        return l;
    }

    public void setWebSeeds(List<WebSeedEntry> seeds) {
        web_seed_entry_vector v = new web_seed_entry_vector();
        for (WebSeedEntry e : seeds) {
            v.add(e.swig());
        }
        this.ti.set_web_seeds(v);
    }

    public long totalSize() {
        return this.ti.total_size();
    }

    public int pieceLength() {
        return this.ti.piece_length();
    }

    public int numPieces() {
        return this.ti.num_pieces();
    }

    public Sha1Hash infoHashV1() {
        info_hash_t infohashes = this.ti.info_hashes();
        if (!infohashes.has_v1()) {
            LOG.error("TorrentInfo.infoHashV1(): Torrent does not have v1 info-hash");
            return null;
        }
        sha1_hash h = this.ti.info_hashes().getV1();
        if (h.is_all_zeros()) {
            LOG.error("TorrentInfo.infoHashV1(): Torrent v1 info-hash is all zeros");
            return null;
        }
        return new Sha1Hash(h);
    }

    public Sha256Hash infoHashV2() {
        info_hash_t infohashes = this.ti.info_hashes();
        if (!infohashes.has_v2()) {
            LOG.error("TorrentInfo.infoHashV2(): Torrent does not have v2 info-hash");
            return null;
        }
        sha256_hash h = this.ti.info_hashes().getV2();
        if (h.is_all_zeros()) {
            LOG.error("TorrentInfo.infoHashV2(): Torrent v2 info-hash is all zeros");
            return null;
        }
        return new Sha256Hash(h);
    }

    public info_hash_t infoHashType() {
        return this.ti.info_hashes();
    }

    public int numFiles() {
        return this.ti.num_files();
    }

    public ArrayList<FileSlice> mapBlock(int piece, long offset, int size) {
        return FileStorage.mapBlock(this.ti.map_block(piece, offset, size));
    }

    public PeerRequest mapFile(int file, long offset, int size) {
        return new PeerRequest(this.ti.map_file(file, offset, size));
    }

    byte[] sslCert() {
        byte_vector v = Vectors.ascii2byte_vector(this.ti.get_ssl_cert());
        return Vectors.byte_vector2bytes(v);
    }

    public boolean isValid() {
        return this.ti.is_valid();
    }

    public boolean isPrivate() {
        return this.ti.priv();
    }

    public boolean isI2p() {
        return this.ti.is_i2p();
    }

    public int pieceSize(int index) {
        return this.ti.piece_size(index);
    }

    public Sha1Hash hashForPiece(int index) {
        return new Sha1Hash(this.ti.hash_for_piece(index));
    }

    public boolean isLoaded() {
        return this.ti.is_loaded();
    }

    public String name() {
        return this.ti.name();
    }

    public long creationDate() {
        return this.ti.creation_date();
    }

    public String creator() {
        return this.ti.creator();
    }

    public String comment() {
        return this.ti.comment();
    }

    public ArrayList<Pair<String, Integer>> nodes() {
        string_int_pair_vector v = this.ti.nodes();
        int size = v.size();
        ArrayList<Pair<String, Integer>> l = new ArrayList<Pair<String, Integer>>(size);
        for (int i = 0; i < size; ++i) {
            string_int_pair p = v.get(i);
            l.add(new Pair<String, Integer>(p.getFirst(), p.getSecond()));
        }
        return l;
    }

    public void addNode(String host, int port) {
        this.ti.add_node(new string_int_pair(host, port));
    }

    public bdecode_node info(String key) {
        return this.ti.info(key);
    }

    public String makeMagnetUri() {
        return this.ti.is_valid() ? libtorrent.make_magnet_uri(this.ti) : null;
    }

    public Entry toEntry() {
        return new Entry(new create_torrent(this.ti).generate());
    }

    public byte[] bencode() {
        return this.toEntry().bencode();
    }

    public static TorrentInfo bdecode(byte[] data) {
        return new TorrentInfo(TorrentInfo.bdecode0(data));
    }

    static ArrayList<AnnounceEntry> trackers(announce_entry_vector v) {
        int size = v.size();
        ArrayList<AnnounceEntry> l = new ArrayList<AnnounceEntry>(size);
        for (announce_entry announceEntry : v) {
            l.add(new AnnounceEntry(announceEntry));
        }
        return l;
    }

    private static torrent_info bdecode0(File file) {
        try {
            byte[] data = Files.bytes(file);
            return TorrentInfo.bdecode0(data);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can't decode data from file: " + String.valueOf(file), e);
        }
    }

    private static torrent_info bdecode0(byte[] data) {
        error_code ec;
        bdecode_node n;
        byte_vector buffer = Vectors.bytes2byte_vector(data);
        int ret = bdecode_node.bdecode(buffer, n = new bdecode_node(), ec = new error_code());
        if (ret == 0) {
            ec.clear();
            torrent_info ti = new torrent_info(n, ec);
            buffer.clear();
            if (ec.value() != 0) {
                throw new IllegalArgumentException("Can't decode data: " + ec.message());
            }
            return ti;
        }
        throw new IllegalArgumentException("Can't decode data: " + ec.message());
    }
}

