/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.jlibtorrent;

import com.frostwire.jlibtorrent.Hex;
import com.frostwire.jlibtorrent.Vectors;
import com.frostwire.jlibtorrent.swig.sha256_hash;
import com.frostwire.jlibtorrent.swig.sha256_hash_vector;
import java.util.ArrayList;

public final class Sha256Hash
implements Comparable<Sha256Hash>,
Cloneable {
    private final sha256_hash h;

    public Sha256Hash(sha256_hash h) {
        this.h = h;
    }

    public Sha256Hash() {
        this(new sha256_hash());
    }

    public Sha256Hash(byte[] bytes) {
        if (bytes.length != 32) {
            throw new IllegalArgumentException("Sha256Hash(byte[]) bytes array must be of length 32");
        }
        this.h = new sha256_hash(Vectors.bytes2byte_vector(bytes));
    }

    public Sha256Hash(String hex) {
        this(Hex.decode(hex));
    }

    public void clear() {
        this.h.clear();
    }

    public boolean isAllZeros() {
        return this.h.is_all_zeros();
    }

    public int countLeadingZeroes() {
        return this.h.count_leading_zeroes();
    }

    public String toHex() {
        return this.h.to_hex();
    }

    @Override
    public int compareTo(Sha256Hash o) {
        return sha256_hash.compare(this.h, o.h);
    }

    public String toString() {
        return this.toHex();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Sha256Hash)) {
            return false;
        }
        return this.h.op_eq(((Sha256Hash)obj).h);
    }

    public int hashCode() {
        return this.h.hash_code();
    }

    public Sha256Hash clone() {
        return new Sha256Hash(new sha256_hash(this.h));
    }

    public static Sha256Hash max() {
        return new Sha256Hash(sha256_hash.max());
    }

    public static Sha256Hash min() {
        return new Sha256Hash(sha256_hash.min());
    }

    static ArrayList<Sha256Hash> convert(sha256_hash_vector v) {
        ArrayList<Sha256Hash> l = new ArrayList<Sha256Hash>(v.size());
        for (sha256_hash hash : v) {
            l.add(new Sha256Hash(hash));
        }
        return l;
    }

    public sha256_hash swig() {
        return this.h;
    }
}

