/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.jlibtorrent;

import com.frostwire.jlibtorrent.FileSlice;
import com.frostwire.jlibtorrent.PeerRequest;
import com.frostwire.jlibtorrent.Sha1Hash;
import com.frostwire.jlibtorrent.swig.error_code;
import com.frostwire.jlibtorrent.swig.file_flags_t;
import com.frostwire.jlibtorrent.swig.file_slice_vector;
import com.frostwire.jlibtorrent.swig.file_storage;
import com.frostwire.jlibtorrent.swig.string_vector;
import com.frostwire.jlibtorrent.swig.torrent_info;
import java.io.File;
import java.util.ArrayList;

public final class FileStorage {
    private final file_storage fs;
    private final torrent_info ti;
    public static final file_flags_t FLAG_PAD_FILE = file_storage.flag_pad_file;
    public static final file_flags_t FLAG_HIDDEN = file_storage.flag_hidden;
    public static final file_flags_t FLAG_EXECUTABLE = file_storage.flag_executable;
    public static final file_flags_t FLAG_SYMLINK = file_storage.flag_symlink;

    public FileStorage(file_storage fs) {
        this(fs, null);
    }

    FileStorage(file_storage fs, torrent_info ti) {
        this.fs = fs;
        this.ti = ti;
    }

    public file_storage swig() {
        return this.fs;
    }

    public torrent_info ti() {
        return this.ti;
    }

    public boolean isValid() {
        return this.fs.is_valid();
    }

    public void reserve(int numFiles) {
        this.fs.reserve(numFiles);
    }

    public void addFile(String path, long size, file_flags_t flags, int mtime, String symlink) {
        error_code ec = new error_code();
        this.fs.add_file_ex(ec, path, size, flags, mtime, symlink);
        if (ec.value() != 0) {
            throw new IllegalArgumentException(ec.message());
        }
    }

    public void addFile(String path, long size, file_flags_t flags, int mtime) {
        error_code ec = new error_code();
        this.fs.add_file_ex(ec, path, size, flags, mtime);
        if (ec.value() != 0) {
            throw new IllegalArgumentException(ec.message());
        }
    }

    public void addFile(String path, long size, file_flags_t flags) {
        error_code ec = new error_code();
        this.fs.add_file_ex(ec, path, size, flags);
        if (ec.value() != 0) {
            throw new IllegalArgumentException(ec.message());
        }
    }

    public void addFile(String p, long size) {
        error_code ec = new error_code();
        this.fs.add_file_ex(ec, p, size);
        if (ec.value() != 0) {
            throw new IllegalArgumentException(ec.message());
        }
    }

    public void renameFile(int index, String newFilename) {
        this.fs.rename_file(index, newFilename);
    }

    public ArrayList<FileSlice> mapBlock(int piece, long offset, int size) {
        return FileStorage.mapBlock(this.fs.map_block(piece, offset, size));
    }

    public PeerRequest mapFile(int file, long offset, int size) {
        return new PeerRequest(this.fs.map_file(file, offset, size));
    }

    public int numFiles() {
        return this.fs.num_files();
    }

    public long totalSize() {
        return this.fs.total_size();
    }

    public int numPieces() {
        return this.fs.num_pieces();
    }

    public void numPieces(int n) {
        this.fs.set_num_pieces(n);
    }

    public int pieceLength() {
        return this.fs.piece_length();
    }

    public void pieceLength(int l) {
        this.fs.set_piece_length(l);
    }

    public int pieceSize(int index) {
        return this.fs.piece_size(index);
    }

    public String name() {
        return this.fs.name();
    }

    public void name(String name) {
        this.fs.set_name(name);
    }

    public Sha1Hash hash(int index) {
        return new Sha1Hash(this.fs.hash(index));
    }

    public String filePath(int index, String savePath) {
        return savePath + File.separator + this.fs.file_path(index);
    }

    public String filePath(int index) {
        return this.fs.file_path(index);
    }

    public String fileName(int index) {
        return this.fs.file_name_ex(index);
    }

    public long fileSize(int index) {
        return this.fs.file_size(index);
    }

    public boolean padFileAt(int index) {
        return this.fs.pad_file_at(index);
    }

    public long fileOffset(int index) {
        return this.fs.file_offset(index);
    }

    public ArrayList<String> paths() {
        string_vector v = this.fs.file_paths_ex();
        int size = v.size();
        ArrayList<String> l = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            l.add(v.get(i));
        }
        return l;
    }

    public file_flags_t fileFlags(int index) {
        return this.fs.file_flags(index);
    }

    public boolean fileAbsolutePath(int index) {
        return this.fs.file_absolute_path(index);
    }

    public int fileIndexAtOffset(long offset) {
        return this.fs.file_index_at_offset(offset);
    }

    static ArrayList<FileSlice> mapBlock(file_slice_vector v) {
        int size = v.size();
        ArrayList<FileSlice> l = new ArrayList<FileSlice>(size);
        for (int i = 0; i < size; ++i) {
            l.add(new FileSlice(v.get(i)));
        }
        return l;
    }
}

