/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.jlibtorrent;

import com.frostwire.jlibtorrent.Vectors;
import com.frostwire.jlibtorrent.swig.bdecode_node;
import com.frostwire.jlibtorrent.swig.byte_vector;
import com.frostwire.jlibtorrent.swig.error_code;

public final class BDecodeNode {
    private final bdecode_node n;
    private final byte_vector buffer;

    public BDecodeNode(bdecode_node n) {
        this(n, null);
    }

    public BDecodeNode(bdecode_node n, byte_vector buffer) {
        this.n = n;
        this.buffer = buffer;
    }

    public bdecode_node swig() {
        return this.n;
    }

    public byte_vector buffer() {
        return this.buffer;
    }

    public String toString() {
        return bdecode_node.to_string(this.n, false, 2);
    }

    public boolean hasList(String key) {
        if (this.n.type() == bdecode_node.type_t.none_t) {
            return false;
        }
        bdecode_node target_node = this.n.dict_find_list_s(key);
        return target_node.type() != bdecode_node.type_t.none_t;
    }

    public boolean hasDict(String key) {
        if (this.n.type() == bdecode_node.type_t.none_t) {
            return false;
        }
        bdecode_node target_node = this.n.dict_find_dict_s(key);
        return target_node.type() != bdecode_node.type_t.none_t;
    }

    public boolean hasString(String key) {
        if (this.n.type() == bdecode_node.type_t.none_t) {
            return false;
        }
        return this.n.dict_find_string_value_s(key) != null;
    }

    public boolean hasInt(String key) {
        if (this.n.type() != bdecode_node.type_t.int_t) {
            return false;
        }
        return this.n.dict_find_int_value_s(key, 0L) != 0L;
    }

    public BDecodeNode getList(String key) {
        if (!this.hasList(key)) {
            return null;
        }
        BDecodeNode result = new BDecodeNode(this.n.dict_find_list_s(key));
        return result;
    }

    public BDecodeNode getDict(String key) {
        if (!this.hasDict(key)) {
            return null;
        }
        BDecodeNode result = new BDecodeNode(this.n.dict_find_dict_s(key));
        return result;
    }

    public String getString(String key) {
        if (this.n.type() == bdecode_node.type_t.none_t) {
            return null;
        }
        return this.n.dict_find_string_value_s(key);
    }

    public long getInt(String key) {
        if (this.n.type() != bdecode_node.type_t.int_t) {
            return 0L;
        }
        return this.n.dict_find_int_value_s(key, 0L);
    }

    public static BDecodeNode bdecode(byte[] data) {
        error_code ec;
        bdecode_node n;
        byte_vector buffer = Vectors.bytes2byte_vector(data);
        int ret = bdecode_node.bdecode(buffer, n = new bdecode_node(), ec = new error_code());
        if (ret == 0) {
            return new BDecodeNode(n, buffer);
        }
        throw new IllegalArgumentException("Can't decode data: " + ec.message());
    }
}

