/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.jlibtorrent;

import com.frostwire.jlibtorrent.swig.address;
import com.frostwire.jlibtorrent.swig.error_code;

public final class Address
implements Comparable<Address>,
Cloneable {
    private final address addr;

    public Address(address addr) {
        this.addr = addr;
    }

    public Address(String ip) {
        error_code ec = new error_code();
        this.addr = address.from_string(ip, ec);
        if (ec.value() != 0) {
            throw new IllegalArgumentException(ec.message());
        }
    }

    public Address() {
        this(new address());
    }

    public address swig() {
        return this.addr;
    }

    public boolean isV4() {
        return this.addr.is_v4();
    }

    public boolean isV6() {
        return this.addr.is_v6();
    }

    public boolean isLoopback() {
        return this.addr.is_loopback();
    }

    public boolean isUnspecified() {
        return this.addr.is_unspecified();
    }

    public boolean isMulticast() {
        return this.addr.is_multicast();
    }

    @Override
    public int compareTo(Address o) {
        return address.compare(this.addr, o.addr);
    }

    public String toString() {
        return this.addr.to_string();
    }

    public Address clone() {
        return new Address(new address(this.addr));
    }
}

