/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.1
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package com.frostwire.jlibtorrent.swig;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;

public class libtorrent_jni {


    public static String jlibtorrentVersion() {
        // extracted from the gradle with the run-swig step
        return "2.0.12.5";
    }

    public static boolean isMacOS() {
      String os = System.getProperty("os.name").toLowerCase(java.util.Locale.US);
      return os.startsWith("mac os");
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase(java.util.Locale.US).contains("win");
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").toLowerCase(java.util.Locale.US).contains("linux");
    }

    public static boolean isAndroid() {
        return System.getProperty("java.runtime.name").toLowerCase(java.util.Locale.US).contains("android");
    }

    public static String getMacOSLibraryName() {
      String os_arch = System.getProperty("os.arch");
      if ("aarch64".equals(os_arch)) {
        return "jlibtorrent.arm64";
      }
      return "jlibtorrent." + os_arch;
    }

/**
     * Loads the jlibtorrent native library from the classpath (e.g., lib/arm64/libjlibtorrent.arm64-${JLIBTORRENT_VERSION}.dylib).
     * @return The absolute path to the extracted temporary file, or null if an IOException occurs.
     * @throws IOException If the library cannot be extracted or loaded.
     */
    private static String loadJlibtorrentJNIFromClassloaderResource() throws java.io.IOException {
        String os = System.getProperty("os.name").toLowerCase(java.util.Locale.US);
        String arch = System.getProperty("os.arch").toLowerCase(java.util.Locale.US);
        boolean isArm64 = arch.equals("aarch64") || arch.equals("arm64");
        String version = jlibtorrentVersion();
        String libraryName;
        String pathToLibraryInJar;

        // Determine platform-specific library path
        if (isWindows()) {
            libraryName = "jlibtorrent-" + version;
            pathToLibraryInJar = "lib/x86_64/" + libraryName + ".dll";
        } else if (isLinux() && !isAndroid()) {
            libraryName = "libjlibtorrent-" + version;
            pathToLibraryInJar = "lib/x86_64/" + libraryName + ".so";
        } else if (isMacOS()) {
            if (isArm64) {
                libraryName = "libjlibtorrent.arm64-" + version;
                pathToLibraryInJar = "lib/arm64/" + libraryName + ".dylib";
            } else {
                libraryName = "libjlibtorrent.x86_64-" + version;
                pathToLibraryInJar = "lib/x86_64/" + libraryName + ".dylib";
            }
        } else if (isAndroid()) {
            if (isArm64) {
                libraryName = "libjlibtorrent-" + version;
                pathToLibraryInJar = "lib/arm64-v8a/" + libraryName + ".so";
            } else if (arch.equals("arm")) {
                libraryName = "libjlibtorrent-" + version;
                pathToLibraryInJar = "lib/armeabi-v7a/" + libraryName + ".so";
            } else if (arch.equals("x86_64")) {
                libraryName = "libjlibtorrent-" + version;
                pathToLibraryInJar = "lib/x86_64/" + libraryName + ".so";
            } else if (arch.equals("x86")) {
                libraryName = "libjlibtorrent-" + version;
                pathToLibraryInJar = "lib/x86/" + libraryName + ".so";
            } else {
                throw new java.io.IOException("Unsupported Android architecture: " + arch);
            }
        } else {
            throw new java.io.IOException("Unsupported OS: " + os);
        }

        try {
            // Get the native library resource from the classpath
            InputStream libStream = libtorrent_jni.class.getClassLoader().getResourceAsStream(pathToLibraryInJar);
            if (libStream == null) {
                System.err.println("jlibtorrent: Could not find native library in JAR: " + pathToLibraryInJar);
                throw new FileNotFoundException("Could not find native library in JAR: " + pathToLibraryInJar);
            }

            // Create temp file
            String suffix = pathToLibraryInJar.substring(pathToLibraryInJar.lastIndexOf('.')); // e.g., ".dylib"
            Path tempLib = Files.createTempFile("jlibtorrent-", suffix);
            tempLib.toFile().deleteOnExit();

            // Extract to temp file
            try (InputStream in = libStream) {
                Files.copy(in, tempLib, StandardCopyOption.REPLACE_EXISTING);
            }

            // Load the library
            String absolutePath = tempLib.toAbsolutePath().toString();
            System.out.println("jlibtorrent: Extracted and loading native library from classpath to: " + absolutePath);
            System.load(absolutePath);
            return absolutePath;
        } catch (IOException e) {
            System.err.println("jlibtorrent: Failed to extract/load native library: " + e.getMessage());
            return null;
        }
    }

    static {
        try {
            // Try loading from classpath resource first
            try {
                System.out.println("jlibtorrent: Trying to load jlibtorrent from classpath resource");
                String loadedPath = loadJlibtorrentJNIFromClassloaderResource();
                if (loadedPath != null) {
                    System.out.println("jlibtorrent: SUCCESS: Loaded jlibtorrent from classpath resource (version=" + jlibtorrentVersion() + ")");
                } else {
                    throw new LinkageError("Failed to load jlibtorrent from classpath resource");
                }
            } catch (Throwable e) {
                System.err.println("jlibtorrent: Failed to load from classpath resource: " + e.getMessage());
                // Fall back to System.loadLibrary
                try {
                    String jlibtorrentLibraryName = "jlibtorrent";
                    if (isMacOS()) {
                        jlibtorrentLibraryName = getMacOSLibraryName();
                    }
                    System.out.println("jlibtorrent: Trying to load jlibtorrent without version number: " + jlibtorrentLibraryName + ".<so|dylib>...");
                    System.loadLibrary(jlibtorrentLibraryName);
                    System.out.println("jlibtorrent: SUCCESS: Loaded jlibtorrent.<so|dylib> (version=" + jlibtorrentVersion() + ")");
                } catch (LinkageError ignored) {
                    // Try with version number
                    try {
                        String versionedLibraryName = "jlibtorrent-" + jlibtorrentVersion();
                        System.out.println("jlibtorrent: FAILED: Trying to load jlibtorrent with version number: " + versionedLibraryName);
                        System.loadLibrary(versionedLibraryName);
                        System.out.println("jlibtorrent: SUCCESS: Loaded jlibtorrent-" + jlibtorrentVersion());
                    } catch (LinkageError e2) {
                        // Try jlibtorrent.jni.path
                        String path = System.getProperty("jlibtorrent.jni.path", "");
                        if (!"".equals(path)) {
                            System.out.println("jlibtorrent: Trying to load jlibtorrent through system property jlibtorrent.jni.path=" + path);
                            System.load(path);
                            System.out.println("jlibtorrent: SUCCESS: Loaded jlibtorrent through jlibtorrent.jni.path parameter");
                        } else {
                            throw new LinkageError("Failed to load jlibtorrent after all attempts");
                        }
                    }
                }
            }
        } catch (LinkageError e) {
            System.err.println("jlibtorrent: FAILED to load native library: " + e.getMessage());
            throw new LinkageError("Look for your architecture binary instructions at: https://github.com/frostwire/frostwire-jlibtorrent", e);
        }
    }

    public static final native long directBufferAddress(java.nio.Buffer buffer);
    public static final native long directBufferCapacity(java.nio.Buffer buffer);

  public final static native long new_int_byte_pair__SWIG_0();
  public final static native long new_int_byte_pair__SWIG_1(int jarg1, byte jarg2);
  public final static native long new_int_byte_pair__SWIG_2(long jarg1, int_byte_pair jarg1_);
  public final static native void int_byte_pair_first_set(long jarg1, int_byte_pair jarg1_, int jarg2);
  public final static native int int_byte_pair_first_get(long jarg1, int_byte_pair jarg1_);
  public final static native void int_byte_pair_second_set(long jarg1, int_byte_pair jarg1_, byte jarg2);
  public final static native byte int_byte_pair_second_get(long jarg1, int_byte_pair jarg1_);
  public final static native void delete_int_byte_pair(long jarg1);
  public final static native long new_string_int_pair__SWIG_0();
  public final static native long new_string_int_pair__SWIG_1(String jarg1, int jarg2);
  public final static native long new_string_int_pair__SWIG_2(long jarg1, string_int_pair jarg1_);
  public final static native void string_int_pair_first_set(long jarg1, string_int_pair jarg1_, String jarg2);
  public final static native String string_int_pair_first_get(long jarg1, string_int_pair jarg1_);
  public final static native void string_int_pair_second_set(long jarg1, string_int_pair jarg1_, int jarg2);
  public final static native int string_int_pair_second_get(long jarg1, string_int_pair jarg1_);
  public final static native void delete_string_int_pair(long jarg1);
  public final static native long new_string_string_pair__SWIG_0();
  public final static native long new_string_string_pair__SWIG_1(String jarg1, String jarg2);
  public final static native long new_string_string_pair__SWIG_2(long jarg1, string_string_pair jarg1_);
  public final static native void string_string_pair_first_set(long jarg1, string_string_pair jarg1_, String jarg2);
  public final static native String string_string_pair_first_get(long jarg1, string_string_pair jarg1_);
  public final static native void string_string_pair_second_set(long jarg1, string_string_pair jarg1_, String jarg2);
  public final static native String string_string_pair_second_get(long jarg1, string_string_pair jarg1_);
  public final static native void delete_string_string_pair(long jarg1);
  public final static native long new_byte_vector_byte_vector_pair__SWIG_0();
  public final static native long new_byte_vector_byte_vector_pair__SWIG_1(long jarg1, byte_vector jarg1_, long jarg2, byte_vector jarg2_);
  public final static native long new_byte_vector_byte_vector_pair__SWIG_2(long jarg1, byte_vector_byte_vector_pair jarg1_);
  public final static native void byte_vector_byte_vector_pair_first_set(long jarg1, byte_vector_byte_vector_pair jarg1_, long jarg2, byte_vector jarg2_);
  public final static native long byte_vector_byte_vector_pair_first_get(long jarg1, byte_vector_byte_vector_pair jarg1_);
  public final static native void byte_vector_byte_vector_pair_second_set(long jarg1, byte_vector_byte_vector_pair jarg1_, long jarg2, byte_vector jarg2_);
  public final static native long byte_vector_byte_vector_pair_second_get(long jarg1, byte_vector_byte_vector_pair jarg1_);
  public final static native void delete_byte_vector_byte_vector_pair(long jarg1);
  public final static native long new_sha1_hash_udp_endpoint_pair__SWIG_0();
  public final static native long new_sha1_hash_udp_endpoint_pair__SWIG_1(long jarg1, sha1_hash jarg1_, long jarg2, udp_endpoint jarg2_);
  public final static native long new_sha1_hash_udp_endpoint_pair__SWIG_2(long jarg1, sha1_hash_udp_endpoint_pair jarg1_);
  public final static native void sha1_hash_udp_endpoint_pair_first_set(long jarg1, sha1_hash_udp_endpoint_pair jarg1_, long jarg2, sha1_hash jarg2_);
  public final static native long sha1_hash_udp_endpoint_pair_first_get(long jarg1, sha1_hash_udp_endpoint_pair jarg1_);
  public final static native void sha1_hash_udp_endpoint_pair_second_set(long jarg1, sha1_hash_udp_endpoint_pair jarg1_, long jarg2, udp_endpoint jarg2_);
  public final static native long sha1_hash_udp_endpoint_pair_second_get(long jarg1, sha1_hash_udp_endpoint_pair jarg1_);
  public final static native void delete_sha1_hash_udp_endpoint_pair(long jarg1);
  public final static native long new_bdecode_node_bdecode_node_pair__SWIG_0();
  public final static native long new_bdecode_node_bdecode_node_pair__SWIG_1(long jarg1, bdecode_node jarg1_, long jarg2, bdecode_node jarg2_);
  public final static native long new_bdecode_node_bdecode_node_pair__SWIG_2(long jarg1, bdecode_node_bdecode_node_pair jarg1_);
  public final static native void bdecode_node_bdecode_node_pair_first_set(long jarg1, bdecode_node_bdecode_node_pair jarg1_, long jarg2, bdecode_node jarg2_);
  public final static native long bdecode_node_bdecode_node_pair_first_get(long jarg1, bdecode_node_bdecode_node_pair jarg1_);
  public final static native void bdecode_node_bdecode_node_pair_second_set(long jarg1, bdecode_node_bdecode_node_pair jarg1_, long jarg2, bdecode_node jarg2_);
  public final static native long bdecode_node_bdecode_node_pair_second_get(long jarg1, bdecode_node_bdecode_node_pair jarg1_);
  public final static native void delete_bdecode_node_bdecode_node_pair(long jarg1);
  public final static native long new_address_sha1_hash_pair__SWIG_0();
  public final static native long new_address_sha1_hash_pair__SWIG_1(long jarg1, address jarg1_, long jarg2, sha1_hash jarg2_);
  public final static native long new_address_sha1_hash_pair__SWIG_2(long jarg1, address_sha1_hash_pair jarg1_);
  public final static native void address_sha1_hash_pair_first_set(long jarg1, address_sha1_hash_pair jarg1_, long jarg2, address jarg2_);
  public final static native long address_sha1_hash_pair_first_get(long jarg1, address_sha1_hash_pair jarg1_);
  public final static native void address_sha1_hash_pair_second_set(long jarg1, address_sha1_hash_pair jarg1_, long jarg2, sha1_hash jarg2_);
  public final static native long address_sha1_hash_pair_second_get(long jarg1, address_sha1_hash_pair jarg1_);
  public final static native void delete_address_sha1_hash_pair(long jarg1);
  public final static native long new_string_vector__SWIG_0();
  public final static native long new_string_vector__SWIG_1(long jarg1, string_vector jarg1_);
  public final static native boolean string_vector_isEmpty(long jarg1, string_vector jarg1_);
  public final static native void string_vector_clear(long jarg1, string_vector jarg1_);
  public final static native long new_string_vector__SWIG_2(int jarg1, String jarg2);
  public final static native int string_vector_doCapacity(long jarg1, string_vector jarg1_);
  public final static native void string_vector_doReserve(long jarg1, string_vector jarg1_, int jarg2);
  public final static native int string_vector_doSize(long jarg1, string_vector jarg1_);
  public final static native void string_vector_doAdd__SWIG_0(long jarg1, string_vector jarg1_, String jarg2);
  public final static native void string_vector_doAdd__SWIG_1(long jarg1, string_vector jarg1_, int jarg2, String jarg3);
  public final static native String string_vector_doRemove(long jarg1, string_vector jarg1_, int jarg2);
  public final static native String string_vector_doGet(long jarg1, string_vector jarg1_, int jarg2);
  public final static native String string_vector_doSet(long jarg1, string_vector jarg1_, int jarg2, String jarg3);
  public final static native void string_vector_doRemoveRange(long jarg1, string_vector jarg1_, int jarg2, int jarg3);
  public final static native void delete_string_vector(long jarg1);
  public final static native long new_int_vector__SWIG_0();
  public final static native long new_int_vector__SWIG_1(long jarg1, int_vector jarg1_);
  public final static native boolean int_vector_isEmpty(long jarg1, int_vector jarg1_);
  public final static native void int_vector_clear(long jarg1, int_vector jarg1_);
  public final static native long new_int_vector__SWIG_2(int jarg1, int jarg2);
  public final static native int int_vector_doCapacity(long jarg1, int_vector jarg1_);
  public final static native void int_vector_doReserve(long jarg1, int_vector jarg1_, int jarg2);
  public final static native int int_vector_doSize(long jarg1, int_vector jarg1_);
  public final static native void int_vector_doAdd__SWIG_0(long jarg1, int_vector jarg1_, int jarg2);
  public final static native void int_vector_doAdd__SWIG_1(long jarg1, int_vector jarg1_, int jarg2, int jarg3);
  public final static native int int_vector_doRemove(long jarg1, int_vector jarg1_, int jarg2);
  public final static native int int_vector_doGet(long jarg1, int_vector jarg1_, int jarg2);
  public final static native int int_vector_doSet(long jarg1, int_vector jarg1_, int jarg2, int jarg3);
  public final static native void int_vector_doRemoveRange(long jarg1, int_vector jarg1_, int jarg2, int jarg3);
  public final static native void delete_int_vector(long jarg1);
  public final static native long new_int64_vector__SWIG_0();
  public final static native long new_int64_vector__SWIG_1(long jarg1, int64_vector jarg1_);
  public final static native boolean int64_vector_isEmpty(long jarg1, int64_vector jarg1_);
  public final static native void int64_vector_clear(long jarg1, int64_vector jarg1_);
  public final static native long new_int64_vector__SWIG_2(int jarg1, long jarg2);
  public final static native int int64_vector_doCapacity(long jarg1, int64_vector jarg1_);
  public final static native void int64_vector_doReserve(long jarg1, int64_vector jarg1_, int jarg2);
  public final static native int int64_vector_doSize(long jarg1, int64_vector jarg1_);
  public final static native void int64_vector_doAdd__SWIG_0(long jarg1, int64_vector jarg1_, long jarg2);
  public final static native void int64_vector_doAdd__SWIG_1(long jarg1, int64_vector jarg1_, int jarg2, long jarg3);
  public final static native long int64_vector_doRemove(long jarg1, int64_vector jarg1_, int jarg2);
  public final static native long int64_vector_doGet(long jarg1, int64_vector jarg1_, int jarg2);
  public final static native long int64_vector_doSet(long jarg1, int64_vector jarg1_, int jarg2, long jarg3);
  public final static native void int64_vector_doRemoveRange(long jarg1, int64_vector jarg1_, int jarg2, int jarg3);
  public final static native void delete_int64_vector(long jarg1);
  public final static native long new_byte_vector__SWIG_0();
  public final static native long new_byte_vector__SWIG_1(long jarg1, byte_vector jarg1_);
  public final static native boolean byte_vector_isEmpty(long jarg1, byte_vector jarg1_);
  public final static native void byte_vector_clear(long jarg1, byte_vector jarg1_);
  public final static native long new_byte_vector__SWIG_2(int jarg1, byte jarg2);
  public final static native int byte_vector_doCapacity(long jarg1, byte_vector jarg1_);
  public final static native void byte_vector_doReserve(long jarg1, byte_vector jarg1_, int jarg2);
  public final static native int byte_vector_doSize(long jarg1, byte_vector jarg1_);
  public final static native void byte_vector_doAdd__SWIG_0(long jarg1, byte_vector jarg1_, byte jarg2);
  public final static native void byte_vector_doAdd__SWIG_1(long jarg1, byte_vector jarg1_, int jarg2, byte jarg3);
  public final static native byte byte_vector_doRemove(long jarg1, byte_vector jarg1_, int jarg2);
  public final static native byte byte_vector_doGet(long jarg1, byte_vector jarg1_, int jarg2);
  public final static native byte byte_vector_doSet(long jarg1, byte_vector jarg1_, int jarg2, byte jarg3);
  public final static native void byte_vector_doRemoveRange(long jarg1, byte_vector jarg1_, int jarg2, int jarg3);
  public final static native void delete_byte_vector(long jarg1);
  public final static native long new_bool_vector__SWIG_0();
  public final static native long new_bool_vector__SWIG_1(long jarg1, bool_vector jarg1_);
  public final static native boolean bool_vector_isEmpty(long jarg1, bool_vector jarg1_);
  public final static native void bool_vector_clear(long jarg1, bool_vector jarg1_);
  public final static native long new_bool_vector__SWIG_2(int jarg1, boolean jarg2);
  public final static native int bool_vector_doCapacity(long jarg1, bool_vector jarg1_);
  public final static native void bool_vector_doReserve(long jarg1, bool_vector jarg1_, int jarg2);
  public final static native int bool_vector_doSize(long jarg1, bool_vector jarg1_);
  public final static native void bool_vector_doAdd__SWIG_0(long jarg1, bool_vector jarg1_, boolean jarg2);
  public final static native void bool_vector_doAdd__SWIG_1(long jarg1, bool_vector jarg1_, int jarg2, boolean jarg3);
  public final static native boolean bool_vector_doRemove(long jarg1, bool_vector jarg1_, int jarg2);
  public final static native boolean bool_vector_doGet(long jarg1, bool_vector jarg1_, int jarg2);
  public final static native boolean bool_vector_doSet(long jarg1, bool_vector jarg1_, int jarg2, boolean jarg3);
  public final static native void bool_vector_doRemoveRange(long jarg1, bool_vector jarg1_, int jarg2, int jarg3);
  public final static native void delete_bool_vector(long jarg1);
  public final static native long new_int_byte_pair_vector__SWIG_0();
  public final static native long new_int_byte_pair_vector__SWIG_1(long jarg1, int_byte_pair_vector jarg1_);
  public final static native boolean int_byte_pair_vector_isEmpty(long jarg1, int_byte_pair_vector jarg1_);
  public final static native void int_byte_pair_vector_clear(long jarg1, int_byte_pair_vector jarg1_);
  public final static native long new_int_byte_pair_vector__SWIG_2(int jarg1, long jarg2, int_byte_pair jarg2_);
  public final static native int int_byte_pair_vector_doCapacity(long jarg1, int_byte_pair_vector jarg1_);
  public final static native void int_byte_pair_vector_doReserve(long jarg1, int_byte_pair_vector jarg1_, int jarg2);
  public final static native int int_byte_pair_vector_doSize(long jarg1, int_byte_pair_vector jarg1_);
  public final static native void int_byte_pair_vector_doAdd__SWIG_0(long jarg1, int_byte_pair_vector jarg1_, long jarg2, int_byte_pair jarg2_);
  public final static native void int_byte_pair_vector_doAdd__SWIG_1(long jarg1, int_byte_pair_vector jarg1_, int jarg2, long jarg3, int_byte_pair jarg3_);
  public final static native long int_byte_pair_vector_doRemove(long jarg1, int_byte_pair_vector jarg1_, int jarg2);
  public final static native long int_byte_pair_vector_doGet(long jarg1, int_byte_pair_vector jarg1_, int jarg2);
  public final static native long int_byte_pair_vector_doSet(long jarg1, int_byte_pair_vector jarg1_, int jarg2, long jarg3, int_byte_pair jarg3_);
  public final static native void int_byte_pair_vector_doRemoveRange(long jarg1, int_byte_pair_vector jarg1_, int jarg2, int jarg3);
  public final static native void delete_int_byte_pair_vector(long jarg1);
  public final static native long new_string_int_pair_vector__SWIG_0();
  public final static native long new_string_int_pair_vector__SWIG_1(long jarg1, string_int_pair_vector jarg1_);
  public final static native boolean string_int_pair_vector_isEmpty(long jarg1, string_int_pair_vector jarg1_);
  public final static native void string_int_pair_vector_clear(long jarg1, string_int_pair_vector jarg1_);
  public final static native long new_string_int_pair_vector__SWIG_2(int jarg1, long jarg2, string_int_pair jarg2_);
  public final static native int string_int_pair_vector_doCapacity(long jarg1, string_int_pair_vector jarg1_);
  public final static native void string_int_pair_vector_doReserve(long jarg1, string_int_pair_vector jarg1_, int jarg2);
  public final static native int string_int_pair_vector_doSize(long jarg1, string_int_pair_vector jarg1_);
  public final static native void string_int_pair_vector_doAdd__SWIG_0(long jarg1, string_int_pair_vector jarg1_, long jarg2, string_int_pair jarg2_);
  public final static native void string_int_pair_vector_doAdd__SWIG_1(long jarg1, string_int_pair_vector jarg1_, int jarg2, long jarg3, string_int_pair jarg3_);
  public final static native long string_int_pair_vector_doRemove(long jarg1, string_int_pair_vector jarg1_, int jarg2);
  public final static native long string_int_pair_vector_doGet(long jarg1, string_int_pair_vector jarg1_, int jarg2);
  public final static native long string_int_pair_vector_doSet(long jarg1, string_int_pair_vector jarg1_, int jarg2, long jarg3, string_int_pair jarg3_);
  public final static native void string_int_pair_vector_doRemoveRange(long jarg1, string_int_pair_vector jarg1_, int jarg2, int jarg3);
  public final static native void delete_string_int_pair_vector(long jarg1);
  public final static native long new_string_string_pair_vector__SWIG_0();
  public final static native long new_string_string_pair_vector__SWIG_1(long jarg1, string_string_pair_vector jarg1_);
  public final static native boolean string_string_pair_vector_isEmpty(long jarg1, string_string_pair_vector jarg1_);
  public final static native void string_string_pair_vector_clear(long jarg1, string_string_pair_vector jarg1_);
  public final static native long new_string_string_pair_vector__SWIG_2(int jarg1, long jarg2, string_string_pair jarg2_);
  public final static native int string_string_pair_vector_doCapacity(long jarg1, string_string_pair_vector jarg1_);
  public final static native void string_string_pair_vector_doReserve(long jarg1, string_string_pair_vector jarg1_, int jarg2);
  public final static native int string_string_pair_vector_doSize(long jarg1, string_string_pair_vector jarg1_);
  public final static native void string_string_pair_vector_doAdd__SWIG_0(long jarg1, string_string_pair_vector jarg1_, long jarg2, string_string_pair jarg2_);
  public final static native void string_string_pair_vector_doAdd__SWIG_1(long jarg1, string_string_pair_vector jarg1_, int jarg2, long jarg3, string_string_pair jarg3_);
  public final static native long string_string_pair_vector_doRemove(long jarg1, string_string_pair_vector jarg1_, int jarg2);
  public final static native long string_string_pair_vector_doGet(long jarg1, string_string_pair_vector jarg1_, int jarg2);
  public final static native long string_string_pair_vector_doSet(long jarg1, string_string_pair_vector jarg1_, int jarg2, long jarg3, string_string_pair jarg3_);
  public final static native void string_string_pair_vector_doRemoveRange(long jarg1, string_string_pair_vector jarg1_, int jarg2, int jarg3);
  public final static native void delete_string_string_pair_vector(long jarg1);
  public final static native long new_tcp_endpoint_vector__SWIG_0();
  public final static native long new_tcp_endpoint_vector__SWIG_1(long jarg1, tcp_endpoint_vector jarg1_);
  public final static native boolean tcp_endpoint_vector_isEmpty(long jarg1, tcp_endpoint_vector jarg1_);
  public final static native void tcp_endpoint_vector_clear(long jarg1, tcp_endpoint_vector jarg1_);
  public final static native long new_tcp_endpoint_vector__SWIG_2(int jarg1, long jarg2, tcp_endpoint jarg2_);
  public final static native int tcp_endpoint_vector_doCapacity(long jarg1, tcp_endpoint_vector jarg1_);
  public final static native void tcp_endpoint_vector_doReserve(long jarg1, tcp_endpoint_vector jarg1_, int jarg2);
  public final static native int tcp_endpoint_vector_doSize(long jarg1, tcp_endpoint_vector jarg1_);
  public final static native void tcp_endpoint_vector_doAdd__SWIG_0(long jarg1, tcp_endpoint_vector jarg1_, long jarg2, tcp_endpoint jarg2_);
  public final static native void tcp_endpoint_vector_doAdd__SWIG_1(long jarg1, tcp_endpoint_vector jarg1_, int jarg2, long jarg3, tcp_endpoint jarg3_);
  public final static native long tcp_endpoint_vector_doRemove(long jarg1, tcp_endpoint_vector jarg1_, int jarg2);
  public final static native long tcp_endpoint_vector_doGet(long jarg1, tcp_endpoint_vector jarg1_, int jarg2);
  public final static native long tcp_endpoint_vector_doSet(long jarg1, tcp_endpoint_vector jarg1_, int jarg2, long jarg3, tcp_endpoint jarg3_);
  public final static native void tcp_endpoint_vector_doRemoveRange(long jarg1, tcp_endpoint_vector jarg1_, int jarg2, int jarg3);
  public final static native void delete_tcp_endpoint_vector(long jarg1);
  public final static native long new_udp_endpoint_vector__SWIG_0();
  public final static native long new_udp_endpoint_vector__SWIG_1(long jarg1, udp_endpoint_vector jarg1_);
  public final static native boolean udp_endpoint_vector_isEmpty(long jarg1, udp_endpoint_vector jarg1_);
  public final static native void udp_endpoint_vector_clear(long jarg1, udp_endpoint_vector jarg1_);
  public final static native long new_udp_endpoint_vector__SWIG_2(int jarg1, long jarg2, udp_endpoint jarg2_);
  public final static native int udp_endpoint_vector_doCapacity(long jarg1, udp_endpoint_vector jarg1_);
  public final static native void udp_endpoint_vector_doReserve(long jarg1, udp_endpoint_vector jarg1_, int jarg2);
  public final static native int udp_endpoint_vector_doSize(long jarg1, udp_endpoint_vector jarg1_);
  public final static native void udp_endpoint_vector_doAdd__SWIG_0(long jarg1, udp_endpoint_vector jarg1_, long jarg2, udp_endpoint jarg2_);
  public final static native void udp_endpoint_vector_doAdd__SWIG_1(long jarg1, udp_endpoint_vector jarg1_, int jarg2, long jarg3, udp_endpoint jarg3_);
  public final static native long udp_endpoint_vector_doRemove(long jarg1, udp_endpoint_vector jarg1_, int jarg2);
  public final static native long udp_endpoint_vector_doGet(long jarg1, udp_endpoint_vector jarg1_, int jarg2);
  public final static native long udp_endpoint_vector_doSet(long jarg1, udp_endpoint_vector jarg1_, int jarg2, long jarg3, udp_endpoint jarg3_);
  public final static native void udp_endpoint_vector_doRemoveRange(long jarg1, udp_endpoint_vector jarg1_, int jarg2, int jarg3);
  public final static native void delete_udp_endpoint_vector(long jarg1);
  public final static native long new_announce_endpoint_vector__SWIG_0();
  public final static native long new_announce_endpoint_vector__SWIG_1(long jarg1, announce_endpoint_vector jarg1_);
  public final static native boolean announce_endpoint_vector_isEmpty(long jarg1, announce_endpoint_vector jarg1_);
  public final static native void announce_endpoint_vector_clear(long jarg1, announce_endpoint_vector jarg1_);
  public final static native long new_announce_endpoint_vector__SWIG_2(int jarg1, long jarg2, announce_endpoint jarg2_);
  public final static native int announce_endpoint_vector_doCapacity(long jarg1, announce_endpoint_vector jarg1_);
  public final static native void announce_endpoint_vector_doReserve(long jarg1, announce_endpoint_vector jarg1_, int jarg2);
  public final static native int announce_endpoint_vector_doSize(long jarg1, announce_endpoint_vector jarg1_);
  public final static native void announce_endpoint_vector_doAdd__SWIG_0(long jarg1, announce_endpoint_vector jarg1_, long jarg2, announce_endpoint jarg2_);
  public final static native void announce_endpoint_vector_doAdd__SWIG_1(long jarg1, announce_endpoint_vector jarg1_, int jarg2, long jarg3, announce_endpoint jarg3_);
  public final static native long announce_endpoint_vector_doRemove(long jarg1, announce_endpoint_vector jarg1_, int jarg2);
  public final static native long announce_endpoint_vector_doGet(long jarg1, announce_endpoint_vector jarg1_, int jarg2);
  public final static native long announce_endpoint_vector_doSet(long jarg1, announce_endpoint_vector jarg1_, int jarg2, long jarg3, announce_endpoint jarg3_);
  public final static native void announce_endpoint_vector_doRemoveRange(long jarg1, announce_endpoint_vector jarg1_, int jarg2, int jarg3);
  public final static native void delete_announce_endpoint_vector(long jarg1);
  public final static native long new_announce_entry_vector__SWIG_0();
  public final static native long new_announce_entry_vector__SWIG_1(long jarg1, announce_entry_vector jarg1_);
  public final static native boolean announce_entry_vector_isEmpty(long jarg1, announce_entry_vector jarg1_);
  public final static native void announce_entry_vector_clear(long jarg1, announce_entry_vector jarg1_);
  public final static native long new_announce_entry_vector__SWIG_2(int jarg1, long jarg2, announce_entry jarg2_);
  public final static native int announce_entry_vector_doCapacity(long jarg1, announce_entry_vector jarg1_);
  public final static native void announce_entry_vector_doReserve(long jarg1, announce_entry_vector jarg1_, int jarg2);
  public final static native int announce_entry_vector_doSize(long jarg1, announce_entry_vector jarg1_);
  public final static native void announce_entry_vector_doAdd__SWIG_0(long jarg1, announce_entry_vector jarg1_, long jarg2, announce_entry jarg2_);
  public final static native void announce_entry_vector_doAdd__SWIG_1(long jarg1, announce_entry_vector jarg1_, int jarg2, long jarg3, announce_entry jarg3_);
  public final static native long announce_entry_vector_doRemove(long jarg1, announce_entry_vector jarg1_, int jarg2);
  public final static native long announce_entry_vector_doGet(long jarg1, announce_entry_vector jarg1_, int jarg2);
  public final static native long announce_entry_vector_doSet(long jarg1, announce_entry_vector jarg1_, int jarg2, long jarg3, announce_entry jarg3_);
  public final static native void announce_entry_vector_doRemoveRange(long jarg1, announce_entry_vector jarg1_, int jarg2, int jarg3);
  public final static native void delete_announce_entry_vector(long jarg1);
  public final static native long new_web_seed_entry_vector__SWIG_0();
  public final static native long new_web_seed_entry_vector__SWIG_1(long jarg1, web_seed_entry_vector jarg1_);
  public final static native boolean web_seed_entry_vector_isEmpty(long jarg1, web_seed_entry_vector jarg1_);
  public final static native void web_seed_entry_vector_clear(long jarg1, web_seed_entry_vector jarg1_);
  public final static native long new_web_seed_entry_vector__SWIG_2(int jarg1, long jarg2, web_seed_entry jarg2_);
  public final static native int web_seed_entry_vector_doCapacity(long jarg1, web_seed_entry_vector jarg1_);
  public final static native void web_seed_entry_vector_doReserve(long jarg1, web_seed_entry_vector jarg1_, int jarg2);
  public final static native int web_seed_entry_vector_doSize(long jarg1, web_seed_entry_vector jarg1_);
  public final static native void web_seed_entry_vector_doAdd__SWIG_0(long jarg1, web_seed_entry_vector jarg1_, long jarg2, web_seed_entry jarg2_);
  public final static native void web_seed_entry_vector_doAdd__SWIG_1(long jarg1, web_seed_entry_vector jarg1_, int jarg2, long jarg3, web_seed_entry jarg3_);
  public final static native long web_seed_entry_vector_doRemove(long jarg1, web_seed_entry_vector jarg1_, int jarg2);
  public final static native long web_seed_entry_vector_doGet(long jarg1, web_seed_entry_vector jarg1_, int jarg2);
  public final static native long web_seed_entry_vector_doSet(long jarg1, web_seed_entry_vector jarg1_, int jarg2, long jarg3, web_seed_entry jarg3_);
  public final static native void web_seed_entry_vector_doRemoveRange(long jarg1, web_seed_entry_vector jarg1_, int jarg2, int jarg3);
  public final static native void delete_web_seed_entry_vector(long jarg1);
  public final static native long new_file_slice_vector__SWIG_0();
  public final static native long new_file_slice_vector__SWIG_1(long jarg1, file_slice_vector jarg1_);
  public final static native boolean file_slice_vector_isEmpty(long jarg1, file_slice_vector jarg1_);
  public final static native void file_slice_vector_clear(long jarg1, file_slice_vector jarg1_);
  public final static native long new_file_slice_vector__SWIG_2(int jarg1, long jarg2, file_slice jarg2_);
  public final static native int file_slice_vector_doCapacity(long jarg1, file_slice_vector jarg1_);
  public final static native void file_slice_vector_doReserve(long jarg1, file_slice_vector jarg1_, int jarg2);
  public final static native int file_slice_vector_doSize(long jarg1, file_slice_vector jarg1_);
  public final static native void file_slice_vector_doAdd__SWIG_0(long jarg1, file_slice_vector jarg1_, long jarg2, file_slice jarg2_);
  public final static native void file_slice_vector_doAdd__SWIG_1(long jarg1, file_slice_vector jarg1_, int jarg2, long jarg3, file_slice jarg3_);
  public final static native long file_slice_vector_doRemove(long jarg1, file_slice_vector jarg1_, int jarg2);
  public final static native long file_slice_vector_doGet(long jarg1, file_slice_vector jarg1_, int jarg2);
  public final static native long file_slice_vector_doSet(long jarg1, file_slice_vector jarg1_, int jarg2, long jarg3, file_slice jarg3_);
  public final static native void file_slice_vector_doRemoveRange(long jarg1, file_slice_vector jarg1_, int jarg2, int jarg3);
  public final static native void delete_file_slice_vector(long jarg1);
  public final static native long new_piece_block_vector__SWIG_0();
  public final static native long new_piece_block_vector__SWIG_1(long jarg1, piece_block_vector jarg1_);
  public final static native boolean piece_block_vector_isEmpty(long jarg1, piece_block_vector jarg1_);
  public final static native void piece_block_vector_clear(long jarg1, piece_block_vector jarg1_);
  public final static native long new_piece_block_vector__SWIG_2(int jarg1, long jarg2, piece_block jarg2_);
  public final static native int piece_block_vector_doCapacity(long jarg1, piece_block_vector jarg1_);
  public final static native void piece_block_vector_doReserve(long jarg1, piece_block_vector jarg1_, int jarg2);
  public final static native int piece_block_vector_doSize(long jarg1, piece_block_vector jarg1_);
  public final static native void piece_block_vector_doAdd__SWIG_0(long jarg1, piece_block_vector jarg1_, long jarg2, piece_block jarg2_);
  public final static native void piece_block_vector_doAdd__SWIG_1(long jarg1, piece_block_vector jarg1_, int jarg2, long jarg3, piece_block jarg3_);
  public final static native long piece_block_vector_doRemove(long jarg1, piece_block_vector jarg1_, int jarg2);
  public final static native long piece_block_vector_doGet(long jarg1, piece_block_vector jarg1_, int jarg2);
  public final static native long piece_block_vector_doSet(long jarg1, piece_block_vector jarg1_, int jarg2, long jarg3, piece_block jarg3_);
  public final static native void piece_block_vector_doRemoveRange(long jarg1, piece_block_vector jarg1_, int jarg2, int jarg3);
  public final static native void delete_piece_block_vector(long jarg1);
  public final static native long new_torrent_status_vector__SWIG_0();
  public final static native long new_torrent_status_vector__SWIG_1(long jarg1, torrent_status_vector jarg1_);
  public final static native boolean torrent_status_vector_isEmpty(long jarg1, torrent_status_vector jarg1_);
  public final static native void torrent_status_vector_clear(long jarg1, torrent_status_vector jarg1_);
  public final static native long new_torrent_status_vector__SWIG_2(int jarg1, long jarg2, torrent_status jarg2_);
  public final static native int torrent_status_vector_doCapacity(long jarg1, torrent_status_vector jarg1_);
  public final static native void torrent_status_vector_doReserve(long jarg1, torrent_status_vector jarg1_, int jarg2);
  public final static native int torrent_status_vector_doSize(long jarg1, torrent_status_vector jarg1_);
  public final static native void torrent_status_vector_doAdd__SWIG_0(long jarg1, torrent_status_vector jarg1_, long jarg2, torrent_status jarg2_);
  public final static native void torrent_status_vector_doAdd__SWIG_1(long jarg1, torrent_status_vector jarg1_, int jarg2, long jarg3, torrent_status jarg3_);
  public final static native long torrent_status_vector_doRemove(long jarg1, torrent_status_vector jarg1_, int jarg2);
  public final static native long torrent_status_vector_doGet(long jarg1, torrent_status_vector jarg1_, int jarg2);
  public final static native long torrent_status_vector_doSet(long jarg1, torrent_status_vector jarg1_, int jarg2, long jarg3, torrent_status jarg3_);
  public final static native void torrent_status_vector_doRemoveRange(long jarg1, torrent_status_vector jarg1_, int jarg2, int jarg3);
  public final static native void delete_torrent_status_vector(long jarg1);
  public final static native long new_dht_lookup_vector__SWIG_0();
  public final static native long new_dht_lookup_vector__SWIG_1(long jarg1, dht_lookup_vector jarg1_);
  public final static native boolean dht_lookup_vector_isEmpty(long jarg1, dht_lookup_vector jarg1_);
  public final static native void dht_lookup_vector_clear(long jarg1, dht_lookup_vector jarg1_);
  public final static native long new_dht_lookup_vector__SWIG_2(int jarg1, long jarg2, dht_lookup jarg2_);
  public final static native int dht_lookup_vector_doCapacity(long jarg1, dht_lookup_vector jarg1_);
  public final static native void dht_lookup_vector_doReserve(long jarg1, dht_lookup_vector jarg1_, int jarg2);
  public final static native int dht_lookup_vector_doSize(long jarg1, dht_lookup_vector jarg1_);
  public final static native void dht_lookup_vector_doAdd__SWIG_0(long jarg1, dht_lookup_vector jarg1_, long jarg2, dht_lookup jarg2_);
  public final static native void dht_lookup_vector_doAdd__SWIG_1(long jarg1, dht_lookup_vector jarg1_, int jarg2, long jarg3, dht_lookup jarg3_);
  public final static native long dht_lookup_vector_doRemove(long jarg1, dht_lookup_vector jarg1_, int jarg2);
  public final static native long dht_lookup_vector_doGet(long jarg1, dht_lookup_vector jarg1_, int jarg2);
  public final static native long dht_lookup_vector_doSet(long jarg1, dht_lookup_vector jarg1_, int jarg2, long jarg3, dht_lookup jarg3_);
  public final static native void dht_lookup_vector_doRemoveRange(long jarg1, dht_lookup_vector jarg1_, int jarg2, int jarg3);
  public final static native void delete_dht_lookup_vector(long jarg1);
  public final static native long new_dht_routing_bucket_vector__SWIG_0();
  public final static native long new_dht_routing_bucket_vector__SWIG_1(long jarg1, dht_routing_bucket_vector jarg1_);
  public final static native boolean dht_routing_bucket_vector_isEmpty(long jarg1, dht_routing_bucket_vector jarg1_);
  public final static native void dht_routing_bucket_vector_clear(long jarg1, dht_routing_bucket_vector jarg1_);
  public final static native long new_dht_routing_bucket_vector__SWIG_2(int jarg1, long jarg2, dht_routing_bucket jarg2_);
  public final static native int dht_routing_bucket_vector_doCapacity(long jarg1, dht_routing_bucket_vector jarg1_);
  public final static native void dht_routing_bucket_vector_doReserve(long jarg1, dht_routing_bucket_vector jarg1_, int jarg2);
  public final static native int dht_routing_bucket_vector_doSize(long jarg1, dht_routing_bucket_vector jarg1_);
  public final static native void dht_routing_bucket_vector_doAdd__SWIG_0(long jarg1, dht_routing_bucket_vector jarg1_, long jarg2, dht_routing_bucket jarg2_);
  public final static native void dht_routing_bucket_vector_doAdd__SWIG_1(long jarg1, dht_routing_bucket_vector jarg1_, int jarg2, long jarg3, dht_routing_bucket jarg3_);
  public final static native long dht_routing_bucket_vector_doRemove(long jarg1, dht_routing_bucket_vector jarg1_, int jarg2);
  public final static native long dht_routing_bucket_vector_doGet(long jarg1, dht_routing_bucket_vector jarg1_, int jarg2);
  public final static native long dht_routing_bucket_vector_doSet(long jarg1, dht_routing_bucket_vector jarg1_, int jarg2, long jarg3, dht_routing_bucket jarg3_);
  public final static native void dht_routing_bucket_vector_doRemoveRange(long jarg1, dht_routing_bucket_vector jarg1_, int jarg2, int jarg3);
  public final static native void delete_dht_routing_bucket_vector(long jarg1);
  public final static native long new_entry_vector__SWIG_0();
  public final static native long new_entry_vector__SWIG_1(long jarg1, entry_vector jarg1_);
  public final static native boolean entry_vector_isEmpty(long jarg1, entry_vector jarg1_);
  public final static native void entry_vector_clear(long jarg1, entry_vector jarg1_);
  public final static native long new_entry_vector__SWIG_2(int jarg1, long jarg2, entry jarg2_);
  public final static native int entry_vector_doCapacity(long jarg1, entry_vector jarg1_);
  public final static native void entry_vector_doReserve(long jarg1, entry_vector jarg1_, int jarg2);
  public final static native int entry_vector_doSize(long jarg1, entry_vector jarg1_);
  public final static native void entry_vector_doAdd__SWIG_0(long jarg1, entry_vector jarg1_, long jarg2, entry jarg2_);
  public final static native void entry_vector_doAdd__SWIG_1(long jarg1, entry_vector jarg1_, int jarg2, long jarg3, entry jarg3_);
  public final static native long entry_vector_doRemove(long jarg1, entry_vector jarg1_, int jarg2);
  public final static native long entry_vector_doGet(long jarg1, entry_vector jarg1_, int jarg2);
  public final static native long entry_vector_doSet(long jarg1, entry_vector jarg1_, int jarg2, long jarg3, entry jarg3_);
  public final static native void entry_vector_doRemoveRange(long jarg1, entry_vector jarg1_, int jarg2, int jarg3);
  public final static native void delete_entry_vector(long jarg1);
  public final static native long new_partial_piece_info_vector__SWIG_0();
  public final static native long new_partial_piece_info_vector__SWIG_1(long jarg1, partial_piece_info_vector jarg1_);
  public final static native boolean partial_piece_info_vector_isEmpty(long jarg1, partial_piece_info_vector jarg1_);
  public final static native void partial_piece_info_vector_clear(long jarg1, partial_piece_info_vector jarg1_);
  public final static native long new_partial_piece_info_vector__SWIG_2(int jarg1, long jarg2, partial_piece_info jarg2_);
  public final static native int partial_piece_info_vector_doCapacity(long jarg1, partial_piece_info_vector jarg1_);
  public final static native void partial_piece_info_vector_doReserve(long jarg1, partial_piece_info_vector jarg1_, int jarg2);
  public final static native int partial_piece_info_vector_doSize(long jarg1, partial_piece_info_vector jarg1_);
  public final static native void partial_piece_info_vector_doAdd__SWIG_0(long jarg1, partial_piece_info_vector jarg1_, long jarg2, partial_piece_info jarg2_);
  public final static native void partial_piece_info_vector_doAdd__SWIG_1(long jarg1, partial_piece_info_vector jarg1_, int jarg2, long jarg3, partial_piece_info jarg3_);
  public final static native long partial_piece_info_vector_doRemove(long jarg1, partial_piece_info_vector jarg1_, int jarg2);
  public final static native long partial_piece_info_vector_doGet(long jarg1, partial_piece_info_vector jarg1_, int jarg2);
  public final static native long partial_piece_info_vector_doSet(long jarg1, partial_piece_info_vector jarg1_, int jarg2, long jarg3, partial_piece_info jarg3_);
  public final static native void partial_piece_info_vector_doRemoveRange(long jarg1, partial_piece_info_vector jarg1_, int jarg2, int jarg3);
  public final static native void delete_partial_piece_info_vector(long jarg1);
  public final static native long new_peer_info_vector__SWIG_0();
  public final static native long new_peer_info_vector__SWIG_1(long jarg1, peer_info_vector jarg1_);
  public final static native boolean peer_info_vector_isEmpty(long jarg1, peer_info_vector jarg1_);
  public final static native void peer_info_vector_clear(long jarg1, peer_info_vector jarg1_);
  public final static native long new_peer_info_vector__SWIG_2(int jarg1, long jarg2, peer_info jarg2_);
  public final static native int peer_info_vector_doCapacity(long jarg1, peer_info_vector jarg1_);
  public final static native void peer_info_vector_doReserve(long jarg1, peer_info_vector jarg1_, int jarg2);
  public final static native int peer_info_vector_doSize(long jarg1, peer_info_vector jarg1_);
  public final static native void peer_info_vector_doAdd__SWIG_0(long jarg1, peer_info_vector jarg1_, long jarg2, peer_info jarg2_);
  public final static native void peer_info_vector_doAdd__SWIG_1(long jarg1, peer_info_vector jarg1_, int jarg2, long jarg3, peer_info jarg3_);
  public final static native long peer_info_vector_doRemove(long jarg1, peer_info_vector jarg1_, int jarg2);
  public final static native long peer_info_vector_doGet(long jarg1, peer_info_vector jarg1_, int jarg2);
  public final static native long peer_info_vector_doSet(long jarg1, peer_info_vector jarg1_, int jarg2, long jarg3, peer_info jarg3_);
  public final static native void peer_info_vector_doRemoveRange(long jarg1, peer_info_vector jarg1_, int jarg2, int jarg3);
  public final static native void delete_peer_info_vector(long jarg1);
  public final static native long new_torrent_handle_vector__SWIG_0();
  public final static native long new_torrent_handle_vector__SWIG_1(long jarg1, torrent_handle_vector jarg1_);
  public final static native boolean torrent_handle_vector_isEmpty(long jarg1, torrent_handle_vector jarg1_);
  public final static native void torrent_handle_vector_clear(long jarg1, torrent_handle_vector jarg1_);
  public final static native long new_torrent_handle_vector__SWIG_2(int jarg1, long jarg2, torrent_handle jarg2_);
  public final static native int torrent_handle_vector_doCapacity(long jarg1, torrent_handle_vector jarg1_);
  public final static native void torrent_handle_vector_doReserve(long jarg1, torrent_handle_vector jarg1_, int jarg2);
  public final static native int torrent_handle_vector_doSize(long jarg1, torrent_handle_vector jarg1_);
  public final static native void torrent_handle_vector_doAdd__SWIG_0(long jarg1, torrent_handle_vector jarg1_, long jarg2, torrent_handle jarg2_);
  public final static native void torrent_handle_vector_doAdd__SWIG_1(long jarg1, torrent_handle_vector jarg1_, int jarg2, long jarg3, torrent_handle jarg3_);
  public final static native long torrent_handle_vector_doRemove(long jarg1, torrent_handle_vector jarg1_, int jarg2);
  public final static native long torrent_handle_vector_doGet(long jarg1, torrent_handle_vector jarg1_, int jarg2);
  public final static native long torrent_handle_vector_doSet(long jarg1, torrent_handle_vector jarg1_, int jarg2, long jarg3, torrent_handle jarg3_);
  public final static native void torrent_handle_vector_doRemoveRange(long jarg1, torrent_handle_vector jarg1_, int jarg2, int jarg3);
  public final static native void delete_torrent_handle_vector(long jarg1);
  public final static native long new_alert_ptr_vector__SWIG_0();
  public final static native long new_alert_ptr_vector__SWIG_1(long jarg1, alert_ptr_vector jarg1_);
  public final static native boolean alert_ptr_vector_isEmpty(long jarg1, alert_ptr_vector jarg1_);
  public final static native void alert_ptr_vector_clear(long jarg1, alert_ptr_vector jarg1_);
  public final static native long new_alert_ptr_vector__SWIG_2(int jarg1, long jarg2, alert jarg2_);
  public final static native int alert_ptr_vector_doCapacity(long jarg1, alert_ptr_vector jarg1_);
  public final static native void alert_ptr_vector_doReserve(long jarg1, alert_ptr_vector jarg1_, int jarg2);
  public final static native int alert_ptr_vector_doSize(long jarg1, alert_ptr_vector jarg1_);
  public final static native void alert_ptr_vector_doAdd__SWIG_0(long jarg1, alert_ptr_vector jarg1_, long jarg2, alert jarg2_);
  public final static native void alert_ptr_vector_doAdd__SWIG_1(long jarg1, alert_ptr_vector jarg1_, int jarg2, long jarg3, alert jarg3_);
  public final static native long alert_ptr_vector_doRemove(long jarg1, alert_ptr_vector jarg1_, int jarg2);
  public final static native long alert_ptr_vector_doGet(long jarg1, alert_ptr_vector jarg1_, int jarg2);
  public final static native long alert_ptr_vector_doSet(long jarg1, alert_ptr_vector jarg1_, int jarg2, long jarg3, alert jarg3_);
  public final static native void alert_ptr_vector_doRemoveRange(long jarg1, alert_ptr_vector jarg1_, int jarg2, int jarg3);
  public final static native void delete_alert_ptr_vector(long jarg1);
  public final static native long new_stats_metric_vector__SWIG_0();
  public final static native long new_stats_metric_vector__SWIG_1(long jarg1, stats_metric_vector jarg1_);
  public final static native boolean stats_metric_vector_isEmpty(long jarg1, stats_metric_vector jarg1_);
  public final static native void stats_metric_vector_clear(long jarg1, stats_metric_vector jarg1_);
  public final static native long new_stats_metric_vector__SWIG_2(int jarg1, long jarg2, stats_metric jarg2_);
  public final static native int stats_metric_vector_doCapacity(long jarg1, stats_metric_vector jarg1_);
  public final static native void stats_metric_vector_doReserve(long jarg1, stats_metric_vector jarg1_, int jarg2);
  public final static native int stats_metric_vector_doSize(long jarg1, stats_metric_vector jarg1_);
  public final static native void stats_metric_vector_doAdd__SWIG_0(long jarg1, stats_metric_vector jarg1_, long jarg2, stats_metric jarg2_);
  public final static native void stats_metric_vector_doAdd__SWIG_1(long jarg1, stats_metric_vector jarg1_, int jarg2, long jarg3, stats_metric jarg3_);
  public final static native long stats_metric_vector_doRemove(long jarg1, stats_metric_vector jarg1_, int jarg2);
  public final static native long stats_metric_vector_doGet(long jarg1, stats_metric_vector jarg1_, int jarg2);
  public final static native long stats_metric_vector_doSet(long jarg1, stats_metric_vector jarg1_, int jarg2, long jarg3, stats_metric jarg3_);
  public final static native void stats_metric_vector_doRemoveRange(long jarg1, stats_metric_vector jarg1_, int jarg2, int jarg3);
  public final static native void delete_stats_metric_vector(long jarg1);
  public final static native long new_ip_interface_vector__SWIG_0();
  public final static native long new_ip_interface_vector__SWIG_1(long jarg1, ip_interface_vector jarg1_);
  public final static native boolean ip_interface_vector_isEmpty(long jarg1, ip_interface_vector jarg1_);
  public final static native void ip_interface_vector_clear(long jarg1, ip_interface_vector jarg1_);
  public final static native long new_ip_interface_vector__SWIG_2(int jarg1, long jarg2, ip_interface jarg2_);
  public final static native int ip_interface_vector_doCapacity(long jarg1, ip_interface_vector jarg1_);
  public final static native void ip_interface_vector_doReserve(long jarg1, ip_interface_vector jarg1_, int jarg2);
  public final static native int ip_interface_vector_doSize(long jarg1, ip_interface_vector jarg1_);
  public final static native void ip_interface_vector_doAdd__SWIG_0(long jarg1, ip_interface_vector jarg1_, long jarg2, ip_interface jarg2_);
  public final static native void ip_interface_vector_doAdd__SWIG_1(long jarg1, ip_interface_vector jarg1_, int jarg2, long jarg3, ip_interface jarg3_);
  public final static native long ip_interface_vector_doRemove(long jarg1, ip_interface_vector jarg1_, int jarg2);
  public final static native long ip_interface_vector_doGet(long jarg1, ip_interface_vector jarg1_, int jarg2);
  public final static native long ip_interface_vector_doSet(long jarg1, ip_interface_vector jarg1_, int jarg2, long jarg3, ip_interface jarg3_);
  public final static native void ip_interface_vector_doRemoveRange(long jarg1, ip_interface_vector jarg1_, int jarg2, int jarg3);
  public final static native void delete_ip_interface_vector(long jarg1);
  public final static native long new_ip_route_vector__SWIG_0();
  public final static native long new_ip_route_vector__SWIG_1(long jarg1, ip_route_vector jarg1_);
  public final static native boolean ip_route_vector_isEmpty(long jarg1, ip_route_vector jarg1_);
  public final static native void ip_route_vector_clear(long jarg1, ip_route_vector jarg1_);
  public final static native long new_ip_route_vector__SWIG_2(int jarg1, long jarg2, ip_route jarg2_);
  public final static native int ip_route_vector_doCapacity(long jarg1, ip_route_vector jarg1_);
  public final static native void ip_route_vector_doReserve(long jarg1, ip_route_vector jarg1_, int jarg2);
  public final static native int ip_route_vector_doSize(long jarg1, ip_route_vector jarg1_);
  public final static native void ip_route_vector_doAdd__SWIG_0(long jarg1, ip_route_vector jarg1_, long jarg2, ip_route jarg2_);
  public final static native void ip_route_vector_doAdd__SWIG_1(long jarg1, ip_route_vector jarg1_, int jarg2, long jarg3, ip_route jarg3_);
  public final static native long ip_route_vector_doRemove(long jarg1, ip_route_vector jarg1_, int jarg2);
  public final static native long ip_route_vector_doGet(long jarg1, ip_route_vector jarg1_, int jarg2);
  public final static native long ip_route_vector_doSet(long jarg1, ip_route_vector jarg1_, int jarg2, long jarg3, ip_route jarg3_);
  public final static native void ip_route_vector_doRemoveRange(long jarg1, ip_route_vector jarg1_, int jarg2, int jarg3);
  public final static native void delete_ip_route_vector(long jarg1);
  public final static native long new_block_info_vector__SWIG_0();
  public final static native long new_block_info_vector__SWIG_1(long jarg1, block_info_vector jarg1_);
  public final static native boolean block_info_vector_isEmpty(long jarg1, block_info_vector jarg1_);
  public final static native void block_info_vector_clear(long jarg1, block_info_vector jarg1_);
  public final static native long new_block_info_vector__SWIG_2(int jarg1, long jarg2, block_info jarg2_);
  public final static native int block_info_vector_doCapacity(long jarg1, block_info_vector jarg1_);
  public final static native void block_info_vector_doReserve(long jarg1, block_info_vector jarg1_, int jarg2);
  public final static native int block_info_vector_doSize(long jarg1, block_info_vector jarg1_);
  public final static native void block_info_vector_doAdd__SWIG_0(long jarg1, block_info_vector jarg1_, long jarg2, block_info jarg2_);
  public final static native void block_info_vector_doAdd__SWIG_1(long jarg1, block_info_vector jarg1_, int jarg2, long jarg3, block_info jarg3_);
  public final static native long block_info_vector_doRemove(long jarg1, block_info_vector jarg1_, int jarg2);
  public final static native long block_info_vector_doGet(long jarg1, block_info_vector jarg1_, int jarg2);
  public final static native long block_info_vector_doSet(long jarg1, block_info_vector jarg1_, int jarg2, long jarg3, block_info jarg3_);
  public final static native void block_info_vector_doRemoveRange(long jarg1, block_info_vector jarg1_, int jarg2, int jarg3);
  public final static native void delete_block_info_vector(long jarg1);
  public final static native long new_bitfield_vector__SWIG_0();
  public final static native long new_bitfield_vector__SWIG_1(long jarg1, bitfield_vector jarg1_);
  public final static native boolean bitfield_vector_isEmpty(long jarg1, bitfield_vector jarg1_);
  public final static native void bitfield_vector_clear(long jarg1, bitfield_vector jarg1_);
  public final static native long new_bitfield_vector__SWIG_2(int jarg1, long jarg2, bitfield jarg2_);
  public final static native int bitfield_vector_doCapacity(long jarg1, bitfield_vector jarg1_);
  public final static native void bitfield_vector_doReserve(long jarg1, bitfield_vector jarg1_, int jarg2);
  public final static native int bitfield_vector_doSize(long jarg1, bitfield_vector jarg1_);
  public final static native void bitfield_vector_doAdd__SWIG_0(long jarg1, bitfield_vector jarg1_, long jarg2, bitfield jarg2_);
  public final static native void bitfield_vector_doAdd__SWIG_1(long jarg1, bitfield_vector jarg1_, int jarg2, long jarg3, bitfield jarg3_);
  public final static native long bitfield_vector_doRemove(long jarg1, bitfield_vector jarg1_, int jarg2);
  public final static native long bitfield_vector_doGet(long jarg1, bitfield_vector jarg1_, int jarg2);
  public final static native long bitfield_vector_doSet(long jarg1, bitfield_vector jarg1_, int jarg2, long jarg3, bitfield jarg3_);
  public final static native void bitfield_vector_doRemoveRange(long jarg1, bitfield_vector jarg1_, int jarg2, int jarg3);
  public final static native void delete_bitfield_vector(long jarg1);
  public final static native long new_bool_vector_vector__SWIG_0();
  public final static native long new_bool_vector_vector__SWIG_1(long jarg1, bool_vector_vector jarg1_);
  public final static native boolean bool_vector_vector_isEmpty(long jarg1, bool_vector_vector jarg1_);
  public final static native void bool_vector_vector_clear(long jarg1, bool_vector_vector jarg1_);
  public final static native long new_bool_vector_vector__SWIG_2(int jarg1, long jarg2, bool_vector jarg2_);
  public final static native int bool_vector_vector_doCapacity(long jarg1, bool_vector_vector jarg1_);
  public final static native void bool_vector_vector_doReserve(long jarg1, bool_vector_vector jarg1_, int jarg2);
  public final static native int bool_vector_vector_doSize(long jarg1, bool_vector_vector jarg1_);
  public final static native void bool_vector_vector_doAdd__SWIG_0(long jarg1, bool_vector_vector jarg1_, long jarg2, bool_vector jarg2_);
  public final static native void bool_vector_vector_doAdd__SWIG_1(long jarg1, bool_vector_vector jarg1_, int jarg2, long jarg3, bool_vector jarg3_);
  public final static native long bool_vector_vector_doRemove(long jarg1, bool_vector_vector jarg1_, int jarg2);
  public final static native long bool_vector_vector_doGet(long jarg1, bool_vector_vector jarg1_, int jarg2);
  public final static native long bool_vector_vector_doSet(long jarg1, bool_vector_vector jarg1_, int jarg2, long jarg3, bool_vector jarg3_);
  public final static native void bool_vector_vector_doRemoveRange(long jarg1, bool_vector_vector jarg1_, int jarg2, int jarg3);
  public final static native void delete_bool_vector_vector(long jarg1);
  public final static native long new_sha256_hash_vector_vector__SWIG_0();
  public final static native long new_sha256_hash_vector_vector__SWIG_1(long jarg1, sha256_hash_vector_vector jarg1_);
  public final static native boolean sha256_hash_vector_vector_isEmpty(long jarg1, sha256_hash_vector_vector jarg1_);
  public final static native void sha256_hash_vector_vector_clear(long jarg1, sha256_hash_vector_vector jarg1_);
  public final static native long new_sha256_hash_vector_vector__SWIG_2(int jarg1, long jarg2, sha256_hash_vector jarg2_);
  public final static native int sha256_hash_vector_vector_doCapacity(long jarg1, sha256_hash_vector_vector jarg1_);
  public final static native void sha256_hash_vector_vector_doReserve(long jarg1, sha256_hash_vector_vector jarg1_, int jarg2);
  public final static native int sha256_hash_vector_vector_doSize(long jarg1, sha256_hash_vector_vector jarg1_);
  public final static native void sha256_hash_vector_vector_doAdd__SWIG_0(long jarg1, sha256_hash_vector_vector jarg1_, long jarg2, sha256_hash_vector jarg2_);
  public final static native void sha256_hash_vector_vector_doAdd__SWIG_1(long jarg1, sha256_hash_vector_vector jarg1_, int jarg2, long jarg3, sha256_hash_vector jarg3_);
  public final static native long sha256_hash_vector_vector_doRemove(long jarg1, sha256_hash_vector_vector jarg1_, int jarg2);
  public final static native long sha256_hash_vector_vector_doGet(long jarg1, sha256_hash_vector_vector jarg1_, int jarg2);
  public final static native long sha256_hash_vector_vector_doSet(long jarg1, sha256_hash_vector_vector jarg1_, int jarg2, long jarg3, sha256_hash_vector jarg3_);
  public final static native void sha256_hash_vector_vector_doRemoveRange(long jarg1, sha256_hash_vector_vector jarg1_, int jarg2, int jarg3);
  public final static native void delete_sha256_hash_vector_vector(long jarg1);
  public final static native long new_sha1_hash_udp_endpoint_pair_vector__SWIG_0();
  public final static native long new_sha1_hash_udp_endpoint_pair_vector__SWIG_1(long jarg1, sha1_hash_udp_endpoint_pair_vector jarg1_);
  public final static native boolean sha1_hash_udp_endpoint_pair_vector_isEmpty(long jarg1, sha1_hash_udp_endpoint_pair_vector jarg1_);
  public final static native void sha1_hash_udp_endpoint_pair_vector_clear(long jarg1, sha1_hash_udp_endpoint_pair_vector jarg1_);
  public final static native long new_sha1_hash_udp_endpoint_pair_vector__SWIG_2(int jarg1, long jarg2, sha1_hash_udp_endpoint_pair jarg2_);
  public final static native int sha1_hash_udp_endpoint_pair_vector_doCapacity(long jarg1, sha1_hash_udp_endpoint_pair_vector jarg1_);
  public final static native void sha1_hash_udp_endpoint_pair_vector_doReserve(long jarg1, sha1_hash_udp_endpoint_pair_vector jarg1_, int jarg2);
  public final static native int sha1_hash_udp_endpoint_pair_vector_doSize(long jarg1, sha1_hash_udp_endpoint_pair_vector jarg1_);
  public final static native void sha1_hash_udp_endpoint_pair_vector_doAdd__SWIG_0(long jarg1, sha1_hash_udp_endpoint_pair_vector jarg1_, long jarg2, sha1_hash_udp_endpoint_pair jarg2_);
  public final static native void sha1_hash_udp_endpoint_pair_vector_doAdd__SWIG_1(long jarg1, sha1_hash_udp_endpoint_pair_vector jarg1_, int jarg2, long jarg3, sha1_hash_udp_endpoint_pair jarg3_);
  public final static native long sha1_hash_udp_endpoint_pair_vector_doRemove(long jarg1, sha1_hash_udp_endpoint_pair_vector jarg1_, int jarg2);
  public final static native long sha1_hash_udp_endpoint_pair_vector_doGet(long jarg1, sha1_hash_udp_endpoint_pair_vector jarg1_, int jarg2);
  public final static native long sha1_hash_udp_endpoint_pair_vector_doSet(long jarg1, sha1_hash_udp_endpoint_pair_vector jarg1_, int jarg2, long jarg3, sha1_hash_udp_endpoint_pair jarg3_);
  public final static native void sha1_hash_udp_endpoint_pair_vector_doRemoveRange(long jarg1, sha1_hash_udp_endpoint_pair_vector jarg1_, int jarg2, int jarg3);
  public final static native void delete_sha1_hash_udp_endpoint_pair_vector(long jarg1);
  public final static native long new_address_sha1_hash_pair_vector__SWIG_0();
  public final static native long new_address_sha1_hash_pair_vector__SWIG_1(long jarg1, address_sha1_hash_pair_vector jarg1_);
  public final static native boolean address_sha1_hash_pair_vector_isEmpty(long jarg1, address_sha1_hash_pair_vector jarg1_);
  public final static native void address_sha1_hash_pair_vector_clear(long jarg1, address_sha1_hash_pair_vector jarg1_);
  public final static native long new_address_sha1_hash_pair_vector__SWIG_2(int jarg1, long jarg2, address_sha1_hash_pair jarg2_);
  public final static native int address_sha1_hash_pair_vector_doCapacity(long jarg1, address_sha1_hash_pair_vector jarg1_);
  public final static native void address_sha1_hash_pair_vector_doReserve(long jarg1, address_sha1_hash_pair_vector jarg1_, int jarg2);
  public final static native int address_sha1_hash_pair_vector_doSize(long jarg1, address_sha1_hash_pair_vector jarg1_);
  public final static native void address_sha1_hash_pair_vector_doAdd__SWIG_0(long jarg1, address_sha1_hash_pair_vector jarg1_, long jarg2, address_sha1_hash_pair jarg2_);
  public final static native void address_sha1_hash_pair_vector_doAdd__SWIG_1(long jarg1, address_sha1_hash_pair_vector jarg1_, int jarg2, long jarg3, address_sha1_hash_pair jarg3_);
  public final static native long address_sha1_hash_pair_vector_doRemove(long jarg1, address_sha1_hash_pair_vector jarg1_, int jarg2);
  public final static native long address_sha1_hash_pair_vector_doGet(long jarg1, address_sha1_hash_pair_vector jarg1_, int jarg2);
  public final static native long address_sha1_hash_pair_vector_doSet(long jarg1, address_sha1_hash_pair_vector jarg1_, int jarg2, long jarg3, address_sha1_hash_pair jarg3_);
  public final static native void address_sha1_hash_pair_vector_doRemoveRange(long jarg1, address_sha1_hash_pair_vector jarg1_, int jarg2, int jarg3);
  public final static native void delete_address_sha1_hash_pair_vector(long jarg1);
  public final static native long new_byte_array_32__SWIG_0();
  public final static native long new_byte_array_32__SWIG_1(long jarg1, byte_array_32 jarg1_);
  public final static native boolean byte_array_32_isEmpty(long jarg1, byte_array_32 jarg1_);
  public final static native void byte_array_32_fill(long jarg1, byte_array_32 jarg1_, byte jarg2);
  public final static native int byte_array_32_size(long jarg1, byte_array_32 jarg1_);
  public final static native byte byte_array_32_get(long jarg1, byte_array_32 jarg1_, int jarg2);
  public final static native void byte_array_32_set(long jarg1, byte_array_32 jarg1_, int jarg2, byte jarg3);
  public final static native void delete_byte_array_32(long jarg1);
  public final static native long new_byte_array_64__SWIG_0();
  public final static native long new_byte_array_64__SWIG_1(long jarg1, byte_array_64 jarg1_);
  public final static native boolean byte_array_64_isEmpty(long jarg1, byte_array_64 jarg1_);
  public final static native void byte_array_64_fill(long jarg1, byte_array_64 jarg1_, byte jarg2);
  public final static native int byte_array_64_size(long jarg1, byte_array_64 jarg1_);
  public final static native byte byte_array_64_get(long jarg1, byte_array_64 jarg1_, int jarg2);
  public final static native void byte_array_64_set(long jarg1, byte_array_64 jarg1_, int jarg2, byte jarg3);
  public final static native void delete_byte_array_64(long jarg1);
  public final static native long new_int_string_map__SWIG_0();
  public final static native long new_int_string_map__SWIG_1(long jarg1, int_string_map jarg1_);
  public final static native long int_string_map_Iterator_getNextUnchecked(long jarg1, int_string_map.Iterator jarg1_);
  public final static native boolean int_string_map_Iterator_isNot(long jarg1, int_string_map.Iterator jarg1_, long jarg2, int_string_map.Iterator jarg2_);
  public final static native int int_string_map_Iterator_getKey(long jarg1, int_string_map.Iterator jarg1_);
  public final static native String int_string_map_Iterator_getValue(long jarg1, int_string_map.Iterator jarg1_);
  public final static native void int_string_map_Iterator_setValue(long jarg1, int_string_map.Iterator jarg1_, String jarg2);
  public final static native void delete_int_string_map_Iterator(long jarg1);
  public final static native boolean int_string_map_isEmpty(long jarg1, int_string_map jarg1_);
  public final static native void int_string_map_clear(long jarg1, int_string_map jarg1_);
  public final static native long int_string_map_find(long jarg1, int_string_map jarg1_, int jarg2);
  public final static native long int_string_map_begin(long jarg1, int_string_map jarg1_);
  public final static native long int_string_map_end(long jarg1, int_string_map jarg1_);
  public final static native int int_string_map_sizeImpl(long jarg1, int_string_map jarg1_);
  public final static native boolean int_string_map_containsImpl(long jarg1, int_string_map jarg1_, int jarg2);
  public final static native void int_string_map_putUnchecked(long jarg1, int_string_map jarg1_, int jarg2, String jarg3);
  public final static native void int_string_map_removeUnchecked(long jarg1, int_string_map jarg1_, long jarg2, int_string_map.Iterator jarg2_);
  public final static native void delete_int_string_map(long jarg1);
  public final static native long new_string_string_map__SWIG_0();
  public final static native long new_string_string_map__SWIG_1(long jarg1, string_string_map jarg1_);
  public final static native long string_string_map_Iterator_getNextUnchecked(long jarg1, string_string_map.Iterator jarg1_);
  public final static native boolean string_string_map_Iterator_isNot(long jarg1, string_string_map.Iterator jarg1_, long jarg2, string_string_map.Iterator jarg2_);
  public final static native String string_string_map_Iterator_getKey(long jarg1, string_string_map.Iterator jarg1_);
  public final static native String string_string_map_Iterator_getValue(long jarg1, string_string_map.Iterator jarg1_);
  public final static native void string_string_map_Iterator_setValue(long jarg1, string_string_map.Iterator jarg1_, String jarg2);
  public final static native void delete_string_string_map_Iterator(long jarg1);
  public final static native boolean string_string_map_isEmpty(long jarg1, string_string_map jarg1_);
  public final static native void string_string_map_clear(long jarg1, string_string_map jarg1_);
  public final static native long string_string_map_find(long jarg1, string_string_map jarg1_, String jarg2);
  public final static native long string_string_map_begin(long jarg1, string_string_map jarg1_);
  public final static native long string_string_map_end(long jarg1, string_string_map jarg1_);
  public final static native int string_string_map_sizeImpl(long jarg1, string_string_map jarg1_);
  public final static native boolean string_string_map_containsImpl(long jarg1, string_string_map jarg1_, String jarg2);
  public final static native void string_string_map_putUnchecked(long jarg1, string_string_map jarg1_, String jarg2, String jarg3);
  public final static native void string_string_map_removeUnchecked(long jarg1, string_string_map jarg1_, long jarg2, string_string_map.Iterator jarg2_);
  public final static native void delete_string_string_map(long jarg1);
  public final static native long new_int_bitfield_map__SWIG_0();
  public final static native long new_int_bitfield_map__SWIG_1(long jarg1, int_bitfield_map jarg1_);
  public final static native long int_bitfield_map_Iterator_getNextUnchecked(long jarg1, int_bitfield_map.Iterator jarg1_);
  public final static native boolean int_bitfield_map_Iterator_isNot(long jarg1, int_bitfield_map.Iterator jarg1_, long jarg2, int_bitfield_map.Iterator jarg2_);
  public final static native int int_bitfield_map_Iterator_getKey(long jarg1, int_bitfield_map.Iterator jarg1_);
  public final static native long int_bitfield_map_Iterator_getValue(long jarg1, int_bitfield_map.Iterator jarg1_);
  public final static native void int_bitfield_map_Iterator_setValue(long jarg1, int_bitfield_map.Iterator jarg1_, long jarg2, bitfield jarg2_);
  public final static native void delete_int_bitfield_map_Iterator(long jarg1);
  public final static native boolean int_bitfield_map_isEmpty(long jarg1, int_bitfield_map jarg1_);
  public final static native void int_bitfield_map_clear(long jarg1, int_bitfield_map jarg1_);
  public final static native long int_bitfield_map_find(long jarg1, int_bitfield_map jarg1_, int jarg2);
  public final static native long int_bitfield_map_begin(long jarg1, int_bitfield_map jarg1_);
  public final static native long int_bitfield_map_end(long jarg1, int_bitfield_map jarg1_);
  public final static native int int_bitfield_map_sizeImpl(long jarg1, int_bitfield_map jarg1_);
  public final static native boolean int_bitfield_map_containsImpl(long jarg1, int_bitfield_map jarg1_, int jarg2);
  public final static native void int_bitfield_map_putUnchecked(long jarg1, int_bitfield_map jarg1_, int jarg2, long jarg3, bitfield jarg3_);
  public final static native void int_bitfield_map_removeUnchecked(long jarg1, int_bitfield_map jarg1_, long jarg2, int_bitfield_map.Iterator jarg2_);
  public final static native void delete_int_bitfield_map(long jarg1);
  public final static native long new_string_entry_map__SWIG_0();
  public final static native long new_string_entry_map__SWIG_1(long jarg1, string_entry_map jarg1_);
  public final static native long string_entry_map_Iterator_getNextUnchecked(long jarg1, string_entry_map.Iterator jarg1_);
  public final static native boolean string_entry_map_Iterator_isNot(long jarg1, string_entry_map.Iterator jarg1_, long jarg2, string_entry_map.Iterator jarg2_);
  public final static native String string_entry_map_Iterator_getKey(long jarg1, string_entry_map.Iterator jarg1_);
  public final static native long string_entry_map_Iterator_getValue(long jarg1, string_entry_map.Iterator jarg1_);
  public final static native void string_entry_map_Iterator_setValue(long jarg1, string_entry_map.Iterator jarg1_, long jarg2, entry jarg2_);
  public final static native void delete_string_entry_map_Iterator(long jarg1);
  public final static native boolean string_entry_map_isEmpty(long jarg1, string_entry_map jarg1_);
  public final static native void string_entry_map_clear(long jarg1, string_entry_map jarg1_);
  public final static native long string_entry_map_find(long jarg1, string_entry_map jarg1_, String jarg2);
  public final static native long string_entry_map_begin(long jarg1, string_entry_map jarg1_);
  public final static native long string_entry_map_end(long jarg1, string_entry_map jarg1_);
  public final static native int string_entry_map_sizeImpl(long jarg1, string_entry_map jarg1_);
  public final static native boolean string_entry_map_containsImpl(long jarg1, string_entry_map jarg1_, String jarg2);
  public final static native void string_entry_map_putUnchecked(long jarg1, string_entry_map jarg1_, String jarg2, long jarg3, entry jarg3_);
  public final static native void string_entry_map_removeUnchecked(long jarg1, string_entry_map jarg1_, long jarg2, string_entry_map.Iterator jarg2_);
  public final static native void delete_string_entry_map(long jarg1);
  public final static native boolean boost_string_entry_map_empty(long jarg1, boost_string_entry_map jarg1_);
  public final static native void boost_string_entry_map_clear(long jarg1, boost_string_entry_map jarg1_);
  public final static native long boost_string_entry_map_size(long jarg1, boost_string_entry_map jarg1_);
  public final static native boolean boost_string_entry_map_contains(long jarg1, boost_string_entry_map jarg1_, String jarg2);
  public final static native void boost_string_entry_map_put(long jarg1, boost_string_entry_map jarg1_, String jarg2, long jarg3, entry jarg3_);
  public final static native long boost_string_entry_map_get(long jarg1, boost_string_entry_map jarg1_, String jarg2);
  public final static native long boost_string_entry_map_keys(long jarg1, boost_string_entry_map jarg1_);
  public final static native void boost_string_entry_map_remove(long jarg1, boost_string_entry_map jarg1_, String jarg2);
  public final static native long new_boost_string_entry_map();
  public final static native void delete_boost_string_entry_map(long jarg1);
  public final static native long new_file_index_string_map__SWIG_0();
  public final static native long new_file_index_string_map__SWIG_1(long jarg1, file_index_string_map jarg1_);
  public final static native long file_index_string_map_Iterator_getNextUnchecked(long jarg1, file_index_string_map.Iterator jarg1_);
  public final static native boolean file_index_string_map_Iterator_isNot(long jarg1, file_index_string_map.Iterator jarg1_, long jarg2, file_index_string_map.Iterator jarg2_);
  public final static native long file_index_string_map_Iterator_getKey(long jarg1, file_index_string_map.Iterator jarg1_);
  public final static native String file_index_string_map_Iterator_getValue(long jarg1, file_index_string_map.Iterator jarg1_);
  public final static native void file_index_string_map_Iterator_setValue(long jarg1, file_index_string_map.Iterator jarg1_, String jarg2);
  public final static native void delete_file_index_string_map_Iterator(long jarg1);
  public final static native boolean file_index_string_map_isEmpty(long jarg1, file_index_string_map jarg1_);
  public final static native void file_index_string_map_clear(long jarg1, file_index_string_map jarg1_);
  public final static native long file_index_string_map_find(long jarg1, file_index_string_map jarg1_, long jarg2);
  public final static native long file_index_string_map_begin(long jarg1, file_index_string_map jarg1_);
  public final static native long file_index_string_map_end(long jarg1, file_index_string_map jarg1_);
  public final static native int file_index_string_map_sizeImpl(long jarg1, file_index_string_map jarg1_);
  public final static native boolean file_index_string_map_containsImpl(long jarg1, file_index_string_map jarg1_, long jarg2);
  public final static native void file_index_string_map_putUnchecked(long jarg1, file_index_string_map jarg1_, long jarg2, String jarg3);
  public final static native void file_index_string_map_removeUnchecked(long jarg1, file_index_string_map jarg1_, long jarg2, file_index_string_map.Iterator jarg2_);
  public final static native void delete_file_index_string_map(long jarg1);
  public final static native long new_file_index_vector__SWIG_0();
  public final static native long new_file_index_vector__SWIG_1(long jarg1, file_index_vector jarg1_);
  public final static native boolean file_index_vector_isEmpty(long jarg1, file_index_vector jarg1_);
  public final static native void file_index_vector_clear(long jarg1, file_index_vector jarg1_);
  public final static native long new_file_index_vector__SWIG_2(int jarg1, long jarg2);
  public final static native int file_index_vector_doCapacity(long jarg1, file_index_vector jarg1_);
  public final static native void file_index_vector_doReserve(long jarg1, file_index_vector jarg1_, int jarg2);
  public final static native int file_index_vector_doSize(long jarg1, file_index_vector jarg1_);
  public final static native void file_index_vector_doAdd__SWIG_0(long jarg1, file_index_vector jarg1_, long jarg2);
  public final static native void file_index_vector_doAdd__SWIG_1(long jarg1, file_index_vector jarg1_, int jarg2, long jarg3);
  public final static native long file_index_vector_doRemove(long jarg1, file_index_vector jarg1_, int jarg2);
  public final static native long file_index_vector_doGet(long jarg1, file_index_vector jarg1_, int jarg2);
  public final static native long file_index_vector_doSet(long jarg1, file_index_vector jarg1_, int jarg2, long jarg3);
  public final static native void file_index_vector_doRemoveRange(long jarg1, file_index_vector jarg1_, int jarg2, int jarg3);
  public final static native void delete_file_index_vector(long jarg1);
  public final static native long new_piece_index_int_pair__SWIG_0();
  public final static native long new_piece_index_int_pair__SWIG_1(int jarg1, int jarg2);
  public final static native long new_piece_index_int_pair__SWIG_2(long jarg1, piece_index_int_pair jarg1_);
  public final static native void piece_index_int_pair_first_set(long jarg1, piece_index_int_pair jarg1_, int jarg2);
  public final static native int piece_index_int_pair_first_get(long jarg1, piece_index_int_pair jarg1_);
  public final static native void piece_index_int_pair_second_set(long jarg1, piece_index_int_pair jarg1_, int jarg2);
  public final static native int piece_index_int_pair_second_get(long jarg1, piece_index_int_pair jarg1_);
  public final static native void delete_piece_index_int_pair(long jarg1);
  public final static native long new_piece_index_int_pair_vector__SWIG_0();
  public final static native long new_piece_index_int_pair_vector__SWIG_1(long jarg1, piece_index_int_pair_vector jarg1_);
  public final static native boolean piece_index_int_pair_vector_isEmpty(long jarg1, piece_index_int_pair_vector jarg1_);
  public final static native void piece_index_int_pair_vector_clear(long jarg1, piece_index_int_pair_vector jarg1_);
  public final static native long new_piece_index_int_pair_vector__SWIG_2(int jarg1, long jarg2);
  public final static native int piece_index_int_pair_vector_doCapacity(long jarg1, piece_index_int_pair_vector jarg1_);
  public final static native void piece_index_int_pair_vector_doReserve(long jarg1, piece_index_int_pair_vector jarg1_, int jarg2);
  public final static native int piece_index_int_pair_vector_doSize(long jarg1, piece_index_int_pair_vector jarg1_);
  public final static native void piece_index_int_pair_vector_doAdd__SWIG_0(long jarg1, piece_index_int_pair_vector jarg1_, long jarg2);
  public final static native void piece_index_int_pair_vector_doAdd__SWIG_1(long jarg1, piece_index_int_pair_vector jarg1_, int jarg2, long jarg3);
  public final static native long piece_index_int_pair_vector_doRemove(long jarg1, piece_index_int_pair_vector jarg1_, int jarg2);
  public final static native long piece_index_int_pair_vector_doGet(long jarg1, piece_index_int_pair_vector jarg1_, int jarg2);
  public final static native long piece_index_int_pair_vector_doSet(long jarg1, piece_index_int_pair_vector jarg1_, int jarg2, long jarg3);
  public final static native void piece_index_int_pair_vector_doRemoveRange(long jarg1, piece_index_int_pair_vector jarg1_, int jarg2, int jarg3);
  public final static native void delete_piece_index_int_pair_vector(long jarg1);
  public final static native long new_piece_index_vector__SWIG_0();
  public final static native long new_piece_index_vector__SWIG_1(long jarg1, piece_index_vector jarg1_);
  public final static native boolean piece_index_vector_isEmpty(long jarg1, piece_index_vector jarg1_);
  public final static native void piece_index_vector_clear(long jarg1, piece_index_vector jarg1_);
  public final static native long new_piece_index_vector__SWIG_2(int jarg1, long jarg2);
  public final static native int piece_index_vector_doCapacity(long jarg1, piece_index_vector jarg1_);
  public final static native void piece_index_vector_doReserve(long jarg1, piece_index_vector jarg1_, int jarg2);
  public final static native int piece_index_vector_doSize(long jarg1, piece_index_vector jarg1_);
  public final static native void piece_index_vector_doAdd__SWIG_0(long jarg1, piece_index_vector jarg1_, long jarg2);
  public final static native void piece_index_vector_doAdd__SWIG_1(long jarg1, piece_index_vector jarg1_, int jarg2, long jarg3);
  public final static native long piece_index_vector_doRemove(long jarg1, piece_index_vector jarg1_, int jarg2);
  public final static native long piece_index_vector_doGet(long jarg1, piece_index_vector jarg1_, int jarg2);
  public final static native long piece_index_vector_doSet(long jarg1, piece_index_vector jarg1_, int jarg2, long jarg3);
  public final static native void piece_index_vector_doRemoveRange(long jarg1, piece_index_vector jarg1_, int jarg2, int jarg3);
  public final static native void delete_piece_index_vector(long jarg1);
  public final static native long new_string_long_map__SWIG_0();
  public final static native long new_string_long_map__SWIG_1(long jarg1, string_long_map jarg1_);
  public final static native long string_long_map_Iterator_getNextUnchecked(long jarg1, string_long_map.Iterator jarg1_);
  public final static native boolean string_long_map_Iterator_isNot(long jarg1, string_long_map.Iterator jarg1_, long jarg2, string_long_map.Iterator jarg2_);
  public final static native String string_long_map_Iterator_getKey(long jarg1, string_long_map.Iterator jarg1_);
  public final static native int string_long_map_Iterator_getValue(long jarg1, string_long_map.Iterator jarg1_);
  public final static native void string_long_map_Iterator_setValue(long jarg1, string_long_map.Iterator jarg1_, int jarg2);
  public final static native void delete_string_long_map_Iterator(long jarg1);
  public final static native boolean string_long_map_isEmpty(long jarg1, string_long_map jarg1_);
  public final static native void string_long_map_clear(long jarg1, string_long_map jarg1_);
  public final static native long string_long_map_find(long jarg1, string_long_map jarg1_, String jarg2);
  public final static native long string_long_map_begin(long jarg1, string_long_map jarg1_);
  public final static native long string_long_map_end(long jarg1, string_long_map jarg1_);
  public final static native int string_long_map_sizeImpl(long jarg1, string_long_map jarg1_);
  public final static native boolean string_long_map_containsImpl(long jarg1, string_long_map jarg1_, String jarg2);
  public final static native void string_long_map_putUnchecked(long jarg1, string_long_map jarg1_, String jarg2, int jarg3);
  public final static native void string_long_map_removeUnchecked(long jarg1, string_long_map jarg1_, long jarg2, string_long_map.Iterator jarg2_);
  public final static native void delete_string_long_map(long jarg1);
  public final static native long new_string_view_bdecode_node_pair__SWIG_0();
  public final static native long new_string_view_bdecode_node_pair__SWIG_1(long jarg1, string_view jarg1_, long jarg2, bdecode_node jarg2_);
  public final static native long new_string_view_bdecode_node_pair__SWIG_2(long jarg1, string_view_bdecode_node_pair jarg1_);
  public final static native void string_view_bdecode_node_pair_first_set(long jarg1, string_view_bdecode_node_pair jarg1_, long jarg2, string_view jarg2_);
  public final static native long string_view_bdecode_node_pair_first_get(long jarg1, string_view_bdecode_node_pair jarg1_);
  public final static native void string_view_bdecode_node_pair_second_set(long jarg1, string_view_bdecode_node_pair jarg1_, long jarg2, bdecode_node jarg2_);
  public final static native long string_view_bdecode_node_pair_second_get(long jarg1, string_view_bdecode_node_pair jarg1_);
  public final static native void delete_string_view_bdecode_node_pair(long jarg1);
  public final static native boolean bitset_128_test(long jarg1, bitset_128 jarg1_, long jarg2);
  public final static native boolean bitset_128_all(long jarg1, bitset_128 jarg1_);
  public final static native boolean bitset_128_any(long jarg1, bitset_128 jarg1_);
  public final static native boolean bitset_128_none(long jarg1, bitset_128 jarg1_);
  public final static native long bitset_128_count(long jarg1, bitset_128 jarg1_);
  public final static native long bitset_128_size(long jarg1, bitset_128 jarg1_);
  public final static native boolean bitset_128_get(long jarg1, bitset_128 jarg1_, long jarg2);
  public final static native long new_bitset_128();
  public final static native void delete_bitset_128(long jarg1);
  public final static native boolean bitset_96_test(long jarg1, bitset_96 jarg1_, long jarg2);
  public final static native boolean bitset_96_all(long jarg1, bitset_96 jarg1_);
  public final static native boolean bitset_96_any(long jarg1, bitset_96 jarg1_);
  public final static native boolean bitset_96_none(long jarg1, bitset_96 jarg1_);
  public final static native long bitset_96_count(long jarg1, bitset_96 jarg1_);
  public final static native long bitset_96_size(long jarg1, bitset_96 jarg1_);
  public final static native boolean bitset_96_get(long jarg1, bitset_96 jarg1_, long jarg2);
  public final static native long new_bitset_96();
  public final static native void delete_bitset_96(long jarg1);
  public final static native long new_bandwidth_state_flags_t();
  public final static native long bandwidth_state_flags_t_all();
  public final static native boolean bandwidth_state_flags_t_non_zero(long jarg1, bandwidth_state_flags_t jarg1_);
  public final static native boolean bandwidth_state_flags_t_nonZero(long jarg1, bandwidth_state_flags_t jarg1_);
  public final static native boolean bandwidth_state_flags_t_eq(long jarg1, bandwidth_state_flags_t jarg1_, long jarg2, bandwidth_state_flags_t jarg2_);
  public final static native boolean bandwidth_state_flags_t_ne(long jarg1, bandwidth_state_flags_t jarg1_, long jarg2, bandwidth_state_flags_t jarg2_);
  public final static native long bandwidth_state_flags_t_or_(long jarg1, bandwidth_state_flags_t jarg1_, long jarg2, bandwidth_state_flags_t jarg2_);
  public final static native long bandwidth_state_flags_t_and_(long jarg1, bandwidth_state_flags_t jarg1_, long jarg2, bandwidth_state_flags_t jarg2_);
  public final static native long bandwidth_state_flags_t_xor_(long jarg1, bandwidth_state_flags_t jarg1_, long jarg2, bandwidth_state_flags_t jarg2_);
  public final static native long bandwidth_state_flags_t_inv(long jarg1, bandwidth_state_flags_t jarg1_);
  public final static native int bandwidth_state_flags_t_to_int(long jarg1, bandwidth_state_flags_t jarg1_);
  public final static native long bandwidth_state_flags_t_from_int(int jarg1);
  public final static native void delete_bandwidth_state_flags_t(long jarg1);
  public final static native long new_create_flags_t();
  public final static native long create_flags_t_all();
  public final static native boolean create_flags_t_non_zero(long jarg1, create_flags_t jarg1_);
  public final static native boolean create_flags_t_nonZero(long jarg1, create_flags_t jarg1_);
  public final static native boolean create_flags_t_eq(long jarg1, create_flags_t jarg1_, long jarg2, create_flags_t jarg2_);
  public final static native boolean create_flags_t_ne(long jarg1, create_flags_t jarg1_, long jarg2, create_flags_t jarg2_);
  public final static native long create_flags_t_or_(long jarg1, create_flags_t jarg1_, long jarg2, create_flags_t jarg2_);
  public final static native long create_flags_t_and_(long jarg1, create_flags_t jarg1_, long jarg2, create_flags_t jarg2_);
  public final static native long create_flags_t_xor_(long jarg1, create_flags_t jarg1_, long jarg2, create_flags_t jarg2_);
  public final static native long create_flags_t_inv(long jarg1, create_flags_t jarg1_);
  public final static native int create_flags_t_to_int(long jarg1, create_flags_t jarg1_);
  public final static native long create_flags_t_from_int(int jarg1);
  public final static native void delete_create_flags_t(long jarg1);
  public final static native long new_file_flags_t();
  public final static native long file_flags_t_all();
  public final static native boolean file_flags_t_non_zero(long jarg1, file_flags_t jarg1_);
  public final static native boolean file_flags_t_nonZero(long jarg1, file_flags_t jarg1_);
  public final static native boolean file_flags_t_eq(long jarg1, file_flags_t jarg1_, long jarg2, file_flags_t jarg2_);
  public final static native boolean file_flags_t_ne(long jarg1, file_flags_t jarg1_, long jarg2, file_flags_t jarg2_);
  public final static native long file_flags_t_or_(long jarg1, file_flags_t jarg1_, long jarg2, file_flags_t jarg2_);
  public final static native long file_flags_t_and_(long jarg1, file_flags_t jarg1_, long jarg2, file_flags_t jarg2_);
  public final static native long file_flags_t_xor_(long jarg1, file_flags_t jarg1_, long jarg2, file_flags_t jarg2_);
  public final static native long file_flags_t_inv(long jarg1, file_flags_t jarg1_);
  public final static native int file_flags_t_to_int(long jarg1, file_flags_t jarg1_);
  public final static native long file_flags_t_from_int(int jarg1);
  public final static native void delete_file_flags_t(long jarg1);
  public final static native long new_peer_flags_t();
  public final static native long peer_flags_t_all();
  public final static native boolean peer_flags_t_non_zero(long jarg1, peer_flags_t jarg1_);
  public final static native boolean peer_flags_t_nonZero(long jarg1, peer_flags_t jarg1_);
  public final static native boolean peer_flags_t_eq(long jarg1, peer_flags_t jarg1_, long jarg2, peer_flags_t jarg2_);
  public final static native boolean peer_flags_t_ne(long jarg1, peer_flags_t jarg1_, long jarg2, peer_flags_t jarg2_);
  public final static native long peer_flags_t_or_(long jarg1, peer_flags_t jarg1_, long jarg2, peer_flags_t jarg2_);
  public final static native long peer_flags_t_and_(long jarg1, peer_flags_t jarg1_, long jarg2, peer_flags_t jarg2_);
  public final static native long peer_flags_t_xor_(long jarg1, peer_flags_t jarg1_, long jarg2, peer_flags_t jarg2_);
  public final static native long peer_flags_t_inv(long jarg1, peer_flags_t jarg1_);
  public final static native int peer_flags_t_to_int(long jarg1, peer_flags_t jarg1_);
  public final static native long peer_flags_t_from_int(int jarg1);
  public final static native void delete_peer_flags_t(long jarg1);
  public final static native long new_peer_source_flags_t();
  public final static native long peer_source_flags_t_all();
  public final static native boolean peer_source_flags_t_non_zero(long jarg1, peer_source_flags_t jarg1_);
  public final static native boolean peer_source_flags_t_nonZero(long jarg1, peer_source_flags_t jarg1_);
  public final static native boolean peer_source_flags_t_eq(long jarg1, peer_source_flags_t jarg1_, long jarg2, peer_source_flags_t jarg2_);
  public final static native boolean peer_source_flags_t_ne(long jarg1, peer_source_flags_t jarg1_, long jarg2, peer_source_flags_t jarg2_);
  public final static native long peer_source_flags_t_or_(long jarg1, peer_source_flags_t jarg1_, long jarg2, peer_source_flags_t jarg2_);
  public final static native long peer_source_flags_t_and_(long jarg1, peer_source_flags_t jarg1_, long jarg2, peer_source_flags_t jarg2_);
  public final static native long peer_source_flags_t_xor_(long jarg1, peer_source_flags_t jarg1_, long jarg2, peer_source_flags_t jarg2_);
  public final static native long peer_source_flags_t_inv(long jarg1, peer_source_flags_t jarg1_);
  public final static native int peer_source_flags_t_to_int(long jarg1, peer_source_flags_t jarg1_);
  public final static native long peer_source_flags_t_from_int(int jarg1);
  public final static native void delete_peer_source_flags_t(long jarg1);
  public final static native long new_pex_flags_t();
  public final static native long pex_flags_t_all();
  public final static native boolean pex_flags_t_non_zero(long jarg1, pex_flags_t jarg1_);
  public final static native boolean pex_flags_t_nonZero(long jarg1, pex_flags_t jarg1_);
  public final static native boolean pex_flags_t_eq(long jarg1, pex_flags_t jarg1_, long jarg2, pex_flags_t jarg2_);
  public final static native boolean pex_flags_t_ne(long jarg1, pex_flags_t jarg1_, long jarg2, pex_flags_t jarg2_);
  public final static native long pex_flags_t_or_(long jarg1, pex_flags_t jarg1_, long jarg2, pex_flags_t jarg2_);
  public final static native long pex_flags_t_and_(long jarg1, pex_flags_t jarg1_, long jarg2, pex_flags_t jarg2_);
  public final static native long pex_flags_t_xor_(long jarg1, pex_flags_t jarg1_, long jarg2, pex_flags_t jarg2_);
  public final static native long pex_flags_t_inv(long jarg1, pex_flags_t jarg1_);
  public final static native int pex_flags_t_to_int(long jarg1, pex_flags_t jarg1_);
  public final static native long pex_flags_t_from_int(int jarg1);
  public final static native void delete_pex_flags_t(long jarg1);
  public final static native long new_picker_flags_t();
  public final static native long picker_flags_t_all();
  public final static native boolean picker_flags_t_non_zero(long jarg1, picker_flags_t jarg1_);
  public final static native boolean picker_flags_t_nonZero(long jarg1, picker_flags_t jarg1_);
  public final static native boolean picker_flags_t_eq(long jarg1, picker_flags_t jarg1_, long jarg2, picker_flags_t jarg2_);
  public final static native boolean picker_flags_t_ne(long jarg1, picker_flags_t jarg1_, long jarg2, picker_flags_t jarg2_);
  public final static native long picker_flags_t_or_(long jarg1, picker_flags_t jarg1_, long jarg2, picker_flags_t jarg2_);
  public final static native long picker_flags_t_and_(long jarg1, picker_flags_t jarg1_, long jarg2, picker_flags_t jarg2_);
  public final static native long picker_flags_t_xor_(long jarg1, picker_flags_t jarg1_, long jarg2, picker_flags_t jarg2_);
  public final static native long picker_flags_t_inv(long jarg1, picker_flags_t jarg1_);
  public final static native int picker_flags_t_to_int(long jarg1, picker_flags_t jarg1_);
  public final static native long picker_flags_t_from_int(int jarg1);
  public final static native void delete_picker_flags_t(long jarg1);
  public final static native long new_write_torrent_flags_t();
  public final static native long write_torrent_flags_t_all();
  public final static native boolean write_torrent_flags_t_non_zero(long jarg1, write_torrent_flags_t jarg1_);
  public final static native boolean write_torrent_flags_t_nonZero(long jarg1, write_torrent_flags_t jarg1_);
  public final static native boolean write_torrent_flags_t_eq(long jarg1, write_torrent_flags_t jarg1_, long jarg2, write_torrent_flags_t jarg2_);
  public final static native boolean write_torrent_flags_t_ne(long jarg1, write_torrent_flags_t jarg1_, long jarg2, write_torrent_flags_t jarg2_);
  public final static native long write_torrent_flags_t_or_(long jarg1, write_torrent_flags_t jarg1_, long jarg2, write_torrent_flags_t jarg2_);
  public final static native long write_torrent_flags_t_and_(long jarg1, write_torrent_flags_t jarg1_, long jarg2, write_torrent_flags_t jarg2_);
  public final static native long write_torrent_flags_t_xor_(long jarg1, write_torrent_flags_t jarg1_, long jarg2, write_torrent_flags_t jarg2_);
  public final static native long write_torrent_flags_t_inv(long jarg1, write_torrent_flags_t jarg1_);
  public final static native int write_torrent_flags_t_to_int(long jarg1, write_torrent_flags_t jarg1_);
  public final static native long write_torrent_flags_t_from_int(int jarg1);
  public final static native void delete_write_torrent_flags_t(long jarg1);
  public final static native long new_error_code();
  public final static native void error_code_clear(long jarg1, error_code jarg1_);
  public final static native int error_code_value(long jarg1, error_code jarg1_);
  public final static native String error_code_message(long jarg1, error_code jarg1_);
  public final static native boolean error_code_failed(long jarg1, error_code jarg1_);
  public final static native boolean error_code_op_bool(long jarg1, error_code jarg1_);
  public final static native void delete_error_code(long jarg1);
  public final static native long new_byte_span();
  public final static native long byte_span_size(long jarg1, byte_span jarg1_);
  public final static native boolean byte_span_empty(long jarg1, byte_span jarg1_);
  public final static native byte byte_span_front(long jarg1, byte_span jarg1_);
  public final static native byte byte_span_back(long jarg1, byte_span jarg1_);
  public final static native long byte_span_first(long jarg1, byte_span jarg1_, long jarg2);
  public final static native long byte_span_last(long jarg1, byte_span jarg1_, long jarg2);
  public final static native long byte_span_subspan__SWIG_0(long jarg1, byte_span jarg1_, long jarg2);
  public final static native long byte_span_subspan__SWIG_1(long jarg1, byte_span jarg1_, long jarg2, long jarg3);
  public final static native byte byte_span_get(long jarg1, byte_span jarg1_, long jarg2);
  public final static native void byte_span_set(long jarg1, byte_span jarg1_, long jarg2, byte jarg3);
  public final static native void delete_byte_span(long jarg1);
  public final static native long new_byte_const_span();
  public final static native long byte_const_span_size(long jarg1, byte_const_span jarg1_);
  public final static native boolean byte_const_span_empty(long jarg1, byte_const_span jarg1_);
  public final static native byte byte_const_span_front(long jarg1, byte_const_span jarg1_);
  public final static native byte byte_const_span_back(long jarg1, byte_const_span jarg1_);
  public final static native long byte_const_span_first(long jarg1, byte_const_span jarg1_, long jarg2);
  public final static native long byte_const_span_last(long jarg1, byte_const_span jarg1_, long jarg2);
  public final static native long byte_const_span_subspan__SWIG_0(long jarg1, byte_const_span jarg1_, long jarg2);
  public final static native long byte_const_span_subspan__SWIG_1(long jarg1, byte_const_span jarg1_, long jarg2, long jarg3);
  public final static native byte byte_const_span_get(long jarg1, byte_const_span jarg1_, long jarg2);
  public final static native void delete_byte_const_span(long jarg1);
  public final static native long new_address__SWIG_0();
  public final static native long new_address__SWIG_1(long jarg1, address jarg1_);
  public final static native boolean address_is_v4(long jarg1, address jarg1_);
  public final static native boolean address_is_v6(long jarg1, address jarg1_);
  public final static native String address_to_string(long jarg1, address jarg1_);
  public final static native boolean address_is_loopback(long jarg1, address jarg1_);
  public final static native boolean address_is_unspecified(long jarg1, address jarg1_);
  public final static native boolean address_is_multicast(long jarg1, address jarg1_);
  public final static native boolean address_op_lt(long jarg1, address jarg1_, long jarg2, address jarg2_);
  public final static native int address_compare(long jarg1, address jarg1_, long jarg2, address jarg2_);
  public final static native long address_from_string(String jarg1, long jarg2, error_code jarg2_);
  public final static native int address_hash_code(long jarg1, address jarg1_);
  public final static native void delete_address(long jarg1);
  public final static native long new_tcp_endpoint__SWIG_0();
  public final static native long new_tcp_endpoint__SWIG_1(long jarg1, address jarg1_, int jarg2);
  public final static native long new_tcp_endpoint__SWIG_2(long jarg1, tcp_endpoint jarg1_);
  public final static native int tcp_endpoint_port(long jarg1, tcp_endpoint jarg1_);
  public final static native long tcp_endpoint_address(long jarg1, tcp_endpoint jarg1_);
  public final static native void delete_tcp_endpoint(long jarg1);
  public final static native long new_udp_endpoint__SWIG_0();
  public final static native long new_udp_endpoint__SWIG_1(long jarg1, address jarg1_, int jarg2);
  public final static native long new_udp_endpoint__SWIG_2(long jarg1, udp_endpoint jarg1_);
  public final static native int udp_endpoint_port(long jarg1, udp_endpoint jarg1_);
  public final static native long udp_endpoint_address(long jarg1, udp_endpoint jarg1_);
  public final static native void delete_udp_endpoint(long jarg1);
  public final static native void dht_state_nids_set(long jarg1, dht_state jarg1_, long jarg2, address_sha1_hash_pair_vector jarg2_);
  public final static native long dht_state_nids_get(long jarg1, dht_state jarg1_);
  public final static native void dht_state_nodes_set(long jarg1, dht_state jarg1_, long jarg2, udp_endpoint_vector jarg2_);
  public final static native long dht_state_nodes_get(long jarg1, dht_state jarg1_);
  public final static native void dht_state_nodes6_set(long jarg1, dht_state jarg1_, long jarg2, udp_endpoint_vector jarg2_);
  public final static native long dht_state_nodes6_get(long jarg1, dht_state jarg1_);
  public final static native void dht_state_clear(long jarg1, dht_state jarg1_);
  public final static native long new_dht_state();
  public final static native void delete_dht_state(long jarg1);
  public final static native long new_client_data_t__SWIG_0();
  public final static native long new_client_data_t__SWIG_1(long jarg1);
  public final static native long client_data_t_get(long jarg1, client_data_t jarg1_);
  public final static native void delete_client_data_t(long jarg1);
  public final static native long sha1_hash_size();
  public final static native long new_sha1_hash__SWIG_0();
  public final static native long new_sha1_hash__SWIG_1(long jarg1, sha1_hash jarg1_);
  public final static native long sha1_hash_max();
  public final static native long sha1_hash_min();
  public final static native void sha1_hash_clear(long jarg1, sha1_hash jarg1_);
  public final static native boolean sha1_hash_is_all_zeros(long jarg1, sha1_hash jarg1_);
  public final static native boolean sha1_hash_op_eq(long jarg1, sha1_hash jarg1_, long jarg2, sha1_hash jarg2_);
  public final static native boolean sha1_hash_op_ne(long jarg1, sha1_hash jarg1_, long jarg2, sha1_hash jarg2_);
  public final static native boolean sha1_hash_op_lt(long jarg1, sha1_hash jarg1_, long jarg2, sha1_hash jarg2_);
  public final static native int sha1_hash_count_leading_zeroes(long jarg1, sha1_hash jarg1_);
  public final static native long sha1_hash_op_inv(long jarg1, sha1_hash jarg1_);
  public final static native long sha1_hash_op_xor(long jarg1, sha1_hash jarg1_, long jarg2, sha1_hash jarg2_);
  public final static native long sha1_hash_op_and(long jarg1, sha1_hash jarg1_, long jarg2, sha1_hash jarg2_);
  public final static native long new_sha1_hash__SWIG_2(long jarg1, byte_vector jarg1_);
  public final static native void sha1_hash_assign(long jarg1, sha1_hash jarg1_, long jarg2, byte_vector jarg2_);
  public final static native int sha1_hash_hash_code(long jarg1, sha1_hash jarg1_);
  public final static native long sha1_hash_to_bytes(long jarg1, sha1_hash jarg1_);
  public final static native String sha1_hash_to_hex(long jarg1, sha1_hash jarg1_);
  public final static native long sha1_hash_from_hex(String jarg1);
  public final static native int sha1_hash_compare(long jarg1, sha1_hash jarg1_, long jarg2, sha1_hash jarg2_);
  public final static native void delete_sha1_hash(long jarg1);
  public final static native long sha256_hash_size();
  public final static native long new_sha256_hash__SWIG_0();
  public final static native long new_sha256_hash__SWIG_1(long jarg1, sha256_hash jarg1_);
  public final static native long sha256_hash_max();
  public final static native long sha256_hash_min();
  public final static native void sha256_hash_clear(long jarg1, sha256_hash jarg1_);
  public final static native boolean sha256_hash_is_all_zeros(long jarg1, sha256_hash jarg1_);
  public final static native boolean sha256_hash_op_eq(long jarg1, sha256_hash jarg1_, long jarg2, sha256_hash jarg2_);
  public final static native boolean sha256_hash_op_ne(long jarg1, sha256_hash jarg1_, long jarg2, sha256_hash jarg2_);
  public final static native boolean sha256_hash_op_lt(long jarg1, sha256_hash jarg1_, long jarg2, sha256_hash jarg2_);
  public final static native int sha256_hash_count_leading_zeroes(long jarg1, sha256_hash jarg1_);
  public final static native long sha256_hash_op_inv(long jarg1, sha256_hash jarg1_);
  public final static native long sha256_hash_op_xor(long jarg1, sha256_hash jarg1_, long jarg2, sha256_hash jarg2_);
  public final static native long sha256_hash_op_and(long jarg1, sha256_hash jarg1_, long jarg2, sha256_hash jarg2_);
  public final static native long new_sha256_hash__SWIG_2(long jarg1, byte_vector jarg1_);
  public final static native void sha256_hash_assign(long jarg1, sha256_hash jarg1_, long jarg2, byte_vector jarg2_);
  public final static native int sha256_hash_hash_code(long jarg1, sha256_hash jarg1_);
  public final static native long sha256_hash_to_bytes(long jarg1, sha256_hash jarg1_);
  public final static native String sha256_hash_to_hex(long jarg1, sha256_hash jarg1_);
  public final static native long sha256_hash_from_hex(String jarg1);
  public final static native int sha256_hash_compare(long jarg1, sha256_hash jarg1_, long jarg2, sha256_hash jarg2_);
  public final static native void delete_sha256_hash(long jarg1);
  public final static native long new_sha1_hash_vector__SWIG_0();
  public final static native long new_sha1_hash_vector__SWIG_1(long jarg1, sha1_hash_vector jarg1_);
  public final static native boolean sha1_hash_vector_isEmpty(long jarg1, sha1_hash_vector jarg1_);
  public final static native void sha1_hash_vector_clear(long jarg1, sha1_hash_vector jarg1_);
  public final static native long new_sha1_hash_vector__SWIG_2(int jarg1, long jarg2, sha1_hash jarg2_);
  public final static native int sha1_hash_vector_doCapacity(long jarg1, sha1_hash_vector jarg1_);
  public final static native void sha1_hash_vector_doReserve(long jarg1, sha1_hash_vector jarg1_, int jarg2);
  public final static native int sha1_hash_vector_doSize(long jarg1, sha1_hash_vector jarg1_);
  public final static native void sha1_hash_vector_doAdd__SWIG_0(long jarg1, sha1_hash_vector jarg1_, long jarg2, sha1_hash jarg2_);
  public final static native void sha1_hash_vector_doAdd__SWIG_1(long jarg1, sha1_hash_vector jarg1_, int jarg2, long jarg3, sha1_hash jarg3_);
  public final static native long sha1_hash_vector_doRemove(long jarg1, sha1_hash_vector jarg1_, int jarg2);
  public final static native long sha1_hash_vector_doGet(long jarg1, sha1_hash_vector jarg1_, int jarg2);
  public final static native long sha1_hash_vector_doSet(long jarg1, sha1_hash_vector jarg1_, int jarg2, long jarg3, sha1_hash jarg3_);
  public final static native void sha1_hash_vector_doRemoveRange(long jarg1, sha1_hash_vector jarg1_, int jarg2, int jarg3);
  public final static native void delete_sha1_hash_vector(long jarg1);
  public final static native long new_sha256_hash_vector__SWIG_0();
  public final static native long new_sha256_hash_vector__SWIG_1(long jarg1, sha256_hash_vector jarg1_);
  public final static native boolean sha256_hash_vector_isEmpty(long jarg1, sha256_hash_vector jarg1_);
  public final static native void sha256_hash_vector_clear(long jarg1, sha256_hash_vector jarg1_);
  public final static native long new_sha256_hash_vector__SWIG_2(int jarg1, long jarg2, sha256_hash jarg2_);
  public final static native int sha256_hash_vector_doCapacity(long jarg1, sha256_hash_vector jarg1_);
  public final static native void sha256_hash_vector_doReserve(long jarg1, sha256_hash_vector jarg1_, int jarg2);
  public final static native int sha256_hash_vector_doSize(long jarg1, sha256_hash_vector jarg1_);
  public final static native void sha256_hash_vector_doAdd__SWIG_0(long jarg1, sha256_hash_vector jarg1_, long jarg2, sha256_hash jarg2_);
  public final static native void sha256_hash_vector_doAdd__SWIG_1(long jarg1, sha256_hash_vector jarg1_, int jarg2, long jarg3, sha256_hash jarg3_);
  public final static native long sha256_hash_vector_doRemove(long jarg1, sha256_hash_vector jarg1_, int jarg2);
  public final static native long sha256_hash_vector_doGet(long jarg1, sha256_hash_vector jarg1_, int jarg2);
  public final static native long sha256_hash_vector_doSet(long jarg1, sha256_hash_vector jarg1_, int jarg2, long jarg3, sha256_hash jarg3_);
  public final static native void sha256_hash_vector_doRemoveRange(long jarg1, sha256_hash_vector jarg1_, int jarg2, int jarg3);
  public final static native void delete_sha256_hash_vector(long jarg1);
  public final static native long num_protocols_get();
  public final static native long new_info_hash_t__SWIG_0();
  public final static native long new_info_hash_t__SWIG_1(long jarg1, sha1_hash jarg1_);
  public final static native long new_info_hash_t__SWIG_2(long jarg1, sha256_hash jarg1_);
  public final static native long new_info_hash_t__SWIG_3(long jarg1, sha1_hash jarg1_, long jarg2, sha256_hash jarg2_);
  public final static native long new_info_hash_t__SWIG_4(long jarg1, info_hash_t jarg1_);
  public final static native boolean info_hash_t_has_v1(long jarg1, info_hash_t jarg1_);
  public final static native boolean info_hash_t_has_v2(long jarg1, info_hash_t jarg1_);
  public final static native boolean info_hash_t_has(long jarg1, info_hash_t jarg1_, int jarg2);
  public final static native long info_hash_t_get(long jarg1, info_hash_t jarg1_, int jarg2);
  public final static native long info_hash_t_get_best(long jarg1, info_hash_t jarg1_);
  public final static native boolean op_ne(long jarg1, info_hash_t jarg1_, long jarg2, info_hash_t jarg2_);
  public final static native boolean op_eq(long jarg1, info_hash_t jarg1_, long jarg2, info_hash_t jarg2_);
  public final static native boolean info_hash_t_op_lt(long jarg1, info_hash_t jarg1_, long jarg2, info_hash_t jarg2_);
  public final static native void info_hash_t_v1_set(long jarg1, info_hash_t jarg1_, long jarg2, sha1_hash jarg2_);
  public final static native long info_hash_t_v1_get(long jarg1, info_hash_t jarg1_);
  public final static native void info_hash_t_v2_set(long jarg1, info_hash_t jarg1_, long jarg2, sha256_hash jarg2_);
  public final static native long info_hash_t_v2_get(long jarg1, info_hash_t jarg1_);
  public final static native boolean info_hash_t_op_eq(long jarg1, info_hash_t jarg1_, long jarg2, info_hash_t jarg2_);
  public final static native boolean info_hash_t_op_ne(long jarg1, info_hash_t jarg1_, long jarg2, info_hash_t jarg2_);
  public final static native void delete_info_hash_t(long jarg1);
  public final static native int status_t_mask_get();
  public final static native int status_t_oversized_file_get();
  public final static native int op_or(int jarg1, int jarg2);
  public final static native int op_and(int jarg1, int jarg2);
  public final static native int op_inv(int jarg1);
  public final static native long new_bitfield__SWIG_0();
  public final static native long new_bitfield__SWIG_1(int jarg1);
  public final static native long new_bitfield__SWIG_2(int jarg1, boolean jarg2);
  public final static native long new_bitfield__SWIG_3(long jarg1, bitfield jarg1_);
  public final static native boolean bitfield_op_at(long jarg1, bitfield jarg1_, int jarg2);
  public final static native boolean bitfield_get_bit(long jarg1, bitfield jarg1_, int jarg2);
  public final static native void bitfield_clear_bit(long jarg1, bitfield jarg1_, int jarg2);
  public final static native void bitfield_set_bit(long jarg1, bitfield jarg1_, int jarg2);
  public final static native boolean bitfield_all_set(long jarg1, bitfield jarg1_);
  public final static native boolean bitfield_none_set(long jarg1, bitfield jarg1_);
  public final static native int bitfield_size(long jarg1, bitfield jarg1_);
  public final static native int bitfield_num_words(long jarg1, bitfield jarg1_);
  public final static native boolean bitfield_empty(long jarg1, bitfield jarg1_);
  public final static native void bitfield_swap(long jarg1, bitfield jarg1_, long jarg2, bitfield jarg2_);
  public final static native int bitfield_count(long jarg1, bitfield jarg1_);
  public final static native int bitfield_find_first_set(long jarg1, bitfield jarg1_);
  public final static native int bitfield_find_last_clear(long jarg1, bitfield jarg1_);
  public final static native void bitfield_resize__SWIG_0(long jarg1, bitfield jarg1_, int jarg2, boolean jarg3);
  public final static native void bitfield_resize__SWIG_1(long jarg1, bitfield jarg1_, int jarg2);
  public final static native void bitfield_set_all(long jarg1, bitfield jarg1_);
  public final static native void bitfield_clear_all(long jarg1, bitfield jarg1_);
  public final static native void bitfield_clear(long jarg1, bitfield jarg1_);
  public final static native long new_bitfield__SWIG_4(long jarg1, byte_vector jarg1_);
  public final static native void bitfield_assign(long jarg1, bitfield jarg1_, long jarg2, byte_vector jarg2_);
  public final static native void delete_bitfield(long jarg1);
  public final static native String operation_name(int jarg1);
  public final static native int libtorrent_no_error_get();
  public final static native int missing_file_sizes_get();
  public final static native int http_parse_error_get();
  public final static native int no_i2p_router_get();
  public final static native int no_i2p_endpoint_get();
  public final static native int scrape_not_available_get();
  public final static native int no_entropy_get();
  public final static native int torrent_unknown_version_get();
  public final static native int cont_get();
  public final static native int ok_get();
  public final static native int created_get();
  public final static native int accepted_get();
  public final static native int no_content_get();
  public final static native int multiple_choices_get();
  public final static native int moved_permanently_get();
  public final static native int moved_temporarily_get();
  public final static native int not_modified_get();
  public final static native int bad_request_get();
  public final static native int unauthorized_get();
  public final static native int forbidden_get();
  public final static native int not_found_get();
  public final static native int internal_server_error_get();
  public final static native int not_implemented_get();
  public final static native int bad_gateway_get();
  public final static native int service_unavailable_get();
  public final static native String print_error(long jarg1, error_code jarg1_);
  public final static native void announce_infohash_message_set(long jarg1, announce_infohash jarg1_, String jarg2);
  public final static native String announce_infohash_message_get(long jarg1, announce_infohash jarg1_);
  public final static native void announce_infohash_last_error_set(long jarg1, announce_infohash jarg1_, long jarg2, error_code jarg2_);
  public final static native long announce_infohash_last_error_get(long jarg1, announce_infohash jarg1_);
  public final static native void announce_infohash_scrape_incomplete_set(long jarg1, announce_infohash jarg1_, int jarg2);
  public final static native int announce_infohash_scrape_incomplete_get(long jarg1, announce_infohash jarg1_);
  public final static native void announce_infohash_scrape_complete_set(long jarg1, announce_infohash jarg1_, int jarg2);
  public final static native int announce_infohash_scrape_complete_get(long jarg1, announce_infohash jarg1_);
  public final static native void announce_infohash_scrape_downloaded_set(long jarg1, announce_infohash jarg1_, int jarg2);
  public final static native int announce_infohash_scrape_downloaded_get(long jarg1, announce_infohash jarg1_);
  public final static native void announce_infohash_fails_set(long jarg1, announce_infohash jarg1_, short jarg2);
  public final static native short announce_infohash_fails_get(long jarg1, announce_infohash jarg1_);
  public final static native void announce_infohash_updating_set(long jarg1, announce_infohash jarg1_, boolean jarg2);
  public final static native boolean announce_infohash_updating_get(long jarg1, announce_infohash jarg1_);
  public final static native void announce_infohash_start_sent_set(long jarg1, announce_infohash jarg1_, boolean jarg2);
  public final static native boolean announce_infohash_start_sent_get(long jarg1, announce_infohash jarg1_);
  public final static native void announce_infohash_complete_sent_set(long jarg1, announce_infohash jarg1_, boolean jarg2);
  public final static native boolean announce_infohash_complete_sent_get(long jarg1, announce_infohash jarg1_);
  public final static native void announce_infohash_triggered_manually_set(long jarg1, announce_infohash jarg1_, boolean jarg2);
  public final static native boolean announce_infohash_triggered_manually_get(long jarg1, announce_infohash jarg1_);
  public final static native long announce_infohash_get_next_announce(long jarg1, announce_infohash jarg1_);
  public final static native long announce_infohash_get_min_announce(long jarg1, announce_infohash jarg1_);
  public final static native void delete_announce_infohash(long jarg1);
  public final static native long new_announce_endpoint();
  public final static native void announce_endpoint_local_endpoint_set(long jarg1, announce_endpoint jarg1_, long jarg2, tcp_endpoint jarg2_);
  public final static native long announce_endpoint_local_endpoint_get(long jarg1, announce_endpoint jarg1_);
  public final static native void announce_endpoint_enabled_set(long jarg1, announce_endpoint jarg1_, boolean jarg2);
  public final static native boolean announce_endpoint_enabled_get(long jarg1, announce_endpoint jarg1_);
  public final static native long announce_endpoint_get_infohash_v1(long jarg1, announce_endpoint jarg1_);
  public final static native long announce_endpoint_get_infohash_v2(long jarg1, announce_endpoint jarg1_);
  public final static native void delete_announce_endpoint(long jarg1);
  public final static native long new_announce_entry__SWIG_0();
  public final static native void delete_announce_entry(long jarg1);
  public final static native long new_announce_entry__SWIG_1(long jarg1, announce_entry jarg1_);
  public final static native void announce_entry_url_set(long jarg1, announce_entry jarg1_, String jarg2);
  public final static native String announce_entry_url_get(long jarg1, announce_entry jarg1_);
  public final static native void announce_entry_trackerid_set(long jarg1, announce_entry jarg1_, String jarg2);
  public final static native String announce_entry_trackerid_get(long jarg1, announce_entry jarg1_);
  public final static native void announce_entry_endpoints_set(long jarg1, announce_entry jarg1_, long jarg2, announce_endpoint_vector jarg2_);
  public final static native long announce_entry_endpoints_get(long jarg1, announce_entry jarg1_);
  public final static native void announce_entry_tier_set(long jarg1, announce_entry jarg1_, short jarg2);
  public final static native short announce_entry_tier_get(long jarg1, announce_entry jarg1_);
  public final static native void announce_entry_fail_limit_set(long jarg1, announce_entry jarg1_, short jarg2);
  public final static native short announce_entry_fail_limit_get(long jarg1, announce_entry jarg1_);
  public final static native int announce_entry_source_torrent_get();
  public final static native int announce_entry_source_client_get();
  public final static native int announce_entry_source_magnet_link_get();
  public final static native int announce_entry_source_tex_get();
  public final static native void announce_entry_source_set(long jarg1, announce_entry jarg1_, short jarg2);
  public final static native short announce_entry_source_get(long jarg1, announce_entry jarg1_);
  public final static native void announce_entry_verified_set(long jarg1, announce_entry jarg1_, boolean jarg2);
  public final static native boolean announce_entry_verified_get(long jarg1, announce_entry jarg1_);
  public final static native long new_announce_entry__SWIG_2(String jarg1);
  public final static native long new_announce_entry__SWIG_3(long jarg1, byte_vector jarg1_);
  public final static native long announce_entry_get_url(long jarg1, announce_entry jarg1_);
  public final static native void announce_entry_set_url(long jarg1, announce_entry jarg1_, long jarg2, byte_vector jarg2_);
  public final static native long announce_entry_get_trackerid(long jarg1, announce_entry jarg1_);
  public final static native void announce_entry_set_trackerid(long jarg1, announce_entry jarg1_, long jarg2, byte_vector jarg2_);
  public final static native void file_slice_file_index_set(long jarg1, file_slice jarg1_, int jarg2);
  public final static native int file_slice_file_index_get(long jarg1, file_slice jarg1_);
  public final static native void file_slice_offset_set(long jarg1, file_slice jarg1_, long jarg2);
  public final static native long file_slice_offset_get(long jarg1, file_slice jarg1_);
  public final static native void file_slice_size_set(long jarg1, file_slice jarg1_, long jarg2);
  public final static native long file_slice_size_get(long jarg1, file_slice jarg1_);
  public final static native long new_file_slice();
  public final static native void delete_file_slice(long jarg1);
  public final static native long new_file_storage__SWIG_0();
  public final static native void delete_file_storage(long jarg1);
  public final static native long new_file_storage__SWIG_1(long jarg1, file_storage jarg1_);
  public final static native long file_storage_max_file_size_get();
  public final static native long file_storage_max_file_offset_get();
  public final static native int file_storage_max_num_pieces_get();
  public final static native int file_storage_max_piece_size_get();
  public final static native boolean file_storage_is_valid(long jarg1, file_storage jarg1_);
  public final static native void file_storage_reserve(long jarg1, file_storage jarg1_, int jarg2);
  public final static native void file_storage_rename_file(long jarg1, file_storage jarg1_, int jarg2, String jarg3);
  public final static native long file_storage_map_block(long jarg1, file_storage jarg1_, int jarg2, long jarg3, long jarg4);
  public final static native long file_storage_map_file(long jarg1, file_storage jarg1_, int jarg2, long jarg3, int jarg4);
  public final static native int file_storage_num_files(long jarg1, file_storage jarg1_);
  public final static native int file_storage_end_file(long jarg1, file_storage jarg1_);
  public final static native long file_storage_total_size(long jarg1, file_storage jarg1_);
  public final static native void file_storage_set_num_pieces(long jarg1, file_storage jarg1_, int jarg2);
  public final static native int file_storage_num_pieces(long jarg1, file_storage jarg1_);
  public final static native int file_storage_end_piece(long jarg1, file_storage jarg1_);
  public final static native int file_storage_last_piece(long jarg1, file_storage jarg1_);
  public final static native void file_storage_set_piece_length(long jarg1, file_storage jarg1_, int jarg2);
  public final static native int file_storage_piece_length(long jarg1, file_storage jarg1_);
  public final static native int file_storage_piece_size(long jarg1, file_storage jarg1_, int jarg2);
  public final static native int file_storage_piece_size2(long jarg1, file_storage jarg1_, int jarg2);
  public final static native int file_storage_blocks_in_piece2(long jarg1, file_storage jarg1_, int jarg2);
  public final static native int file_storage_blocks_per_piece(long jarg1, file_storage jarg1_);
  public final static native void file_storage_set_name(long jarg1, file_storage jarg1_, String jarg2);
  public final static native String file_storage_name(long jarg1, file_storage jarg1_);
  public final static native void file_storage_swap(long jarg1, file_storage jarg1_, long jarg2, file_storage jarg2_);
  public final static native void file_storage_canonicalize(long jarg1, file_storage jarg1_);
  public final static native long file_storage_hash(long jarg1, file_storage jarg1_, int jarg2);
  public final static native long file_storage_root(long jarg1, file_storage jarg1_, int jarg2);
  public final static native String file_storage_root_ptr(long jarg1, file_storage jarg1_, int jarg2);
  public final static native String file_storage_symlink(long jarg1, file_storage jarg1_, int jarg2);
  public final static native long file_storage_mtime(long jarg1, file_storage jarg1_, int jarg2);
  public final static native String file_storage_file_path__SWIG_0(long jarg1, file_storage jarg1_, int jarg2, String jarg3);
  public final static native String file_storage_file_path__SWIG_1(long jarg1, file_storage jarg1_, int jarg2);
  public final static native long file_storage_file_size(long jarg1, file_storage jarg1_, int jarg2);
  public final static native boolean file_storage_pad_file_at(long jarg1, file_storage jarg1_, int jarg2);
  public final static native long file_storage_file_offset(long jarg1, file_storage jarg1_, int jarg2);
  public final static native int file_storage_file_num_pieces(long jarg1, file_storage jarg1_, int jarg2);
  public final static native int file_storage_file_num_blocks(long jarg1, file_storage jarg1_, int jarg2);
  public final static native int file_storage_file_first_piece_node(long jarg1, file_storage jarg1_, int jarg2);
  public final static native int file_storage_file_first_block_node(long jarg1, file_storage jarg1_, int jarg2);
  public final static native long file_storage_flag_pad_file_get();
  public final static native long file_storage_flag_hidden_get();
  public final static native long file_storage_flag_executable_get();
  public final static native long file_storage_flag_symlink_get();
  public final static native long file_storage_file_flags(long jarg1, file_storage jarg1_, int jarg2);
  public final static native boolean file_storage_file_absolute_path(long jarg1, file_storage jarg1_, int jarg2);
  public final static native int file_storage_file_index_at_offset(long jarg1, file_storage jarg1_, long jarg2);
  public final static native int file_storage_file_index_at_piece(long jarg1, file_storage jarg1_, int jarg2);
  public final static native int file_storage_file_index_for_root(long jarg1, file_storage jarg1_, long jarg2, sha256_hash jarg2_);
  public final static native int file_storage_piece_index_at_file(long jarg1, file_storage jarg1_, int jarg2);
  public final static native boolean file_storage_v2(long jarg1, file_storage jarg1_);
  public final static native void file_storage_canonicalize_impl(long jarg1, file_storage jarg1_, boolean jarg2);
  public final static native void file_storage_add_file_ex__SWIG_0(long jarg1, file_storage jarg1_, long jarg2, error_code jarg2_, String jarg3, long jarg4, long jarg5, file_flags_t jarg5_, long jarg6, String jarg7);
  public final static native void file_storage_add_file_ex__SWIG_1(long jarg1, file_storage jarg1_, long jarg2, error_code jarg2_, String jarg3, long jarg4, long jarg5, file_flags_t jarg5_, long jarg6);
  public final static native void file_storage_add_file_ex__SWIG_2(long jarg1, file_storage jarg1_, long jarg2, error_code jarg2_, String jarg3, long jarg4, long jarg5, file_flags_t jarg5_);
  public final static native void file_storage_add_file_ex__SWIG_3(long jarg1, file_storage jarg1_, long jarg2, error_code jarg2_, String jarg3, long jarg4);
  public final static native String file_storage_file_name_ex(long jarg1, file_storage jarg1_, int jarg2);
  public final static native long file_storage_file_paths_ex(long jarg1, file_storage jarg1_);
  public final static native void peer_request_piece_set(long jarg1, peer_request jarg1_, int jarg2);
  public final static native int peer_request_piece_get(long jarg1, peer_request jarg1_);
  public final static native void peer_request_start_set(long jarg1, peer_request jarg1_, int jarg2);
  public final static native int peer_request_start_get(long jarg1, peer_request jarg1_);
  public final static native void peer_request_length_set(long jarg1, peer_request jarg1_, int jarg2);
  public final static native int peer_request_length_get(long jarg1, peer_request jarg1_);
  public final static native boolean peer_request_op_eq(long jarg1, peer_request jarg1_, long jarg2, peer_request jarg2_);
  public final static native long new_peer_request();
  public final static native void delete_peer_request(long jarg1);
  public final static native int bdecode_no_error_get();
  public final static native long new_bdecode_node__SWIG_0();
  public final static native long new_bdecode_node__SWIG_1(long jarg1, bdecode_node jarg1_);
  public final static native int bdecode_node_type(long jarg1, bdecode_node jarg1_);
  public final static native boolean bdecode_node_op_bool(long jarg1, bdecode_node jarg1_);
  public final static native long bdecode_node_data_offset(long jarg1, bdecode_node jarg1_);
  public final static native long bdecode_node_list_at(long jarg1, bdecode_node jarg1_, int jarg2);
  public final static native long bdecode_node_list_int_value_at__SWIG_0(long jarg1, bdecode_node jarg1_, int jarg2, long jarg3);
  public final static native long bdecode_node_list_int_value_at__SWIG_1(long jarg1, bdecode_node jarg1_, int jarg2);
  public final static native int bdecode_node_list_size(long jarg1, bdecode_node jarg1_);
  public final static native long bdecode_node_dict_at_node(long jarg1, bdecode_node jarg1_, int jarg2);
  public final static native int bdecode_node_dict_size(long jarg1, bdecode_node jarg1_);
  public final static native long bdecode_node_int_value(long jarg1, bdecode_node jarg1_);
  public final static native int bdecode_node_string_length(long jarg1, bdecode_node jarg1_);
  public final static native long bdecode_node_string_offset(long jarg1, bdecode_node jarg1_);
  public final static native void bdecode_node_clear(long jarg1, bdecode_node jarg1_);
  public final static native String bdecode_node_list_string_value_at_s__SWIG_0(long jarg1, bdecode_node jarg1_, int jarg2, String jarg3);
  public final static native String bdecode_node_list_string_value_at_s__SWIG_1(long jarg1, bdecode_node jarg1_, int jarg2);
  public final static native long bdecode_node_dict_find_s(long jarg1, bdecode_node jarg1_, String jarg2);
  public final static native long bdecode_node_dict_find_dict_s(long jarg1, bdecode_node jarg1_, String jarg2);
  public final static native long bdecode_node_dict_find_list_s(long jarg1, bdecode_node jarg1_, String jarg2);
  public final static native long bdecode_node_dict_find_string_s(long jarg1, bdecode_node jarg1_, String jarg2);
  public final static native long bdecode_node_dict_find_int_s(long jarg1, bdecode_node jarg1_, String jarg2);
  public final static native String bdecode_node_dict_find_string_value_s__SWIG_0(long jarg1, bdecode_node jarg1_, String jarg2, String jarg3);
  public final static native String bdecode_node_dict_find_string_value_s__SWIG_1(long jarg1, bdecode_node jarg1_, String jarg2);
  public final static native long bdecode_node_dict_find_int_value_s__SWIG_0(long jarg1, bdecode_node jarg1_, String jarg2, long jarg3);
  public final static native long bdecode_node_dict_find_int_value_s__SWIG_1(long jarg1, bdecode_node jarg1_, String jarg2);
  public final static native String bdecode_node_string_value_s(long jarg1, bdecode_node jarg1_);
  public final static native String bdecode_node_string_value_ex(long jarg1, bdecode_node jarg1_);
  public final static native String bdecode_node_to_string(long jarg1, bdecode_node jarg1_, boolean jarg2, int jarg3);
  public final static native int bdecode_node_bdecode(long jarg1, byte_vector jarg1_, long jarg2, bdecode_node jarg2_, long jarg3, error_code jarg3_);
  public final static native void delete_bdecode_node(long jarg1);
  public final static native long new_web_seed_entry__SWIG_0(String jarg1, int jarg2, String jarg3, long jarg4, string_string_pair_vector jarg4_);
  public final static native long new_web_seed_entry__SWIG_1(String jarg1, int jarg2, String jarg3);
  public final static native long new_web_seed_entry__SWIG_2(String jarg1, int jarg2);
  public final static native boolean web_seed_entry_op_eq(long jarg1, web_seed_entry jarg1_, long jarg2, web_seed_entry jarg2_);
  public final static native boolean web_seed_entry_op_lt(long jarg1, web_seed_entry jarg1_, long jarg2, web_seed_entry jarg2_);
  public final static native void web_seed_entry_url_set(long jarg1, web_seed_entry jarg1_, String jarg2);
  public final static native String web_seed_entry_url_get(long jarg1, web_seed_entry jarg1_);
  public final static native void web_seed_entry_auth_set(long jarg1, web_seed_entry jarg1_, String jarg2);
  public final static native String web_seed_entry_auth_get(long jarg1, web_seed_entry jarg1_);
  public final static native void web_seed_entry_extra_headers_set(long jarg1, web_seed_entry jarg1_, long jarg2, string_string_pair_vector jarg2_);
  public final static native long web_seed_entry_extra_headers_get(long jarg1, web_seed_entry jarg1_);
  public final static native void web_seed_entry_type_set(long jarg1, web_seed_entry jarg1_, short jarg2);
  public final static native short web_seed_entry_type_get(long jarg1, web_seed_entry jarg1_);
  public final static native void delete_web_seed_entry(long jarg1);
  public final static native void load_torrent_limits_max_buffer_size_set(long jarg1, load_torrent_limits jarg1_, int jarg2);
  public final static native int load_torrent_limits_max_buffer_size_get(long jarg1, load_torrent_limits jarg1_);
  public final static native void load_torrent_limits_max_pieces_set(long jarg1, load_torrent_limits jarg1_, int jarg2);
  public final static native int load_torrent_limits_max_pieces_get(long jarg1, load_torrent_limits jarg1_);
  public final static native void load_torrent_limits_max_decode_depth_set(long jarg1, load_torrent_limits jarg1_, int jarg2);
  public final static native int load_torrent_limits_max_decode_depth_get(long jarg1, load_torrent_limits jarg1_);
  public final static native void load_torrent_limits_max_decode_tokens_set(long jarg1, load_torrent_limits jarg1_, int jarg2);
  public final static native int load_torrent_limits_max_decode_tokens_get(long jarg1, load_torrent_limits jarg1_);
  public final static native long new_load_torrent_limits();
  public final static native void delete_load_torrent_limits(long jarg1);
  public final static native long new_torrent_info__SWIG_0(long jarg1, torrent_info jarg1_);
  public final static native long new_torrent_info__SWIG_1(long jarg1, info_hash_t jarg1_);
  public final static native long new_torrent_info__SWIG_2(long jarg1, bdecode_node jarg1_, long jarg2, error_code jarg2_);
  public final static native long new_torrent_info__SWIG_3(String jarg1, long jarg2, error_code jarg2_);
  public final static native void delete_torrent_info(long jarg1);
  public final static native long torrent_info_files(long jarg1, torrent_info jarg1_);
  public final static native long torrent_info_orig_files(long jarg1, torrent_info jarg1_);
  public final static native void torrent_info_rename_file(long jarg1, torrent_info jarg1_, int jarg2, String jarg3);
  public final static native void torrent_info_remap_files(long jarg1, torrent_info jarg1_, long jarg2, file_storage jarg2_);
  public final static native void torrent_info_add_tracker__SWIG_0(long jarg1, torrent_info jarg1_, String jarg2, int jarg3);
  public final static native void torrent_info_add_tracker__SWIG_1(long jarg1, torrent_info jarg1_, String jarg2);
  public final static native void torrent_info_add_tracker__SWIG_2(long jarg1, torrent_info jarg1_, String jarg2, int jarg3, int jarg4);
  public final static native long torrent_info_trackers(long jarg1, torrent_info jarg1_);
  public final static native void torrent_info_clear_trackers(long jarg1, torrent_info jarg1_);
  public final static native long torrent_info_similar_torrents__SWIG_0(long jarg1, torrent_info jarg1_);
  public final static native long torrent_info_collections(long jarg1, torrent_info jarg1_);
  public final static native void torrent_info_add_url_seed__SWIG_0(long jarg1, torrent_info jarg1_, String jarg2, String jarg3, long jarg4, string_string_pair_vector jarg4_);
  public final static native void torrent_info_add_url_seed__SWIG_1(long jarg1, torrent_info jarg1_, String jarg2, String jarg3);
  public final static native void torrent_info_add_url_seed__SWIG_2(long jarg1, torrent_info jarg1_, String jarg2);
  public final static native void torrent_info_add_http_seed__SWIG_0(long jarg1, torrent_info jarg1_, String jarg2, String jarg3, long jarg4, string_string_pair_vector jarg4_);
  public final static native void torrent_info_add_http_seed__SWIG_1(long jarg1, torrent_info jarg1_, String jarg2, String jarg3);
  public final static native void torrent_info_add_http_seed__SWIG_2(long jarg1, torrent_info jarg1_, String jarg2);
  public final static native long torrent_info_web_seeds(long jarg1, torrent_info jarg1_);
  public final static native void torrent_info_set_web_seeds(long jarg1, torrent_info jarg1_, long jarg2, web_seed_entry_vector jarg2_);
  public final static native long torrent_info_total_size(long jarg1, torrent_info jarg1_);
  public final static native int torrent_info_piece_length(long jarg1, torrent_info jarg1_);
  public final static native int torrent_info_num_pieces(long jarg1, torrent_info jarg1_);
  public final static native int torrent_info_blocks_per_piece(long jarg1, torrent_info jarg1_);
  public final static native int torrent_info_last_piece(long jarg1, torrent_info jarg1_);
  public final static native int torrent_info_end_piece(long jarg1, torrent_info jarg1_);
  public final static native long torrent_info_info_hash(long jarg1, torrent_info jarg1_);
  public final static native long torrent_info_info_hashes(long jarg1, torrent_info jarg1_);
  public final static native boolean torrent_info_v1(long jarg1, torrent_info jarg1_);
  public final static native boolean torrent_info_v2(long jarg1, torrent_info jarg1_);
  public final static native int torrent_info_num_files(long jarg1, torrent_info jarg1_);
  public final static native long torrent_info_map_block(long jarg1, torrent_info jarg1_, int jarg2, long jarg3, int jarg4);
  public final static native long torrent_info_map_file(long jarg1, torrent_info jarg1_, int jarg2, long jarg3, int jarg4);
  public final static native boolean torrent_info_is_valid(long jarg1, torrent_info jarg1_);
  public final static native boolean torrent_info_priv(long jarg1, torrent_info jarg1_);
  public final static native boolean torrent_info_is_i2p(long jarg1, torrent_info jarg1_);
  public final static native int torrent_info_piece_size(long jarg1, torrent_info jarg1_, int jarg2);
  public final static native long torrent_info_hash_for_piece(long jarg1, torrent_info jarg1_, int jarg2);
  public final static native boolean torrent_info_is_loaded(long jarg1, torrent_info jarg1_);
  public final static native String torrent_info_name(long jarg1, torrent_info jarg1_);
  public final static native long torrent_info_creation_date(long jarg1, torrent_info jarg1_);
  public final static native String torrent_info_creator(long jarg1, torrent_info jarg1_);
  public final static native String torrent_info_comment(long jarg1, torrent_info jarg1_);
  public final static native long torrent_info_nodes(long jarg1, torrent_info jarg1_);
  public final static native void torrent_info_add_node(long jarg1, torrent_info jarg1_, long jarg2, string_int_pair jarg2_);
  public final static native long torrent_info_info(long jarg1, torrent_info jarg1_, String jarg2);
  public final static native void torrent_info_free_piece_layers(long jarg1, torrent_info jarg1_);
  public final static native long new_torrent_info__SWIG_4(long jarg1, int jarg2, long jarg3, error_code jarg3_);
  public final static native long torrent_info_get_info_section(long jarg1, torrent_info jarg1_);
  public final static native String torrent_info_get_ssl_cert(long jarg1, torrent_info jarg1_);
  public final static native long seed_mode_get();
  public final static native long upload_mode_get();
  public final static native long share_mode_get();
  public final static native long apply_ip_filter_get();
  public final static native long paused_get();
  public final static native long auto_managed_get();
  public final static native long duplicate_is_error_get();
  public final static native long update_subscribe_get();
  public final static native long super_seeding_get();
  public final static native long sequential_download_get();
  public final static native long stop_when_ready_get();
  public final static native long override_trackers_get();
  public final static native long override_web_seeds_get();
  public final static native long need_save_resume_get();
  public final static native long disable_dht_get();
  public final static native long disable_lsd_get();
  public final static native long disable_pex_get();
  public final static native long no_verify_files_get();
  public final static native long default_dont_download_get();
  public final static native long i2p_torrent_get();
  public final static native long all_get();
  public final static native long default_flags_get();
  public final static native long new_torrent_flags_t();
  public final static native long torrent_flags_t_all();
  public final static native boolean torrent_flags_t_non_zero(long jarg1, torrent_flags_t jarg1_);
  public final static native boolean torrent_flags_t_nonZero(long jarg1, torrent_flags_t jarg1_);
  public final static native boolean torrent_flags_t_eq(long jarg1, torrent_flags_t jarg1_, long jarg2, torrent_flags_t jarg2_);
  public final static native boolean torrent_flags_t_ne(long jarg1, torrent_flags_t jarg1_, long jarg2, torrent_flags_t jarg2_);
  public final static native long torrent_flags_t_or_(long jarg1, torrent_flags_t jarg1_, long jarg2, torrent_flags_t jarg2_);
  public final static native long torrent_flags_t_and_(long jarg1, torrent_flags_t jarg1_, long jarg2, torrent_flags_t jarg2_);
  public final static native long torrent_flags_t_xor_(long jarg1, torrent_flags_t jarg1_, long jarg2, torrent_flags_t jarg2_);
  public final static native long torrent_flags_t_inv(long jarg1, torrent_flags_t jarg1_);
  public final static native int torrent_flags_t_to_int(long jarg1, torrent_flags_t jarg1_);
  public final static native long torrent_flags_t_from_int(int jarg1);
  public final static native void delete_torrent_flags_t(long jarg1);
  public final static native void delete_add_torrent_params(long jarg1);
  public final static native void add_torrent_params_version_set(long jarg1, add_torrent_params jarg1_, int jarg2);
  public final static native int add_torrent_params_version_get(long jarg1, add_torrent_params jarg1_);
  public final static native void add_torrent_params_name_set(long jarg1, add_torrent_params jarg1_, String jarg2);
  public final static native String add_torrent_params_name_get(long jarg1, add_torrent_params jarg1_);
  public final static native void add_torrent_params_save_path_set(long jarg1, add_torrent_params jarg1_, String jarg2);
  public final static native String add_torrent_params_save_path_get(long jarg1, add_torrent_params jarg1_);
  public final static native void add_torrent_params_storage_mode_set(long jarg1, add_torrent_params jarg1_, int jarg2);
  public final static native int add_torrent_params_storage_mode_get(long jarg1, add_torrent_params jarg1_);
  public final static native void add_torrent_params_trackerid_set(long jarg1, add_torrent_params jarg1_, String jarg2);
  public final static native String add_torrent_params_trackerid_get(long jarg1, add_torrent_params jarg1_);
  public final static native void add_torrent_params_flags_set(long jarg1, add_torrent_params jarg1_, long jarg2, torrent_flags_t jarg2_);
  public final static native long add_torrent_params_flags_get(long jarg1, add_torrent_params jarg1_);
  public final static native void add_torrent_params_info_hashes_set(long jarg1, add_torrent_params jarg1_, long jarg2, info_hash_t jarg2_);
  public final static native long add_torrent_params_info_hashes_get(long jarg1, add_torrent_params jarg1_);
  public final static native void add_torrent_params_max_uploads_set(long jarg1, add_torrent_params jarg1_, int jarg2);
  public final static native int add_torrent_params_max_uploads_get(long jarg1, add_torrent_params jarg1_);
  public final static native void add_torrent_params_max_connections_set(long jarg1, add_torrent_params jarg1_, int jarg2);
  public final static native int add_torrent_params_max_connections_get(long jarg1, add_torrent_params jarg1_);
  public final static native void add_torrent_params_upload_limit_set(long jarg1, add_torrent_params jarg1_, int jarg2);
  public final static native int add_torrent_params_upload_limit_get(long jarg1, add_torrent_params jarg1_);
  public final static native void add_torrent_params_download_limit_set(long jarg1, add_torrent_params jarg1_, int jarg2);
  public final static native int add_torrent_params_download_limit_get(long jarg1, add_torrent_params jarg1_);
  public final static native void add_torrent_params_total_uploaded_set(long jarg1, add_torrent_params jarg1_, long jarg2);
  public final static native long add_torrent_params_total_uploaded_get(long jarg1, add_torrent_params jarg1_);
  public final static native void add_torrent_params_total_downloaded_set(long jarg1, add_torrent_params jarg1_, long jarg2);
  public final static native long add_torrent_params_total_downloaded_get(long jarg1, add_torrent_params jarg1_);
  public final static native void add_torrent_params_active_time_set(long jarg1, add_torrent_params jarg1_, int jarg2);
  public final static native int add_torrent_params_active_time_get(long jarg1, add_torrent_params jarg1_);
  public final static native void add_torrent_params_finished_time_set(long jarg1, add_torrent_params jarg1_, int jarg2);
  public final static native int add_torrent_params_finished_time_get(long jarg1, add_torrent_params jarg1_);
  public final static native void add_torrent_params_seeding_time_set(long jarg1, add_torrent_params jarg1_, int jarg2);
  public final static native int add_torrent_params_seeding_time_get(long jarg1, add_torrent_params jarg1_);
  public final static native void add_torrent_params_added_time_set(long jarg1, add_torrent_params jarg1_, long jarg2);
  public final static native long add_torrent_params_added_time_get(long jarg1, add_torrent_params jarg1_);
  public final static native void add_torrent_params_completed_time_set(long jarg1, add_torrent_params jarg1_, long jarg2);
  public final static native long add_torrent_params_completed_time_get(long jarg1, add_torrent_params jarg1_);
  public final static native void add_torrent_params_last_seen_complete_set(long jarg1, add_torrent_params jarg1_, long jarg2);
  public final static native long add_torrent_params_last_seen_complete_get(long jarg1, add_torrent_params jarg1_);
  public final static native void add_torrent_params_num_complete_set(long jarg1, add_torrent_params jarg1_, int jarg2);
  public final static native int add_torrent_params_num_complete_get(long jarg1, add_torrent_params jarg1_);
  public final static native void add_torrent_params_num_incomplete_set(long jarg1, add_torrent_params jarg1_, int jarg2);
  public final static native int add_torrent_params_num_incomplete_get(long jarg1, add_torrent_params jarg1_);
  public final static native void add_torrent_params_num_downloaded_set(long jarg1, add_torrent_params jarg1_, int jarg2);
  public final static native int add_torrent_params_num_downloaded_get(long jarg1, add_torrent_params jarg1_);
  public final static native void add_torrent_params_last_download_set(long jarg1, add_torrent_params jarg1_, long jarg2);
  public final static native long add_torrent_params_last_download_get(long jarg1, add_torrent_params jarg1_);
  public final static native void add_torrent_params_last_upload_set(long jarg1, add_torrent_params jarg1_, long jarg2);
  public final static native long add_torrent_params_last_upload_get(long jarg1, add_torrent_params jarg1_);
  public final static native long add_torrent_params_ti_ptr(long jarg1, add_torrent_params jarg1_);
  public final static native void add_torrent_params_set_ti(long jarg1, add_torrent_params jarg1_, long jarg2, torrent_info jarg2_);
  public final static native long add_torrent_params_get_file_priorities(long jarg1, add_torrent_params jarg1_);
  public final static native void add_torrent_params_set_renamed_files__SWIG_0(long jarg1, add_torrent_params jarg1_, long jarg2);
  public final static native void add_torrent_params_set_renamed_files__SWIG_1(long jarg1, add_torrent_params jarg1_, long jarg2, int_string_map jarg2_);
  public final static native long add_torrent_params_get_tracker_tiers(long jarg1, add_torrent_params jarg1_);
  public final static native void add_torrent_params_set_tracker_tiers(long jarg1, add_torrent_params jarg1_, long jarg2, int_vector jarg2_);
  public final static native long add_torrent_params_get_banned_peers(long jarg1, add_torrent_params jarg1_);
  public final static native void add_torrent_params_set_banned_peers(long jarg1, add_torrent_params jarg1_, long jarg2, tcp_endpoint_vector jarg2_);
  public final static native long add_torrent_params_get_peers(long jarg1, add_torrent_params jarg1_);
  public final static native void add_torrent_params_set_peers(long jarg1, add_torrent_params jarg1_, long jarg2, tcp_endpoint_vector jarg2_);
  public final static native void add_torrent_params_set_file_priorities2(long jarg1, add_torrent_params jarg1_, long jarg2, byte_vector jarg2_);
  public final static native void add_torrent_params_set_file_priorities(long jarg1, add_torrent_params jarg1_, long jarg2, byte_vector jarg2_);
  public final static native long add_torrent_params_get_piece_priorities(long jarg1, add_torrent_params jarg1_);
  public final static native void add_torrent_params_set_piece_priorities(long jarg1, add_torrent_params jarg1_, long jarg2, byte_vector jarg2_);
  public final static native long add_torrent_params_get_dht_nodes(long jarg1, add_torrent_params jarg1_);
  public final static native void add_torrent_params_set_dht_nodes(long jarg1, add_torrent_params jarg1_, long jarg2, string_int_pair_vector jarg2_);
  public final static native void add_torrent_params_set_http_seeds(long jarg1, add_torrent_params jarg1_, long jarg2, string_vector jarg2_);
  public final static native long add_torrent_params_get_url_seeds(long jarg1, add_torrent_params jarg1_);
  public final static native void add_torrent_params_set_url_seeds(long jarg1, add_torrent_params jarg1_, long jarg2, string_vector jarg2_);
  public final static native long add_torrent_params_get_trackers(long jarg1, add_torrent_params jarg1_);
  public final static native void add_torrent_params_set_trackers(long jarg1, add_torrent_params jarg1_, long jarg2, string_vector jarg2_);
  public final static native long add_torrent_params_get_merkle_trees(long jarg1, add_torrent_params jarg1_);
  public final static native void add_torrent_params_set_merkle_trees(long jarg1, add_torrent_params jarg1_, long jarg2, sha256_hash_vector_vector jarg2_);
  public final static native long add_torrent_params_get_merkle_tree_mask(long jarg1, add_torrent_params jarg1_);
  public final static native void add_torrent_params_set_piece_priorities2(long jarg1, add_torrent_params jarg1_, long jarg2, byte_vector jarg2_);
  public final static native long add_torrent_params_get_verified_leaf_hashes_old(long jarg1, add_torrent_params jarg1_);
  public final static native long add_torrent_params_get_verified_leaf_hashes(long jarg1, add_torrent_params jarg1_);
  public final static native long add_torrent_params_get_unfinished_pieces(long jarg1, add_torrent_params jarg1_);
  public final static native void add_torrent_params_set_unfinished_pieces(long jarg1, add_torrent_params jarg1_, long jarg2, int_bitfield_map jarg2_);
  public final static native long add_torrent_params_get_renamed_files(long jarg1, add_torrent_params jarg1_);
  public final static native long add_torrent_params_get_have_pieces(long jarg1, add_torrent_params jarg1_);
  public final static native void add_torrent_params_set_have_pieces(long jarg1, add_torrent_params jarg1_, long jarg2, bitfield jarg2_);
  public final static native long add_torrent_params_get_verified_pieces(long jarg1, add_torrent_params jarg1_);
  public final static native void add_torrent_params_set_verified_pieces(long jarg1, add_torrent_params jarg1_, long jarg2, bitfield jarg2_);
  public final static native long add_torrent_params_create_instance();
  public final static native long add_torrent_params_read_resume_data__SWIG_0(long jarg1, bdecode_node jarg1_, long jarg2, error_code jarg2_);
  public final static native long add_torrent_params_read_resume_data__SWIG_1(long jarg1, byte_vector jarg1_, long jarg2, error_code jarg2_);
  public final static native long add_torrent_params_write_resume_data(long jarg1, add_torrent_params jarg1_);
  public final static native long add_torrent_params_write_resume_data_buf(long jarg1, add_torrent_params jarg1_);
  public final static native long add_torrent_params_parse_magnet_uri(String jarg1, long jarg2, error_code jarg2_);
  public final static native int close_reason_t_none_get();
  public final static native int close_reason_t_encryption_error_get();
  public final static native long new_peer_info__SWIG_0();
  public final static native void delete_peer_info(long jarg1);
  public final static native long new_peer_info__SWIG_1(long jarg1, peer_info jarg1_);
  public final static native void peer_info_total_download_set(long jarg1, peer_info jarg1_, long jarg2);
  public final static native long peer_info_total_download_get(long jarg1, peer_info jarg1_);
  public final static native void peer_info_total_upload_set(long jarg1, peer_info jarg1_, long jarg2);
  public final static native long peer_info_total_upload_get(long jarg1, peer_info jarg1_);
  public final static native long peer_info_interesting_get();
  public final static native long peer_info_choked_get();
  public final static native long peer_info_remote_interested_get();
  public final static native long peer_info_remote_choked_get();
  public final static native long peer_info_supports_extensions_get();
  public final static native long peer_info_outgoing_connection_get();
  public final static native long peer_info_local_connection_get();
  public final static native long peer_info_handshake_get();
  public final static native long peer_info_connecting_get();
  public final static native long peer_info_on_parole_get();
  public final static native long peer_info_seed_get();
  public final static native long peer_info_optimistic_unchoke_get();
  public final static native long peer_info_snubbed_get();
  public final static native long peer_info_upload_only_get();
  public final static native long peer_info_endgame_mode_get();
  public final static native long peer_info_holepunched_get();
  public final static native long peer_info_i2p_socket_get();
  public final static native long peer_info_utp_socket_get();
  public final static native long peer_info_ssl_socket_get();
  public final static native long peer_info_rc4_encrypted_get();
  public final static native long peer_info_plaintext_encrypted_get();
  public final static native void peer_info_flags_set(long jarg1, peer_info jarg1_, long jarg2, peer_flags_t jarg2_);
  public final static native long peer_info_flags_get(long jarg1, peer_info jarg1_);
  public final static native long peer_info_tracker_get();
  public final static native long peer_info_dht_get();
  public final static native long peer_info_pex_get();
  public final static native long peer_info_lsd_get();
  public final static native long peer_info_resume_data_get();
  public final static native long peer_info_incoming_get();
  public final static native void peer_info_source_set(long jarg1, peer_info jarg1_, long jarg2, peer_source_flags_t jarg2_);
  public final static native long peer_info_source_get(long jarg1, peer_info jarg1_);
  public final static native void peer_info_up_speed_set(long jarg1, peer_info jarg1_, int jarg2);
  public final static native int peer_info_up_speed_get(long jarg1, peer_info jarg1_);
  public final static native void peer_info_down_speed_set(long jarg1, peer_info jarg1_, int jarg2);
  public final static native int peer_info_down_speed_get(long jarg1, peer_info jarg1_);
  public final static native void peer_info_payload_up_speed_set(long jarg1, peer_info jarg1_, int jarg2);
  public final static native int peer_info_payload_up_speed_get(long jarg1, peer_info jarg1_);
  public final static native void peer_info_payload_down_speed_set(long jarg1, peer_info jarg1_, int jarg2);
  public final static native int peer_info_payload_down_speed_get(long jarg1, peer_info jarg1_);
  public final static native void peer_info_pid_set(long jarg1, peer_info jarg1_, long jarg2, sha1_hash jarg2_);
  public final static native long peer_info_pid_get(long jarg1, peer_info jarg1_);
  public final static native void peer_info_queue_bytes_set(long jarg1, peer_info jarg1_, int jarg2);
  public final static native int peer_info_queue_bytes_get(long jarg1, peer_info jarg1_);
  public final static native void peer_info_request_timeout_set(long jarg1, peer_info jarg1_, int jarg2);
  public final static native int peer_info_request_timeout_get(long jarg1, peer_info jarg1_);
  public final static native void peer_info_send_buffer_size_set(long jarg1, peer_info jarg1_, int jarg2);
  public final static native int peer_info_send_buffer_size_get(long jarg1, peer_info jarg1_);
  public final static native void peer_info_used_send_buffer_set(long jarg1, peer_info jarg1_, int jarg2);
  public final static native int peer_info_used_send_buffer_get(long jarg1, peer_info jarg1_);
  public final static native void peer_info_receive_buffer_size_set(long jarg1, peer_info jarg1_, int jarg2);
  public final static native int peer_info_receive_buffer_size_get(long jarg1, peer_info jarg1_);
  public final static native void peer_info_used_receive_buffer_set(long jarg1, peer_info jarg1_, int jarg2);
  public final static native int peer_info_used_receive_buffer_get(long jarg1, peer_info jarg1_);
  public final static native void peer_info_receive_buffer_watermark_set(long jarg1, peer_info jarg1_, int jarg2);
  public final static native int peer_info_receive_buffer_watermark_get(long jarg1, peer_info jarg1_);
  public final static native void peer_info_num_hashfails_set(long jarg1, peer_info jarg1_, int jarg2);
  public final static native int peer_info_num_hashfails_get(long jarg1, peer_info jarg1_);
  public final static native void peer_info_download_queue_length_set(long jarg1, peer_info jarg1_, int jarg2);
  public final static native int peer_info_download_queue_length_get(long jarg1, peer_info jarg1_);
  public final static native void peer_info_timed_out_requests_set(long jarg1, peer_info jarg1_, int jarg2);
  public final static native int peer_info_timed_out_requests_get(long jarg1, peer_info jarg1_);
  public final static native void peer_info_busy_requests_set(long jarg1, peer_info jarg1_, int jarg2);
  public final static native int peer_info_busy_requests_get(long jarg1, peer_info jarg1_);
  public final static native void peer_info_requests_in_buffer_set(long jarg1, peer_info jarg1_, int jarg2);
  public final static native int peer_info_requests_in_buffer_get(long jarg1, peer_info jarg1_);
  public final static native void peer_info_target_dl_queue_length_set(long jarg1, peer_info jarg1_, int jarg2);
  public final static native int peer_info_target_dl_queue_length_get(long jarg1, peer_info jarg1_);
  public final static native void peer_info_upload_queue_length_set(long jarg1, peer_info jarg1_, int jarg2);
  public final static native int peer_info_upload_queue_length_get(long jarg1, peer_info jarg1_);
  public final static native void peer_info_failcount_set(long jarg1, peer_info jarg1_, int jarg2);
  public final static native int peer_info_failcount_get(long jarg1, peer_info jarg1_);
  public final static native void peer_info_downloading_piece_index_set(long jarg1, peer_info jarg1_, int jarg2);
  public final static native int peer_info_downloading_piece_index_get(long jarg1, peer_info jarg1_);
  public final static native void peer_info_downloading_block_index_set(long jarg1, peer_info jarg1_, int jarg2);
  public final static native int peer_info_downloading_block_index_get(long jarg1, peer_info jarg1_);
  public final static native void peer_info_downloading_progress_set(long jarg1, peer_info jarg1_, int jarg2);
  public final static native int peer_info_downloading_progress_get(long jarg1, peer_info jarg1_);
  public final static native void peer_info_downloading_total_set(long jarg1, peer_info jarg1_, int jarg2);
  public final static native int peer_info_downloading_total_get(long jarg1, peer_info jarg1_);
  public final static native long peer_info_standard_bittorrent_get();
  public final static native long peer_info_web_seed_get();
  public final static native long peer_info_http_seed_get();
  public final static native void peer_info_connection_type_set(long jarg1, peer_info jarg1_, long jarg2, connection_type_t jarg2_);
  public final static native long peer_info_connection_type_get(long jarg1, peer_info jarg1_);
  public final static native void peer_info_pending_disk_bytes_set(long jarg1, peer_info jarg1_, int jarg2);
  public final static native int peer_info_pending_disk_bytes_get(long jarg1, peer_info jarg1_);
  public final static native void peer_info_pending_disk_read_bytes_set(long jarg1, peer_info jarg1_, int jarg2);
  public final static native int peer_info_pending_disk_read_bytes_get(long jarg1, peer_info jarg1_);
  public final static native void peer_info_send_quota_set(long jarg1, peer_info jarg1_, int jarg2);
  public final static native int peer_info_send_quota_get(long jarg1, peer_info jarg1_);
  public final static native void peer_info_receive_quota_set(long jarg1, peer_info jarg1_, int jarg2);
  public final static native int peer_info_receive_quota_get(long jarg1, peer_info jarg1_);
  public final static native void peer_info_rtt_set(long jarg1, peer_info jarg1_, int jarg2);
  public final static native int peer_info_rtt_get(long jarg1, peer_info jarg1_);
  public final static native void peer_info_num_pieces_set(long jarg1, peer_info jarg1_, int jarg2);
  public final static native int peer_info_num_pieces_get(long jarg1, peer_info jarg1_);
  public final static native void peer_info_download_rate_peak_set(long jarg1, peer_info jarg1_, int jarg2);
  public final static native int peer_info_download_rate_peak_get(long jarg1, peer_info jarg1_);
  public final static native void peer_info_upload_rate_peak_set(long jarg1, peer_info jarg1_, int jarg2);
  public final static native int peer_info_upload_rate_peak_get(long jarg1, peer_info jarg1_);
  public final static native void peer_info_progress_set(long jarg1, peer_info jarg1_, float jarg2);
  public final static native float peer_info_progress_get(long jarg1, peer_info jarg1_);
  public final static native void peer_info_progress_ppm_set(long jarg1, peer_info jarg1_, int jarg2);
  public final static native int peer_info_progress_ppm_get(long jarg1, peer_info jarg1_);
  public final static native void peer_info_ip_set(long jarg1, peer_info jarg1_, long jarg2, tcp_endpoint jarg2_);
  public final static native long peer_info_ip_get(long jarg1, peer_info jarg1_);
  public final static native void peer_info_local_endpoint_set(long jarg1, peer_info jarg1_, long jarg2, tcp_endpoint jarg2_);
  public final static native long peer_info_local_endpoint_get(long jarg1, peer_info jarg1_);
  public final static native long peer_info_bw_idle_get();
  public final static native long peer_info_bw_limit_get();
  public final static native long peer_info_bw_network_get();
  public final static native long peer_info_bw_disk_get();
  public final static native void peer_info_read_state_set(long jarg1, peer_info jarg1_, long jarg2, bandwidth_state_flags_t jarg2_);
  public final static native long peer_info_read_state_get(long jarg1, peer_info jarg1_);
  public final static native void peer_info_write_state_set(long jarg1, peer_info jarg1_, long jarg2, bandwidth_state_flags_t jarg2_);
  public final static native long peer_info_write_state_get(long jarg1, peer_info jarg1_);
  public final static native long peer_info_get_client(long jarg1, peer_info jarg1_);
  public final static native long peer_info_get_last_request(long jarg1, peer_info jarg1_);
  public final static native long peer_info_get_last_active(long jarg1, peer_info jarg1_);
  public final static native long peer_info_get_download_queue_time(long jarg1, peer_info jarg1_);
  public final static native int peer_info_get_flags(long jarg1, peer_info jarg1_);
  public final static native byte peer_info_get_source(long jarg1, peer_info jarg1_);
  public final static native byte peer_info_get_read_state(long jarg1, peer_info jarg1_);
  public final static native byte peer_info_get_write_state(long jarg1, peer_info jarg1_);
  public final static native long peer_info_get_pieces(long jarg1, peer_info jarg1_);
  public final static native long new_connection_type_t();
  public final static native long connection_type_t_all();
  public final static native boolean connection_type_t_non_zero(long jarg1, connection_type_t jarg1_);
  public final static native boolean connection_type_t_nonZero(long jarg1, connection_type_t jarg1_);
  public final static native boolean connection_type_t_eq(long jarg1, connection_type_t jarg1_, long jarg2, connection_type_t jarg2_);
  public final static native boolean connection_type_t_ne(long jarg1, connection_type_t jarg1_, long jarg2, connection_type_t jarg2_);
  public final static native long connection_type_t_or_(long jarg1, connection_type_t jarg1_, long jarg2, connection_type_t jarg2_);
  public final static native long connection_type_t_and_(long jarg1, connection_type_t jarg1_, long jarg2, connection_type_t jarg2_);
  public final static native long connection_type_t_xor_(long jarg1, connection_type_t jarg1_, long jarg2, connection_type_t jarg2_);
  public final static native long connection_type_t_inv(long jarg1, connection_type_t jarg1_);
  public final static native int connection_type_t_to_int(long jarg1, connection_type_t jarg1_);
  public final static native long connection_type_t_from_int(int jarg1);
  public final static native void delete_connection_type_t(long jarg1);
  public final static native long block_info_peer(long jarg1, block_info jarg1_);
  public final static native void block_info_bytes_progress_set(long jarg1, block_info jarg1_, long jarg2);
  public final static native long block_info_bytes_progress_get(long jarg1, block_info jarg1_);
  public final static native void block_info_block_size_set(long jarg1, block_info jarg1_, long jarg2);
  public final static native long block_info_block_size_get(long jarg1, block_info jarg1_);
  public final static native void block_info_state_set(long jarg1, block_info jarg1_, long jarg2);
  public final static native long block_info_state_get(long jarg1, block_info jarg1_);
  public final static native void block_info_num_peers_set(long jarg1, block_info jarg1_, long jarg2);
  public final static native long block_info_num_peers_get(long jarg1, block_info jarg1_);
  public final static native long new_block_info();
  public final static native void delete_block_info(long jarg1);
  public final static native void partial_piece_info_piece_index_set(long jarg1, partial_piece_info jarg1_, int jarg2);
  public final static native int partial_piece_info_piece_index_get(long jarg1, partial_piece_info jarg1_);
  public final static native void partial_piece_info_blocks_in_piece_set(long jarg1, partial_piece_info jarg1_, int jarg2);
  public final static native int partial_piece_info_blocks_in_piece_get(long jarg1, partial_piece_info jarg1_);
  public final static native void partial_piece_info_finished_set(long jarg1, partial_piece_info jarg1_, int jarg2);
  public final static native int partial_piece_info_finished_get(long jarg1, partial_piece_info jarg1_);
  public final static native void partial_piece_info_writing_set(long jarg1, partial_piece_info jarg1_, int jarg2);
  public final static native int partial_piece_info_writing_get(long jarg1, partial_piece_info jarg1_);
  public final static native void partial_piece_info_requested_set(long jarg1, partial_piece_info jarg1_, int jarg2);
  public final static native int partial_piece_info_requested_get(long jarg1, partial_piece_info jarg1_);
  public final static native long new_partial_piece_info();
  public final static native void delete_partial_piece_info(long jarg1);
  public final static native long torrent_handle_overwrite_existing_get();
  public final static native void torrent_handle_read_piece(long jarg1, torrent_handle jarg1_, int jarg2);
  public final static native boolean torrent_handle_have_piece(long jarg1, torrent_handle jarg1_, int jarg2);
  public final static native void torrent_handle_post_peer_info(long jarg1, torrent_handle jarg1_);
  public final static native void torrent_handle_get_peer_info(long jarg1, torrent_handle jarg1_, long jarg2, peer_info_vector jarg2_);
  public final static native long torrent_handle_query_distributed_copies_get();
  public final static native long torrent_handle_query_accurate_download_counters_get();
  public final static native long torrent_handle_query_last_seen_complete_get();
  public final static native long torrent_handle_query_pieces_get();
  public final static native long torrent_handle_query_verified_pieces_get();
  public final static native long torrent_handle_query_torrent_file_get();
  public final static native long torrent_handle_query_name_get();
  public final static native long torrent_handle_query_save_path_get();
  public final static native long torrent_handle_status__SWIG_0(long jarg1, torrent_handle jarg1_, long jarg2, status_flags_t jarg2_);
  public final static native long torrent_handle_status__SWIG_1(long jarg1, torrent_handle jarg1_);
  public final static native void torrent_handle_post_status__SWIG_0(long jarg1, torrent_handle jarg1_, long jarg2, status_flags_t jarg2_);
  public final static native void torrent_handle_post_status__SWIG_1(long jarg1, torrent_handle jarg1_);
  public final static native void torrent_handle_post_download_queue(long jarg1, torrent_handle jarg1_);
  public final static native long torrent_handle_get_download_queue__SWIG_0(long jarg1, torrent_handle jarg1_);
  public final static native void torrent_handle_get_download_queue__SWIG_1(long jarg1, torrent_handle jarg1_, long jarg2, partial_piece_info_vector jarg2_);
  public final static native long torrent_handle_alert_when_available_get();
  public final static native void torrent_handle_set_piece_deadline__SWIG_0(long jarg1, torrent_handle jarg1_, int jarg2, int jarg3, long jarg4, deadline_flags_t jarg4_);
  public final static native void torrent_handle_set_piece_deadline__SWIG_1(long jarg1, torrent_handle jarg1_, int jarg2, int jarg3);
  public final static native void torrent_handle_reset_piece_deadline(long jarg1, torrent_handle jarg1_, int jarg2);
  public final static native void torrent_handle_clear_piece_deadlines(long jarg1, torrent_handle jarg1_);
  public final static native long torrent_handle_piece_granularity_get();
  public final static native void torrent_handle_file_progress__SWIG_0(long jarg1, torrent_handle jarg1_, long jarg2, int64_vector jarg2_, long jarg3, file_progress_flags_t jarg3_);
  public final static native void torrent_handle_file_progress__SWIG_1(long jarg1, torrent_handle jarg1_, long jarg2, int64_vector jarg2_);
  public final static native long torrent_handle_file_progress__SWIG_2(long jarg1, torrent_handle jarg1_, long jarg2, file_progress_flags_t jarg2_);
  public final static native long torrent_handle_file_progress__SWIG_3(long jarg1, torrent_handle jarg1_);
  public final static native void torrent_handle_post_file_progress(long jarg1, torrent_handle jarg1_, long jarg2, file_progress_flags_t jarg2_);
  public final static native void torrent_handle_clear_error(long jarg1, torrent_handle jarg1_);
  public final static native long torrent_handle_trackers(long jarg1, torrent_handle jarg1_);
  public final static native void torrent_handle_replace_trackers(long jarg1, torrent_handle jarg1_, long jarg2, announce_entry_vector jarg2_);
  public final static native void torrent_handle_add_tracker(long jarg1, torrent_handle jarg1_, long jarg2, announce_entry jarg2_);
  public final static native void torrent_handle_post_trackers(long jarg1, torrent_handle jarg1_);
  public final static native void torrent_handle_add_url_seed(long jarg1, torrent_handle jarg1_, String jarg2);
  public final static native void torrent_handle_remove_url_seed(long jarg1, torrent_handle jarg1_, String jarg2);
  public final static native void torrent_handle_add_http_seed(long jarg1, torrent_handle jarg1_, String jarg2);
  public final static native void torrent_handle_remove_http_seed(long jarg1, torrent_handle jarg1_, String jarg2);
  public final static native boolean torrent_handle_is_valid(long jarg1, torrent_handle jarg1_);
  public final static native long torrent_handle_graceful_pause_get();
  public final static native void torrent_handle_pause__SWIG_0(long jarg1, torrent_handle jarg1_, long jarg2, pause_flags_t jarg2_);
  public final static native void torrent_handle_pause__SWIG_1(long jarg1, torrent_handle jarg1_);
  public final static native void torrent_handle_resume(long jarg1, torrent_handle jarg1_);
  public final static native long torrent_handle_flags(long jarg1, torrent_handle jarg1_);
  public final static native void torrent_handle_set_flags__SWIG_0(long jarg1, torrent_handle jarg1_, long jarg2, torrent_flags_t jarg2_, long jarg3, torrent_flags_t jarg3_);
  public final static native void torrent_handle_set_flags__SWIG_1(long jarg1, torrent_handle jarg1_, long jarg2, torrent_flags_t jarg2_);
  public final static native void torrent_handle_unset_flags(long jarg1, torrent_handle jarg1_, long jarg2, torrent_flags_t jarg2_);
  public final static native void torrent_handle_flush_cache(long jarg1, torrent_handle jarg1_);
  public final static native void torrent_handle_force_recheck(long jarg1, torrent_handle jarg1_);
  public final static native long torrent_handle_flush_disk_cache_get();
  public final static native long torrent_handle_save_info_dict_get();
  public final static native long torrent_handle_only_if_modified_get();
  public final static native long torrent_handle_if_counters_changed_get();
  public final static native long torrent_handle_if_download_progress_get();
  public final static native long torrent_handle_if_config_changed_get();
  public final static native long torrent_handle_if_state_changed_get();
  public final static native long torrent_handle_if_metadata_changed_get();
  public final static native void torrent_handle_save_resume_data__SWIG_0(long jarg1, torrent_handle jarg1_, long jarg2, resume_data_flags_t jarg2_);
  public final static native void torrent_handle_save_resume_data__SWIG_1(long jarg1, torrent_handle jarg1_);
  public final static native long torrent_handle_get_resume_data__SWIG_0(long jarg1, torrent_handle jarg1_, long jarg2, resume_data_flags_t jarg2_);
  public final static native long torrent_handle_get_resume_data__SWIG_1(long jarg1, torrent_handle jarg1_);
  public final static native boolean torrent_handle_need_save_resume_data__SWIG_0(long jarg1, torrent_handle jarg1_);
  public final static native boolean torrent_handle_need_save_resume_data__SWIG_1(long jarg1, torrent_handle jarg1_, long jarg2, resume_data_flags_t jarg2_);
  public final static native void torrent_handle_queue_position_up(long jarg1, torrent_handle jarg1_);
  public final static native void torrent_handle_queue_position_down(long jarg1, torrent_handle jarg1_);
  public final static native void torrent_handle_queue_position_top(long jarg1, torrent_handle jarg1_);
  public final static native void torrent_handle_queue_position_bottom(long jarg1, torrent_handle jarg1_);
  public final static native void torrent_handle_set_ssl_certificate__SWIG_0(long jarg1, torrent_handle jarg1_, String jarg2, String jarg3, String jarg4, String jarg5);
  public final static native void torrent_handle_set_ssl_certificate__SWIG_1(long jarg1, torrent_handle jarg1_, String jarg2, String jarg3, String jarg4);
  public final static native long torrent_handle_torrent_file_with_hashes(long jarg1, torrent_handle jarg1_);
  public final static native long torrent_handle_piece_layers(long jarg1, torrent_handle jarg1_);
  public final static native void torrent_handle_post_piece_availability(long jarg1, torrent_handle jarg1_);
  public final static native void torrent_handle_piece_availability(long jarg1, torrent_handle jarg1_, long jarg2, int_vector jarg2_);
  public final static native long torrent_handle_ignore_min_interval_get();
  public final static native void torrent_handle_force_reannounce__SWIG_0(long jarg1, torrent_handle jarg1_, int jarg2, int jarg3, long jarg4, reannounce_flags_t jarg4_);
  public final static native void torrent_handle_force_reannounce__SWIG_1(long jarg1, torrent_handle jarg1_, int jarg2, int jarg3);
  public final static native void torrent_handle_force_reannounce__SWIG_2(long jarg1, torrent_handle jarg1_, int jarg2);
  public final static native void torrent_handle_force_reannounce__SWIG_3(long jarg1, torrent_handle jarg1_);
  public final static native void torrent_handle_force_dht_announce(long jarg1, torrent_handle jarg1_);
  public final static native void torrent_handle_force_lsd_announce(long jarg1, torrent_handle jarg1_);
  public final static native void torrent_handle_scrape_tracker__SWIG_0(long jarg1, torrent_handle jarg1_, int jarg2);
  public final static native void torrent_handle_scrape_tracker__SWIG_1(long jarg1, torrent_handle jarg1_);
  public final static native void torrent_handle_set_upload_limit(long jarg1, torrent_handle jarg1_, int jarg2);
  public final static native int torrent_handle_upload_limit(long jarg1, torrent_handle jarg1_);
  public final static native void torrent_handle_set_download_limit(long jarg1, torrent_handle jarg1_, int jarg2);
  public final static native int torrent_handle_download_limit(long jarg1, torrent_handle jarg1_);
  public final static native void torrent_handle_connect_peer__SWIG_0(long jarg1, torrent_handle jarg1_, long jarg2, tcp_endpoint jarg2_, long jarg3, peer_source_flags_t jarg3_, long jarg4);
  public final static native void torrent_handle_connect_peer__SWIG_1(long jarg1, torrent_handle jarg1_, long jarg2, tcp_endpoint jarg2_, long jarg3, peer_source_flags_t jarg3_);
  public final static native void torrent_handle_connect_peer__SWIG_2(long jarg1, torrent_handle jarg1_, long jarg2, tcp_endpoint jarg2_);
  public final static native void torrent_handle_clear_peers(long jarg1, torrent_handle jarg1_);
  public final static native void torrent_handle_set_max_uploads(long jarg1, torrent_handle jarg1_, int jarg2);
  public final static native int torrent_handle_max_uploads(long jarg1, torrent_handle jarg1_);
  public final static native void torrent_handle_set_max_connections(long jarg1, torrent_handle jarg1_, int jarg2);
  public final static native int torrent_handle_max_connections(long jarg1, torrent_handle jarg1_);
  public final static native void torrent_handle_move_storage__SWIG_0(long jarg1, torrent_handle jarg1_, String jarg2, int jarg3);
  public final static native void torrent_handle_move_storage__SWIG_1(long jarg1, torrent_handle jarg1_, String jarg2);
  public final static native void torrent_handle_rename_file(long jarg1, torrent_handle jarg1_, int jarg2, String jarg3);
  public final static native long torrent_handle_info_hash(long jarg1, torrent_handle jarg1_);
  public final static native long torrent_handle_info_hashes(long jarg1, torrent_handle jarg1_);
  public final static native boolean torrent_handle_op_eq(long jarg1, torrent_handle jarg1_, long jarg2, torrent_handle jarg2_);
  public final static native boolean torrent_handle_op_ne(long jarg1, torrent_handle jarg1_, long jarg2, torrent_handle jarg2_);
  public final static native boolean torrent_handle_op_lt(long jarg1, torrent_handle jarg1_, long jarg2, torrent_handle jarg2_);
  public final static native long torrent_handle_id(long jarg1, torrent_handle jarg1_);
  public final static native long torrent_handle_userdata(long jarg1, torrent_handle jarg1_);
  public final static native boolean torrent_handle_in_session(long jarg1, torrent_handle jarg1_);
  public final static native void torrent_handle_add_piece_bytes__SWIG_0(long jarg1, torrent_handle jarg1_, int jarg2, long jarg3, byte_vector jarg3_, long jarg4, add_piece_flags_t jarg4_);
  public final static native void torrent_handle_add_piece_bytes__SWIG_1(long jarg1, torrent_handle jarg1_, int jarg2, long jarg3, byte_vector jarg3_);
  public final static native long torrent_handle_torrent_file_ptr(long jarg1, torrent_handle jarg1_);
  public final static native long torrent_handle_torrent_file_with_hashes_ptr(long jarg1, torrent_handle jarg1_);
  public final static native long torrent_handle_get_url_seeds(long jarg1, torrent_handle jarg1_);
  public final static native long torrent_handle_get_http_seeds(long jarg1, torrent_handle jarg1_);
  public final static native void torrent_handle_set_ssl_certificate_buffer2(long jarg1, torrent_handle jarg1_, long jarg2, byte_vector jarg2_, long jarg3, byte_vector jarg3_, long jarg4, byte_vector jarg4_);
  public final static native int torrent_handle_queue_position2(long jarg1, torrent_handle jarg1_);
  public final static native void torrent_handle_queue_position_set2(long jarg1, torrent_handle jarg1_, int jarg2);
  public final static native int torrent_handle_piece_priority2__SWIG_0(long jarg1, torrent_handle jarg1_, int jarg2);
  public final static native void torrent_handle_piece_priority2__SWIG_1(long jarg1, torrent_handle jarg1_, int jarg2, int jarg3);
  public final static native void torrent_handle_prioritize_pieces2__SWIG_0(long jarg1, torrent_handle jarg1_, long jarg2, int_vector jarg2_);
  public final static native void torrent_handle_prioritize_pieces2__SWIG_1(long jarg1, torrent_handle jarg1_, long jarg2);
  public final static native long torrent_handle_get_piece_priorities2(long jarg1, torrent_handle jarg1_);
  public final static native int torrent_handle_file_priority2__SWIG_0(long jarg1, torrent_handle jarg1_, int jarg2);
  public final static native void torrent_handle_file_priority2__SWIG_1(long jarg1, torrent_handle jarg1_, int jarg2, int jarg3);
  public final static native void torrent_handle_prioritize_files2(long jarg1, torrent_handle jarg1_, long jarg2, int_vector jarg2_);
  public final static native long torrent_handle_get_file_priorities2(long jarg1, torrent_handle jarg1_);
  public final static native void delete_torrent_handle(long jarg1);
  public final static native long new_add_piece_flags_t();
  public final static native long add_piece_flags_t_all();
  public final static native boolean add_piece_flags_t_non_zero(long jarg1, add_piece_flags_t jarg1_);
  public final static native boolean add_piece_flags_t_nonZero(long jarg1, add_piece_flags_t jarg1_);
  public final static native boolean add_piece_flags_t_eq(long jarg1, add_piece_flags_t jarg1_, long jarg2, add_piece_flags_t jarg2_);
  public final static native boolean add_piece_flags_t_ne(long jarg1, add_piece_flags_t jarg1_, long jarg2, add_piece_flags_t jarg2_);
  public final static native long add_piece_flags_t_or_(long jarg1, add_piece_flags_t jarg1_, long jarg2, add_piece_flags_t jarg2_);
  public final static native long add_piece_flags_t_and_(long jarg1, add_piece_flags_t jarg1_, long jarg2, add_piece_flags_t jarg2_);
  public final static native long add_piece_flags_t_xor_(long jarg1, add_piece_flags_t jarg1_, long jarg2, add_piece_flags_t jarg2_);
  public final static native long add_piece_flags_t_inv(long jarg1, add_piece_flags_t jarg1_);
  public final static native int add_piece_flags_t_to_int(long jarg1, add_piece_flags_t jarg1_);
  public final static native long add_piece_flags_t_from_int(int jarg1);
  public final static native void delete_add_piece_flags_t(long jarg1);
  public final static native long new_deadline_flags_t();
  public final static native long deadline_flags_t_all();
  public final static native boolean deadline_flags_t_non_zero(long jarg1, deadline_flags_t jarg1_);
  public final static native boolean deadline_flags_t_nonZero(long jarg1, deadline_flags_t jarg1_);
  public final static native boolean deadline_flags_t_eq(long jarg1, deadline_flags_t jarg1_, long jarg2, deadline_flags_t jarg2_);
  public final static native boolean deadline_flags_t_ne(long jarg1, deadline_flags_t jarg1_, long jarg2, deadline_flags_t jarg2_);
  public final static native long deadline_flags_t_or_(long jarg1, deadline_flags_t jarg1_, long jarg2, deadline_flags_t jarg2_);
  public final static native long deadline_flags_t_and_(long jarg1, deadline_flags_t jarg1_, long jarg2, deadline_flags_t jarg2_);
  public final static native long deadline_flags_t_xor_(long jarg1, deadline_flags_t jarg1_, long jarg2, deadline_flags_t jarg2_);
  public final static native long deadline_flags_t_inv(long jarg1, deadline_flags_t jarg1_);
  public final static native int deadline_flags_t_to_int(long jarg1, deadline_flags_t jarg1_);
  public final static native long deadline_flags_t_from_int(int jarg1);
  public final static native void delete_deadline_flags_t(long jarg1);
  public final static native long new_file_progress_flags_t();
  public final static native long file_progress_flags_t_all();
  public final static native boolean file_progress_flags_t_non_zero(long jarg1, file_progress_flags_t jarg1_);
  public final static native boolean file_progress_flags_t_nonZero(long jarg1, file_progress_flags_t jarg1_);
  public final static native boolean file_progress_flags_t_eq(long jarg1, file_progress_flags_t jarg1_, long jarg2, file_progress_flags_t jarg2_);
  public final static native boolean file_progress_flags_t_ne(long jarg1, file_progress_flags_t jarg1_, long jarg2, file_progress_flags_t jarg2_);
  public final static native long file_progress_flags_t_or_(long jarg1, file_progress_flags_t jarg1_, long jarg2, file_progress_flags_t jarg2_);
  public final static native long file_progress_flags_t_and_(long jarg1, file_progress_flags_t jarg1_, long jarg2, file_progress_flags_t jarg2_);
  public final static native long file_progress_flags_t_xor_(long jarg1, file_progress_flags_t jarg1_, long jarg2, file_progress_flags_t jarg2_);
  public final static native long file_progress_flags_t_inv(long jarg1, file_progress_flags_t jarg1_);
  public final static native int file_progress_flags_t_to_int(long jarg1, file_progress_flags_t jarg1_);
  public final static native long file_progress_flags_t_from_int(int jarg1);
  public final static native void delete_file_progress_flags_t(long jarg1);
  public final static native long new_pause_flags_t();
  public final static native long pause_flags_t_all();
  public final static native boolean pause_flags_t_non_zero(long jarg1, pause_flags_t jarg1_);
  public final static native boolean pause_flags_t_nonZero(long jarg1, pause_flags_t jarg1_);
  public final static native boolean pause_flags_t_eq(long jarg1, pause_flags_t jarg1_, long jarg2, pause_flags_t jarg2_);
  public final static native boolean pause_flags_t_ne(long jarg1, pause_flags_t jarg1_, long jarg2, pause_flags_t jarg2_);
  public final static native long pause_flags_t_or_(long jarg1, pause_flags_t jarg1_, long jarg2, pause_flags_t jarg2_);
  public final static native long pause_flags_t_and_(long jarg1, pause_flags_t jarg1_, long jarg2, pause_flags_t jarg2_);
  public final static native long pause_flags_t_xor_(long jarg1, pause_flags_t jarg1_, long jarg2, pause_flags_t jarg2_);
  public final static native long pause_flags_t_inv(long jarg1, pause_flags_t jarg1_);
  public final static native int pause_flags_t_to_int(long jarg1, pause_flags_t jarg1_);
  public final static native long pause_flags_t_from_int(int jarg1);
  public final static native void delete_pause_flags_t(long jarg1);
  public final static native long new_resume_data_flags_t();
  public final static native long resume_data_flags_t_all();
  public final static native boolean resume_data_flags_t_non_zero(long jarg1, resume_data_flags_t jarg1_);
  public final static native boolean resume_data_flags_t_nonZero(long jarg1, resume_data_flags_t jarg1_);
  public final static native boolean resume_data_flags_t_eq(long jarg1, resume_data_flags_t jarg1_, long jarg2, resume_data_flags_t jarg2_);
  public final static native boolean resume_data_flags_t_ne(long jarg1, resume_data_flags_t jarg1_, long jarg2, resume_data_flags_t jarg2_);
  public final static native long resume_data_flags_t_or_(long jarg1, resume_data_flags_t jarg1_, long jarg2, resume_data_flags_t jarg2_);
  public final static native long resume_data_flags_t_and_(long jarg1, resume_data_flags_t jarg1_, long jarg2, resume_data_flags_t jarg2_);
  public final static native long resume_data_flags_t_xor_(long jarg1, resume_data_flags_t jarg1_, long jarg2, resume_data_flags_t jarg2_);
  public final static native long resume_data_flags_t_inv(long jarg1, resume_data_flags_t jarg1_);
  public final static native int resume_data_flags_t_to_int(long jarg1, resume_data_flags_t jarg1_);
  public final static native long resume_data_flags_t_from_int(int jarg1);
  public final static native void delete_resume_data_flags_t(long jarg1);
  public final static native long new_reannounce_flags_t();
  public final static native long reannounce_flags_t_all();
  public final static native boolean reannounce_flags_t_non_zero(long jarg1, reannounce_flags_t jarg1_);
  public final static native boolean reannounce_flags_t_nonZero(long jarg1, reannounce_flags_t jarg1_);
  public final static native boolean reannounce_flags_t_eq(long jarg1, reannounce_flags_t jarg1_, long jarg2, reannounce_flags_t jarg2_);
  public final static native boolean reannounce_flags_t_ne(long jarg1, reannounce_flags_t jarg1_, long jarg2, reannounce_flags_t jarg2_);
  public final static native long reannounce_flags_t_or_(long jarg1, reannounce_flags_t jarg1_, long jarg2, reannounce_flags_t jarg2_);
  public final static native long reannounce_flags_t_and_(long jarg1, reannounce_flags_t jarg1_, long jarg2, reannounce_flags_t jarg2_);
  public final static native long reannounce_flags_t_xor_(long jarg1, reannounce_flags_t jarg1_, long jarg2, reannounce_flags_t jarg2_);
  public final static native long reannounce_flags_t_inv(long jarg1, reannounce_flags_t jarg1_);
  public final static native int reannounce_flags_t_to_int(long jarg1, reannounce_flags_t jarg1_);
  public final static native long reannounce_flags_t_from_int(int jarg1);
  public final static native void delete_reannounce_flags_t(long jarg1);
  public final static native long new_status_flags_t();
  public final static native long status_flags_t_all();
  public final static native boolean status_flags_t_non_zero(long jarg1, status_flags_t jarg1_);
  public final static native boolean status_flags_t_nonZero(long jarg1, status_flags_t jarg1_);
  public final static native boolean status_flags_t_eq(long jarg1, status_flags_t jarg1_, long jarg2, status_flags_t jarg2_);
  public final static native boolean status_flags_t_ne(long jarg1, status_flags_t jarg1_, long jarg2, status_flags_t jarg2_);
  public final static native long status_flags_t_or_(long jarg1, status_flags_t jarg1_, long jarg2, status_flags_t jarg2_);
  public final static native long status_flags_t_and_(long jarg1, status_flags_t jarg1_, long jarg2, status_flags_t jarg2_);
  public final static native long status_flags_t_xor_(long jarg1, status_flags_t jarg1_, long jarg2, status_flags_t jarg2_);
  public final static native long status_flags_t_inv(long jarg1, status_flags_t jarg1_);
  public final static native int status_flags_t_to_int(long jarg1, status_flags_t jarg1_);
  public final static native long status_flags_t_from_int(int jarg1);
  public final static native void delete_status_flags_t(long jarg1);
  public final static native long new_torrent_status__SWIG_0();
  public final static native void delete_torrent_status(long jarg1);
  public final static native long new_torrent_status__SWIG_1(long jarg1, torrent_status jarg1_);
  public final static native boolean torrent_status_op_eq(long jarg1, torrent_status jarg1_, long jarg2, torrent_status jarg2_);
  public final static native void torrent_status_handle_set(long jarg1, torrent_status jarg1_, long jarg2, torrent_handle jarg2_);
  public final static native long torrent_status_handle_get(long jarg1, torrent_status jarg1_);
  public final static native int torrent_status_checking_files_get();
  public final static native int torrent_status_downloading_metadata_get();
  public final static native int torrent_status_downloading_get();
  public final static native int torrent_status_finished_get();
  public final static native int torrent_status_seeding_get();
  public final static native int torrent_status_checking_resume_data_get();
  public final static native void torrent_status_errc_set(long jarg1, torrent_status jarg1_, long jarg2, error_code jarg2_);
  public final static native long torrent_status_errc_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_error_file_set(long jarg1, torrent_status jarg1_, int jarg2);
  public final static native int torrent_status_error_file_get(long jarg1, torrent_status jarg1_);
  public final static native int torrent_status_error_file_none_get();
  public final static native int torrent_status_error_file_ssl_ctx_get();
  public final static native int torrent_status_error_file_metadata_get();
  public final static native int torrent_status_error_file_exception_get();
  public final static native int torrent_status_error_file_partfile_get();
  public final static native void torrent_status_save_path_set(long jarg1, torrent_status jarg1_, String jarg2);
  public final static native String torrent_status_save_path_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_name_set(long jarg1, torrent_status jarg1_, String jarg2);
  public final static native String torrent_status_name_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_current_tracker_set(long jarg1, torrent_status jarg1_, String jarg2);
  public final static native String torrent_status_current_tracker_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_total_download_set(long jarg1, torrent_status jarg1_, long jarg2);
  public final static native long torrent_status_total_download_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_total_upload_set(long jarg1, torrent_status jarg1_, long jarg2);
  public final static native long torrent_status_total_upload_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_total_payload_download_set(long jarg1, torrent_status jarg1_, long jarg2);
  public final static native long torrent_status_total_payload_download_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_total_payload_upload_set(long jarg1, torrent_status jarg1_, long jarg2);
  public final static native long torrent_status_total_payload_upload_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_total_failed_bytes_set(long jarg1, torrent_status jarg1_, long jarg2);
  public final static native long torrent_status_total_failed_bytes_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_total_redundant_bytes_set(long jarg1, torrent_status jarg1_, long jarg2);
  public final static native long torrent_status_total_redundant_bytes_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_total_done_set(long jarg1, torrent_status jarg1_, long jarg2);
  public final static native long torrent_status_total_done_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_total_set(long jarg1, torrent_status jarg1_, long jarg2);
  public final static native long torrent_status_total_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_total_wanted_done_set(long jarg1, torrent_status jarg1_, long jarg2);
  public final static native long torrent_status_total_wanted_done_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_total_wanted_set(long jarg1, torrent_status jarg1_, long jarg2);
  public final static native long torrent_status_total_wanted_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_all_time_upload_set(long jarg1, torrent_status jarg1_, long jarg2);
  public final static native long torrent_status_all_time_upload_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_all_time_download_set(long jarg1, torrent_status jarg1_, long jarg2);
  public final static native long torrent_status_all_time_download_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_added_time_set(long jarg1, torrent_status jarg1_, long jarg2);
  public final static native long torrent_status_added_time_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_completed_time_set(long jarg1, torrent_status jarg1_, long jarg2);
  public final static native long torrent_status_completed_time_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_last_seen_complete_set(long jarg1, torrent_status jarg1_, long jarg2);
  public final static native long torrent_status_last_seen_complete_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_storage_mode_set(long jarg1, torrent_status jarg1_, int jarg2);
  public final static native int torrent_status_storage_mode_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_progress_set(long jarg1, torrent_status jarg1_, float jarg2);
  public final static native float torrent_status_progress_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_progress_ppm_set(long jarg1, torrent_status jarg1_, int jarg2);
  public final static native int torrent_status_progress_ppm_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_download_rate_set(long jarg1, torrent_status jarg1_, int jarg2);
  public final static native int torrent_status_download_rate_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_upload_rate_set(long jarg1, torrent_status jarg1_, int jarg2);
  public final static native int torrent_status_upload_rate_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_download_payload_rate_set(long jarg1, torrent_status jarg1_, int jarg2);
  public final static native int torrent_status_download_payload_rate_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_upload_payload_rate_set(long jarg1, torrent_status jarg1_, int jarg2);
  public final static native int torrent_status_upload_payload_rate_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_num_seeds_set(long jarg1, torrent_status jarg1_, int jarg2);
  public final static native int torrent_status_num_seeds_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_num_peers_set(long jarg1, torrent_status jarg1_, int jarg2);
  public final static native int torrent_status_num_peers_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_num_complete_set(long jarg1, torrent_status jarg1_, int jarg2);
  public final static native int torrent_status_num_complete_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_num_incomplete_set(long jarg1, torrent_status jarg1_, int jarg2);
  public final static native int torrent_status_num_incomplete_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_list_seeds_set(long jarg1, torrent_status jarg1_, int jarg2);
  public final static native int torrent_status_list_seeds_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_list_peers_set(long jarg1, torrent_status jarg1_, int jarg2);
  public final static native int torrent_status_list_peers_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_connect_candidates_set(long jarg1, torrent_status jarg1_, int jarg2);
  public final static native int torrent_status_connect_candidates_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_num_pieces_set(long jarg1, torrent_status jarg1_, int jarg2);
  public final static native int torrent_status_num_pieces_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_distributed_full_copies_set(long jarg1, torrent_status jarg1_, int jarg2);
  public final static native int torrent_status_distributed_full_copies_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_distributed_fraction_set(long jarg1, torrent_status jarg1_, int jarg2);
  public final static native int torrent_status_distributed_fraction_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_distributed_copies_set(long jarg1, torrent_status jarg1_, float jarg2);
  public final static native float torrent_status_distributed_copies_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_block_size_set(long jarg1, torrent_status jarg1_, int jarg2);
  public final static native int torrent_status_block_size_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_num_uploads_set(long jarg1, torrent_status jarg1_, int jarg2);
  public final static native int torrent_status_num_uploads_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_num_connections_set(long jarg1, torrent_status jarg1_, int jarg2);
  public final static native int torrent_status_num_connections_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_uploads_limit_set(long jarg1, torrent_status jarg1_, int jarg2);
  public final static native int torrent_status_uploads_limit_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_connections_limit_set(long jarg1, torrent_status jarg1_, int jarg2);
  public final static native int torrent_status_connections_limit_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_up_bandwidth_queue_set(long jarg1, torrent_status jarg1_, int jarg2);
  public final static native int torrent_status_up_bandwidth_queue_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_down_bandwidth_queue_set(long jarg1, torrent_status jarg1_, int jarg2);
  public final static native int torrent_status_down_bandwidth_queue_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_seed_rank_set(long jarg1, torrent_status jarg1_, int jarg2);
  public final static native int torrent_status_seed_rank_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_state_set(long jarg1, torrent_status jarg1_, int jarg2);
  public final static native int torrent_status_state_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_need_save_resume_set(long jarg1, torrent_status jarg1_, boolean jarg2);
  public final static native boolean torrent_status_need_save_resume_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_is_seeding_set(long jarg1, torrent_status jarg1_, boolean jarg2);
  public final static native boolean torrent_status_is_seeding_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_is_finished_set(long jarg1, torrent_status jarg1_, boolean jarg2);
  public final static native boolean torrent_status_is_finished_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_has_metadata_set(long jarg1, torrent_status jarg1_, boolean jarg2);
  public final static native boolean torrent_status_has_metadata_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_has_incoming_set(long jarg1, torrent_status jarg1_, boolean jarg2);
  public final static native boolean torrent_status_has_incoming_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_moving_storage_set(long jarg1, torrent_status jarg1_, boolean jarg2);
  public final static native boolean torrent_status_moving_storage_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_announcing_to_trackers_set(long jarg1, torrent_status jarg1_, boolean jarg2);
  public final static native boolean torrent_status_announcing_to_trackers_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_announcing_to_lsd_set(long jarg1, torrent_status jarg1_, boolean jarg2);
  public final static native boolean torrent_status_announcing_to_lsd_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_announcing_to_dht_set(long jarg1, torrent_status jarg1_, boolean jarg2);
  public final static native boolean torrent_status_announcing_to_dht_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_info_hashes_set(long jarg1, torrent_status jarg1_, long jarg2, info_hash_t jarg2_);
  public final static native long torrent_status_info_hashes_get(long jarg1, torrent_status jarg1_);
  public final static native void torrent_status_flags_set(long jarg1, torrent_status jarg1_, long jarg2, torrent_flags_t jarg2_);
  public final static native long torrent_status_flags_get(long jarg1, torrent_status jarg1_);
  public final static native long torrent_status_torrent_file_ptr(long jarg1, torrent_status jarg1_);
  public final static native long torrent_status_get_next_announce(long jarg1, torrent_status jarg1_);
  public final static native long torrent_status_get_last_upload(long jarg1, torrent_status jarg1_);
  public final static native long torrent_status_get_last_download(long jarg1, torrent_status jarg1_);
  public final static native long torrent_status_get_active_duration(long jarg1, torrent_status jarg1_);
  public final static native long torrent_status_get_finished_duration(long jarg1, torrent_status jarg1_);
  public final static native long torrent_status_get_seeding_duration(long jarg1, torrent_status jarg1_);
  public final static native int torrent_status_get_queue_position(long jarg1, torrent_status jarg1_);
  public final static native long torrent_status_get_pieces(long jarg1, torrent_status jarg1_);
  public final static native long torrent_status_get_verified_pieces(long jarg1, torrent_status jarg1_);
  public final static native int counters_num_checking_torrents_get();
  public final static native int counters_num_gauges_counters_get();
  public final static native long new_counters__SWIG_0();
  public final static native long new_counters__SWIG_1(long jarg1, counters jarg1_);
  public final static native long counters_inc_stats_counter__SWIG_0(long jarg1, counters jarg1_, int jarg2, long jarg3);
  public final static native long counters_inc_stats_counter__SWIG_1(long jarg1, counters jarg1_, int jarg2);
  public final static native long counters_op_at(long jarg1, counters jarg1_, int jarg2);
  public final static native void counters_set_value(long jarg1, counters jarg1_, int jarg2, long jarg3);
  public final static native void counters_blend_stats_counter(long jarg1, counters jarg1_, int jarg2, long jarg3, int jarg4);
  public final static native void delete_counters(long jarg1);
  public final static native long piece_block_invalid_get();
  public final static native long new_piece_block__SWIG_0();
  public final static native long new_piece_block__SWIG_1(int jarg1, int jarg2);
  public final static native void piece_block_piece_index_set(long jarg1, piece_block jarg1_, int jarg2);
  public final static native int piece_block_piece_index_get(long jarg1, piece_block jarg1_);
  public final static native void piece_block_block_index_set(long jarg1, piece_block jarg1_, int jarg2);
  public final static native int piece_block_block_index_get(long jarg1, piece_block jarg1_);
  public final static native boolean piece_block_op_lt(long jarg1, piece_block jarg1_, long jarg2, piece_block jarg2_);
  public final static native boolean piece_block_op_eq(long jarg1, piece_block jarg1_, long jarg2, piece_block jarg2_);
  public final static native boolean piece_block_op_ne(long jarg1, piece_block jarg1_, long jarg2, piece_block jarg2_);
  public final static native void delete_piece_block(long jarg1);
  public final static native int entry_type(long jarg1, entry jarg1_);
  public final static native long new_entry__SWIG_0(long jarg1, string_entry_map jarg1_);
  public final static native long new_entry__SWIG_1(String jarg1);
  public final static native long new_entry__SWIG_2(long jarg1, entry_vector jarg1_);
  public final static native long new_entry__SWIG_3(long jarg1);
  public final static native long new_entry__SWIG_4(int jarg1);
  public final static native long new_entry__SWIG_5(long jarg1, entry jarg1_);
  public final static native long new_entry__SWIG_6();
  public final static native long entry_integer(long jarg1, entry jarg1_);
  public final static native String entry_string(long jarg1, entry jarg1_);
  public final static native long entry_list(long jarg1, entry jarg1_);
  public final static native long entry_dict(long jarg1, entry jarg1_);
  public final static native String entry_to_string(long jarg1, entry jarg1_);
  public final static native long entry_get(long jarg1, entry jarg1_, String jarg2);
  public final static native void entry_set__SWIG_0(long jarg1, entry jarg1_, String jarg2, String jarg3);
  public final static native void entry_set__SWIG_1(long jarg1, entry jarg1_, String jarg2, long jarg3, byte_vector jarg3_);
  public final static native void entry_set__SWIG_2(long jarg1, entry jarg1_, String jarg2, long jarg3);
  public final static native void entry_set__SWIG_3(long jarg1, entry jarg1_, String jarg2, long jarg3, entry jarg3_);
  public final static native long entry_string_bytes(long jarg1, entry jarg1_);
  public final static native long entry_preformatted_bytes(long jarg1, entry jarg1_);
  public final static native long entry_bencode(long jarg1, entry jarg1_);
  public final static native long entry_from_string_bytes(long jarg1, byte_vector jarg1_);
  public final static native long entry_from_preformatted_bytes(long jarg1, byte_vector jarg1_);
  public final static native long entry_bdecode(long jarg1, byte_vector jarg1_);
  public final static native void delete_entry(long jarg1);
  public final static native long error_get();
  public final static native long peer_get();
  public final static native long port_mapping_get();
  public final static native long storage_get();
  public final static native long tracker_get();
  public final static native long connect_get();
  public final static native long status_get();
  public final static native long ip_block_get();
  public final static native long performance_warning_get();
  public final static native long dht_get();
  public final static native long stats_get();
  public final static native long session_log_get();
  public final static native long torrent_log_get();
  public final static native long peer_log_get();
  public final static native long incoming_request_get();
  public final static native long dht_log_get();
  public final static native long dht_operation_get();
  public final static native long port_mapping_log_get();
  public final static native long picker_log_get();
  public final static native long file_progress_get();
  public final static native long piece_progress_get();
  public final static native long upload_get();
  public final static native long block_progress_get();
  public final static native long alert_error_notification_get();
  public final static native long alert_peer_notification_get();
  public final static native long alert_port_mapping_notification_get();
  public final static native long alert_storage_notification_get();
  public final static native long alert_tracker_notification_get();
  public final static native long alert_connect_notification_get();
  public final static native long alert_status_notification_get();
  public final static native long alert_ip_block_notification_get();
  public final static native long alert_performance_warning_get();
  public final static native long alert_dht_notification_get();
  public final static native long alert_session_log_notification_get();
  public final static native long alert_torrent_log_notification_get();
  public final static native long alert_peer_log_notification_get();
  public final static native long alert_incoming_request_notification_get();
  public final static native long alert_dht_log_notification_get();
  public final static native long alert_dht_operation_notification_get();
  public final static native long alert_port_mapping_log_notification_get();
  public final static native long alert_picker_log_notification_get();
  public final static native long alert_file_progress_notification_get();
  public final static native long alert_piece_progress_notification_get();
  public final static native long alert_upload_notification_get();
  public final static native long alert_block_progress_notification_get();
  public final static native long alert_all_categories_get();
  public final static native void delete_alert(long jarg1);
  public final static native int alert_type(long jarg1, alert jarg1_);
  public final static native String alert_what(long jarg1, alert jarg1_);
  public final static native String alert_message(long jarg1, alert jarg1_);
  public final static native long alert_category(long jarg1, alert jarg1_);
  public final static native long alert_get_timestamp(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_add_torrent_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_alerts_dropped_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_block_downloading_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_block_finished_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_block_timeout_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_block_uploaded_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_cache_flushed_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_dht_announce_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_dht_bootstrap_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_dht_direct_response_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_dht_error_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_dht_get_peers_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_dht_get_peers_reply_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_dht_immutable_item_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_dht_live_nodes_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_dht_log_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_dht_mutable_item_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_dht_outgoing_get_peers_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_dht_pkt_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_dht_put_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_dht_reply_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_dht_sample_infohashes_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_dht_stats_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_external_ip_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_fastresume_rejected_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_file_completed_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_file_error_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_file_prio_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_file_progress_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_file_rename_failed_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_file_renamed_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_hash_failed_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_i2p_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_incoming_connection_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_incoming_request_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_invalid_request_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_listen_failed_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_listen_succeeded_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_log_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_lsd_error_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_lsd_peer_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_metadata_failed_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_metadata_received_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_oversized_file_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_peer_ban_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_peer_blocked_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_peer_connect_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_peer_disconnected_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_peer_error_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_peer_info_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_peer_log_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_peer_snubbed_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_peer_unsnubbed_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_performance_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_picker_log_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_piece_availability_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_piece_finished_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_piece_info_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_portmap_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_portmap_error_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_portmap_log_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_read_piece_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_request_dropped_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_save_resume_data_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_save_resume_data_failed_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_scrape_failed_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_scrape_reply_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_session_error_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_session_stats_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_session_stats_header_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_socks5_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_state_changed_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_state_update_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_storage_moved_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_storage_moved_failed_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_torrent_checked_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_torrent_conflict_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_torrent_delete_failed_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_torrent_deleted_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_torrent_error_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_torrent_finished_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_torrent_log_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_torrent_need_cert_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_torrent_paused_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_torrent_removed_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_torrent_resumed_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_tracker_announce_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_tracker_error_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_tracker_list_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_tracker_reply_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_tracker_warning_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_trackerid_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_udp_error_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_unwanted_block_alert(long jarg1, alert jarg1_);
  public final static native long alert_cast_to_url_seed_alert(long jarg1, alert jarg1_);
  public final static native String alert_name(int jarg1);
  public final static native int num_alert_types_get();
  public final static native int abi_alert_count_get();
  public final static native int alert_priority_normal_get();
  public final static native void dht_routing_bucket_num_nodes_set(long jarg1, dht_routing_bucket jarg1_, int jarg2);
  public final static native int dht_routing_bucket_num_nodes_get(long jarg1, dht_routing_bucket jarg1_);
  public final static native void dht_routing_bucket_num_replacements_set(long jarg1, dht_routing_bucket jarg1_, int jarg2);
  public final static native int dht_routing_bucket_num_replacements_get(long jarg1, dht_routing_bucket jarg1_);
  public final static native void dht_routing_bucket_last_active_set(long jarg1, dht_routing_bucket jarg1_, int jarg2);
  public final static native int dht_routing_bucket_last_active_get(long jarg1, dht_routing_bucket jarg1_);
  public final static native long new_dht_routing_bucket();
  public final static native void delete_dht_routing_bucket(long jarg1);
  public final static native String torrent_alert_message(long jarg1, torrent_alert jarg1_);
  public final static native void torrent_alert_handle_set(long jarg1, torrent_alert jarg1_, long jarg2, torrent_handle jarg2_);
  public final static native long torrent_alert_handle_get(long jarg1, torrent_alert jarg1_);
  public final static native String torrent_alert_torrent_name(long jarg1, torrent_alert jarg1_);
  public final static native void delete_torrent_alert(long jarg1);
  public final static native String peer_alert_message(long jarg1, peer_alert jarg1_);
  public final static native void peer_alert_pid_set(long jarg1, peer_alert jarg1_, long jarg2, sha1_hash jarg2_);
  public final static native long peer_alert_pid_get(long jarg1, peer_alert jarg1_);
  public final static native long peer_alert_get_endpoint(long jarg1, peer_alert jarg1_);
  public final static native void delete_peer_alert(long jarg1);
  public final static native String tracker_alert_message(long jarg1, tracker_alert jarg1_);
  public final static native String tracker_alert_tracker_url(long jarg1, tracker_alert jarg1_);
  public final static native long tracker_alert_get_local_endpoint(long jarg1, tracker_alert jarg1_);
  public final static native void delete_tracker_alert(long jarg1);
  public final static native int torrent_removed_alert_priority_get();
  public final static native int torrent_removed_alert_alert_type_get();
  public final static native int torrent_removed_alert_type(long jarg1, torrent_removed_alert jarg1_);
  public final static native long torrent_removed_alert_category(long jarg1, torrent_removed_alert jarg1_);
  public final static native String torrent_removed_alert_what(long jarg1, torrent_removed_alert jarg1_);
  public final static native long torrent_removed_alert_static_category_get();
  public final static native String torrent_removed_alert_message(long jarg1, torrent_removed_alert jarg1_);
  public final static native void torrent_removed_alert_info_hashes_set(long jarg1, torrent_removed_alert jarg1_, long jarg2, info_hash_t jarg2_);
  public final static native long torrent_removed_alert_info_hashes_get(long jarg1, torrent_removed_alert jarg1_);
  public final static native void torrent_removed_alert_userdata_set(long jarg1, torrent_removed_alert jarg1_, long jarg2, client_data_t jarg2_);
  public final static native long torrent_removed_alert_userdata_get(long jarg1, torrent_removed_alert jarg1_);
  public final static native void delete_torrent_removed_alert(long jarg1);
  public final static native int read_piece_alert_priority_get();
  public final static native int read_piece_alert_alert_type_get();
  public final static native int read_piece_alert_type(long jarg1, read_piece_alert jarg1_);
  public final static native long read_piece_alert_category(long jarg1, read_piece_alert jarg1_);
  public final static native String read_piece_alert_what(long jarg1, read_piece_alert jarg1_);
  public final static native long read_piece_alert_static_category_get();
  public final static native String read_piece_alert_message(long jarg1, read_piece_alert jarg1_);
  public final static native long read_piece_alert_error_get(long jarg1, read_piece_alert jarg1_);
  public final static native int read_piece_alert_piece_get(long jarg1, read_piece_alert jarg1_);
  public final static native int read_piece_alert_size_get(long jarg1, read_piece_alert jarg1_);
  public final static native long read_piece_alert_buffer_ptr(long jarg1, read_piece_alert jarg1_);
  public final static native void delete_read_piece_alert(long jarg1);
  public final static native int file_completed_alert_priority_get();
  public final static native int file_completed_alert_alert_type_get();
  public final static native int file_completed_alert_type(long jarg1, file_completed_alert jarg1_);
  public final static native long file_completed_alert_category(long jarg1, file_completed_alert jarg1_);
  public final static native String file_completed_alert_what(long jarg1, file_completed_alert jarg1_);
  public final static native long file_completed_alert_static_category_get();
  public final static native String file_completed_alert_message(long jarg1, file_completed_alert jarg1_);
  public final static native int file_completed_alert_index_get(long jarg1, file_completed_alert jarg1_);
  public final static native void delete_file_completed_alert(long jarg1);
  public final static native int file_renamed_alert_priority_get();
  public final static native int file_renamed_alert_alert_type_get();
  public final static native int file_renamed_alert_type(long jarg1, file_renamed_alert jarg1_);
  public final static native long file_renamed_alert_category(long jarg1, file_renamed_alert jarg1_);
  public final static native String file_renamed_alert_what(long jarg1, file_renamed_alert jarg1_);
  public final static native long file_renamed_alert_static_category_get();
  public final static native String file_renamed_alert_message(long jarg1, file_renamed_alert jarg1_);
  public final static native String file_renamed_alert_new_name(long jarg1, file_renamed_alert jarg1_);
  public final static native String file_renamed_alert_old_name(long jarg1, file_renamed_alert jarg1_);
  public final static native int file_renamed_alert_index_get(long jarg1, file_renamed_alert jarg1_);
  public final static native void delete_file_renamed_alert(long jarg1);
  public final static native int file_rename_failed_alert_priority_get();
  public final static native int file_rename_failed_alert_alert_type_get();
  public final static native int file_rename_failed_alert_type(long jarg1, file_rename_failed_alert jarg1_);
  public final static native long file_rename_failed_alert_category(long jarg1, file_rename_failed_alert jarg1_);
  public final static native String file_rename_failed_alert_what(long jarg1, file_rename_failed_alert jarg1_);
  public final static native long file_rename_failed_alert_static_category_get();
  public final static native String file_rename_failed_alert_message(long jarg1, file_rename_failed_alert jarg1_);
  public final static native int file_rename_failed_alert_index_get(long jarg1, file_rename_failed_alert jarg1_);
  public final static native long file_rename_failed_alert_error_get(long jarg1, file_rename_failed_alert jarg1_);
  public final static native void delete_file_rename_failed_alert(long jarg1);
  public final static native int performance_alert_too_few_outgoing_ports_get();
  public final static native int performance_alert_priority_get();
  public final static native int performance_alert_alert_type_get();
  public final static native int performance_alert_type(long jarg1, performance_alert jarg1_);
  public final static native long performance_alert_category(long jarg1, performance_alert jarg1_);
  public final static native String performance_alert_what(long jarg1, performance_alert jarg1_);
  public final static native long performance_alert_static_category_get();
  public final static native String performance_alert_message(long jarg1, performance_alert jarg1_);
  public final static native int performance_alert_warning_code_get(long jarg1, performance_alert jarg1_);
  public final static native void delete_performance_alert(long jarg1);
  public final static native int state_changed_alert_priority_get();
  public final static native int state_changed_alert_alert_type_get();
  public final static native int state_changed_alert_type(long jarg1, state_changed_alert jarg1_);
  public final static native long state_changed_alert_category(long jarg1, state_changed_alert jarg1_);
  public final static native String state_changed_alert_what(long jarg1, state_changed_alert jarg1_);
  public final static native long state_changed_alert_static_category_get();
  public final static native String state_changed_alert_message(long jarg1, state_changed_alert jarg1_);
  public final static native int state_changed_alert_state_get(long jarg1, state_changed_alert jarg1_);
  public final static native int state_changed_alert_prev_state_get(long jarg1, state_changed_alert jarg1_);
  public final static native void delete_state_changed_alert(long jarg1);
  public final static native int tracker_error_alert_priority_get();
  public final static native int tracker_error_alert_alert_type_get();
  public final static native int tracker_error_alert_type(long jarg1, tracker_error_alert jarg1_);
  public final static native long tracker_error_alert_category(long jarg1, tracker_error_alert jarg1_);
  public final static native String tracker_error_alert_what(long jarg1, tracker_error_alert jarg1_);
  public final static native long tracker_error_alert_static_category_get();
  public final static native String tracker_error_alert_message(long jarg1, tracker_error_alert jarg1_);
  public final static native int tracker_error_alert_times_in_row_get(long jarg1, tracker_error_alert jarg1_);
  public final static native long tracker_error_alert_error_get(long jarg1, tracker_error_alert jarg1_);
  public final static native void tracker_error_alert_op_set(long jarg1, tracker_error_alert jarg1_, int jarg2);
  public final static native int tracker_error_alert_op_get(long jarg1, tracker_error_alert jarg1_);
  public final static native String tracker_error_alert_failure_reason(long jarg1, tracker_error_alert jarg1_);
  public final static native String tracker_error_alert_error_message(long jarg1, tracker_error_alert jarg1_);
  public final static native void tracker_error_alert_version_set(long jarg1, tracker_error_alert jarg1_, int jarg2);
  public final static native int tracker_error_alert_version_get(long jarg1, tracker_error_alert jarg1_);
  public final static native void delete_tracker_error_alert(long jarg1);
  public final static native int tracker_warning_alert_priority_get();
  public final static native int tracker_warning_alert_alert_type_get();
  public final static native int tracker_warning_alert_type(long jarg1, tracker_warning_alert jarg1_);
  public final static native long tracker_warning_alert_category(long jarg1, tracker_warning_alert jarg1_);
  public final static native String tracker_warning_alert_what(long jarg1, tracker_warning_alert jarg1_);
  public final static native long tracker_warning_alert_static_category_get();
  public final static native String tracker_warning_alert_message(long jarg1, tracker_warning_alert jarg1_);
  public final static native String tracker_warning_alert_warning_message(long jarg1, tracker_warning_alert jarg1_);
  public final static native void tracker_warning_alert_version_set(long jarg1, tracker_warning_alert jarg1_, int jarg2);
  public final static native int tracker_warning_alert_version_get(long jarg1, tracker_warning_alert jarg1_);
  public final static native void delete_tracker_warning_alert(long jarg1);
  public final static native int scrape_reply_alert_priority_get();
  public final static native int scrape_reply_alert_alert_type_get();
  public final static native int scrape_reply_alert_type(long jarg1, scrape_reply_alert jarg1_);
  public final static native long scrape_reply_alert_category(long jarg1, scrape_reply_alert jarg1_);
  public final static native String scrape_reply_alert_what(long jarg1, scrape_reply_alert jarg1_);
  public final static native long scrape_reply_alert_static_category_get();
  public final static native String scrape_reply_alert_message(long jarg1, scrape_reply_alert jarg1_);
  public final static native int scrape_reply_alert_incomplete_get(long jarg1, scrape_reply_alert jarg1_);
  public final static native int scrape_reply_alert_complete_get(long jarg1, scrape_reply_alert jarg1_);
  public final static native void scrape_reply_alert_version_set(long jarg1, scrape_reply_alert jarg1_, int jarg2);
  public final static native int scrape_reply_alert_version_get(long jarg1, scrape_reply_alert jarg1_);
  public final static native void delete_scrape_reply_alert(long jarg1);
  public final static native int scrape_failed_alert_priority_get();
  public final static native int scrape_failed_alert_alert_type_get();
  public final static native int scrape_failed_alert_type(long jarg1, scrape_failed_alert jarg1_);
  public final static native long scrape_failed_alert_category(long jarg1, scrape_failed_alert jarg1_);
  public final static native String scrape_failed_alert_what(long jarg1, scrape_failed_alert jarg1_);
  public final static native long scrape_failed_alert_static_category_get();
  public final static native String scrape_failed_alert_message(long jarg1, scrape_failed_alert jarg1_);
  public final static native long scrape_failed_alert_error_get(long jarg1, scrape_failed_alert jarg1_);
  public final static native String scrape_failed_alert_error_message(long jarg1, scrape_failed_alert jarg1_);
  public final static native void scrape_failed_alert_version_set(long jarg1, scrape_failed_alert jarg1_, int jarg2);
  public final static native int scrape_failed_alert_version_get(long jarg1, scrape_failed_alert jarg1_);
  public final static native void delete_scrape_failed_alert(long jarg1);
  public final static native int tracker_reply_alert_priority_get();
  public final static native int tracker_reply_alert_alert_type_get();
  public final static native int tracker_reply_alert_type(long jarg1, tracker_reply_alert jarg1_);
  public final static native long tracker_reply_alert_category(long jarg1, tracker_reply_alert jarg1_);
  public final static native String tracker_reply_alert_what(long jarg1, tracker_reply_alert jarg1_);
  public final static native long tracker_reply_alert_static_category_get();
  public final static native String tracker_reply_alert_message(long jarg1, tracker_reply_alert jarg1_);
  public final static native int tracker_reply_alert_num_peers_get(long jarg1, tracker_reply_alert jarg1_);
  public final static native void tracker_reply_alert_version_set(long jarg1, tracker_reply_alert jarg1_, int jarg2);
  public final static native int tracker_reply_alert_version_get(long jarg1, tracker_reply_alert jarg1_);
  public final static native void delete_tracker_reply_alert(long jarg1);
  public final static native int dht_reply_alert_priority_get();
  public final static native int dht_reply_alert_alert_type_get();
  public final static native int dht_reply_alert_type(long jarg1, dht_reply_alert jarg1_);
  public final static native long dht_reply_alert_category(long jarg1, dht_reply_alert jarg1_);
  public final static native String dht_reply_alert_what(long jarg1, dht_reply_alert jarg1_);
  public final static native long dht_reply_alert_static_category_get();
  public final static native String dht_reply_alert_message(long jarg1, dht_reply_alert jarg1_);
  public final static native int dht_reply_alert_num_peers_get(long jarg1, dht_reply_alert jarg1_);
  public final static native void delete_dht_reply_alert(long jarg1);
  public final static native int tracker_announce_alert_priority_get();
  public final static native int tracker_announce_alert_alert_type_get();
  public final static native int tracker_announce_alert_type(long jarg1, tracker_announce_alert jarg1_);
  public final static native long tracker_announce_alert_category(long jarg1, tracker_announce_alert jarg1_);
  public final static native String tracker_announce_alert_what(long jarg1, tracker_announce_alert jarg1_);
  public final static native long tracker_announce_alert_static_category_get();
  public final static native String tracker_announce_alert_message(long jarg1, tracker_announce_alert jarg1_);
  public final static native int tracker_announce_alert_event_get(long jarg1, tracker_announce_alert jarg1_);
  public final static native void tracker_announce_alert_version_set(long jarg1, tracker_announce_alert jarg1_, int jarg2);
  public final static native int tracker_announce_alert_version_get(long jarg1, tracker_announce_alert jarg1_);
  public final static native void delete_tracker_announce_alert(long jarg1);
  public final static native int hash_failed_alert_priority_get();
  public final static native int hash_failed_alert_alert_type_get();
  public final static native int hash_failed_alert_type(long jarg1, hash_failed_alert jarg1_);
  public final static native long hash_failed_alert_category(long jarg1, hash_failed_alert jarg1_);
  public final static native String hash_failed_alert_what(long jarg1, hash_failed_alert jarg1_);
  public final static native long hash_failed_alert_static_category_get();
  public final static native String hash_failed_alert_message(long jarg1, hash_failed_alert jarg1_);
  public final static native int hash_failed_alert_piece_index_get(long jarg1, hash_failed_alert jarg1_);
  public final static native void delete_hash_failed_alert(long jarg1);
  public final static native int peer_ban_alert_priority_get();
  public final static native int peer_ban_alert_alert_type_get();
  public final static native int peer_ban_alert_type(long jarg1, peer_ban_alert jarg1_);
  public final static native long peer_ban_alert_category(long jarg1, peer_ban_alert jarg1_);
  public final static native String peer_ban_alert_what(long jarg1, peer_ban_alert jarg1_);
  public final static native long peer_ban_alert_static_category_get();
  public final static native String peer_ban_alert_message(long jarg1, peer_ban_alert jarg1_);
  public final static native void delete_peer_ban_alert(long jarg1);
  public final static native int peer_unsnubbed_alert_priority_get();
  public final static native int peer_unsnubbed_alert_alert_type_get();
  public final static native int peer_unsnubbed_alert_type(long jarg1, peer_unsnubbed_alert jarg1_);
  public final static native long peer_unsnubbed_alert_category(long jarg1, peer_unsnubbed_alert jarg1_);
  public final static native String peer_unsnubbed_alert_what(long jarg1, peer_unsnubbed_alert jarg1_);
  public final static native long peer_unsnubbed_alert_static_category_get();
  public final static native String peer_unsnubbed_alert_message(long jarg1, peer_unsnubbed_alert jarg1_);
  public final static native void delete_peer_unsnubbed_alert(long jarg1);
  public final static native int peer_snubbed_alert_priority_get();
  public final static native int peer_snubbed_alert_alert_type_get();
  public final static native int peer_snubbed_alert_type(long jarg1, peer_snubbed_alert jarg1_);
  public final static native long peer_snubbed_alert_category(long jarg1, peer_snubbed_alert jarg1_);
  public final static native String peer_snubbed_alert_what(long jarg1, peer_snubbed_alert jarg1_);
  public final static native long peer_snubbed_alert_static_category_get();
  public final static native String peer_snubbed_alert_message(long jarg1, peer_snubbed_alert jarg1_);
  public final static native void delete_peer_snubbed_alert(long jarg1);
  public final static native int peer_error_alert_priority_get();
  public final static native int peer_error_alert_alert_type_get();
  public final static native int peer_error_alert_type(long jarg1, peer_error_alert jarg1_);
  public final static native long peer_error_alert_category(long jarg1, peer_error_alert jarg1_);
  public final static native String peer_error_alert_what(long jarg1, peer_error_alert jarg1_);
  public final static native long peer_error_alert_static_category_get();
  public final static native String peer_error_alert_message(long jarg1, peer_error_alert jarg1_);
  public final static native void peer_error_alert_op_set(long jarg1, peer_error_alert jarg1_, int jarg2);
  public final static native int peer_error_alert_op_get(long jarg1, peer_error_alert jarg1_);
  public final static native long peer_error_alert_error_get(long jarg1, peer_error_alert jarg1_);
  public final static native void delete_peer_error_alert(long jarg1);
  public final static native int peer_connect_alert_priority_get();
  public final static native int peer_connect_alert_alert_type_get();
  public final static native int peer_connect_alert_type(long jarg1, peer_connect_alert jarg1_);
  public final static native long peer_connect_alert_category(long jarg1, peer_connect_alert jarg1_);
  public final static native String peer_connect_alert_what(long jarg1, peer_connect_alert jarg1_);
  public final static native long peer_connect_alert_static_category_get();
  public final static native String peer_connect_alert_message(long jarg1, peer_connect_alert jarg1_);
  public final static native void peer_connect_alert_direction_set(long jarg1, peer_connect_alert jarg1_, int jarg2);
  public final static native int peer_connect_alert_direction_get(long jarg1, peer_connect_alert jarg1_);
  public final static native void peer_connect_alert_socket_type_set(long jarg1, peer_connect_alert jarg1_, int jarg2);
  public final static native int peer_connect_alert_socket_type_get(long jarg1, peer_connect_alert jarg1_);
  public final static native void delete_peer_connect_alert(long jarg1);
  public final static native int peer_disconnected_alert_priority_get();
  public final static native int peer_disconnected_alert_alert_type_get();
  public final static native int peer_disconnected_alert_type(long jarg1, peer_disconnected_alert jarg1_);
  public final static native long peer_disconnected_alert_category(long jarg1, peer_disconnected_alert jarg1_);
  public final static native String peer_disconnected_alert_what(long jarg1, peer_disconnected_alert jarg1_);
  public final static native long peer_disconnected_alert_static_category_get();
  public final static native String peer_disconnected_alert_message(long jarg1, peer_disconnected_alert jarg1_);
  public final static native int peer_disconnected_alert_socket_type_get(long jarg1, peer_disconnected_alert jarg1_);
  public final static native int peer_disconnected_alert_op_get(long jarg1, peer_disconnected_alert jarg1_);
  public final static native long peer_disconnected_alert_error_get(long jarg1, peer_disconnected_alert jarg1_);
  public final static native int peer_disconnected_alert_reason_get(long jarg1, peer_disconnected_alert jarg1_);
  public final static native void delete_peer_disconnected_alert(long jarg1);
  public final static native int invalid_request_alert_priority_get();
  public final static native int invalid_request_alert_alert_type_get();
  public final static native int invalid_request_alert_type(long jarg1, invalid_request_alert jarg1_);
  public final static native long invalid_request_alert_category(long jarg1, invalid_request_alert jarg1_);
  public final static native String invalid_request_alert_what(long jarg1, invalid_request_alert jarg1_);
  public final static native long invalid_request_alert_static_category_get();
  public final static native String invalid_request_alert_message(long jarg1, invalid_request_alert jarg1_);
  public final static native long invalid_request_alert_request_get(long jarg1, invalid_request_alert jarg1_);
  public final static native boolean invalid_request_alert_we_have_get(long jarg1, invalid_request_alert jarg1_);
  public final static native boolean invalid_request_alert_peer_interested_get(long jarg1, invalid_request_alert jarg1_);
  public final static native boolean invalid_request_alert_withheld_get(long jarg1, invalid_request_alert jarg1_);
  public final static native void delete_invalid_request_alert(long jarg1);
  public final static native int torrent_finished_alert_priority_get();
  public final static native int torrent_finished_alert_alert_type_get();
  public final static native int torrent_finished_alert_type(long jarg1, torrent_finished_alert jarg1_);
  public final static native long torrent_finished_alert_category(long jarg1, torrent_finished_alert jarg1_);
  public final static native String torrent_finished_alert_what(long jarg1, torrent_finished_alert jarg1_);
  public final static native long torrent_finished_alert_static_category_get();
  public final static native String torrent_finished_alert_message(long jarg1, torrent_finished_alert jarg1_);
  public final static native void delete_torrent_finished_alert(long jarg1);
  public final static native int piece_finished_alert_priority_get();
  public final static native int piece_finished_alert_alert_type_get();
  public final static native int piece_finished_alert_type(long jarg1, piece_finished_alert jarg1_);
  public final static native long piece_finished_alert_category(long jarg1, piece_finished_alert jarg1_);
  public final static native String piece_finished_alert_what(long jarg1, piece_finished_alert jarg1_);
  public final static native long piece_finished_alert_static_category_get();
  public final static native String piece_finished_alert_message(long jarg1, piece_finished_alert jarg1_);
  public final static native int piece_finished_alert_piece_index_get(long jarg1, piece_finished_alert jarg1_);
  public final static native void delete_piece_finished_alert(long jarg1);
  public final static native int request_dropped_alert_priority_get();
  public final static native int request_dropped_alert_alert_type_get();
  public final static native int request_dropped_alert_type(long jarg1, request_dropped_alert jarg1_);
  public final static native long request_dropped_alert_category(long jarg1, request_dropped_alert jarg1_);
  public final static native String request_dropped_alert_what(long jarg1, request_dropped_alert jarg1_);
  public final static native long request_dropped_alert_static_category_get();
  public final static native String request_dropped_alert_message(long jarg1, request_dropped_alert jarg1_);
  public final static native int request_dropped_alert_block_index_get(long jarg1, request_dropped_alert jarg1_);
  public final static native int request_dropped_alert_piece_index_get(long jarg1, request_dropped_alert jarg1_);
  public final static native void delete_request_dropped_alert(long jarg1);
  public final static native int block_timeout_alert_priority_get();
  public final static native int block_timeout_alert_alert_type_get();
  public final static native int block_timeout_alert_type(long jarg1, block_timeout_alert jarg1_);
  public final static native long block_timeout_alert_category(long jarg1, block_timeout_alert jarg1_);
  public final static native String block_timeout_alert_what(long jarg1, block_timeout_alert jarg1_);
  public final static native long block_timeout_alert_static_category_get();
  public final static native String block_timeout_alert_message(long jarg1, block_timeout_alert jarg1_);
  public final static native int block_timeout_alert_block_index_get(long jarg1, block_timeout_alert jarg1_);
  public final static native int block_timeout_alert_piece_index_get(long jarg1, block_timeout_alert jarg1_);
  public final static native void delete_block_timeout_alert(long jarg1);
  public final static native int block_finished_alert_priority_get();
  public final static native int block_finished_alert_alert_type_get();
  public final static native int block_finished_alert_type(long jarg1, block_finished_alert jarg1_);
  public final static native long block_finished_alert_category(long jarg1, block_finished_alert jarg1_);
  public final static native String block_finished_alert_what(long jarg1, block_finished_alert jarg1_);
  public final static native long block_finished_alert_static_category_get();
  public final static native String block_finished_alert_message(long jarg1, block_finished_alert jarg1_);
  public final static native int block_finished_alert_block_index_get(long jarg1, block_finished_alert jarg1_);
  public final static native int block_finished_alert_piece_index_get(long jarg1, block_finished_alert jarg1_);
  public final static native void delete_block_finished_alert(long jarg1);
  public final static native int block_downloading_alert_priority_get();
  public final static native int block_downloading_alert_alert_type_get();
  public final static native int block_downloading_alert_type(long jarg1, block_downloading_alert jarg1_);
  public final static native long block_downloading_alert_category(long jarg1, block_downloading_alert jarg1_);
  public final static native String block_downloading_alert_what(long jarg1, block_downloading_alert jarg1_);
  public final static native long block_downloading_alert_static_category_get();
  public final static native String block_downloading_alert_message(long jarg1, block_downloading_alert jarg1_);
  public final static native int block_downloading_alert_block_index_get(long jarg1, block_downloading_alert jarg1_);
  public final static native int block_downloading_alert_piece_index_get(long jarg1, block_downloading_alert jarg1_);
  public final static native void delete_block_downloading_alert(long jarg1);
  public final static native int unwanted_block_alert_priority_get();
  public final static native int unwanted_block_alert_alert_type_get();
  public final static native int unwanted_block_alert_type(long jarg1, unwanted_block_alert jarg1_);
  public final static native long unwanted_block_alert_category(long jarg1, unwanted_block_alert jarg1_);
  public final static native String unwanted_block_alert_what(long jarg1, unwanted_block_alert jarg1_);
  public final static native long unwanted_block_alert_static_category_get();
  public final static native String unwanted_block_alert_message(long jarg1, unwanted_block_alert jarg1_);
  public final static native int unwanted_block_alert_block_index_get(long jarg1, unwanted_block_alert jarg1_);
  public final static native int unwanted_block_alert_piece_index_get(long jarg1, unwanted_block_alert jarg1_);
  public final static native void delete_unwanted_block_alert(long jarg1);
  public final static native int storage_moved_alert_priority_get();
  public final static native int storage_moved_alert_alert_type_get();
  public final static native int storage_moved_alert_type(long jarg1, storage_moved_alert jarg1_);
  public final static native long storage_moved_alert_category(long jarg1, storage_moved_alert jarg1_);
  public final static native String storage_moved_alert_what(long jarg1, storage_moved_alert jarg1_);
  public final static native long storage_moved_alert_static_category_get();
  public final static native String storage_moved_alert_message(long jarg1, storage_moved_alert jarg1_);
  public final static native String storage_moved_alert_storage_path(long jarg1, storage_moved_alert jarg1_);
  public final static native String storage_moved_alert_old_path(long jarg1, storage_moved_alert jarg1_);
  public final static native void delete_storage_moved_alert(long jarg1);
  public final static native int storage_moved_failed_alert_priority_get();
  public final static native int storage_moved_failed_alert_alert_type_get();
  public final static native int storage_moved_failed_alert_type(long jarg1, storage_moved_failed_alert jarg1_);
  public final static native long storage_moved_failed_alert_category(long jarg1, storage_moved_failed_alert jarg1_);
  public final static native String storage_moved_failed_alert_what(long jarg1, storage_moved_failed_alert jarg1_);
  public final static native long storage_moved_failed_alert_static_category_get();
  public final static native String storage_moved_failed_alert_message(long jarg1, storage_moved_failed_alert jarg1_);
  public final static native long storage_moved_failed_alert_error_get(long jarg1, storage_moved_failed_alert jarg1_);
  public final static native String storage_moved_failed_alert_file_path(long jarg1, storage_moved_failed_alert jarg1_);
  public final static native void storage_moved_failed_alert_op_set(long jarg1, storage_moved_failed_alert jarg1_, int jarg2);
  public final static native int storage_moved_failed_alert_op_get(long jarg1, storage_moved_failed_alert jarg1_);
  public final static native void delete_storage_moved_failed_alert(long jarg1);
  public final static native int torrent_deleted_alert_priority_get();
  public final static native int torrent_deleted_alert_alert_type_get();
  public final static native int torrent_deleted_alert_type(long jarg1, torrent_deleted_alert jarg1_);
  public final static native long torrent_deleted_alert_category(long jarg1, torrent_deleted_alert jarg1_);
  public final static native String torrent_deleted_alert_what(long jarg1, torrent_deleted_alert jarg1_);
  public final static native long torrent_deleted_alert_static_category_get();
  public final static native String torrent_deleted_alert_message(long jarg1, torrent_deleted_alert jarg1_);
  public final static native void torrent_deleted_alert_info_hashes_set(long jarg1, torrent_deleted_alert jarg1_, long jarg2, info_hash_t jarg2_);
  public final static native long torrent_deleted_alert_info_hashes_get(long jarg1, torrent_deleted_alert jarg1_);
  public final static native void delete_torrent_deleted_alert(long jarg1);
  public final static native int torrent_delete_failed_alert_priority_get();
  public final static native int torrent_delete_failed_alert_alert_type_get();
  public final static native int torrent_delete_failed_alert_type(long jarg1, torrent_delete_failed_alert jarg1_);
  public final static native long torrent_delete_failed_alert_category(long jarg1, torrent_delete_failed_alert jarg1_);
  public final static native String torrent_delete_failed_alert_what(long jarg1, torrent_delete_failed_alert jarg1_);
  public final static native long torrent_delete_failed_alert_static_category_get();
  public final static native String torrent_delete_failed_alert_message(long jarg1, torrent_delete_failed_alert jarg1_);
  public final static native long torrent_delete_failed_alert_error_get(long jarg1, torrent_delete_failed_alert jarg1_);
  public final static native void torrent_delete_failed_alert_info_hashes_set(long jarg1, torrent_delete_failed_alert jarg1_, long jarg2, info_hash_t jarg2_);
  public final static native long torrent_delete_failed_alert_info_hashes_get(long jarg1, torrent_delete_failed_alert jarg1_);
  public final static native void delete_torrent_delete_failed_alert(long jarg1);
  public final static native int save_resume_data_alert_priority_get();
  public final static native int save_resume_data_alert_alert_type_get();
  public final static native int save_resume_data_alert_type(long jarg1, save_resume_data_alert jarg1_);
  public final static native long save_resume_data_alert_category(long jarg1, save_resume_data_alert jarg1_);
  public final static native String save_resume_data_alert_what(long jarg1, save_resume_data_alert jarg1_);
  public final static native long save_resume_data_alert_static_category_get();
  public final static native String save_resume_data_alert_message(long jarg1, save_resume_data_alert jarg1_);
  public final static native void save_resume_data_alert_params_set(long jarg1, save_resume_data_alert jarg1_, long jarg2, add_torrent_params jarg2_);
  public final static native long save_resume_data_alert_params_get(long jarg1, save_resume_data_alert jarg1_);
  public final static native void delete_save_resume_data_alert(long jarg1);
  public final static native int save_resume_data_failed_alert_priority_get();
  public final static native int save_resume_data_failed_alert_alert_type_get();
  public final static native int save_resume_data_failed_alert_type(long jarg1, save_resume_data_failed_alert jarg1_);
  public final static native long save_resume_data_failed_alert_category(long jarg1, save_resume_data_failed_alert jarg1_);
  public final static native String save_resume_data_failed_alert_what(long jarg1, save_resume_data_failed_alert jarg1_);
  public final static native long save_resume_data_failed_alert_static_category_get();
  public final static native String save_resume_data_failed_alert_message(long jarg1, save_resume_data_failed_alert jarg1_);
  public final static native long save_resume_data_failed_alert_error_get(long jarg1, save_resume_data_failed_alert jarg1_);
  public final static native void delete_save_resume_data_failed_alert(long jarg1);
  public final static native int torrent_paused_alert_priority_get();
  public final static native int torrent_paused_alert_alert_type_get();
  public final static native int torrent_paused_alert_type(long jarg1, torrent_paused_alert jarg1_);
  public final static native long torrent_paused_alert_category(long jarg1, torrent_paused_alert jarg1_);
  public final static native String torrent_paused_alert_what(long jarg1, torrent_paused_alert jarg1_);
  public final static native long torrent_paused_alert_static_category_get();
  public final static native String torrent_paused_alert_message(long jarg1, torrent_paused_alert jarg1_);
  public final static native void delete_torrent_paused_alert(long jarg1);
  public final static native int torrent_resumed_alert_priority_get();
  public final static native int torrent_resumed_alert_alert_type_get();
  public final static native int torrent_resumed_alert_type(long jarg1, torrent_resumed_alert jarg1_);
  public final static native long torrent_resumed_alert_category(long jarg1, torrent_resumed_alert jarg1_);
  public final static native String torrent_resumed_alert_what(long jarg1, torrent_resumed_alert jarg1_);
  public final static native long torrent_resumed_alert_static_category_get();
  public final static native String torrent_resumed_alert_message(long jarg1, torrent_resumed_alert jarg1_);
  public final static native void delete_torrent_resumed_alert(long jarg1);
  public final static native int torrent_checked_alert_priority_get();
  public final static native int torrent_checked_alert_alert_type_get();
  public final static native int torrent_checked_alert_type(long jarg1, torrent_checked_alert jarg1_);
  public final static native long torrent_checked_alert_category(long jarg1, torrent_checked_alert jarg1_);
  public final static native String torrent_checked_alert_what(long jarg1, torrent_checked_alert jarg1_);
  public final static native long torrent_checked_alert_static_category_get();
  public final static native String torrent_checked_alert_message(long jarg1, torrent_checked_alert jarg1_);
  public final static native void delete_torrent_checked_alert(long jarg1);
  public final static native int url_seed_alert_priority_get();
  public final static native int url_seed_alert_alert_type_get();
  public final static native int url_seed_alert_type(long jarg1, url_seed_alert jarg1_);
  public final static native long url_seed_alert_category(long jarg1, url_seed_alert jarg1_);
  public final static native String url_seed_alert_what(long jarg1, url_seed_alert jarg1_);
  public final static native long url_seed_alert_static_category_get();
  public final static native String url_seed_alert_message(long jarg1, url_seed_alert jarg1_);
  public final static native long url_seed_alert_error_get(long jarg1, url_seed_alert jarg1_);
  public final static native String url_seed_alert_server_url(long jarg1, url_seed_alert jarg1_);
  public final static native String url_seed_alert_error_message(long jarg1, url_seed_alert jarg1_);
  public final static native void delete_url_seed_alert(long jarg1);
  public final static native int file_error_alert_priority_get();
  public final static native int file_error_alert_alert_type_get();
  public final static native int file_error_alert_type(long jarg1, file_error_alert jarg1_);
  public final static native long file_error_alert_category(long jarg1, file_error_alert jarg1_);
  public final static native String file_error_alert_what(long jarg1, file_error_alert jarg1_);
  public final static native long file_error_alert_static_category_get();
  public final static native String file_error_alert_message(long jarg1, file_error_alert jarg1_);
  public final static native long file_error_alert_error_get(long jarg1, file_error_alert jarg1_);
  public final static native void file_error_alert_op_set(long jarg1, file_error_alert jarg1_, int jarg2);
  public final static native int file_error_alert_op_get(long jarg1, file_error_alert jarg1_);
  public final static native String file_error_alert_filename(long jarg1, file_error_alert jarg1_);
  public final static native void delete_file_error_alert(long jarg1);
  public final static native int metadata_failed_alert_priority_get();
  public final static native int metadata_failed_alert_alert_type_get();
  public final static native int metadata_failed_alert_type(long jarg1, metadata_failed_alert jarg1_);
  public final static native long metadata_failed_alert_category(long jarg1, metadata_failed_alert jarg1_);
  public final static native String metadata_failed_alert_what(long jarg1, metadata_failed_alert jarg1_);
  public final static native long metadata_failed_alert_static_category_get();
  public final static native String metadata_failed_alert_message(long jarg1, metadata_failed_alert jarg1_);
  public final static native long metadata_failed_alert_error_get(long jarg1, metadata_failed_alert jarg1_);
  public final static native void delete_metadata_failed_alert(long jarg1);
  public final static native int metadata_received_alert_priority_get();
  public final static native int metadata_received_alert_alert_type_get();
  public final static native int metadata_received_alert_type(long jarg1, metadata_received_alert jarg1_);
  public final static native long metadata_received_alert_category(long jarg1, metadata_received_alert jarg1_);
  public final static native String metadata_received_alert_what(long jarg1, metadata_received_alert jarg1_);
  public final static native long metadata_received_alert_static_category_get();
  public final static native String metadata_received_alert_message(long jarg1, metadata_received_alert jarg1_);
  public final static native void delete_metadata_received_alert(long jarg1);
  public final static native int udp_error_alert_priority_get();
  public final static native int udp_error_alert_alert_type_get();
  public final static native int udp_error_alert_type(long jarg1, udp_error_alert jarg1_);
  public final static native long udp_error_alert_category(long jarg1, udp_error_alert jarg1_);
  public final static native String udp_error_alert_what(long jarg1, udp_error_alert jarg1_);
  public final static native long udp_error_alert_static_category_get();
  public final static native String udp_error_alert_message(long jarg1, udp_error_alert jarg1_);
  public final static native void udp_error_alert_operation_set(long jarg1, udp_error_alert jarg1_, int jarg2);
  public final static native int udp_error_alert_operation_get(long jarg1, udp_error_alert jarg1_);
  public final static native long udp_error_alert_error_get(long jarg1, udp_error_alert jarg1_);
  public final static native long udp_error_alert_get_endpoint(long jarg1, udp_error_alert jarg1_);
  public final static native void delete_udp_error_alert(long jarg1);
  public final static native int external_ip_alert_priority_get();
  public final static native int external_ip_alert_alert_type_get();
  public final static native int external_ip_alert_type(long jarg1, external_ip_alert jarg1_);
  public final static native long external_ip_alert_category(long jarg1, external_ip_alert jarg1_);
  public final static native String external_ip_alert_what(long jarg1, external_ip_alert jarg1_);
  public final static native long external_ip_alert_static_category_get();
  public final static native String external_ip_alert_message(long jarg1, external_ip_alert jarg1_);
  public final static native long external_ip_alert_get_external_address(long jarg1, external_ip_alert jarg1_);
  public final static native void delete_external_ip_alert(long jarg1);
  public final static native int listen_failed_alert_priority_get();
  public final static native int listen_failed_alert_alert_type_get();
  public final static native int listen_failed_alert_type(long jarg1, listen_failed_alert jarg1_);
  public final static native long listen_failed_alert_category(long jarg1, listen_failed_alert jarg1_);
  public final static native String listen_failed_alert_what(long jarg1, listen_failed_alert jarg1_);
  public final static native long listen_failed_alert_static_category_get();
  public final static native String listen_failed_alert_message(long jarg1, listen_failed_alert jarg1_);
  public final static native String listen_failed_alert_listen_interface(long jarg1, listen_failed_alert jarg1_);
  public final static native long listen_failed_alert_error_get(long jarg1, listen_failed_alert jarg1_);
  public final static native void listen_failed_alert_op_set(long jarg1, listen_failed_alert jarg1_, int jarg2);
  public final static native int listen_failed_alert_op_get(long jarg1, listen_failed_alert jarg1_);
  public final static native int listen_failed_alert_port_get(long jarg1, listen_failed_alert jarg1_);
  public final static native int listen_failed_alert_get_socket_type(long jarg1, listen_failed_alert jarg1_);
  public final static native long listen_failed_alert_get_address(long jarg1, listen_failed_alert jarg1_);
  public final static native void delete_listen_failed_alert(long jarg1);
  public final static native int listen_succeeded_alert_priority_get();
  public final static native int listen_succeeded_alert_alert_type_get();
  public final static native int listen_succeeded_alert_type(long jarg1, listen_succeeded_alert jarg1_);
  public final static native long listen_succeeded_alert_category(long jarg1, listen_succeeded_alert jarg1_);
  public final static native String listen_succeeded_alert_what(long jarg1, listen_succeeded_alert jarg1_);
  public final static native long listen_succeeded_alert_static_category_get();
  public final static native String listen_succeeded_alert_message(long jarg1, listen_succeeded_alert jarg1_);
  public final static native int listen_succeeded_alert_port_get(long jarg1, listen_succeeded_alert jarg1_);
  public final static native long listen_succeeded_alert_get_address(long jarg1, listen_succeeded_alert jarg1_);
  public final static native int listen_succeeded_alert_get_socket_type(long jarg1, listen_succeeded_alert jarg1_);
  public final static native void delete_listen_succeeded_alert(long jarg1);
  public final static native int portmap_error_alert_priority_get();
  public final static native int portmap_error_alert_alert_type_get();
  public final static native int portmap_error_alert_type(long jarg1, portmap_error_alert jarg1_);
  public final static native long portmap_error_alert_category(long jarg1, portmap_error_alert jarg1_);
  public final static native String portmap_error_alert_what(long jarg1, portmap_error_alert jarg1_);
  public final static native long portmap_error_alert_static_category_get();
  public final static native String portmap_error_alert_message(long jarg1, portmap_error_alert jarg1_);
  public final static native void portmap_error_alert_map_transport_set(long jarg1, portmap_error_alert jarg1_, int jarg2);
  public final static native int portmap_error_alert_map_transport_get(long jarg1, portmap_error_alert jarg1_);
  public final static native long portmap_error_alert_error_get(long jarg1, portmap_error_alert jarg1_);
  public final static native int portmap_error_alert_get_mapping(long jarg1, portmap_error_alert jarg1_);
  public final static native void delete_portmap_error_alert(long jarg1);
  public final static native int portmap_alert_priority_get();
  public final static native int portmap_alert_alert_type_get();
  public final static native int portmap_alert_type(long jarg1, portmap_alert jarg1_);
  public final static native long portmap_alert_category(long jarg1, portmap_alert jarg1_);
  public final static native String portmap_alert_what(long jarg1, portmap_alert jarg1_);
  public final static native long portmap_alert_static_category_get();
  public final static native String portmap_alert_message(long jarg1, portmap_alert jarg1_);
  public final static native int portmap_alert_external_port_get(long jarg1, portmap_alert jarg1_);
  public final static native int portmap_alert_map_protocol_get(long jarg1, portmap_alert jarg1_);
  public final static native int portmap_alert_map_transport_get(long jarg1, portmap_alert jarg1_);
  public final static native int portmap_alert_get_mapping(long jarg1, portmap_alert jarg1_);
  public final static native void delete_portmap_alert(long jarg1);
  public final static native int portmap_log_alert_priority_get();
  public final static native int portmap_log_alert_alert_type_get();
  public final static native int portmap_log_alert_type(long jarg1, portmap_log_alert jarg1_);
  public final static native long portmap_log_alert_category(long jarg1, portmap_log_alert jarg1_);
  public final static native String portmap_log_alert_what(long jarg1, portmap_log_alert jarg1_);
  public final static native long portmap_log_alert_static_category_get();
  public final static native String portmap_log_alert_message(long jarg1, portmap_log_alert jarg1_);
  public final static native int portmap_log_alert_map_transport_get(long jarg1, portmap_log_alert jarg1_);
  public final static native String portmap_log_alert_log_message(long jarg1, portmap_log_alert jarg1_);
  public final static native void delete_portmap_log_alert(long jarg1);
  public final static native int fastresume_rejected_alert_priority_get();
  public final static native int fastresume_rejected_alert_alert_type_get();
  public final static native int fastresume_rejected_alert_type(long jarg1, fastresume_rejected_alert jarg1_);
  public final static native long fastresume_rejected_alert_category(long jarg1, fastresume_rejected_alert jarg1_);
  public final static native String fastresume_rejected_alert_what(long jarg1, fastresume_rejected_alert jarg1_);
  public final static native long fastresume_rejected_alert_static_category_get();
  public final static native String fastresume_rejected_alert_message(long jarg1, fastresume_rejected_alert jarg1_);
  public final static native void fastresume_rejected_alert_error_set(long jarg1, fastresume_rejected_alert jarg1_, long jarg2, error_code jarg2_);
  public final static native long fastresume_rejected_alert_error_get(long jarg1, fastresume_rejected_alert jarg1_);
  public final static native String fastresume_rejected_alert_file_path(long jarg1, fastresume_rejected_alert jarg1_);
  public final static native void fastresume_rejected_alert_op_set(long jarg1, fastresume_rejected_alert jarg1_, int jarg2);
  public final static native int fastresume_rejected_alert_op_get(long jarg1, fastresume_rejected_alert jarg1_);
  public final static native void delete_fastresume_rejected_alert(long jarg1);
  public final static native int peer_blocked_alert_priority_get();
  public final static native int peer_blocked_alert_alert_type_get();
  public final static native int peer_blocked_alert_type(long jarg1, peer_blocked_alert jarg1_);
  public final static native long peer_blocked_alert_category(long jarg1, peer_blocked_alert jarg1_);
  public final static native String peer_blocked_alert_what(long jarg1, peer_blocked_alert jarg1_);
  public final static native long peer_blocked_alert_static_category_get();
  public final static native String peer_blocked_alert_message(long jarg1, peer_blocked_alert jarg1_);
  public final static native int peer_blocked_alert_reason_get(long jarg1, peer_blocked_alert jarg1_);
  public final static native void delete_peer_blocked_alert(long jarg1);
  public final static native int dht_announce_alert_priority_get();
  public final static native int dht_announce_alert_alert_type_get();
  public final static native int dht_announce_alert_type(long jarg1, dht_announce_alert jarg1_);
  public final static native long dht_announce_alert_category(long jarg1, dht_announce_alert jarg1_);
  public final static native String dht_announce_alert_what(long jarg1, dht_announce_alert jarg1_);
  public final static native long dht_announce_alert_static_category_get();
  public final static native String dht_announce_alert_message(long jarg1, dht_announce_alert jarg1_);
  public final static native void dht_announce_alert_port_set(long jarg1, dht_announce_alert jarg1_, int jarg2);
  public final static native int dht_announce_alert_port_get(long jarg1, dht_announce_alert jarg1_);
  public final static native void dht_announce_alert_info_hash_set(long jarg1, dht_announce_alert jarg1_, long jarg2, sha1_hash jarg2_);
  public final static native long dht_announce_alert_info_hash_get(long jarg1, dht_announce_alert jarg1_);
  public final static native long dht_announce_alert_get_ip(long jarg1, dht_announce_alert jarg1_);
  public final static native void delete_dht_announce_alert(long jarg1);
  public final static native int dht_get_peers_alert_priority_get();
  public final static native int dht_get_peers_alert_alert_type_get();
  public final static native int dht_get_peers_alert_type(long jarg1, dht_get_peers_alert jarg1_);
  public final static native long dht_get_peers_alert_category(long jarg1, dht_get_peers_alert jarg1_);
  public final static native String dht_get_peers_alert_what(long jarg1, dht_get_peers_alert jarg1_);
  public final static native long dht_get_peers_alert_static_category_get();
  public final static native String dht_get_peers_alert_message(long jarg1, dht_get_peers_alert jarg1_);
  public final static native void dht_get_peers_alert_info_hash_set(long jarg1, dht_get_peers_alert jarg1_, long jarg2, sha1_hash jarg2_);
  public final static native long dht_get_peers_alert_info_hash_get(long jarg1, dht_get_peers_alert jarg1_);
  public final static native void delete_dht_get_peers_alert(long jarg1);
  public final static native int cache_flushed_alert_priority_get();
  public final static native int cache_flushed_alert_alert_type_get();
  public final static native int cache_flushed_alert_type(long jarg1, cache_flushed_alert jarg1_);
  public final static native long cache_flushed_alert_category(long jarg1, cache_flushed_alert jarg1_);
  public final static native String cache_flushed_alert_what(long jarg1, cache_flushed_alert jarg1_);
  public final static native long cache_flushed_alert_static_category_get();
  public final static native void delete_cache_flushed_alert(long jarg1);
  public final static native int lsd_peer_alert_priority_get();
  public final static native int lsd_peer_alert_alert_type_get();
  public final static native int lsd_peer_alert_type(long jarg1, lsd_peer_alert jarg1_);
  public final static native long lsd_peer_alert_category(long jarg1, lsd_peer_alert jarg1_);
  public final static native String lsd_peer_alert_what(long jarg1, lsd_peer_alert jarg1_);
  public final static native long lsd_peer_alert_static_category_get();
  public final static native String lsd_peer_alert_message(long jarg1, lsd_peer_alert jarg1_);
  public final static native void delete_lsd_peer_alert(long jarg1);
  public final static native int trackerid_alert_priority_get();
  public final static native int trackerid_alert_alert_type_get();
  public final static native int trackerid_alert_type(long jarg1, trackerid_alert jarg1_);
  public final static native long trackerid_alert_category(long jarg1, trackerid_alert jarg1_);
  public final static native String trackerid_alert_what(long jarg1, trackerid_alert jarg1_);
  public final static native long trackerid_alert_static_category_get();
  public final static native String trackerid_alert_message(long jarg1, trackerid_alert jarg1_);
  public final static native String trackerid_alert_tracker_id(long jarg1, trackerid_alert jarg1_);
  public final static native void delete_trackerid_alert(long jarg1);
  public final static native int dht_bootstrap_alert_priority_get();
  public final static native int dht_bootstrap_alert_alert_type_get();
  public final static native int dht_bootstrap_alert_type(long jarg1, dht_bootstrap_alert jarg1_);
  public final static native long dht_bootstrap_alert_category(long jarg1, dht_bootstrap_alert jarg1_);
  public final static native String dht_bootstrap_alert_what(long jarg1, dht_bootstrap_alert jarg1_);
  public final static native long dht_bootstrap_alert_static_category_get();
  public final static native String dht_bootstrap_alert_message(long jarg1, dht_bootstrap_alert jarg1_);
  public final static native void delete_dht_bootstrap_alert(long jarg1);
  public final static native int torrent_error_alert_priority_get();
  public final static native int torrent_error_alert_alert_type_get();
  public final static native int torrent_error_alert_type(long jarg1, torrent_error_alert jarg1_);
  public final static native long torrent_error_alert_category(long jarg1, torrent_error_alert jarg1_);
  public final static native String torrent_error_alert_what(long jarg1, torrent_error_alert jarg1_);
  public final static native long torrent_error_alert_static_category_get();
  public final static native String torrent_error_alert_message(long jarg1, torrent_error_alert jarg1_);
  public final static native long torrent_error_alert_error_get(long jarg1, torrent_error_alert jarg1_);
  public final static native String torrent_error_alert_filename(long jarg1, torrent_error_alert jarg1_);
  public final static native void delete_torrent_error_alert(long jarg1);
  public final static native int torrent_need_cert_alert_priority_get();
  public final static native int torrent_need_cert_alert_alert_type_get();
  public final static native int torrent_need_cert_alert_type(long jarg1, torrent_need_cert_alert jarg1_);
  public final static native long torrent_need_cert_alert_category(long jarg1, torrent_need_cert_alert jarg1_);
  public final static native String torrent_need_cert_alert_what(long jarg1, torrent_need_cert_alert jarg1_);
  public final static native long torrent_need_cert_alert_static_category_get();
  public final static native String torrent_need_cert_alert_message(long jarg1, torrent_need_cert_alert jarg1_);
  public final static native void delete_torrent_need_cert_alert(long jarg1);
  public final static native int incoming_connection_alert_priority_get();
  public final static native int incoming_connection_alert_alert_type_get();
  public final static native int incoming_connection_alert_type(long jarg1, incoming_connection_alert jarg1_);
  public final static native long incoming_connection_alert_category(long jarg1, incoming_connection_alert jarg1_);
  public final static native String incoming_connection_alert_what(long jarg1, incoming_connection_alert jarg1_);
  public final static native long incoming_connection_alert_static_category_get();
  public final static native String incoming_connection_alert_message(long jarg1, incoming_connection_alert jarg1_);
  public final static native void incoming_connection_alert_socket_type_set(long jarg1, incoming_connection_alert jarg1_, int jarg2);
  public final static native int incoming_connection_alert_socket_type_get(long jarg1, incoming_connection_alert jarg1_);
  public final static native long incoming_connection_alert_get_endpoint(long jarg1, incoming_connection_alert jarg1_);
  public final static native void delete_incoming_connection_alert(long jarg1);
  public final static native int add_torrent_alert_priority_get();
  public final static native int add_torrent_alert_alert_type_get();
  public final static native int add_torrent_alert_type(long jarg1, add_torrent_alert jarg1_);
  public final static native long add_torrent_alert_category(long jarg1, add_torrent_alert jarg1_);
  public final static native String add_torrent_alert_what(long jarg1, add_torrent_alert jarg1_);
  public final static native long add_torrent_alert_static_category_get();
  public final static native String add_torrent_alert_message(long jarg1, add_torrent_alert jarg1_);
  public final static native void add_torrent_alert_params_set(long jarg1, add_torrent_alert jarg1_, long jarg2, add_torrent_params jarg2_);
  public final static native long add_torrent_alert_params_get(long jarg1, add_torrent_alert jarg1_);
  public final static native void add_torrent_alert_error_set(long jarg1, add_torrent_alert jarg1_, long jarg2, error_code jarg2_);
  public final static native long add_torrent_alert_error_get(long jarg1, add_torrent_alert jarg1_);
  public final static native void delete_add_torrent_alert(long jarg1);
  public final static native int state_update_alert_priority_get();
  public final static native int state_update_alert_alert_type_get();
  public final static native int state_update_alert_type(long jarg1, state_update_alert jarg1_);
  public final static native long state_update_alert_category(long jarg1, state_update_alert jarg1_);
  public final static native String state_update_alert_what(long jarg1, state_update_alert jarg1_);
  public final static native long state_update_alert_static_category_get();
  public final static native String state_update_alert_message(long jarg1, state_update_alert jarg1_);
  public final static native void state_update_alert_status_set(long jarg1, state_update_alert jarg1_, long jarg2, torrent_status_vector jarg2_);
  public final static native long state_update_alert_status_get(long jarg1, state_update_alert jarg1_);
  public final static native void delete_state_update_alert(long jarg1);
  public final static native int session_stats_alert_priority_get();
  public final static native int session_stats_alert_alert_type_get();
  public final static native int session_stats_alert_type(long jarg1, session_stats_alert jarg1_);
  public final static native long session_stats_alert_category(long jarg1, session_stats_alert jarg1_);
  public final static native String session_stats_alert_what(long jarg1, session_stats_alert jarg1_);
  public final static native long session_stats_alert_static_category_get();
  public final static native String session_stats_alert_message(long jarg1, session_stats_alert jarg1_);
  public final static native long session_stats_alert_get_value(long jarg1, session_stats_alert jarg1_, int jarg2);
  public final static native void delete_session_stats_alert(long jarg1);
  public final static native int dht_error_alert_priority_get();
  public final static native int dht_error_alert_alert_type_get();
  public final static native int dht_error_alert_type(long jarg1, dht_error_alert jarg1_);
  public final static native long dht_error_alert_category(long jarg1, dht_error_alert jarg1_);
  public final static native String dht_error_alert_what(long jarg1, dht_error_alert jarg1_);
  public final static native long dht_error_alert_static_category_get();
  public final static native String dht_error_alert_message(long jarg1, dht_error_alert jarg1_);
  public final static native void dht_error_alert_error_set(long jarg1, dht_error_alert jarg1_, long jarg2, error_code jarg2_);
  public final static native long dht_error_alert_error_get(long jarg1, dht_error_alert jarg1_);
  public final static native void dht_error_alert_op_set(long jarg1, dht_error_alert jarg1_, int jarg2);
  public final static native int dht_error_alert_op_get(long jarg1, dht_error_alert jarg1_);
  public final static native void delete_dht_error_alert(long jarg1);
  public final static native int dht_immutable_item_alert_priority_get();
  public final static native int dht_immutable_item_alert_alert_type_get();
  public final static native int dht_immutable_item_alert_type(long jarg1, dht_immutable_item_alert jarg1_);
  public final static native long dht_immutable_item_alert_category(long jarg1, dht_immutable_item_alert jarg1_);
  public final static native String dht_immutable_item_alert_what(long jarg1, dht_immutable_item_alert jarg1_);
  public final static native long dht_immutable_item_alert_static_category_get();
  public final static native String dht_immutable_item_alert_message(long jarg1, dht_immutable_item_alert jarg1_);
  public final static native void dht_immutable_item_alert_target_set(long jarg1, dht_immutable_item_alert jarg1_, long jarg2, sha1_hash jarg2_);
  public final static native long dht_immutable_item_alert_target_get(long jarg1, dht_immutable_item_alert jarg1_);
  public final static native void dht_immutable_item_alert_item_set(long jarg1, dht_immutable_item_alert jarg1_, long jarg2, entry jarg2_);
  public final static native long dht_immutable_item_alert_item_get(long jarg1, dht_immutable_item_alert jarg1_);
  public final static native void delete_dht_immutable_item_alert(long jarg1);
  public final static native int dht_mutable_item_alert_priority_get();
  public final static native int dht_mutable_item_alert_alert_type_get();
  public final static native int dht_mutable_item_alert_type(long jarg1, dht_mutable_item_alert jarg1_);
  public final static native long dht_mutable_item_alert_category(long jarg1, dht_mutable_item_alert jarg1_);
  public final static native String dht_mutable_item_alert_what(long jarg1, dht_mutable_item_alert jarg1_);
  public final static native long dht_mutable_item_alert_static_category_get();
  public final static native String dht_mutable_item_alert_message(long jarg1, dht_mutable_item_alert jarg1_);
  public final static native void dht_mutable_item_alert_item_set(long jarg1, dht_mutable_item_alert jarg1_, long jarg2, entry jarg2_);
  public final static native long dht_mutable_item_alert_item_get(long jarg1, dht_mutable_item_alert jarg1_);
  public final static native void dht_mutable_item_alert_authoritative_set(long jarg1, dht_mutable_item_alert jarg1_, boolean jarg2);
  public final static native boolean dht_mutable_item_alert_authoritative_get(long jarg1, dht_mutable_item_alert jarg1_);
  public final static native long dht_mutable_item_alert_get_key(long jarg1, dht_mutable_item_alert jarg1_);
  public final static native long dht_mutable_item_alert_get_signature(long jarg1, dht_mutable_item_alert jarg1_);
  public final static native long dht_mutable_item_alert_get_seq(long jarg1, dht_mutable_item_alert jarg1_);
  public final static native long dht_mutable_item_alert_get_salt(long jarg1, dht_mutable_item_alert jarg1_);
  public final static native void delete_dht_mutable_item_alert(long jarg1);
  public final static native int dht_put_alert_priority_get();
  public final static native int dht_put_alert_alert_type_get();
  public final static native int dht_put_alert_type(long jarg1, dht_put_alert jarg1_);
  public final static native long dht_put_alert_category(long jarg1, dht_put_alert jarg1_);
  public final static native String dht_put_alert_what(long jarg1, dht_put_alert jarg1_);
  public final static native long dht_put_alert_static_category_get();
  public final static native String dht_put_alert_message(long jarg1, dht_put_alert jarg1_);
  public final static native void dht_put_alert_target_set(long jarg1, dht_put_alert jarg1_, long jarg2, sha1_hash jarg2_);
  public final static native long dht_put_alert_target_get(long jarg1, dht_put_alert jarg1_);
  public final static native void dht_put_alert_num_success_set(long jarg1, dht_put_alert jarg1_, int jarg2);
  public final static native int dht_put_alert_num_success_get(long jarg1, dht_put_alert jarg1_);
  public final static native long dht_put_alert_get_public_key(long jarg1, dht_put_alert jarg1_);
  public final static native long dht_put_alert_get_signature(long jarg1, dht_put_alert jarg1_);
  public final static native long dht_put_alert_get_salt(long jarg1, dht_put_alert jarg1_);
  public final static native long dht_put_alert_get_seq(long jarg1, dht_put_alert jarg1_);
  public final static native void delete_dht_put_alert(long jarg1);
  public final static native int i2p_alert_priority_get();
  public final static native int i2p_alert_alert_type_get();
  public final static native int i2p_alert_type(long jarg1, i2p_alert jarg1_);
  public final static native long i2p_alert_category(long jarg1, i2p_alert jarg1_);
  public final static native String i2p_alert_what(long jarg1, i2p_alert jarg1_);
  public final static native long i2p_alert_static_category_get();
  public final static native String i2p_alert_message(long jarg1, i2p_alert jarg1_);
  public final static native void i2p_alert_error_set(long jarg1, i2p_alert jarg1_, long jarg2, error_code jarg2_);
  public final static native long i2p_alert_error_get(long jarg1, i2p_alert jarg1_);
  public final static native void delete_i2p_alert(long jarg1);
  public final static native int dht_outgoing_get_peers_alert_priority_get();
  public final static native int dht_outgoing_get_peers_alert_alert_type_get();
  public final static native int dht_outgoing_get_peers_alert_type(long jarg1, dht_outgoing_get_peers_alert jarg1_);
  public final static native long dht_outgoing_get_peers_alert_category(long jarg1, dht_outgoing_get_peers_alert jarg1_);
  public final static native String dht_outgoing_get_peers_alert_what(long jarg1, dht_outgoing_get_peers_alert jarg1_);
  public final static native long dht_outgoing_get_peers_alert_static_category_get();
  public final static native String dht_outgoing_get_peers_alert_message(long jarg1, dht_outgoing_get_peers_alert jarg1_);
  public final static native void dht_outgoing_get_peers_alert_info_hash_set(long jarg1, dht_outgoing_get_peers_alert jarg1_, long jarg2, sha1_hash jarg2_);
  public final static native long dht_outgoing_get_peers_alert_info_hash_get(long jarg1, dht_outgoing_get_peers_alert jarg1_);
  public final static native void dht_outgoing_get_peers_alert_obfuscated_info_hash_set(long jarg1, dht_outgoing_get_peers_alert jarg1_, long jarg2, sha1_hash jarg2_);
  public final static native long dht_outgoing_get_peers_alert_obfuscated_info_hash_get(long jarg1, dht_outgoing_get_peers_alert jarg1_);
  public final static native long dht_outgoing_get_peers_alert_get_endpoint(long jarg1, dht_outgoing_get_peers_alert jarg1_);
  public final static native void delete_dht_outgoing_get_peers_alert(long jarg1);
  public final static native int log_alert_priority_get();
  public final static native int log_alert_alert_type_get();
  public final static native int log_alert_type(long jarg1, log_alert jarg1_);
  public final static native long log_alert_category(long jarg1, log_alert jarg1_);
  public final static native String log_alert_what(long jarg1, log_alert jarg1_);
  public final static native long log_alert_static_category_get();
  public final static native String log_alert_message(long jarg1, log_alert jarg1_);
  public final static native String log_alert_log_message(long jarg1, log_alert jarg1_);
  public final static native void delete_log_alert(long jarg1);
  public final static native int torrent_log_alert_priority_get();
  public final static native int torrent_log_alert_alert_type_get();
  public final static native int torrent_log_alert_type(long jarg1, torrent_log_alert jarg1_);
  public final static native long torrent_log_alert_category(long jarg1, torrent_log_alert jarg1_);
  public final static native String torrent_log_alert_what(long jarg1, torrent_log_alert jarg1_);
  public final static native long torrent_log_alert_static_category_get();
  public final static native String torrent_log_alert_message(long jarg1, torrent_log_alert jarg1_);
  public final static native String torrent_log_alert_log_message(long jarg1, torrent_log_alert jarg1_);
  public final static native void delete_torrent_log_alert(long jarg1);
  public final static native int peer_log_alert_priority_get();
  public final static native int peer_log_alert_alert_type_get();
  public final static native int peer_log_alert_type(long jarg1, peer_log_alert jarg1_);
  public final static native long peer_log_alert_category(long jarg1, peer_log_alert jarg1_);
  public final static native String peer_log_alert_what(long jarg1, peer_log_alert jarg1_);
  public final static native long peer_log_alert_static_category_get();
  public final static native String peer_log_alert_message(long jarg1, peer_log_alert jarg1_);
  public final static native void peer_log_alert_direction_set(long jarg1, peer_log_alert jarg1_, int jarg2);
  public final static native int peer_log_alert_direction_get(long jarg1, peer_log_alert jarg1_);
  public final static native String peer_log_alert_log_message(long jarg1, peer_log_alert jarg1_);
  public final static native String peer_log_alert_get_event_type(long jarg1, peer_log_alert jarg1_);
  public final static native void delete_peer_log_alert(long jarg1);
  public final static native int lsd_error_alert_priority_get();
  public final static native int lsd_error_alert_alert_type_get();
  public final static native int lsd_error_alert_type(long jarg1, lsd_error_alert jarg1_);
  public final static native long lsd_error_alert_category(long jarg1, lsd_error_alert jarg1_);
  public final static native String lsd_error_alert_what(long jarg1, lsd_error_alert jarg1_);
  public final static native long lsd_error_alert_static_category_get();
  public final static native String lsd_error_alert_message(long jarg1, lsd_error_alert jarg1_);
  public final static native void lsd_error_alert_error_set(long jarg1, lsd_error_alert jarg1_, long jarg2, error_code jarg2_);
  public final static native long lsd_error_alert_error_get(long jarg1, lsd_error_alert jarg1_);
  public final static native void delete_lsd_error_alert(long jarg1);
  public final static native void dht_lookup_outstanding_requests_set(long jarg1, dht_lookup jarg1_, int jarg2);
  public final static native int dht_lookup_outstanding_requests_get(long jarg1, dht_lookup jarg1_);
  public final static native void dht_lookup_timeouts_set(long jarg1, dht_lookup jarg1_, int jarg2);
  public final static native int dht_lookup_timeouts_get(long jarg1, dht_lookup jarg1_);
  public final static native void dht_lookup_responses_set(long jarg1, dht_lookup jarg1_, int jarg2);
  public final static native int dht_lookup_responses_get(long jarg1, dht_lookup jarg1_);
  public final static native void dht_lookup_branch_factor_set(long jarg1, dht_lookup jarg1_, int jarg2);
  public final static native int dht_lookup_branch_factor_get(long jarg1, dht_lookup jarg1_);
  public final static native void dht_lookup_nodes_left_set(long jarg1, dht_lookup jarg1_, int jarg2);
  public final static native int dht_lookup_nodes_left_get(long jarg1, dht_lookup jarg1_);
  public final static native void dht_lookup_last_sent_set(long jarg1, dht_lookup jarg1_, int jarg2);
  public final static native int dht_lookup_last_sent_get(long jarg1, dht_lookup jarg1_);
  public final static native void dht_lookup_first_timeout_set(long jarg1, dht_lookup jarg1_, int jarg2);
  public final static native int dht_lookup_first_timeout_get(long jarg1, dht_lookup jarg1_);
  public final static native void dht_lookup_target_set(long jarg1, dht_lookup jarg1_, long jarg2, sha1_hash jarg2_);
  public final static native long dht_lookup_target_get(long jarg1, dht_lookup jarg1_);
  public final static native String dht_lookup_get_type(long jarg1, dht_lookup jarg1_);
  public final static native long new_dht_lookup();
  public final static native void delete_dht_lookup(long jarg1);
  public final static native int dht_stats_alert_priority_get();
  public final static native int dht_stats_alert_alert_type_get();
  public final static native int dht_stats_alert_type(long jarg1, dht_stats_alert jarg1_);
  public final static native long dht_stats_alert_category(long jarg1, dht_stats_alert jarg1_);
  public final static native String dht_stats_alert_what(long jarg1, dht_stats_alert jarg1_);
  public final static native long dht_stats_alert_static_category_get();
  public final static native String dht_stats_alert_message(long jarg1, dht_stats_alert jarg1_);
  public final static native void dht_stats_alert_active_requests_set(long jarg1, dht_stats_alert jarg1_, long jarg2, dht_lookup_vector jarg2_);
  public final static native long dht_stats_alert_active_requests_get(long jarg1, dht_stats_alert jarg1_);
  public final static native void dht_stats_alert_routing_table_set(long jarg1, dht_stats_alert jarg1_, long jarg2, dht_routing_bucket_vector jarg2_);
  public final static native long dht_stats_alert_routing_table_get(long jarg1, dht_stats_alert jarg1_);
  public final static native void dht_stats_alert_nid_set(long jarg1, dht_stats_alert jarg1_, long jarg2, sha1_hash jarg2_);
  public final static native long dht_stats_alert_nid_get(long jarg1, dht_stats_alert jarg1_);
  public final static native long dht_stats_alert_get_local_endpoint(long jarg1, dht_stats_alert jarg1_);
  public final static native void delete_dht_stats_alert(long jarg1);
  public final static native long incoming_request_alert_static_category_get();
  public final static native int incoming_request_alert_priority_get();
  public final static native int incoming_request_alert_alert_type_get();
  public final static native int incoming_request_alert_type(long jarg1, incoming_request_alert jarg1_);
  public final static native long incoming_request_alert_category(long jarg1, incoming_request_alert jarg1_);
  public final static native String incoming_request_alert_what(long jarg1, incoming_request_alert jarg1_);
  public final static native String incoming_request_alert_message(long jarg1, incoming_request_alert jarg1_);
  public final static native void incoming_request_alert_req_set(long jarg1, incoming_request_alert jarg1_, long jarg2, peer_request jarg2_);
  public final static native long incoming_request_alert_req_get(long jarg1, incoming_request_alert jarg1_);
  public final static native void delete_incoming_request_alert(long jarg1);
  public final static native long dht_log_alert_static_category_get();
  public final static native int dht_log_alert_priority_get();
  public final static native int dht_log_alert_alert_type_get();
  public final static native int dht_log_alert_type(long jarg1, dht_log_alert jarg1_);
  public final static native long dht_log_alert_category(long jarg1, dht_log_alert jarg1_);
  public final static native String dht_log_alert_what(long jarg1, dht_log_alert jarg1_);
  public final static native String dht_log_alert_message(long jarg1, dht_log_alert jarg1_);
  public final static native String dht_log_alert_log_message(long jarg1, dht_log_alert jarg1_);
  public final static native void dht_log_alert_module_set(long jarg1, dht_log_alert jarg1_, int jarg2);
  public final static native int dht_log_alert_module_get(long jarg1, dht_log_alert jarg1_);
  public final static native void delete_dht_log_alert(long jarg1);
  public final static native long dht_pkt_alert_static_category_get();
  public final static native int dht_pkt_alert_priority_get();
  public final static native int dht_pkt_alert_alert_type_get();
  public final static native int dht_pkt_alert_type(long jarg1, dht_pkt_alert jarg1_);
  public final static native long dht_pkt_alert_category(long jarg1, dht_pkt_alert jarg1_);
  public final static native String dht_pkt_alert_what(long jarg1, dht_pkt_alert jarg1_);
  public final static native String dht_pkt_alert_message(long jarg1, dht_pkt_alert jarg1_);
  public final static native void dht_pkt_alert_direction_set(long jarg1, dht_pkt_alert jarg1_, int jarg2);
  public final static native int dht_pkt_alert_direction_get(long jarg1, dht_pkt_alert jarg1_);
  public final static native long dht_pkt_alert_get_node(long jarg1, dht_pkt_alert jarg1_);
  public final static native long dht_pkt_alert_get_pkt_buf(long jarg1, dht_pkt_alert jarg1_);
  public final static native void delete_dht_pkt_alert(long jarg1);
  public final static native long dht_get_peers_reply_alert_static_category_get();
  public final static native int dht_get_peers_reply_alert_priority_get();
  public final static native int dht_get_peers_reply_alert_alert_type_get();
  public final static native int dht_get_peers_reply_alert_type(long jarg1, dht_get_peers_reply_alert jarg1_);
  public final static native long dht_get_peers_reply_alert_category(long jarg1, dht_get_peers_reply_alert jarg1_);
  public final static native String dht_get_peers_reply_alert_what(long jarg1, dht_get_peers_reply_alert jarg1_);
  public final static native String dht_get_peers_reply_alert_message(long jarg1, dht_get_peers_reply_alert jarg1_);
  public final static native void dht_get_peers_reply_alert_info_hash_set(long jarg1, dht_get_peers_reply_alert jarg1_, long jarg2, sha1_hash jarg2_);
  public final static native long dht_get_peers_reply_alert_info_hash_get(long jarg1, dht_get_peers_reply_alert jarg1_);
  public final static native int dht_get_peers_reply_alert_num_peers(long jarg1, dht_get_peers_reply_alert jarg1_);
  public final static native long dht_get_peers_reply_alert_peers(long jarg1, dht_get_peers_reply_alert jarg1_);
  public final static native void delete_dht_get_peers_reply_alert(long jarg1);
  public final static native int dht_direct_response_alert_priority_get();
  public final static native int dht_direct_response_alert_alert_type_get();
  public final static native int dht_direct_response_alert_type(long jarg1, dht_direct_response_alert jarg1_);
  public final static native long dht_direct_response_alert_category(long jarg1, dht_direct_response_alert jarg1_);
  public final static native String dht_direct_response_alert_what(long jarg1, dht_direct_response_alert jarg1_);
  public final static native long dht_direct_response_alert_static_category_get();
  public final static native String dht_direct_response_alert_message(long jarg1, dht_direct_response_alert jarg1_);
  public final static native long dht_direct_response_alert_response(long jarg1, dht_direct_response_alert jarg1_);
  public final static native long dht_direct_response_alert_get_userdata(long jarg1, dht_direct_response_alert jarg1_);
  public final static native long dht_direct_response_alert_get_endpoint(long jarg1, dht_direct_response_alert jarg1_);
  public final static native void delete_dht_direct_response_alert(long jarg1);
  public final static native int picker_log_alert_priority_get();
  public final static native int picker_log_alert_alert_type_get();
  public final static native int picker_log_alert_type(long jarg1, picker_log_alert jarg1_);
  public final static native long picker_log_alert_category(long jarg1, picker_log_alert jarg1_);
  public final static native String picker_log_alert_what(long jarg1, picker_log_alert jarg1_);
  public final static native long picker_log_alert_static_category_get();
  public final static native String picker_log_alert_message(long jarg1, picker_log_alert jarg1_);
  public final static native long picker_log_alert_partial_ratio_get();
  public final static native long picker_log_alert_prioritize_partials_get();
  public final static native long picker_log_alert_rarest_first_partials_get();
  public final static native long picker_log_alert_rarest_first_get();
  public final static native long picker_log_alert_reverse_rarest_first_get();
  public final static native long picker_log_alert_suggested_pieces_get();
  public final static native long picker_log_alert_prio_sequential_pieces_get();
  public final static native long picker_log_alert_sequential_pieces_get();
  public final static native long picker_log_alert_reverse_pieces_get();
  public final static native long picker_log_alert_time_critical_get();
  public final static native long picker_log_alert_random_pieces_get();
  public final static native long picker_log_alert_prefer_contiguous_get();
  public final static native long picker_log_alert_reverse_sequential_get();
  public final static native long picker_log_alert_backup1_get();
  public final static native long picker_log_alert_backup2_get();
  public final static native long picker_log_alert_end_game_get();
  public final static native long picker_log_alert_extent_affinity_get();
  public final static native long picker_log_alert_picker_flags_get(long jarg1, picker_log_alert jarg1_);
  public final static native void delete_picker_log_alert(long jarg1);
  public final static native int session_error_alert_priority_get();
  public final static native int session_error_alert_alert_type_get();
  public final static native int session_error_alert_type(long jarg1, session_error_alert jarg1_);
  public final static native long session_error_alert_category(long jarg1, session_error_alert jarg1_);
  public final static native String session_error_alert_what(long jarg1, session_error_alert jarg1_);
  public final static native long session_error_alert_static_category_get();
  public final static native String session_error_alert_message(long jarg1, session_error_alert jarg1_);
  public final static native long session_error_alert_error_get(long jarg1, session_error_alert jarg1_);
  public final static native void delete_session_error_alert(long jarg1);
  public final static native int dht_live_nodes_alert_priority_get();
  public final static native int dht_live_nodes_alert_alert_type_get();
  public final static native int dht_live_nodes_alert_type(long jarg1, dht_live_nodes_alert jarg1_);
  public final static native long dht_live_nodes_alert_category(long jarg1, dht_live_nodes_alert jarg1_);
  public final static native String dht_live_nodes_alert_what(long jarg1, dht_live_nodes_alert jarg1_);
  public final static native long dht_live_nodes_alert_static_category_get();
  public final static native String dht_live_nodes_alert_message(long jarg1, dht_live_nodes_alert jarg1_);
  public final static native void dht_live_nodes_alert_node_id_set(long jarg1, dht_live_nodes_alert jarg1_, long jarg2, sha1_hash jarg2_);
  public final static native long dht_live_nodes_alert_node_id_get(long jarg1, dht_live_nodes_alert jarg1_);
  public final static native int dht_live_nodes_alert_num_nodes(long jarg1, dht_live_nodes_alert jarg1_);
  public final static native long dht_live_nodes_alert_nodes(long jarg1, dht_live_nodes_alert jarg1_);
  public final static native void delete_dht_live_nodes_alert(long jarg1);
  public final static native int session_stats_header_alert_priority_get();
  public final static native int session_stats_header_alert_alert_type_get();
  public final static native int session_stats_header_alert_type(long jarg1, session_stats_header_alert jarg1_);
  public final static native long session_stats_header_alert_category(long jarg1, session_stats_header_alert jarg1_);
  public final static native String session_stats_header_alert_what(long jarg1, session_stats_header_alert jarg1_);
  public final static native long session_stats_header_alert_static_category_get();
  public final static native String session_stats_header_alert_message(long jarg1, session_stats_header_alert jarg1_);
  public final static native void delete_session_stats_header_alert(long jarg1);
  public final static native long dht_sample_infohashes_alert_static_category_get();
  public final static native int dht_sample_infohashes_alert_priority_get();
  public final static native int dht_sample_infohashes_alert_alert_type_get();
  public final static native int dht_sample_infohashes_alert_type(long jarg1, dht_sample_infohashes_alert jarg1_);
  public final static native long dht_sample_infohashes_alert_category(long jarg1, dht_sample_infohashes_alert jarg1_);
  public final static native String dht_sample_infohashes_alert_what(long jarg1, dht_sample_infohashes_alert jarg1_);
  public final static native String dht_sample_infohashes_alert_message(long jarg1, dht_sample_infohashes_alert jarg1_);
  public final static native void dht_sample_infohashes_alert_node_id_set(long jarg1, dht_sample_infohashes_alert jarg1_, long jarg2, sha1_hash jarg2_);
  public final static native long dht_sample_infohashes_alert_node_id_get(long jarg1, dht_sample_infohashes_alert jarg1_);
  public final static native int dht_sample_infohashes_alert_num_infohashes_get(long jarg1, dht_sample_infohashes_alert jarg1_);
  public final static native int dht_sample_infohashes_alert_num_samples(long jarg1, dht_sample_infohashes_alert jarg1_);
  public final static native long dht_sample_infohashes_alert_samples(long jarg1, dht_sample_infohashes_alert jarg1_);
  public final static native int dht_sample_infohashes_alert_num_nodes(long jarg1, dht_sample_infohashes_alert jarg1_);
  public final static native long dht_sample_infohashes_alert_nodes(long jarg1, dht_sample_infohashes_alert jarg1_);
  public final static native long dht_sample_infohashes_alert_get_endpoint(long jarg1, dht_sample_infohashes_alert jarg1_);
  public final static native long dht_sample_infohashes_alert_get_interval(long jarg1, dht_sample_infohashes_alert jarg1_);
  public final static native void delete_dht_sample_infohashes_alert(long jarg1);
  public final static native int block_uploaded_alert_priority_get();
  public final static native int block_uploaded_alert_alert_type_get();
  public final static native int block_uploaded_alert_type(long jarg1, block_uploaded_alert jarg1_);
  public final static native long block_uploaded_alert_category(long jarg1, block_uploaded_alert jarg1_);
  public final static native String block_uploaded_alert_what(long jarg1, block_uploaded_alert jarg1_);
  public final static native long block_uploaded_alert_static_category_get();
  public final static native String block_uploaded_alert_message(long jarg1, block_uploaded_alert jarg1_);
  public final static native int block_uploaded_alert_block_index_get(long jarg1, block_uploaded_alert jarg1_);
  public final static native int block_uploaded_alert_piece_index_get(long jarg1, block_uploaded_alert jarg1_);
  public final static native void delete_block_uploaded_alert(long jarg1);
  public final static native int alerts_dropped_alert_priority_get();
  public final static native int alerts_dropped_alert_alert_type_get();
  public final static native int alerts_dropped_alert_type(long jarg1, alerts_dropped_alert jarg1_);
  public final static native long alerts_dropped_alert_category(long jarg1, alerts_dropped_alert jarg1_);
  public final static native String alerts_dropped_alert_what(long jarg1, alerts_dropped_alert jarg1_);
  public final static native long alerts_dropped_alert_static_category_get();
  public final static native String alerts_dropped_alert_message(long jarg1, alerts_dropped_alert jarg1_);
  public final static native void alerts_dropped_alert_dropped_alerts_set(long jarg1, alerts_dropped_alert jarg1_, long jarg2, bitset_128 jarg2_);
  public final static native long alerts_dropped_alert_dropped_alerts_get(long jarg1, alerts_dropped_alert jarg1_);
  public final static native void delete_alerts_dropped_alert(long jarg1);
  public final static native int socks5_alert_priority_get();
  public final static native int socks5_alert_alert_type_get();
  public final static native int socks5_alert_type(long jarg1, socks5_alert jarg1_);
  public final static native long socks5_alert_category(long jarg1, socks5_alert jarg1_);
  public final static native String socks5_alert_what(long jarg1, socks5_alert jarg1_);
  public final static native long socks5_alert_static_category_get();
  public final static native String socks5_alert_message(long jarg1, socks5_alert jarg1_);
  public final static native void socks5_alert_error_set(long jarg1, socks5_alert jarg1_, long jarg2, error_code jarg2_);
  public final static native long socks5_alert_error_get(long jarg1, socks5_alert jarg1_);
  public final static native void socks5_alert_op_set(long jarg1, socks5_alert jarg1_, int jarg2);
  public final static native int socks5_alert_op_get(long jarg1, socks5_alert jarg1_);
  public final static native void delete_socks5_alert(long jarg1);
  public final static native int file_prio_alert_priority_get();
  public final static native int file_prio_alert_alert_type_get();
  public final static native int file_prio_alert_type(long jarg1, file_prio_alert jarg1_);
  public final static native long file_prio_alert_category(long jarg1, file_prio_alert jarg1_);
  public final static native String file_prio_alert_what(long jarg1, file_prio_alert jarg1_);
  public final static native long file_prio_alert_static_category_get();
  public final static native String file_prio_alert_message(long jarg1, file_prio_alert jarg1_);
  public final static native void file_prio_alert_error_set(long jarg1, file_prio_alert jarg1_, long jarg2, error_code jarg2_);
  public final static native long file_prio_alert_error_get(long jarg1, file_prio_alert jarg1_);
  public final static native void file_prio_alert_op_set(long jarg1, file_prio_alert jarg1_, int jarg2);
  public final static native int file_prio_alert_op_get(long jarg1, file_prio_alert jarg1_);
  public final static native void delete_file_prio_alert(long jarg1);
  public final static native int oversized_file_alert_priority_get();
  public final static native int oversized_file_alert_alert_type_get();
  public final static native int oversized_file_alert_type(long jarg1, oversized_file_alert jarg1_);
  public final static native long oversized_file_alert_category(long jarg1, oversized_file_alert jarg1_);
  public final static native String oversized_file_alert_what(long jarg1, oversized_file_alert jarg1_);
  public final static native long oversized_file_alert_static_category_get();
  public final static native String oversized_file_alert_message(long jarg1, oversized_file_alert jarg1_);
  public final static native void delete_oversized_file_alert(long jarg1);
  public final static native int torrent_conflict_alert_priority_get();
  public final static native int torrent_conflict_alert_alert_type_get();
  public final static native int torrent_conflict_alert_type(long jarg1, torrent_conflict_alert jarg1_);
  public final static native long torrent_conflict_alert_category(long jarg1, torrent_conflict_alert jarg1_);
  public final static native String torrent_conflict_alert_what(long jarg1, torrent_conflict_alert jarg1_);
  public final static native long torrent_conflict_alert_static_category_get();
  public final static native String torrent_conflict_alert_message(long jarg1, torrent_conflict_alert jarg1_);
  public final static native void torrent_conflict_alert_conflicting_torrent_set(long jarg1, torrent_conflict_alert jarg1_, long jarg2, torrent_handle jarg2_);
  public final static native long torrent_conflict_alert_conflicting_torrent_get(long jarg1, torrent_conflict_alert jarg1_);
  public final static native long torrent_conflict_alert_get_metadata(long jarg1, torrent_conflict_alert jarg1_);
  public final static native void delete_torrent_conflict_alert(long jarg1);
  public final static native int peer_info_alert_priority_get();
  public final static native int peer_info_alert_alert_type_get();
  public final static native int peer_info_alert_type(long jarg1, peer_info_alert jarg1_);
  public final static native long peer_info_alert_category(long jarg1, peer_info_alert jarg1_);
  public final static native String peer_info_alert_what(long jarg1, peer_info_alert jarg1_);
  public final static native long peer_info_alert_static_category_get();
  public final static native String peer_info_alert_message(long jarg1, peer_info_alert jarg1_);
  public final static native void peer_info_alert_peer_info_set(long jarg1, peer_info_alert jarg1_, long jarg2, peer_info_vector jarg2_);
  public final static native long peer_info_alert_peer_info_get(long jarg1, peer_info_alert jarg1_);
  public final static native void delete_peer_info_alert(long jarg1);
  public final static native int file_progress_alert_priority_get();
  public final static native int file_progress_alert_alert_type_get();
  public final static native int file_progress_alert_type(long jarg1, file_progress_alert jarg1_);
  public final static native long file_progress_alert_category(long jarg1, file_progress_alert jarg1_);
  public final static native String file_progress_alert_what(long jarg1, file_progress_alert jarg1_);
  public final static native long file_progress_alert_static_category_get();
  public final static native String file_progress_alert_message(long jarg1, file_progress_alert jarg1_);
  public final static native void delete_file_progress_alert(long jarg1);
  public final static native int piece_info_alert_priority_get();
  public final static native int piece_info_alert_alert_type_get();
  public final static native int piece_info_alert_type(long jarg1, piece_info_alert jarg1_);
  public final static native long piece_info_alert_category(long jarg1, piece_info_alert jarg1_);
  public final static native String piece_info_alert_what(long jarg1, piece_info_alert jarg1_);
  public final static native long piece_info_alert_static_category_get();
  public final static native String piece_info_alert_message(long jarg1, piece_info_alert jarg1_);
  public final static native void piece_info_alert_piece_info_set(long jarg1, piece_info_alert jarg1_, long jarg2, partial_piece_info_vector jarg2_);
  public final static native long piece_info_alert_piece_info_get(long jarg1, piece_info_alert jarg1_);
  public final static native void piece_info_alert_block_data_set(long jarg1, piece_info_alert jarg1_, long jarg2, block_info_vector jarg2_);
  public final static native long piece_info_alert_block_data_get(long jarg1, piece_info_alert jarg1_);
  public final static native void delete_piece_info_alert(long jarg1);
  public final static native int piece_availability_alert_priority_get();
  public final static native int piece_availability_alert_alert_type_get();
  public final static native int piece_availability_alert_type(long jarg1, piece_availability_alert jarg1_);
  public final static native long piece_availability_alert_category(long jarg1, piece_availability_alert jarg1_);
  public final static native String piece_availability_alert_what(long jarg1, piece_availability_alert jarg1_);
  public final static native long piece_availability_alert_static_category_get();
  public final static native String piece_availability_alert_message(long jarg1, piece_availability_alert jarg1_);
  public final static native void piece_availability_alert_piece_availability_set(long jarg1, piece_availability_alert jarg1_, long jarg2, int_vector jarg2_);
  public final static native long piece_availability_alert_piece_availability_get(long jarg1, piece_availability_alert jarg1_);
  public final static native void delete_piece_availability_alert(long jarg1);
  public final static native int tracker_list_alert_priority_get();
  public final static native int tracker_list_alert_alert_type_get();
  public final static native int tracker_list_alert_type(long jarg1, tracker_list_alert jarg1_);
  public final static native long tracker_list_alert_category(long jarg1, tracker_list_alert jarg1_);
  public final static native String tracker_list_alert_what(long jarg1, tracker_list_alert jarg1_);
  public final static native long tracker_list_alert_static_category_get();
  public final static native String tracker_list_alert_message(long jarg1, tracker_list_alert jarg1_);
  public final static native void tracker_list_alert_trackers_set(long jarg1, tracker_list_alert jarg1_, long jarg2, announce_entry_vector jarg2_);
  public final static native long tracker_list_alert_trackers_get(long jarg1, tracker_list_alert jarg1_);
  public final static native void delete_tracker_list_alert(long jarg1);
  public final static native long new_alert_category_t();
  public final static native long alert_category_t_all();
  public final static native boolean alert_category_t_non_zero(long jarg1, alert_category_t jarg1_);
  public final static native boolean alert_category_t_nonZero(long jarg1, alert_category_t jarg1_);
  public final static native boolean alert_category_t_eq(long jarg1, alert_category_t jarg1_, long jarg2, alert_category_t jarg2_);
  public final static native boolean alert_category_t_ne(long jarg1, alert_category_t jarg1_, long jarg2, alert_category_t jarg2_);
  public final static native long alert_category_t_or_(long jarg1, alert_category_t jarg1_, long jarg2, alert_category_t jarg2_);
  public final static native long alert_category_t_and_(long jarg1, alert_category_t jarg1_, long jarg2, alert_category_t jarg2_);
  public final static native long alert_category_t_xor_(long jarg1, alert_category_t jarg1_, long jarg2, alert_category_t jarg2_);
  public final static native long alert_category_t_inv(long jarg1, alert_category_t jarg1_);
  public final static native int alert_category_t_to_int(long jarg1, alert_category_t jarg1_);
  public final static native long alert_category_t_from_int(int jarg1);
  public final static native void delete_alert_category_t(long jarg1);
  public final static native String name_for_setting(int jarg1);
  public final static native long default_settings();
  public final static native void settings_interface_set_str(long jarg1, settings_interface jarg1_, int jarg2, String jarg3);
  public final static native void settings_interface_set_int(long jarg1, settings_interface jarg1_, int jarg2, int jarg3);
  public final static native void settings_interface_set_bool(long jarg1, settings_interface jarg1_, int jarg2, boolean jarg3);
  public final static native boolean settings_interface_has_val(long jarg1, settings_interface jarg1_, int jarg2);
  public final static native String settings_interface_get_str(long jarg1, settings_interface jarg1_, int jarg2);
  public final static native int settings_interface_get_int(long jarg1, settings_interface jarg1_, int jarg2);
  public final static native boolean settings_interface_get_bool(long jarg1, settings_interface jarg1_, int jarg2);
  public final static native long new_settings_pack__SWIG_0();
  public final static native long new_settings_pack__SWIG_1(long jarg1, settings_pack jarg1_);
  public final static native void settings_pack_set_str(long jarg1, settings_pack jarg1_, int jarg2, String jarg3);
  public final static native void settings_pack_set_int(long jarg1, settings_pack jarg1_, int jarg2, int jarg3);
  public final static native void settings_pack_set_bool(long jarg1, settings_pack jarg1_, int jarg2, boolean jarg3);
  public final static native boolean settings_pack_has_val(long jarg1, settings_pack jarg1_, int jarg2);
  public final static native void settings_pack_clear__SWIG_0(long jarg1, settings_pack jarg1_);
  public final static native void settings_pack_clear__SWIG_1(long jarg1, settings_pack jarg1_, int jarg2);
  public final static native String settings_pack_get_str(long jarg1, settings_pack jarg1_, int jarg2);
  public final static native int settings_pack_get_int(long jarg1, settings_pack jarg1_, int jarg2);
  public final static native boolean settings_pack_get_bool(long jarg1, settings_pack jarg1_, int jarg2);
  public final static native int settings_pack_string_type_base_get();
  public final static native int settings_pack_int_type_base_get();
  public final static native int settings_pack_bool_type_base_get();
  public final static native int settings_pack_type_mask_get();
  public final static native int settings_pack_index_mask_get();
  public final static native int settings_pack_user_agent_get();
  public final static native int settings_pack_handshake_client_version_get();
  public final static native int settings_pack_allow_multiple_connections_per_ip_get();
  public final static native int settings_pack_send_redundant_have_get();
  public final static native int settings_pack_use_dht_as_fallback_get();
  public final static native int settings_pack_auto_manage_prefer_seeds_get();
  public final static native int settings_pack_disable_hash_checks_get();
  public final static native int settings_pack_no_atime_storage_get();
  public final static native int settings_pack_enable_outgoing_utp_get();
  public final static native int settings_pack_no_recheck_incomplete_resume_get();
  public final static native int settings_pack_seeding_outgoing_connections_get();
  public final static native int settings_pack_ban_web_seeds_get();
  public final static native int settings_pack_support_share_mode_get();
  public final static native int settings_pack_report_redundant_bytes_get();
  public final static native int settings_pack_announce_crypto_support_get();
  public final static native int settings_pack_tracker_completion_timeout_get();
  public final static native int settings_pack_disk_io_write_mode_get();
  public final static native int settings_pack_active_downloads_get();
  public final static native int settings_pack_auto_manage_interval_get();
  public final static native int settings_pack_optimistic_disk_retry_get();
  public final static native int settings_pack_num_optimistic_unchoke_slots_get();
  public final static native int settings_pack_max_pex_peers_get();
  public final static native int settings_pack_dht_upload_rate_limit_get();
  public final static native int settings_pack_connections_limit_get();
  public final static native int settings_pack_utp_loss_multiplier_get();
  public final static native int settings_pack_tracker_backoff_get();
  public final static native int settings_pack_urlseed_max_request_bytes_get();
  public final static native int settings_pack_num_string_settings_get();
  public final static native int settings_pack_num_bool_settings_get();
  public final static native int settings_pack_num_int_settings_get();
  public final static native int settings_pack_always_pwrite_get();
  public final static native int settings_pack_no_piece_suggestions_get();
  public final static native int settings_pack_suggest_read_cache_get();
  public final static native int settings_pack_fixed_slots_choker_get();
  public final static native int settings_pack_rate_based_choker_get();
  public final static native int settings_pack_enable_os_cache_get();
  public final static native int settings_pack_disable_os_cache_get();
  public final static native int settings_pack_write_through_get();
  public final static native int settings_pack_prefer_tcp_get();
  public final static native int settings_pack_peer_proportional_get();
  public final static native int settings_pack_pe_plaintext_get();
  public final static native int settings_pack_pe_rc4_get();
  public final static native int settings_pack_pe_both_get();
  public final static native long settings_pack_get_bytes(long jarg1, settings_pack jarg1_, int jarg2);
  public final static native void settings_pack_set_bytes(long jarg1, settings_pack jarg1_, int jarg2, long jarg3, byte_vector jarg3_);
  public final static native void delete_settings_pack(long jarg1);
  public final static native void peer_class_info_ignore_unchoke_slots_set(long jarg1, peer_class_info jarg1_, boolean jarg2);
  public final static native boolean peer_class_info_ignore_unchoke_slots_get(long jarg1, peer_class_info jarg1_);
  public final static native void peer_class_info_connection_limit_factor_set(long jarg1, peer_class_info jarg1_, int jarg2);
  public final static native int peer_class_info_connection_limit_factor_get(long jarg1, peer_class_info jarg1_);
  public final static native void peer_class_info_label_set(long jarg1, peer_class_info jarg1_, String jarg2);
  public final static native String peer_class_info_label_get(long jarg1, peer_class_info jarg1_);
  public final static native void peer_class_info_upload_limit_set(long jarg1, peer_class_info jarg1_, int jarg2);
  public final static native int peer_class_info_upload_limit_get(long jarg1, peer_class_info jarg1_);
  public final static native void peer_class_info_download_limit_set(long jarg1, peer_class_info jarg1_, int jarg2);
  public final static native int peer_class_info_download_limit_get(long jarg1, peer_class_info jarg1_);
  public final static native void peer_class_info_upload_priority_set(long jarg1, peer_class_info jarg1_, int jarg2);
  public final static native int peer_class_info_upload_priority_get(long jarg1, peer_class_info jarg1_);
  public final static native void peer_class_info_download_priority_set(long jarg1, peer_class_info jarg1_, int jarg2);
  public final static native int peer_class_info_download_priority_get(long jarg1, peer_class_info jarg1_);
  public final static native long new_peer_class_info();
  public final static native void delete_peer_class_info(long jarg1);
  public final static native long new_peer_class_type_filter();
  public final static native int peer_class_type_filter_tcp_socket_get();
  public final static native long peer_class_type_filter_apply(long jarg1, peer_class_type_filter jarg1_, int jarg2, long jarg3);
  public final static native void delete_peer_class_type_filter(long jarg1);
  public final static native long new_ip_filter__SWIG_0();
  public final static native long new_ip_filter__SWIG_1(long jarg1, ip_filter jarg1_);
  public final static native int ip_filter_blocked_get();
  public final static native boolean ip_filter_empty(long jarg1, ip_filter jarg1_);
  public final static native void ip_filter_add_rule(long jarg1, ip_filter jarg1_, long jarg2, address jarg2_, long jarg3, address jarg3_, long jarg4);
  public final static native long ip_filter_access(long jarg1, ip_filter jarg1_, long jarg2, address jarg2_);
  public final static native void delete_ip_filter(long jarg1);
  public final static native long new_port_filter__SWIG_0();
  public final static native long new_port_filter__SWIG_1(long jarg1, port_filter jarg1_);
  public final static native void delete_port_filter(long jarg1);
  public final static native int port_filter_blocked_get();
  public final static native void port_filter_add_rule(long jarg1, port_filter jarg1_, int jarg2, int jarg3, long jarg4);
  public final static native long port_filter_access(long jarg1, port_filter jarg1_, int jarg2);
  public final static native long new_remove_flags_t();
  public final static native long remove_flags_t_all();
  public final static native boolean remove_flags_t_non_zero(long jarg1, remove_flags_t jarg1_);
  public final static native boolean remove_flags_t_nonZero(long jarg1, remove_flags_t jarg1_);
  public final static native boolean remove_flags_t_eq(long jarg1, remove_flags_t jarg1_, long jarg2, remove_flags_t jarg2_);
  public final static native boolean remove_flags_t_ne(long jarg1, remove_flags_t jarg1_, long jarg2, remove_flags_t jarg2_);
  public final static native long remove_flags_t_or_(long jarg1, remove_flags_t jarg1_, long jarg2, remove_flags_t jarg2_);
  public final static native long remove_flags_t_and_(long jarg1, remove_flags_t jarg1_, long jarg2, remove_flags_t jarg2_);
  public final static native long remove_flags_t_xor_(long jarg1, remove_flags_t jarg1_, long jarg2, remove_flags_t jarg2_);
  public final static native long remove_flags_t_inv(long jarg1, remove_flags_t jarg1_);
  public final static native int remove_flags_t_to_int(long jarg1, remove_flags_t jarg1_);
  public final static native long remove_flags_t_from_int(int jarg1);
  public final static native void delete_remove_flags_t(long jarg1);
  public final static native long new_save_state_flags_t();
  public final static native long save_state_flags_t_all();
  public final static native boolean save_state_flags_t_non_zero(long jarg1, save_state_flags_t jarg1_);
  public final static native boolean save_state_flags_t_nonZero(long jarg1, save_state_flags_t jarg1_);
  public final static native boolean save_state_flags_t_eq(long jarg1, save_state_flags_t jarg1_, long jarg2, save_state_flags_t jarg2_);
  public final static native boolean save_state_flags_t_ne(long jarg1, save_state_flags_t jarg1_, long jarg2, save_state_flags_t jarg2_);
  public final static native long save_state_flags_t_or_(long jarg1, save_state_flags_t jarg1_, long jarg2, save_state_flags_t jarg2_);
  public final static native long save_state_flags_t_and_(long jarg1, save_state_flags_t jarg1_, long jarg2, save_state_flags_t jarg2_);
  public final static native long save_state_flags_t_xor_(long jarg1, save_state_flags_t jarg1_, long jarg2, save_state_flags_t jarg2_);
  public final static native long save_state_flags_t_inv(long jarg1, save_state_flags_t jarg1_);
  public final static native int save_state_flags_t_to_int(long jarg1, save_state_flags_t jarg1_);
  public final static native long save_state_flags_t_from_int(int jarg1);
  public final static native void delete_save_state_flags_t(long jarg1);
  public final static native long new_session_flags_t();
  public final static native long session_flags_t_all();
  public final static native boolean session_flags_t_non_zero(long jarg1, session_flags_t jarg1_);
  public final static native boolean session_flags_t_nonZero(long jarg1, session_flags_t jarg1_);
  public final static native boolean session_flags_t_eq(long jarg1, session_flags_t jarg1_, long jarg2, session_flags_t jarg2_);
  public final static native boolean session_flags_t_ne(long jarg1, session_flags_t jarg1_, long jarg2, session_flags_t jarg2_);
  public final static native long session_flags_t_or_(long jarg1, session_flags_t jarg1_, long jarg2, session_flags_t jarg2_);
  public final static native long session_flags_t_and_(long jarg1, session_flags_t jarg1_, long jarg2, session_flags_t jarg2_);
  public final static native long session_flags_t_xor_(long jarg1, session_flags_t jarg1_, long jarg2, session_flags_t jarg2_);
  public final static native long session_flags_t_inv(long jarg1, session_flags_t jarg1_);
  public final static native int session_flags_t_to_int(long jarg1, session_flags_t jarg1_);
  public final static native long session_flags_t_from_int(int jarg1);
  public final static native void delete_session_flags_t(long jarg1);
  public final static native long new_reopen_network_flags_t();
  public final static native long reopen_network_flags_t_all();
  public final static native boolean reopen_network_flags_t_non_zero(long jarg1, reopen_network_flags_t jarg1_);
  public final static native boolean reopen_network_flags_t_nonZero(long jarg1, reopen_network_flags_t jarg1_);
  public final static native boolean reopen_network_flags_t_eq(long jarg1, reopen_network_flags_t jarg1_, long jarg2, reopen_network_flags_t jarg2_);
  public final static native boolean reopen_network_flags_t_ne(long jarg1, reopen_network_flags_t jarg1_, long jarg2, reopen_network_flags_t jarg2_);
  public final static native long reopen_network_flags_t_or_(long jarg1, reopen_network_flags_t jarg1_, long jarg2, reopen_network_flags_t jarg2_);
  public final static native long reopen_network_flags_t_and_(long jarg1, reopen_network_flags_t jarg1_, long jarg2, reopen_network_flags_t jarg2_);
  public final static native long reopen_network_flags_t_xor_(long jarg1, reopen_network_flags_t jarg1_, long jarg2, reopen_network_flags_t jarg2_);
  public final static native long reopen_network_flags_t_inv(long jarg1, reopen_network_flags_t jarg1_);
  public final static native int reopen_network_flags_t_to_int(long jarg1, reopen_network_flags_t jarg1_);
  public final static native long reopen_network_flags_t_from_int(int jarg1);
  public final static native void delete_reopen_network_flags_t(long jarg1);
  public final static native long new_session_params__SWIG_0(long jarg1, settings_pack jarg1_);
  public final static native long new_session_params__SWIG_1();
  public final static native void delete_session_params(long jarg1);
  public final static native long new_session_params__SWIG_2(long jarg1, session_params jarg1_);
  public final static native void session_params_settings_set(long jarg1, session_params jarg1_, long jarg2, settings_pack jarg2_);
  public final static native long session_params_settings_get(long jarg1, session_params jarg1_);
  public final static native void session_params_dht_state_set(long jarg1, session_params jarg1_, long jarg2, dht_state jarg2_);
  public final static native long session_params_dht_state_get(long jarg1, session_params jarg1_);
  public final static native void session_params_ext_state_set(long jarg1, session_params jarg1_, long jarg2, string_string_map jarg2_);
  public final static native long session_params_ext_state_get(long jarg1, session_params jarg1_);
  public final static native void session_params_ip_filter_set(long jarg1, session_params jarg1_, long jarg2, ip_filter jarg2_);
  public final static native long session_params_ip_filter_get(long jarg1, session_params jarg1_);
  public final static native long session_params_read_session_params__SWIG_0(long jarg1, bdecode_node jarg1_, long jarg2, save_state_flags_t jarg2_);
  public final static native long session_params_read_session_params__SWIG_1(long jarg1, bdecode_node jarg1_);
  public final static native long session_params_write_session_params__SWIG_0(long jarg1, session_params jarg1_, long jarg2, save_state_flags_t jarg2_);
  public final static native long session_params_write_session_params__SWIG_1(long jarg1, session_params jarg1_);
  public final static native long session_params_write_session_params_buf__SWIG_0(long jarg1, session_params jarg1_, long jarg2, save_state_flags_t jarg2_);
  public final static native long session_params_write_session_params_buf__SWIG_1(long jarg1, session_params jarg1_);
  public final static native void session_params_set_posix_disk_io_constructor(long jarg1, session_params jarg1_);
  public final static native void session_params_set_default_disk_io_constructor(long jarg1, session_params jarg1_);
  public final static native long new_session_handle__SWIG_0();
  public final static native long new_session_handle__SWIG_1(long jarg1, session_handle jarg1_);
  public final static native boolean session_handle_is_valid(long jarg1, session_handle jarg1_);
  public final static native long session_handle_save_settings_get();
  public final static native long session_handle_save_dht_state_get();
  public final static native long session_handle_save_extension_state_get();
  public final static native long session_handle_save_ip_filter_get();
  public final static native long session_handle_session_state__SWIG_0(long jarg1, session_handle jarg1_, long jarg2, save_state_flags_t jarg2_);
  public final static native long session_handle_session_state__SWIG_1(long jarg1, session_handle jarg1_);
  public final static native void session_handle_refresh_torrent_status__SWIG_0(long jarg1, session_handle jarg1_, long jarg2, torrent_status_vector jarg2_, long jarg3, status_flags_t jarg3_);
  public final static native void session_handle_refresh_torrent_status__SWIG_1(long jarg1, session_handle jarg1_, long jarg2, torrent_status_vector jarg2_);
  public final static native void session_handle_post_torrent_updates__SWIG_0(long jarg1, session_handle jarg1_, long jarg2, status_flags_t jarg2_);
  public final static native void session_handle_post_torrent_updates__SWIG_1(long jarg1, session_handle jarg1_);
  public final static native void session_handle_post_session_stats(long jarg1, session_handle jarg1_);
  public final static native void session_handle_post_dht_stats(long jarg1, session_handle jarg1_);
  public final static native void session_handle_set_dht_state__SWIG_0(long jarg1, session_handle jarg1_, long jarg2, dht_state jarg2_);
  public final static native long session_handle_find_torrent__SWIG_0(long jarg1, session_handle jarg1_, long jarg2, sha1_hash jarg2_);
  public final static native long session_handle_find_torrent__SWIG_1(long jarg1, session_handle jarg1_, long jarg2, sha256_hash jarg2_);
  public final static native long session_handle_get_torrents(long jarg1, session_handle jarg1_);
  public final static native long session_handle_add_torrent(long jarg1, session_handle jarg1_, long jarg2, add_torrent_params jarg2_, long jarg3, error_code jarg3_);
  public final static native void session_handle_async_add_torrent(long jarg1, session_handle jarg1_, long jarg2, add_torrent_params jarg2_);
  public final static native void session_handle_pause(long jarg1, session_handle jarg1_);
  public final static native void session_handle_resume(long jarg1, session_handle jarg1_);
  public final static native boolean session_handle_is_paused(long jarg1, session_handle jarg1_);
  public final static native boolean session_handle_is_dht_running(long jarg1, session_handle jarg1_);
  public final static native void session_handle_add_dht_node(long jarg1, session_handle jarg1_, long jarg2, string_int_pair jarg2_);
  public final static native void session_handle_dht_get_item__SWIG_0(long jarg1, session_handle jarg1_, long jarg2, sha1_hash jarg2_);
  public final static native long session_handle_dht_put_item__SWIG_0(long jarg1, session_handle jarg1_, long jarg2, entry jarg2_);
  public final static native void session_handle_dht_get_peers(long jarg1, session_handle jarg1_, long jarg2, sha1_hash jarg2_);
  public final static native void session_handle_dht_live_nodes(long jarg1, session_handle jarg1_, long jarg2, sha1_hash jarg2_);
  public final static native void session_handle_dht_sample_infohashes(long jarg1, session_handle jarg1_, long jarg2, udp_endpoint jarg2_, long jarg3, sha1_hash jarg3_);
  public final static native void session_handle_dht_direct_request__SWIG_0(long jarg1, session_handle jarg1_, long jarg2, udp_endpoint jarg2_, long jarg3, entry jarg3_, long jarg4, client_data_t jarg4_);
  public final static native void session_handle_dht_direct_request__SWIG_1(long jarg1, session_handle jarg1_, long jarg2, udp_endpoint jarg2_, long jarg3, entry jarg3_);
  public final static native void session_handle_set_ip_filter(long jarg1, session_handle jarg1_, long jarg2, ip_filter jarg2_);
  public final static native long session_handle_get_ip_filter(long jarg1, session_handle jarg1_);
  public final static native void session_handle_set_port_filter(long jarg1, session_handle jarg1_, long jarg2, port_filter jarg2_);
  public final static native int session_handle_listen_port(long jarg1, session_handle jarg1_);
  public final static native int session_handle_ssl_listen_port(long jarg1, session_handle jarg1_);
  public final static native boolean session_handle_is_listening(long jarg1, session_handle jarg1_);
  public final static native void session_handle_set_peer_class_filter(long jarg1, session_handle jarg1_, long jarg2, ip_filter jarg2_);
  public final static native long session_handle_get_peer_class_filter(long jarg1, session_handle jarg1_);
  public final static native void session_handle_set_peer_class_type_filter(long jarg1, session_handle jarg1_, long jarg2, peer_class_type_filter jarg2_);
  public final static native long session_handle_get_peer_class_type_filter(long jarg1, session_handle jarg1_);
  public final static native long session_handle_delete_files_get();
  public final static native long session_handle_delete_partfile_get();
  public final static native long session_handle_paused_get();
  public final static native void session_handle_remove_torrent__SWIG_0(long jarg1, session_handle jarg1_, long jarg2, torrent_handle jarg2_, long jarg3, remove_flags_t jarg3_);
  public final static native void session_handle_remove_torrent__SWIG_1(long jarg1, session_handle jarg1_, long jarg2, torrent_handle jarg2_);
  public final static native void session_handle_apply_settings(long jarg1, session_handle jarg1_, long jarg2, settings_pack jarg2_);
  public final static native long session_handle_get_settings(long jarg1, session_handle jarg1_);
  public final static native void session_handle_pop_alerts(long jarg1, session_handle jarg1_, long jarg2, alert_ptr_vector jarg2_);
  public final static native int session_handle_udp_get();
  public final static native int session_handle_tcp_get();
  public final static native long session_handle_reopen_map_ports_get();
  public final static native void session_handle_reopen_network_sockets__SWIG_0(long jarg1, session_handle jarg1_, long jarg2, reopen_network_flags_t jarg2_);
  public final static native void session_handle_reopen_network_sockets__SWIG_1(long jarg1, session_handle jarg1_);
  public final static native void session_handle_dht_get_item__SWIG_1(long jarg1, session_handle jarg1_, long jarg2, byte_vector jarg2_, long jarg3, byte_vector jarg3_);
  public final static native void session_handle_dht_get_item__SWIG_2(long jarg1, session_handle jarg1_, long jarg2, byte_array_32 jarg2_, long jarg3, byte_vector jarg3_);
  public final static native void session_handle_dht_put_item__SWIG_1(long jarg1, session_handle jarg1_, long jarg2, byte_vector jarg2_, long jarg3, byte_vector jarg3_, long jarg4, entry jarg4_, long jarg5, byte_vector jarg5_);
  public final static native void session_handle_dht_put_item__SWIG_2(long jarg1, session_handle jarg1_, long jarg2, byte_array_32 jarg2_, long jarg3, byte_array_64 jarg3_, long jarg4, entry jarg4_, long jarg5, byte_vector jarg5_);
  public final static native void session_handle_dht_direct_request__SWIG_2(long jarg1, session_handle jarg1_, long jarg2, udp_endpoint jarg2_, long jarg3, entry jarg3_, long jarg4);
  public final static native long session_handle_wait_for_alert_ms(long jarg1, session_handle jarg1_, long jarg2);
  public final static native void session_handle_set_alert_notify_callback(long jarg1, session_handle jarg1_, long jarg2, alert_notify_callback jarg2_);
  public final static native void session_handle_dht_announce_ex__SWIG_0(long jarg1, session_handle jarg1_, long jarg2, sha1_hash jarg2_, int jarg3, byte jarg4);
  public final static native void session_handle_dht_announce_ex__SWIG_1(long jarg1, session_handle jarg1_, long jarg2, sha1_hash jarg2_, int jarg3);
  public final static native void session_handle_dht_announce_ex__SWIG_2(long jarg1, session_handle jarg1_, long jarg2, sha1_hash jarg2_);
  public final static native long session_handle_add_port_mapping_ex(long jarg1, session_handle jarg1_, int jarg2, int jarg3, int jarg4);
  public final static native void session_handle_delete_port_mapping_ex(long jarg1, session_handle jarg1_, int jarg2);
  public final static native void delete_session_handle(long jarg1);
  public final static native long min_memory_usage();
  public final static native long high_performance_seed();
  public final static native long new_session_proxy__SWIG_0();
  public final static native void delete_session_proxy(long jarg1);
  public final static native long new_session_proxy__SWIG_1(long jarg1, session_proxy jarg1_);
  public final static native long new_session__SWIG_0(long jarg1, session_params jarg1_);
  public final static native long new_session__SWIG_1(long jarg1, session_params jarg1_, long jarg2, session_flags_t jarg2_);
  public final static native long new_session__SWIG_2();
  public final static native long new_session__SWIG_3(long jarg1, session jarg1_);
  public final static native void delete_session(long jarg1);
  public final static native long session_abort(long jarg1, session jarg1_);
  public final static native long create_torrent_modification_time_get();
  public final static native long create_torrent_symlinks_get();
  public final static native long create_torrent_v2_only_get();
  public final static native long create_torrent_v1_only_get();
  public final static native long create_torrent_canonical_files_get();
  public final static native long create_torrent_no_attributes_get();
  public final static native long create_torrent_canonical_files_no_tail_padding_get();
  public final static native long create_torrent_allow_odd_piece_size_get();
  public final static native long new_create_torrent__SWIG_0(long jarg1, file_storage jarg1_, int jarg2, long jarg3, create_flags_t jarg3_);
  public final static native long new_create_torrent__SWIG_1(long jarg1, file_storage jarg1_, int jarg2);
  public final static native long new_create_torrent__SWIG_2(long jarg1, file_storage jarg1_);
  public final static native long new_create_torrent__SWIG_3(long jarg1, torrent_info jarg1_);
  public final static native void delete_create_torrent(long jarg1);
  public final static native long create_torrent_generate(long jarg1, create_torrent jarg1_);
  public final static native long create_torrent_files(long jarg1, create_torrent jarg1_);
  public final static native void create_torrent_set_comment(long jarg1, create_torrent jarg1_, String jarg2);
  public final static native void create_torrent_set_creator(long jarg1, create_torrent jarg1_, String jarg2);
  public final static native void create_torrent_set_creation_date(long jarg1, create_torrent jarg1_, long jarg2);
  public final static native void create_torrent_set_hash(long jarg1, create_torrent jarg1_, int jarg2, long jarg3, sha1_hash jarg3_);
  public final static native void create_torrent_add_node(long jarg1, create_torrent jarg1_, long jarg2, string_int_pair jarg2_);
  public final static native void create_torrent_set_priv(long jarg1, create_torrent jarg1_, boolean jarg2);
  public final static native boolean create_torrent_priv(long jarg1, create_torrent jarg1_);
  public final static native boolean create_torrent_is_v2_only(long jarg1, create_torrent jarg1_);
  public final static native boolean create_torrent_is_v1_only(long jarg1, create_torrent jarg1_);
  public final static native int create_torrent_num_pieces(long jarg1, create_torrent jarg1_);
  public final static native int create_torrent_end_piece(long jarg1, create_torrent jarg1_);
  public final static native int create_torrent_end_file(long jarg1, create_torrent jarg1_);
  public final static native long create_torrent_total_size(long jarg1, create_torrent jarg1_);
  public final static native int create_torrent_piece_length(long jarg1, create_torrent jarg1_);
  public final static native int create_torrent_piece_size(long jarg1, create_torrent jarg1_, int jarg2);
  public final static native void create_torrent_add_similar_torrent(long jarg1, create_torrent jarg1_, long jarg2, sha1_hash jarg2_);
  public final static native void create_torrent_add_url_seed(long jarg1, create_torrent jarg1_, String jarg2);
  public final static native void create_torrent_add_http_seed(long jarg1, create_torrent jarg1_, String jarg2);
  public final static native void create_torrent_add_tracker__SWIG_0(long jarg1, create_torrent jarg1_, String jarg2);
  public final static native void create_torrent_add_tracker__SWIG_1(long jarg1, create_torrent jarg1_, String jarg2, int jarg3);
  public final static native void create_torrent_add_collection(long jarg1, create_torrent jarg1_, String jarg2);
  public final static native void create_torrent_set_root_cert2(long jarg1, create_torrent jarg1_, long jarg2, byte_vector jarg2_);
  public final static native void create_torrent_set_hash2(long jarg1, create_torrent jarg1_, int jarg2, int jarg3, long jarg4, sha256_hash jarg4_);
  public final static native void add_files__SWIG_0(long jarg1, file_storage jarg1_, String jarg2, long jarg3, create_flags_t jarg3_);
  public final static native void add_files__SWIG_1(long jarg1, file_storage jarg1_, String jarg2);
  public final static native void stats_metric_value_index_set(long jarg1, stats_metric jarg1_, int jarg2);
  public final static native int stats_metric_value_index_get(long jarg1, stats_metric jarg1_);
  public final static native void stats_metric_type_set(long jarg1, stats_metric jarg1_, int jarg2);
  public final static native int stats_metric_type_get(long jarg1, stats_metric jarg1_);
  public final static native String stats_metric_get_name(long jarg1, stats_metric jarg1_);
  public final static native long new_stats_metric();
  public final static native void delete_stats_metric(long jarg1);
  public final static native long session_stats_metrics();
  public final static native int LIBTORRENT_VERSION_MAJOR_get();
  public final static native int LIBTORRENT_VERSION_MINOR_get();
  public final static native int LIBTORRENT_VERSION_TINY_get();
  public final static native int LIBTORRENT_VERSION_NUM_get();
  public final static native String LIBTORRENT_VERSION_get();
  public final static native String LIBTORRENT_REVISION_get();
  public final static native String version();
  public final static native String make_magnet_uri__SWIG_0(long jarg1, add_torrent_params jarg1_);
  public final static native String make_magnet_uri__SWIG_1(long jarg1, torrent_handle jarg1_);
  public final static native String make_magnet_uri__SWIG_2(long jarg1, torrent_info jarg1_);
  public final static native String generate_fingerprint__SWIG_0(String jarg1, int jarg2, int jarg3, int jarg4, int jarg5);
  public final static native String generate_fingerprint__SWIG_1(String jarg1, int jarg2, int jarg3, int jarg4);
  public final static native String generate_fingerprint__SWIG_2(String jarg1, int jarg2, int jarg3);
  public final static native String generate_fingerprint__SWIG_3(String jarg1, int jarg2);
  public final static native long read_resume_data__SWIG_0(long jarg1, bdecode_node jarg1_, long jarg2, error_code jarg2_, int jarg3);
  public final static native long read_resume_data__SWIG_1(long jarg1, bdecode_node jarg1_, long jarg2, error_code jarg2_);
  public final static native long write_resume_data(long jarg1, add_torrent_params jarg1_);
  public final static native long allow_missing_piece_layer_get();
  public final static native long no_http_seeds_get();
  public final static native long include_dht_nodes_get();
  public final static native long write_torrent_file__SWIG_0(long jarg1, add_torrent_params jarg1_);
  public final static native long write_torrent_file__SWIG_1(long jarg1, add_torrent_params jarg1_, long jarg2, write_torrent_flags_t jarg2_);
  public final static native boolean bloom_filter_128_find(long jarg1, bloom_filter_128 jarg1_, long jarg2, sha1_hash jarg2_);
  public final static native void bloom_filter_128_set(long jarg1, bloom_filter_128 jarg1_, long jarg2, sha1_hash jarg2_);
  public final static native void bloom_filter_128_clear(long jarg1, bloom_filter_128 jarg1_);
  public final static native float bloom_filter_128_size(long jarg1, bloom_filter_128 jarg1_);
  public final static native long new_bloom_filter_128();
  public final static native long bloom_filter_128_to_bytes(long jarg1, bloom_filter_128 jarg1_);
  public final static native void bloom_filter_128_from_bytes(long jarg1, bloom_filter_128 jarg1_, long jarg2, byte_vector jarg2_);
  public final static native void delete_bloom_filter_128(long jarg1);
  public final static native boolean bloom_filter_256_find(long jarg1, bloom_filter_256 jarg1_, long jarg2, sha1_hash jarg2_);
  public final static native void bloom_filter_256_set(long jarg1, bloom_filter_256 jarg1_, long jarg2, sha1_hash jarg2_);
  public final static native void bloom_filter_256_clear(long jarg1, bloom_filter_256 jarg1_);
  public final static native float bloom_filter_256_size(long jarg1, bloom_filter_256 jarg1_);
  public final static native long new_bloom_filter_256();
  public final static native long bloom_filter_256_to_bytes(long jarg1, bloom_filter_256 jarg1_);
  public final static native void bloom_filter_256_from_bytes(long jarg1, bloom_filter_256 jarg1_, long jarg2, byte_vector jarg2_);
  public final static native void delete_bloom_filter_256(long jarg1);
  public final static native long new_peer_connection_handle(long jarg1);
  public final static native int peer_connection_handle_type(long jarg1, peer_connection_handle jarg1_);
  public final static native boolean peer_connection_handle_is_seed(long jarg1, peer_connection_handle jarg1_);
  public final static native boolean peer_connection_handle_upload_only(long jarg1, peer_connection_handle jarg1_);
  public final static native long peer_connection_handle_pid(long jarg1, peer_connection_handle jarg1_);
  public final static native boolean peer_connection_handle_has_piece(long jarg1, peer_connection_handle jarg1_, int jarg2);
  public final static native boolean peer_connection_handle_is_interesting(long jarg1, peer_connection_handle jarg1_);
  public final static native boolean peer_connection_handle_is_choked(long jarg1, peer_connection_handle jarg1_);
  public final static native boolean peer_connection_handle_is_peer_interested(long jarg1, peer_connection_handle jarg1_);
  public final static native boolean peer_connection_handle_has_peer_choked(long jarg1, peer_connection_handle jarg1_);
  public final static native void peer_connection_handle_choke_this_peer(long jarg1, peer_connection_handle jarg1_);
  public final static native void peer_connection_handle_maybe_unchoke_this_peer(long jarg1, peer_connection_handle jarg1_);
  public final static native void peer_connection_handle_get_peer_info(long jarg1, peer_connection_handle jarg1_, long jarg2, peer_info jarg2_);
  public final static native long peer_connection_handle_associated_torrent(long jarg1, peer_connection_handle jarg1_);
  public final static native long peer_connection_handle_remote(long jarg1, peer_connection_handle jarg1_);
  public final static native long peer_connection_handle_local_endpoint(long jarg1, peer_connection_handle jarg1_);
  public final static native void peer_connection_handle_disconnect__SWIG_0(long jarg1, peer_connection_handle jarg1_, long jarg2, error_code jarg2_, int jarg3, int jarg4);
  public final static native void peer_connection_handle_disconnect__SWIG_1(long jarg1, peer_connection_handle jarg1_, long jarg2, error_code jarg2_, int jarg3);
  public final static native boolean peer_connection_handle_is_disconnecting(long jarg1, peer_connection_handle jarg1_);
  public final static native boolean peer_connection_handle_is_connecting(long jarg1, peer_connection_handle jarg1_);
  public final static native boolean peer_connection_handle_is_outgoing(long jarg1, peer_connection_handle jarg1_);
  public final static native boolean peer_connection_handle_on_local_network(long jarg1, peer_connection_handle jarg1_);
  public final static native boolean peer_connection_handle_ignore_unchoke_slots(long jarg1, peer_connection_handle jarg1_);
  public final static native boolean peer_connection_handle_failed(long jarg1, peer_connection_handle jarg1_);
  public final static native boolean peer_connection_handle_can_disconnect(long jarg1, peer_connection_handle jarg1_, long jarg2, error_code jarg2_);
  public final static native boolean peer_connection_handle_has_metadata(long jarg1, peer_connection_handle jarg1_);
  public final static native boolean peer_connection_handle_in_handshake(long jarg1, peer_connection_handle jarg1_);
  public final static native void peer_connection_handle_send_buffer(long jarg1, peer_connection_handle jarg1_, String jarg2, int jarg3);
  public final static native long peer_connection_handle_last_seen_complete(long jarg1, peer_connection_handle jarg1_);
  public final static native boolean peer_connection_handle_op_eq(long jarg1, peer_connection_handle jarg1_, long jarg2, peer_connection_handle jarg2_);
  public final static native boolean peer_connection_handle_op_ne(long jarg1, peer_connection_handle jarg1_, long jarg2, peer_connection_handle jarg2_);
  public final static native boolean peer_connection_handle_op_lt(long jarg1, peer_connection_handle jarg1_, long jarg2, peer_connection_handle jarg2_);
  public final static native long peer_connection_handle_get_time_of_last_unchoke(long jarg1, peer_connection_handle jarg1_);
  public final static native void delete_peer_connection_handle(long jarg1);
  public final static native long new_bt_peer_connection_handle(long jarg1, peer_connection_handle jarg1_);
  public final static native boolean bt_peer_connection_handle_packet_finished(long jarg1, bt_peer_connection_handle jarg1_);
  public final static native boolean bt_peer_connection_handle_support_extensions(long jarg1, bt_peer_connection_handle jarg1_);
  public final static native boolean bt_peer_connection_handle_supports_encryption(long jarg1, bt_peer_connection_handle jarg1_);
  public final static native void delete_bt_peer_connection_handle(long jarg1);
  public final static native long string_view_to_bytes(long jarg1, string_view jarg1_);
  public final static native long new_string_view();
  public final static native void delete_string_view(long jarg1);
  public final static native long ed25519_create_seed();
  public final static native long ed25519_create_keypair(long jarg1, byte_vector jarg1_);
  public final static native long ed25519_sign(long jarg1, byte_vector jarg1_, long jarg2, byte_vector jarg2_, long jarg3, byte_vector jarg3_);
  public final static native boolean ed25519_verify(long jarg1, byte_vector jarg1_, long jarg2, byte_vector jarg2_, long jarg3, byte_vector jarg3_);
  public final static native long ed25519_add_scalar_public(long jarg1, byte_vector jarg1_, long jarg2, byte_vector jarg2_);
  public final static native long ed25519_add_scalar_secret(long jarg1, byte_vector jarg1_, long jarg2, byte_vector jarg2_);
  public final static native long ed25519_key_exchange(long jarg1, byte_vector jarg1_, long jarg2, byte_vector jarg2_);
  public final static native void delete_alert_notify_callback(long jarg1);
  public final static native void alert_notify_callback_on_alert(long jarg1, alert_notify_callback jarg1_);
  public final static native void alert_notify_callback_on_alertSwigExplicitalert_notify_callback(long jarg1, alert_notify_callback jarg1_);
  public final static native long new_alert_notify_callback();
  public final static native void alert_notify_callback_director_connect(alert_notify_callback obj, long cptr, boolean mem_own, boolean weak_global);
  public final static native void alert_notify_callback_change_ownership(alert_notify_callback obj, long cptr, boolean take_or_release);
  public final static native void delete_add_files_listener(long jarg1);
  public final static native boolean add_files_listener_pred(long jarg1, add_files_listener jarg1_, String jarg2);
  public final static native boolean add_files_listener_predSwigExplicitadd_files_listener(long jarg1, add_files_listener jarg1_, String jarg2);
  public final static native long new_add_files_listener();
  public final static native void add_files_listener_director_connect(add_files_listener obj, long cptr, boolean mem_own, boolean weak_global);
  public final static native void add_files_listener_change_ownership(add_files_listener obj, long cptr, boolean take_or_release);
  public final static native void add_files_ex(long jarg1, file_storage jarg1_, String jarg2, long jarg3, add_files_listener jarg3_, long jarg4, create_flags_t jarg4_);
  public final static native void delete_set_piece_hashes_listener(long jarg1);
  public final static native void set_piece_hashes_listener_progress(long jarg1, set_piece_hashes_listener jarg1_, int jarg2);
  public final static native void set_piece_hashes_listener_progressSwigExplicitset_piece_hashes_listener(long jarg1, set_piece_hashes_listener jarg1_, int jarg2);
  public final static native long new_set_piece_hashes_listener();
  public final static native void set_piece_hashes_listener_director_connect(set_piece_hashes_listener obj, long cptr, boolean mem_own, boolean weak_global);
  public final static native void set_piece_hashes_listener_change_ownership(set_piece_hashes_listener obj, long cptr, boolean take_or_release);
  public final static native void set_piece_hashes_ex(long jarg1, create_torrent jarg1_, String jarg2, long jarg3, set_piece_hashes_listener jarg3_, long jarg4, error_code jarg4_);
  public final static native void set_piece_hashes_posix_disk_io(long jarg1, create_torrent jarg1_, String jarg2, long jarg3, set_piece_hashes_listener jarg3_, long jarg4, error_code jarg4_);
  public final static native int boost_version();
  public final static native String boost_lib_version();
  public final static native int openssl_version_number();
  public final static native String openssl_version_text();
  public final static native int find_metric_idx_s(String jarg1);
  public final static native long read_resume_data_ex__SWIG_0(long jarg1, byte_vector jarg1_, long jarg2, error_code jarg2_, long jarg3, load_torrent_limits jarg3_);
  public final static native long read_resume_data_ex__SWIG_1(long jarg1, byte_vector jarg1_, long jarg2, error_code jarg2_);
  public final static native long write_resume_data_buf_ex(long jarg1, add_torrent_params jarg1_);
  public final static native long write_torrent_file_buf_ex(long jarg1, add_torrent_params jarg1_);
  public final static native long parse_magnet_uri(String jarg1, long jarg2, error_code jarg2_);
  public final static native void ip_interface_interface_address_set(long jarg1, ip_interface jarg1_, long jarg2, address jarg2_);
  public final static native long ip_interface_interface_address_get(long jarg1, ip_interface jarg1_);
  public final static native void ip_interface_netmask_set(long jarg1, ip_interface jarg1_, long jarg2, address jarg2_);
  public final static native long ip_interface_netmask_get(long jarg1, ip_interface jarg1_);
  public final static native void ip_interface_name_set(long jarg1, ip_interface jarg1_, long jarg2, byte_vector jarg2_);
  public final static native long ip_interface_name_get(long jarg1, ip_interface jarg1_);
  public final static native void ip_interface_friendly_name_set(long jarg1, ip_interface jarg1_, long jarg2, byte_vector jarg2_);
  public final static native long ip_interface_friendly_name_get(long jarg1, ip_interface jarg1_);
  public final static native void ip_interface_description_set(long jarg1, ip_interface jarg1_, long jarg2, byte_vector jarg2_);
  public final static native long ip_interface_description_get(long jarg1, ip_interface jarg1_);
  public final static native void ip_interface_preferred_set(long jarg1, ip_interface jarg1_, boolean jarg2);
  public final static native boolean ip_interface_preferred_get(long jarg1, ip_interface jarg1_);
  public final static native long new_ip_interface();
  public final static native void delete_ip_interface(long jarg1);
  public final static native void ip_route_destination_set(long jarg1, ip_route jarg1_, long jarg2, address jarg2_);
  public final static native long ip_route_destination_get(long jarg1, ip_route jarg1_);
  public final static native void ip_route_netmask_set(long jarg1, ip_route jarg1_, long jarg2, address jarg2_);
  public final static native long ip_route_netmask_get(long jarg1, ip_route jarg1_);
  public final static native void ip_route_gateway_set(long jarg1, ip_route jarg1_, long jarg2, address jarg2_);
  public final static native long ip_route_gateway_get(long jarg1, ip_route jarg1_);
  public final static native void ip_route_source_hint_set(long jarg1, ip_route jarg1_, long jarg2, address jarg2_);
  public final static native long ip_route_source_hint_get(long jarg1, ip_route jarg1_);
  public final static native void ip_route_name_set(long jarg1, ip_route jarg1_, long jarg2, byte_vector jarg2_);
  public final static native long ip_route_name_get(long jarg1, ip_route jarg1_);
  public final static native void ip_route_mtu_set(long jarg1, ip_route jarg1_, int jarg2);
  public final static native int ip_route_mtu_get(long jarg1, ip_route jarg1_);
  public final static native long new_ip_route();
  public final static native void delete_ip_route(long jarg1);
  public final static native long enum_net_interfaces(long jarg1, session jarg1_);
  public final static native long enum_routes(long jarg1, session jarg1_);
  public final static native void mem_copy(long jarg1, byte_vector jarg1_, String jarg2, long jarg3);
  public final static native void copy_byte_vector_to_char_array(long jarg1, byte_vector jarg1_, String jarg2, long jarg3);
  public final static native long get_gateway(long jarg1, ip_interface jarg1_, long jarg2, ip_route_vector jarg2_);
  public final static native String device_for_address(long jarg1, session jarg1_, long jarg2, address jarg2_, long jarg3, error_code jarg3_);
  public final static native void delete_list_files_listener(long jarg1);
  public final static native boolean list_files_listener_pred(long jarg1, list_files_listener jarg1_, String jarg2);
  public final static native long new_list_files_listener();
  public final static native boolean arm_neon_support();
  public final static native void posix_stat_t_size_set(long jarg1, posix_stat_t jarg1_, long jarg2);
  public final static native long posix_stat_t_size_get(long jarg1, posix_stat_t jarg1_);
  public final static native void posix_stat_t_atime_set(long jarg1, posix_stat_t jarg1_, long jarg2);
  public final static native long posix_stat_t_atime_get(long jarg1, posix_stat_t jarg1_);
  public final static native void posix_stat_t_mtime_set(long jarg1, posix_stat_t jarg1_, long jarg2);
  public final static native long posix_stat_t_mtime_get(long jarg1, posix_stat_t jarg1_);
  public final static native void posix_stat_t_ctime_set(long jarg1, posix_stat_t jarg1_, long jarg2);
  public final static native long posix_stat_t_ctime_get(long jarg1, posix_stat_t jarg1_);
  public final static native void posix_stat_t_mode_set(long jarg1, posix_stat_t jarg1_, int jarg2);
  public final static native int posix_stat_t_mode_get(long jarg1, posix_stat_t jarg1_);
  public final static native long new_posix_stat_t();
  public final static native void delete_posix_stat_t(long jarg1);
  public final static native void delete_posix_wrapper(long jarg1);
  public final static native int posix_wrapper_open(long jarg1, posix_wrapper jarg1_, String jarg2, int jarg3, int jarg4);
  public final static native int posix_wrapper_openSwigExplicitposix_wrapper(long jarg1, posix_wrapper jarg1_, String jarg2, int jarg3, int jarg4);
  public final static native int posix_wrapper_stat(long jarg1, posix_wrapper jarg1_, String jarg2, long jarg3, posix_stat_t jarg3_);
  public final static native int posix_wrapper_statSwigExplicitposix_wrapper(long jarg1, posix_wrapper jarg1_, String jarg2, long jarg3, posix_stat_t jarg3_);
  public final static native int posix_wrapper_mkdir(long jarg1, posix_wrapper jarg1_, String jarg2, int jarg3);
  public final static native int posix_wrapper_mkdirSwigExplicitposix_wrapper(long jarg1, posix_wrapper jarg1_, String jarg2, int jarg3);
  public final static native int posix_wrapper_rename(long jarg1, posix_wrapper jarg1_, String jarg2, String jarg3);
  public final static native int posix_wrapper_renameSwigExplicitposix_wrapper(long jarg1, posix_wrapper jarg1_, String jarg2, String jarg3);
  public final static native int posix_wrapper_remove(long jarg1, posix_wrapper jarg1_, String jarg2);
  public final static native int posix_wrapper_removeSwigExplicitposix_wrapper(long jarg1, posix_wrapper jarg1_, String jarg2);
  public final static native long new_posix_wrapper();
  public final static native void posix_wrapper_director_connect(posix_wrapper obj, long cptr, boolean mem_own, boolean weak_global);
  public final static native void posix_wrapper_change_ownership(posix_wrapper obj, long cptr, boolean take_or_release);
  public final static native void set_posix_wrapper(long jarg1, posix_wrapper jarg1_);
  public final static native long torrent_alert_SWIGUpcast(long jarg1);
  public final static native long peer_alert_SWIGUpcast(long jarg1);
  public final static native long tracker_alert_SWIGUpcast(long jarg1);
  public final static native long torrent_removed_alert_SWIGUpcast(long jarg1);
  public final static native long read_piece_alert_SWIGUpcast(long jarg1);
  public final static native long file_completed_alert_SWIGUpcast(long jarg1);
  public final static native long file_renamed_alert_SWIGUpcast(long jarg1);
  public final static native long file_rename_failed_alert_SWIGUpcast(long jarg1);
  public final static native long performance_alert_SWIGUpcast(long jarg1);
  public final static native long state_changed_alert_SWIGUpcast(long jarg1);
  public final static native long tracker_error_alert_SWIGUpcast(long jarg1);
  public final static native long tracker_warning_alert_SWIGUpcast(long jarg1);
  public final static native long scrape_reply_alert_SWIGUpcast(long jarg1);
  public final static native long scrape_failed_alert_SWIGUpcast(long jarg1);
  public final static native long tracker_reply_alert_SWIGUpcast(long jarg1);
  public final static native long dht_reply_alert_SWIGUpcast(long jarg1);
  public final static native long tracker_announce_alert_SWIGUpcast(long jarg1);
  public final static native long hash_failed_alert_SWIGUpcast(long jarg1);
  public final static native long peer_ban_alert_SWIGUpcast(long jarg1);
  public final static native long peer_unsnubbed_alert_SWIGUpcast(long jarg1);
  public final static native long peer_snubbed_alert_SWIGUpcast(long jarg1);
  public final static native long peer_error_alert_SWIGUpcast(long jarg1);
  public final static native long peer_connect_alert_SWIGUpcast(long jarg1);
  public final static native long peer_disconnected_alert_SWIGUpcast(long jarg1);
  public final static native long invalid_request_alert_SWIGUpcast(long jarg1);
  public final static native long torrent_finished_alert_SWIGUpcast(long jarg1);
  public final static native long piece_finished_alert_SWIGUpcast(long jarg1);
  public final static native long request_dropped_alert_SWIGUpcast(long jarg1);
  public final static native long block_timeout_alert_SWIGUpcast(long jarg1);
  public final static native long block_finished_alert_SWIGUpcast(long jarg1);
  public final static native long block_downloading_alert_SWIGUpcast(long jarg1);
  public final static native long unwanted_block_alert_SWIGUpcast(long jarg1);
  public final static native long storage_moved_alert_SWIGUpcast(long jarg1);
  public final static native long storage_moved_failed_alert_SWIGUpcast(long jarg1);
  public final static native long torrent_deleted_alert_SWIGUpcast(long jarg1);
  public final static native long torrent_delete_failed_alert_SWIGUpcast(long jarg1);
  public final static native long save_resume_data_alert_SWIGUpcast(long jarg1);
  public final static native long save_resume_data_failed_alert_SWIGUpcast(long jarg1);
  public final static native long torrent_paused_alert_SWIGUpcast(long jarg1);
  public final static native long torrent_resumed_alert_SWIGUpcast(long jarg1);
  public final static native long torrent_checked_alert_SWIGUpcast(long jarg1);
  public final static native long url_seed_alert_SWIGUpcast(long jarg1);
  public final static native long file_error_alert_SWIGUpcast(long jarg1);
  public final static native long metadata_failed_alert_SWIGUpcast(long jarg1);
  public final static native long metadata_received_alert_SWIGUpcast(long jarg1);
  public final static native long udp_error_alert_SWIGUpcast(long jarg1);
  public final static native long external_ip_alert_SWIGUpcast(long jarg1);
  public final static native long listen_failed_alert_SWIGUpcast(long jarg1);
  public final static native long listen_succeeded_alert_SWIGUpcast(long jarg1);
  public final static native long portmap_error_alert_SWIGUpcast(long jarg1);
  public final static native long portmap_alert_SWIGUpcast(long jarg1);
  public final static native long portmap_log_alert_SWIGUpcast(long jarg1);
  public final static native long fastresume_rejected_alert_SWIGUpcast(long jarg1);
  public final static native long peer_blocked_alert_SWIGUpcast(long jarg1);
  public final static native long dht_announce_alert_SWIGUpcast(long jarg1);
  public final static native long dht_get_peers_alert_SWIGUpcast(long jarg1);
  public final static native long cache_flushed_alert_SWIGUpcast(long jarg1);
  public final static native long lsd_peer_alert_SWIGUpcast(long jarg1);
  public final static native long trackerid_alert_SWIGUpcast(long jarg1);
  public final static native long dht_bootstrap_alert_SWIGUpcast(long jarg1);
  public final static native long torrent_error_alert_SWIGUpcast(long jarg1);
  public final static native long torrent_need_cert_alert_SWIGUpcast(long jarg1);
  public final static native long incoming_connection_alert_SWIGUpcast(long jarg1);
  public final static native long add_torrent_alert_SWIGUpcast(long jarg1);
  public final static native long state_update_alert_SWIGUpcast(long jarg1);
  public final static native long session_stats_alert_SWIGUpcast(long jarg1);
  public final static native long dht_error_alert_SWIGUpcast(long jarg1);
  public final static native long dht_immutable_item_alert_SWIGUpcast(long jarg1);
  public final static native long dht_mutable_item_alert_SWIGUpcast(long jarg1);
  public final static native long dht_put_alert_SWIGUpcast(long jarg1);
  public final static native long i2p_alert_SWIGUpcast(long jarg1);
  public final static native long dht_outgoing_get_peers_alert_SWIGUpcast(long jarg1);
  public final static native long log_alert_SWIGUpcast(long jarg1);
  public final static native long torrent_log_alert_SWIGUpcast(long jarg1);
  public final static native long peer_log_alert_SWIGUpcast(long jarg1);
  public final static native long lsd_error_alert_SWIGUpcast(long jarg1);
  public final static native long dht_stats_alert_SWIGUpcast(long jarg1);
  public final static native long incoming_request_alert_SWIGUpcast(long jarg1);
  public final static native long dht_log_alert_SWIGUpcast(long jarg1);
  public final static native long dht_pkt_alert_SWIGUpcast(long jarg1);
  public final static native long dht_get_peers_reply_alert_SWIGUpcast(long jarg1);
  public final static native long dht_direct_response_alert_SWIGUpcast(long jarg1);
  public final static native long picker_log_alert_SWIGUpcast(long jarg1);
  public final static native long session_error_alert_SWIGUpcast(long jarg1);
  public final static native long dht_live_nodes_alert_SWIGUpcast(long jarg1);
  public final static native long session_stats_header_alert_SWIGUpcast(long jarg1);
  public final static native long dht_sample_infohashes_alert_SWIGUpcast(long jarg1);
  public final static native long block_uploaded_alert_SWIGUpcast(long jarg1);
  public final static native long alerts_dropped_alert_SWIGUpcast(long jarg1);
  public final static native long socks5_alert_SWIGUpcast(long jarg1);
  public final static native long file_prio_alert_SWIGUpcast(long jarg1);
  public final static native long oversized_file_alert_SWIGUpcast(long jarg1);
  public final static native long torrent_conflict_alert_SWIGUpcast(long jarg1);
  public final static native long peer_info_alert_SWIGUpcast(long jarg1);
  public final static native long file_progress_alert_SWIGUpcast(long jarg1);
  public final static native long piece_info_alert_SWIGUpcast(long jarg1);
  public final static native long piece_availability_alert_SWIGUpcast(long jarg1);
  public final static native long tracker_list_alert_SWIGUpcast(long jarg1);
  public final static native long settings_pack_SWIGUpcast(long jarg1);
  public final static native long session_SWIGUpcast(long jarg1);
  public final static native long bt_peer_connection_handle_SWIGUpcast(long jarg1);

  public static void SwigDirector_alert_notify_callback_on_alert(alert_notify_callback jself) {
    jself.on_alert();
  }
  public static boolean SwigDirector_add_files_listener_pred(add_files_listener jself, String p) {
    return jself.pred(p);
  }
  public static void SwigDirector_set_piece_hashes_listener_progress(set_piece_hashes_listener jself, int i) {
    jself.progress(i);
  }
  public static int SwigDirector_posix_wrapper_open(posix_wrapper jself, String path, int flags, int mode) {
    return jself.open(path, flags, mode);
  }
  public static int SwigDirector_posix_wrapper_stat(posix_wrapper jself, String path, long buf) {
    return jself.stat(path, (buf == 0) ? null : new posix_stat_t(buf, false));
  }
  public static int SwigDirector_posix_wrapper_mkdir(posix_wrapper jself, String path, int mode) {
    return jself.mkdir(path, mode);
  }
  public static int SwigDirector_posix_wrapper_rename(posix_wrapper jself, String oldpath, String newpath) {
    return jself.rename(oldpath, newpath);
  }
  public static int SwigDirector_posix_wrapper_remove(posix_wrapper jself, String path) {
    return jself.remove(path);
  }

  private final static native void swig_module_init();
  static {
    swig_module_init();
  }
}
