/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.jlibtorrent;

import com.frostwire.jlibtorrent.TcpEndpoint;
import com.frostwire.jlibtorrent.Vectors;
import com.frostwire.jlibtorrent.swig.peer_info;

public class PeerInfo {
    protected String client;
    protected long totalDownload;
    protected long totalUpload;
    protected int flags;
    protected byte source;
    protected int upSpeed;
    protected int downSpeed;
    protected ConnectionType connectionType;
    protected float progress;
    protected int progressPpm;
    protected String ip;

    public PeerInfo(peer_info p) {
        this.init(p);
    }

    public String client() {
        return this.client;
    }

    public long totalDownload() {
        return this.totalDownload;
    }

    public long totalUpload() {
        return this.totalUpload;
    }

    public int flags() {
        return this.flags;
    }

    public byte source() {
        return this.source;
    }

    public int upSpeed() {
        return this.upSpeed;
    }

    public int downSpeed() {
        return this.downSpeed;
    }

    public ConnectionType connectionType() {
        return this.connectionType;
    }

    public float progress() {
        return this.progress;
    }

    public int progressPpm() {
        return this.progressPpm;
    }

    public String ip() {
        return this.ip;
    }

    protected void init(peer_info p) {
        this.client = Vectors.byte_vector2utf8(p.get_client());
        this.totalDownload = p.getTotal_download();
        this.totalUpload = p.getTotal_upload();
        this.flags = p.get_flags();
        this.source = p.get_source();
        this.upSpeed = p.getUp_speed();
        this.downSpeed = p.getDown_speed();
        this.connectionType = ConnectionType.fromSwig(p.getConnection_type().to_int());
        this.progress = p.getProgress();
        this.progressPpm = p.getProgress_ppm();
        this.ip = new TcpEndpoint(p.getIp()).toString();
    }

    public static enum ConnectionType {
        STANDARD_BITTORRENT(peer_info.standard_bittorrent.to_int()),
        WEB_SEED(peer_info.web_seed.to_int()),
        HTTP_SEED(peer_info.http_seed.to_int()),
        UNKNOWN(-1);

        private final int swigValue;

        private ConnectionType(int swigValue) {
            this.swigValue = swigValue;
        }

        public int swig() {
            return this.swigValue;
        }

        public static ConnectionType fromSwig(int swigValue) {
            ConnectionType[] enumValues;
            for (ConnectionType ev : enumValues = (ConnectionType[])ConnectionType.class.getEnumConstants()) {
                if (ev.swig() != swigValue) continue;
                return ev;
            }
            return UNKNOWN;
        }
    }
}

