/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.jlibtorrent;

import com.frostwire.jlibtorrent.Entry;
import com.frostwire.jlibtorrent.Pair;
import com.frostwire.jlibtorrent.Sha1Hash;
import com.frostwire.jlibtorrent.swig.add_files_listener;
import com.frostwire.jlibtorrent.swig.create_flags_t;
import com.frostwire.jlibtorrent.swig.create_torrent;
import com.frostwire.jlibtorrent.swig.error_code;
import com.frostwire.jlibtorrent.swig.file_storage;
import com.frostwire.jlibtorrent.swig.libtorrent;
import com.frostwire.jlibtorrent.swig.set_piece_hashes_listener;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public final class TorrentBuilder {
    private File path;
    private int pieceSize = 0;
    private create_flags_t flags = new create_flags_t();
    private int alignment = -1;
    private String comment;
    private String creator;
    private Long creationDate;
    private final List<String> urlSeeds = new LinkedList<String>();
    private final List<Pair<String, Integer>> nodes = new LinkedList<Pair<String, Integer>>();
    private final List<Pair<String, Integer>> trackers = new LinkedList<Pair<String, Integer>>();
    private boolean priv;
    private final List<Sha1Hash> similarTorrents = new LinkedList<Sha1Hash>();
    private final List<String> collections = new LinkedList<String>();
    private Listener listener;
    public static final create_flags_t MODIFICATION_TIME = create_torrent.modification_time;
    public static final create_flags_t SYMLINKS = create_torrent.symlinks;
    public static final create_flags_t V2_ONLY = create_torrent.v2_only;
    public static final create_flags_t V1_ONLY = create_torrent.v1_only;
    public static final create_flags_t CANONICAL_FILES = create_torrent.canonical_files;

    public File path() {
        return this.path;
    }

    public TorrentBuilder path(File value) {
        this.path = value;
        return this;
    }

    public int pieceSize() {
        return this.pieceSize;
    }

    public TorrentBuilder pieceSize(int value) {
        this.pieceSize = value;
        return this;
    }

    public create_flags_t flags() {
        return this.flags;
    }

    public TorrentBuilder flags(create_flags_t value) {
        this.flags = value;
        return this;
    }

    public int alignment() {
        return this.alignment;
    }

    public TorrentBuilder alignment(int value) {
        this.alignment = value;
        return this;
    }

    public String comment() {
        return this.comment;
    }

    public TorrentBuilder comment(String value) {
        this.comment = value;
        return this;
    }

    public String creator() {
        return this.creator;
    }

    public TorrentBuilder creator(String value) {
        this.creator = value;
        return this;
    }

    public long creationDate() {
        return this.creationDate;
    }

    public TorrentBuilder creationDate(long timestamp) {
        this.creationDate = timestamp;
        return this;
    }

    public List<String> urlSeeds() {
        return this.urlSeeds;
    }

    public TorrentBuilder addUrlSeeds(List<String> value) {
        if (value != null) {
            this.urlSeeds.addAll(value);
        }
        return this;
    }

    public TorrentBuilder addUrlSeed(String value) {
        if (value != null) {
            this.urlSeeds.add(value);
        }
        return this;
    }

    public List<Pair<String, Integer>> nodes() {
        return this.nodes;
    }

    public TorrentBuilder addNodes(List<Pair<String, Integer>> value) {
        if (value != null) {
            this.nodes.addAll(value);
        }
        return this;
    }

    public TorrentBuilder addNode(Pair<String, Integer> value) {
        if (value != null) {
            this.nodes.add(value);
        }
        return this;
    }

    public List<Pair<String, Integer>> trackers() {
        return this.trackers;
    }

    public TorrentBuilder addTrackers(List<Pair<String, Integer>> value) {
        if (value != null) {
            this.trackers.addAll(value);
        }
        return this;
    }

    public TorrentBuilder addTracker(Pair<String, Integer> value) {
        if (value != null) {
            this.trackers.add(value);
        }
        return this;
    }

    public TorrentBuilder addTracker(String url, int tier) {
        return this.addTracker(new Pair<String, Integer>(url, tier));
    }

    public TorrentBuilder addTracker(String url) {
        return this.addTracker(url, 0);
    }

    public boolean isPrivate() {
        return this.priv;
    }

    public TorrentBuilder setPrivate(boolean value) {
        this.priv = value;
        return this;
    }

    public List<Sha1Hash> similarTorrents() {
        return this.similarTorrents;
    }

    public TorrentBuilder addSimilarTorrents(List<Sha1Hash> value) {
        if (value != null) {
            this.similarTorrents.addAll(value);
        }
        return this;
    }

    public TorrentBuilder addSimilarTorrent(Sha1Hash value) {
        if (value != null) {
            this.similarTorrents.add(value);
        }
        return this;
    }

    public List<String> collections() {
        return this.collections;
    }

    public TorrentBuilder addCollections(List<String> value) {
        if (value != null) {
            this.collections.addAll(value);
        }
        return this;
    }

    public TorrentBuilder addCollection(String value) {
        if (value != null) {
            this.collections.add(value);
        }
        return this;
    }

    public Listener listener() {
        return this.listener;
    }

    public TorrentBuilder listener(Listener value) {
        this.listener = value;
        return this;
    }

    public Result generate() throws IOException {
        if (this.path == null) {
            throw new IOException("path can't be null");
        }
        File absPath = this.path.getAbsoluteFile();
        file_storage fs = new file_storage();
        add_files_listener l1 = new add_files_listener(){

            @Override
            public boolean pred(String p) {
                return TorrentBuilder.this.listener == null || TorrentBuilder.this.listener.accept(p);
            }
        };
        libtorrent.add_files_ex(fs, absPath.getPath(), l1, this.flags);
        if (fs.total_size() == 0L) {
            throw new IOException("content total size can't be 0");
        }
        create_torrent t = new create_torrent(fs, this.pieceSize, this.flags);
        final int numPieces = t.num_pieces();
        set_piece_hashes_listener l2 = new set_piece_hashes_listener(){

            @Override
            public void progress(int i) {
                if (TorrentBuilder.this.listener != null) {
                    TorrentBuilder.this.listener.progress(i, numPieces);
                }
            }
        };
        File parent = absPath.getParentFile();
        if (parent == null) {
            throw new IOException("path's parent can't be null");
        }
        error_code ec = new error_code();
        libtorrent.set_piece_hashes_ex(t, parent.getAbsolutePath(), l2, ec);
        if (ec.value() != 0) {
            throw new IOException(ec.message());
        }
        if (this.comment != null) {
            t.set_comment(this.comment);
        }
        if (this.creator != null) {
            t.set_creator(this.creator);
        }
        for (String string : this.urlSeeds) {
            t.add_url_seed(string);
        }
        for (Pair pair : this.nodes) {
            t.add_node(pair.to_string_int_pair());
        }
        for (Pair pair : this.trackers) {
            t.add_tracker((String)pair.first, (Integer)pair.second);
        }
        if (this.priv) {
            t.set_priv(true);
        }
        if (!this.similarTorrents.isEmpty()) {
            for (Sha1Hash sha1Hash : this.similarTorrents) {
                t.add_similar_torrent(sha1Hash.swig());
            }
        }
        if (!this.collections.isEmpty()) {
            for (String string : this.collections) {
                t.add_collection(string);
            }
        }
        return new Result(t);
    }

    public static interface Listener {
        public boolean accept(String var1);

        public void progress(int var1, int var2);
    }

    public static final class Result {
        private final create_torrent t;
        private final Entry entry;

        private Result(create_torrent t) {
            this.t = t;
            this.entry = new Entry(t.generate());
        }

        public Entry entry() {
            return this.entry;
        }

        public int numPieces() {
            return this.t.num_pieces();
        }

        public int pieceLength() {
            return this.t.piece_length();
        }

        public int pieceSize(int index) {
            return this.t.piece_size(index);
        }
    }
}

