/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.jlibtorrent;

import com.frostwire.jlibtorrent.Address;
import com.frostwire.jlibtorrent.AlertListener;
import com.frostwire.jlibtorrent.AlertMulticaster;
import com.frostwire.jlibtorrent.Entry;
import com.frostwire.jlibtorrent.Files;
import com.frostwire.jlibtorrent.Logger;
import com.frostwire.jlibtorrent.Priority;
import com.frostwire.jlibtorrent.SessionHandle;
import com.frostwire.jlibtorrent.SessionParams;
import com.frostwire.jlibtorrent.SessionStats;
import com.frostwire.jlibtorrent.SettingsPack;
import com.frostwire.jlibtorrent.Sha1Hash;
import com.frostwire.jlibtorrent.TcpEndpoint;
import com.frostwire.jlibtorrent.TorrentFlags;
import com.frostwire.jlibtorrent.TorrentHandle;
import com.frostwire.jlibtorrent.TorrentInfo;
import com.frostwire.jlibtorrent.Vectors;
import com.frostwire.jlibtorrent.alerts.AddTorrentAlert;
import com.frostwire.jlibtorrent.alerts.Alert;
import com.frostwire.jlibtorrent.alerts.AlertType;
import com.frostwire.jlibtorrent.alerts.Alerts;
import com.frostwire.jlibtorrent.alerts.DhtGetPeersReplyAlert;
import com.frostwire.jlibtorrent.alerts.DhtImmutableItemAlert;
import com.frostwire.jlibtorrent.alerts.DhtMutableItemAlert;
import com.frostwire.jlibtorrent.alerts.ExternalIpAlert;
import com.frostwire.jlibtorrent.alerts.ListenFailedAlert;
import com.frostwire.jlibtorrent.alerts.ListenSucceededAlert;
import com.frostwire.jlibtorrent.alerts.SaveResumeDataAlert;
import com.frostwire.jlibtorrent.alerts.SessionStatsAlert;
import com.frostwire.jlibtorrent.alerts.SocketType;
import com.frostwire.jlibtorrent.alerts.TorrentAlert;
import com.frostwire.jlibtorrent.swig.add_torrent_params;
import com.frostwire.jlibtorrent.swig.address;
import com.frostwire.jlibtorrent.swig.alert;
import com.frostwire.jlibtorrent.swig.alert_category_t;
import com.frostwire.jlibtorrent.swig.alert_ptr_vector;
import com.frostwire.jlibtorrent.swig.byte_vector;
import com.frostwire.jlibtorrent.swig.dht_get_peers_reply_alert;
import com.frostwire.jlibtorrent.swig.dht_immutable_item_alert;
import com.frostwire.jlibtorrent.swig.dht_mutable_item_alert;
import com.frostwire.jlibtorrent.swig.entry;
import com.frostwire.jlibtorrent.swig.error_code;
import com.frostwire.jlibtorrent.swig.external_ip_alert;
import com.frostwire.jlibtorrent.swig.info_hash_t;
import com.frostwire.jlibtorrent.swig.libtorrent;
import com.frostwire.jlibtorrent.swig.port_filter;
import com.frostwire.jlibtorrent.swig.remove_flags_t;
import com.frostwire.jlibtorrent.swig.session;
import com.frostwire.jlibtorrent.swig.session_params;
import com.frostwire.jlibtorrent.swig.settings_pack;
import com.frostwire.jlibtorrent.swig.sha1_hash;
import com.frostwire.jlibtorrent.swig.tcp_endpoint_vector;
import com.frostwire.jlibtorrent.swig.torrent_alert;
import com.frostwire.jlibtorrent.swig.torrent_flags_t;
import com.frostwire.jlibtorrent.swig.torrent_handle;
import com.frostwire.jlibtorrent.swig.torrent_handle_vector;
import com.frostwire.jlibtorrent.swig.torrent_info;
import com.frostwire.jlibtorrent.swig.torrent_status;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;

public class SessionManager {
    private static final Logger LOG = Logger.getLogger(SessionManager.class);
    private static final long REQUEST_STATS_RESOLUTION_MILLIS = 1000L;
    private static final long ALERTS_LOOP_WAIT_MILLIS = 500L;
    private static final int[] METADATA_ALERT_TYPES = new int[]{AlertType.METADATA_RECEIVED.swig(), AlertType.METADATA_FAILED.swig(), AlertType.SAVE_RESUME_DATA.swig(), AlertType.SAVE_RESUME_DATA_FAILED.swig()};
    private static final String FETCH_MAGNET_DOWNLOAD_KEY = "fetch_magnet___";
    private static final int[] DHT_IMMUTABLE_ITEM_TYPES = new int[]{AlertType.DHT_IMMUTABLE_ITEM.swig()};
    private static final int[] DHT_MUTABLE_ITEM_TYPES = new int[]{AlertType.DHT_MUTABLE_ITEM.swig()};
    private static final int[] DHT_GET_PEERS_REPLY_ALERT_TYPES = new int[]{AlertType.DHT_GET_PEERS_REPLY.swig()};
    private final boolean logging;
    private final AlertListener[] listeners;
    private final ReentrantLock sync;
    private final ReentrantLock syncMagnet;
    private volatile session session;
    private final SessionStats stats;
    private long lastStatsRequestTime;
    private boolean firewalled;
    private final Map<String, String> listenEndpoints;
    private String externalAddress;
    private int externalPort;
    private Thread alertsLoop;
    private Throwable lastAlertError;

    public SessionManager(boolean logging) {
        this.logging = logging;
        this.listeners = new AlertListener[Alerts.NUM_ALERT_TYPES + 1];
        this.sync = new ReentrantLock();
        this.syncMagnet = new ReentrantLock();
        this.stats = new SessionStats();
        this.listenEndpoints = new HashMap<String, String>();
        this.resetState();
    }

    public SessionManager() {
        this(false);
    }

    public session swig() {
        return this.session;
    }

    public void addListener(AlertListener listener) {
        this.modifyListeners(true, listener);
    }

    public void removeListener(AlertListener listener) {
        this.modifyListeners(false, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(SessionParams params) {
        if (this.session != null) {
            return;
        }
        this.sync.lock();
        try {
            if (this.session != null) {
                return;
            }
            this.onBeforeStart();
            this.resetState();
            SettingsPack sp = params.getSettings();
            sp.setInteger(settings_pack.int_types.alert_mask.swigValue(), SessionManager.alertMask(this.logging).to_int());
            if (!sp.hasValue(settings_pack.int_types.max_metadata_size.swigValue())) {
                sp.setMaxMetadataSize(0x200000);
            }
            if (!sp.hasValue(settings_pack.string_types.dht_bootstrap_nodes.swigValue())) {
                sp.setDhtBootstrapNodes(SessionManager.defaultDHTBootstrapNodes());
            }
            this.session = new session(params.swig());
            this.alertsLoop();
            port_filter f = new port_filter();
            f.add_rule(0, 79, 1L);
            f.add_rule(81, 442, 1L);
            f.add_rule(444, 1023, 1L);
            this.session.set_port_filter(f);
            this.onAfterStart();
        }
        finally {
            this.sync.unlock();
        }
    }

    public void start() {
        this.start(new SessionParams());
    }

    public void stop() {
        if (this.session == null) {
            return;
        }
        this.sync.lock();
        try {
            if (this.session == null) {
                return;
            }
            this.onBeforeStop();
            session s = this.session;
            this.session = null;
            s.post_session_stats();
            try {
                Thread.sleep(750L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.alertsLoop != null) {
                try {
                    this.alertsLoop.join();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.resetState();
            s.delete();
            this.onAfterStop();
        }
        finally {
            this.sync.unlock();
        }
    }

    public void restart() {
        this.sync.lock();
        try {
            session_params params = this.session.session_state();
            this.stop();
            Thread.sleep(1000L);
            this.start(new SessionParams(params));
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.sync.unlock();
        }
    }

    public boolean isRunning() {
        return this.session != null;
    }

    public void pause() {
        if (this.session != null && !this.session.is_paused()) {
            this.session.pause();
        }
    }

    public void resume() {
        if (this.session != null) {
            this.session.resume();
        }
    }

    public boolean isPaused() {
        return this.session != null ? this.session.is_paused() : false;
    }

    public SessionStats stats() {
        return this.stats;
    }

    public long downloadRate() {
        return this.stats.downloadRate();
    }

    public long uploadRate() {
        return this.stats.uploadRate();
    }

    public long totalDownload() {
        return this.stats.totalDownload();
    }

    public long totalUpload() {
        return this.stats.totalUpload();
    }

    public long dhtNodes() {
        return this.stats.dhtNodes();
    }

    public boolean isFirewalled() {
        return this.firewalled;
    }

    public String externalAddress() {
        return this.externalAddress;
    }

    public List<String> listenEndpoints() {
        return new ArrayList<String>(this.listenEndpoints.values());
    }

    public SettingsPack settings() {
        return this.session != null ? new SettingsPack(this.session.get_settings()) : null;
    }

    public void applySettings(SettingsPack sp) {
        if (this.session != null) {
            if (sp == null) {
                throw new IllegalArgumentException("settings pack can't be null");
            }
            this.session.apply_settings(sp.swig());
            this.onApplySettings(sp);
        }
    }

    public int downloadRateLimit() {
        if (this.session == null) {
            return 0;
        }
        return this.settings().downloadRateLimit();
    }

    public void downloadRateLimit(int limit) {
        if (this.session == null) {
            return;
        }
        this.applySettings(new SettingsPack().downloadRateLimit(limit));
    }

    public int uploadRateLimit() {
        if (this.session == null) {
            return 0;
        }
        return this.settings().uploadRateLimit();
    }

    public void uploadRateLimit(int limit) {
        if (this.session == null) {
            return;
        }
        this.applySettings(new SettingsPack().uploadRateLimit(limit));
    }

    public int maxActiveDownloads() {
        if (this.session == null) {
            return 0;
        }
        return this.settings().activeDownloads();
    }

    public void maxActiveDownloads(int limit) {
        if (this.session == null) {
            return;
        }
        this.applySettings(new SettingsPack().activeDownloads(limit));
    }

    public int maxActiveSeeds() {
        if (this.session == null) {
            return 0;
        }
        return this.settings().activeSeeds();
    }

    public void maxActiveSeeds(int limit) {
        if (this.session == null) {
            return;
        }
        this.applySettings(new SettingsPack().activeSeeds(limit));
    }

    public int maxConnections() {
        if (this.session == null) {
            return 0;
        }
        return this.settings().connectionsLimit();
    }

    public void maxConnections(int limit) {
        if (this.session == null) {
            return;
        }
        this.applySettings(new SettingsPack().connectionsLimit(limit));
    }

    public int maxPeers() {
        if (this.session == null) {
            return 0;
        }
        return this.settings().maxPeerlistSize();
    }

    public void maxPeers(int limit) {
        if (this.session == null) {
            return;
        }
        this.applySettings(new SettingsPack().maxPeerlistSize(limit));
    }

    public String listenInterfaces() {
        if (this.session == null) {
            return null;
        }
        return this.settings().listenInterfaces();
    }

    public void listenInterfaces(String value) {
        if (this.session == null) {
            return;
        }
        this.applySettings(new SettingsPack().listenInterfaces(value));
    }

    public void postSessionStats() {
        if (this.session != null) {
            this.session.post_session_stats();
        }
    }

    public void postDhtStats() {
        if (this.session != null) {
            this.session.post_dht_stats();
        }
    }

    public void postTorrentUpdates() {
        if (this.session != null) {
            this.session.post_torrent_updates();
        }
    }

    public boolean isDhtRunning() {
        return this.session != null ? this.session.is_dht_running() : false;
    }

    public void startDht() {
        this.toggleDht(true);
    }

    public void stopDht() {
        this.toggleDht(false);
    }

    public TorrentHandle find(Sha1Hash sha1) {
        if (this.session == null) {
            return null;
        }
        torrent_handle th = this.session.find_torrent(sha1.swig());
        if (th != null && !th.is_valid()) {
            LOG.warn("SessionManager.find(Sha1Hash " + sha1.toHex() + ") found, but it is invalid");
        }
        return th != null && th.is_valid() ? new TorrentHandle(th) : null;
    }

    public void download(TorrentInfo ti, File saveDir, File resumeFile, Priority[] priorities, List<TcpEndpoint> peers, torrent_flags_t flags) {
        if (this.session == null) {
            return;
        }
        if (!ti.isValid()) {
            throw new IllegalArgumentException("torrent info not valid");
        }
        torrent_handle th = this.session.find_torrent(ti.swig().info_hash());
        if (th != null && th.is_valid()) {
            if (priorities != null) {
                if (ti.numFiles() != priorities.length) {
                    throw new IllegalArgumentException("priorities count should be equals to the number of files");
                }
                th.prioritize_files2(Priority.array2vector(priorities));
            } else {
                priorities = Priority.array(Priority.NORMAL, ti.numFiles());
                th.prioritize_files2(Priority.array2vector(priorities));
            }
            return;
        }
        add_torrent_params p = null;
        if (resumeFile != null) {
            try {
                byte[] data = Files.bytes(resumeFile);
                error_code ec = new error_code();
                p = add_torrent_params.read_resume_data(Vectors.bytes2byte_vector(data), ec);
                if (ec.value() != 0) {
                    throw new IllegalArgumentException("Unable to read the resume data: " + ec.message());
                }
            }
            catch (Throwable e) {
                LOG.warn("Unable to set resume data", e);
            }
        }
        if (p == null) {
            p = add_torrent_params.create_instance();
        }
        p.set_ti(ti.swig());
        if (saveDir != null) {
            p.setSave_path(saveDir.getAbsolutePath());
        }
        if (priorities != null) {
            if (ti.files().numFiles() != priorities.length) {
                throw new IllegalArgumentException("priorities count should be equals to the number of files");
            }
            th.prioritize_files2(Priority.array2vector(priorities));
        }
        if (peers != null && !peers.isEmpty()) {
            tcp_endpoint_vector v = new tcp_endpoint_vector();
            for (TcpEndpoint endp : peers) {
                v.add(endp.swig());
            }
            p.set_peers(v);
        }
        p.setFlags(p.getFlags().or_(flags));
        this.session.async_add_torrent(p);
    }

    public void download(String magnetUri, File saveDir, torrent_flags_t flags) {
        if (this.session == null) {
            return;
        }
        error_code ec = new error_code();
        add_torrent_params p = add_torrent_params.parse_magnet_uri(magnetUri, ec);
        if (ec.value() != 0) {
            throw new IllegalArgumentException(ec.message());
        }
        sha1_hash info_hash = p.getInfo_hashes().get_best();
        torrent_handle th = this.session.find_torrent(info_hash);
        if (th != null && th.is_valid()) {
            return;
        }
        if (saveDir != null) {
            p.setSave_path(saveDir.getAbsolutePath());
        }
        if ("".equals(p.getName())) {
            p.setName(info_hash.to_hex());
        }
        p.setFlags(p.getFlags().or_(flags));
        this.session.async_add_torrent(p);
    }

    public void download(TorrentInfo ti, File saveDir) {
        this.download(ti, saveDir, null, null, null, new torrent_flags_t());
    }

    public void remove(TorrentHandle th, remove_flags_t options) {
        if (this.session != null && th.isValid()) {
            this.session.remove_torrent(th.swig(), options);
        }
    }

    public void remove(TorrentHandle th) {
        if (this.session != null && th.isValid()) {
            this.session.remove_torrent(th.swig());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] fetchMagnet(String uri, int timeout, File tempDir) {
        if (this.session == null) {
            return null;
        }
        error_code ec = new error_code();
        add_torrent_params p = add_torrent_params.parse_magnet_uri(uri, ec);
        if (ec.value() != 0) {
            throw new IllegalArgumentException(ec.message());
        }
        final info_hash_t info_hashes = p.getInfo_hashes();
        final AtomicReference data = new AtomicReference();
        final CountDownLatch signal = new CountDownLatch(1);
        AlertListener listener = new AlertListener(){

            @Override
            public int[] types() {
                return METADATA_ALERT_TYPES;
            }

            @Override
            public void alert(Alert<?> alert2) {
                torrent_handle th = ((torrent_alert)((TorrentAlert)alert2).swig()).getHandle();
                if (th == null || !th.is_valid() || th.info_hash().op_ne(info_hashes.get_best())) {
                    return;
                }
                AlertType type = alert2.type();
                if (type.equals((Object)AlertType.METADATA_RECEIVED)) {
                    ((TorrentAlert)alert2).handle().saveResumeData(TorrentHandle.SAVE_INFO_DICT);
                }
                if (type.equals((Object)AlertType.SAVE_RESUME_DATA)) {
                    try {
                        add_torrent_params resumeDataParams = ((SaveResumeDataAlert)alert2).params().swig();
                        byte_vector bytes = libtorrent.write_torrent_file_buf_ex(resumeDataParams);
                        data.set(Vectors.byte_vector2bytes(bytes));
                        signal.countDown();
                    }
                    catch (Throwable e) {
                        LOG.error("Error building magnet torrent data", e);
                    }
                }
                if (type.equals((Object)AlertType.METADATA_FAILED)) {
                    LOG.error("Error fetching magnet metadata");
                    signal.countDown();
                }
                if (type.equals((Object)AlertType.SAVE_RESUME_DATA_FAILED)) {
                    LOG.error("Error saving resume data");
                    signal.countDown();
                }
            }
        };
        this.addListener(listener);
        boolean add = false;
        torrent_handle th = null;
        try {
            this.syncMagnet.lock();
            try {
                th = this.session.find_torrent(info_hashes.get_best());
                if (th != null && th.is_valid()) {
                    add = false;
                    torrent_info ti = th.torrent_file_ptr();
                    if (ti != null && ti.is_valid()) {
                        th.save_resume_data(torrent_handle.save_info_dict);
                    }
                } else {
                    add = true;
                }
                if (add) {
                    p.setName(FETCH_MAGNET_DOWNLOAD_KEY + uri);
                    p.setSave_path(tempDir.getAbsolutePath());
                    torrent_flags_t flags = p.getFlags();
                    flags = flags.and_(TorrentFlags.AUTO_MANAGED.inv());
                    flags = flags.or_(TorrentFlags.UPLOAD_MODE);
                    flags = flags.or_(TorrentFlags.STOP_WHEN_READY);
                    p.setFlags(flags);
                    ec.clear();
                    th = this.session.add_torrent(p, ec);
                    th.resume();
                }
            }
            finally {
                this.syncMagnet.unlock();
            }
            signal.await(timeout, TimeUnit.SECONDS);
        }
        catch (Throwable e) {
            LOG.error("Error fetching magnet", e);
        }
        finally {
            this.removeListener(listener);
            if (this.session != null && add && th != null && th.is_valid()) {
                this.session.remove_torrent(th);
            }
        }
        return (byte[])data.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry dhtGetItem(Sha1Hash sha1, int timeout) {
        if (this.session == null) {
            return null;
        }
        final sha1_hash target = sha1.swig();
        final Entry[] result = new Entry[]{null};
        final CountDownLatch signal = new CountDownLatch(1);
        AlertListener listener = new AlertListener(){

            @Override
            public int[] types() {
                return DHT_IMMUTABLE_ITEM_TYPES;
            }

            @Override
            public void alert(Alert<?> alert2) {
                DhtImmutableItemAlert a = (DhtImmutableItemAlert)alert2;
                if (target.op_eq(((dht_immutable_item_alert)a.swig()).getTarget())) {
                    result[0] = new Entry(new entry(((dht_immutable_item_alert)a.swig()).getItem()));
                    signal.countDown();
                }
            }
        };
        this.addListener(listener);
        try {
            this.session.dht_get_item(target);
            signal.await(timeout, TimeUnit.SECONDS);
        }
        catch (Throwable e) {
            LOG.error("Error getting immutable item", e);
        }
        finally {
            this.removeListener(listener);
        }
        return result[0];
    }

    public Sha1Hash dhtPutItem(Entry entry2) {
        return this.session != null ? new SessionHandle(this.session).dhtPutItem(entry2) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableItem dhtGetItem(final byte[] key, final byte[] salt, int timeout) {
        if (this.session == null) {
            return null;
        }
        final MutableItem[] result = new MutableItem[]{null};
        final CountDownLatch signal = new CountDownLatch(1);
        AlertListener listener = new AlertListener(){

            @Override
            public int[] types() {
                return DHT_MUTABLE_ITEM_TYPES;
            }

            @Override
            public void alert(Alert<?> alert2) {
                DhtMutableItemAlert a = (DhtMutableItemAlert)alert2;
                boolean sameKey = Arrays.equals(key, a.key());
                boolean sameSalt = Arrays.equals(salt, a.salt());
                if (sameKey && sameSalt) {
                    MutableItem item;
                    Entry e = new Entry(new entry(((dht_mutable_item_alert)a.swig()).getItem()));
                    result[0] = item = new MutableItem(e, a.signature(), a.seq());
                    signal.countDown();
                }
            }
        };
        this.addListener(listener);
        try {
            new SessionHandle(this.session).dhtGetItem(key, salt);
            signal.await(timeout, TimeUnit.SECONDS);
        }
        catch (Throwable e) {
            LOG.error("Error getting mutable item", e);
        }
        finally {
            this.removeListener(listener);
        }
        return result[0];
    }

    public void dhtPutItem(byte[] publicKey, byte[] privateKey, Entry entry2, byte[] salt) {
        if (this.session != null) {
            new SessionHandle(this.session).dhtPutItem(publicKey, privateKey, entry2, salt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<TcpEndpoint> dhtGetPeers(Sha1Hash sha1, int timeout) {
        final ArrayList<TcpEndpoint> result = new ArrayList<TcpEndpoint>();
        if (this.session == null) {
            return result;
        }
        final sha1_hash target = sha1.swig();
        final CountDownLatch signal = new CountDownLatch(1);
        AlertListener listener = new AlertListener(){

            @Override
            public int[] types() {
                return DHT_GET_PEERS_REPLY_ALERT_TYPES;
            }

            @Override
            public void alert(Alert<?> alert2) {
                DhtGetPeersReplyAlert a = (DhtGetPeersReplyAlert)alert2;
                if (target.op_eq(((dht_get_peers_reply_alert)a.swig()).getInfo_hash())) {
                    result.addAll(a.peers());
                    signal.countDown();
                }
            }
        };
        this.addListener(listener);
        try {
            this.session.dht_get_peers(target);
            signal.await(timeout, TimeUnit.SECONDS);
        }
        catch (Throwable e) {
            LOG.error("Error getting peers from the dht", e);
        }
        finally {
            this.removeListener(listener);
        }
        return result;
    }

    public void dhtAnnounce(Sha1Hash sha1, int port, int flags) {
        if (this.session != null) {
            this.session.dht_announce_ex(sha1.swig(), port, (byte)flags);
        }
    }

    public void dhtAnnounce(Sha1Hash sha1) {
        if (this.session != null) {
            this.session.dht_announce_ex(sha1.swig());
        }
    }

    public void moveStorage(File dir) {
        if (this.session == null) {
            return;
        }
        try {
            torrent_handle_vector v = this.session.get_torrents();
            int size = v.size();
            String path = dir.getAbsolutePath();
            for (int i = 0; i < size; ++i) {
                boolean incomplete;
                torrent_handle th = v.get(i);
                torrent_status ts = th.status();
                boolean bl = incomplete = !ts.getIs_seeding() && !ts.getIs_finished();
                if (!th.is_valid() || !incomplete) continue;
                th.move_storage(path);
            }
        }
        catch (Throwable e) {
            LOG.error("Error changing save path for session", e);
        }
    }

    public byte[] saveState() {
        if (this.session == null) {
            return null;
        }
        session_params params = this.session.session_state();
        byte_vector v = session_params.write_session_params_buf(params);
        return Vectors.byte_vector2bytes(v);
    }

    public void reopenNetworkSockets() {
        if (this.session != null) {
            this.session.reopen_network_sockets();
        }
    }

    public String magnetPeers() {
        if (this.session == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (this.externalAddress != null && this.externalPort > 0) {
            sb.append("&x.pe=");
            sb.append(this.externalAddress).append(":").append(this.externalPort);
        }
        for (String endp : this.listenEndpoints.values()) {
            sb.append("&x.pe=").append(endp);
        }
        return sb.toString();
    }

    public Throwable lastAlertError() {
        return this.lastAlertError;
    }

    protected void onBeforeStart() {
    }

    protected void onAfterStart() {
    }

    protected void onBeforeStop() {
    }

    protected void onAfterStop() {
    }

    protected void onApplySettings(SettingsPack sp) {
    }

    private void resetState() {
        this.stats.clear();
        this.firewalled = true;
        this.listenEndpoints.clear();
        this.externalAddress = null;
        this.alertsLoop = null;
    }

    private void modifyListeners(boolean add, AlertListener listener) {
        if (listener == null) {
            return;
        }
        int[] types = listener.types();
        if (types == null) {
            this.modifyListeners(add, Alerts.NUM_ALERT_TYPES, listener);
        } else {
            for (int i = 0; i < types.length; ++i) {
                this.modifyListeners(add, types[i], listener);
            }
        }
    }

    private synchronized void modifyListeners(boolean add, int type, AlertListener listener) {
        this.listeners[type] = add ? AlertMulticaster.add(this.listeners[type], listener) : AlertMulticaster.remove(this.listeners[type], listener);
    }

    private void fireAlert(Alert<?> a, int type) {
        AlertListener listener = this.listeners[type];
        if (listener != null) {
            try {
                listener.alert(a);
            }
            catch (Throwable e) {
                LOG.warn("Error calling alert listener: " + e.getMessage());
                this.lastAlertError = e;
            }
        }
    }

    private void onListenSucceeded(ListenSucceededAlert alert2) {
        try {
            if (alert2.socketType() == SocketType.TCP) {
                return;
            }
            Address addr = alert2.address();
            if (addr.isV4()) {
                this.externalPort = alert2.port();
            }
            if (addr.isLoopback() || addr.isMulticast() || addr.isUnspecified()) {
                return;
            }
            String address2 = addr.toString();
            int port = alert2.port();
            if (address2.contains("invalid")) {
                return;
            }
            if (address2.startsWith("127.") || address2.startsWith("fe80::")) {
                return;
            }
            String endp = (String)(addr.isV6() ? "[" + address2 + "]" : address2) + ":" + port;
            this.listenEndpoints.put(address2, endp);
        }
        catch (Throwable e) {
            LOG.error("Error adding listen endpoint to internal list", e);
        }
    }

    private void onListenFailed(ListenFailedAlert alert2) {
        LOG.error("onListenFailed(): iface= " + alert2.listenInterface() + ", address= " + String.valueOf(alert2.address()) + ", port= " + alert2.port() + ", socketType= " + String.valueOf((Object)alert2.socketType()) + ", errorCode= " + String.valueOf(alert2.error()));
        LOG.error("onListenFailed(): error_message=" + alert2.message());
    }

    private void toggleDht(boolean on) {
        if (this.session == null || this.isDhtRunning() == on) {
            return;
        }
        SettingsPack sp = new SettingsPack();
        sp.setEnableDht(on);
        this.applySettings(sp);
    }

    private void onExternalIpAlert(ExternalIpAlert alert2) {
        try {
            address addr = ((external_ip_alert)alert2.swig()).get_external_address();
            if (!addr.is_v4()) {
                return;
            }
            String address2 = alert2.externalAddress().toString();
            if (address2.contains("invalid")) {
                return;
            }
            this.externalAddress = address2;
        }
        catch (Throwable e) {
            LOG.error("Error saving reported external ip", e);
        }
    }

    private boolean isFetchMagnetDownload(AddTorrentAlert alert2) {
        String name = alert2.torrentName();
        return name != null && name.contains(FETCH_MAGNET_DOWNLOAD_KEY);
    }

    private static alert_category_t alertMask(boolean logging) {
        alert_category_t mask = alert.all_categories;
        if (!logging) {
            alert_category_t log_mask = alert.session_log_notification;
            log_mask = log_mask.or_(alert.torrent_log_notification);
            log_mask = log_mask.or_(alert.peer_log_notification);
            log_mask = log_mask.or_(alert.dht_log_notification);
            log_mask = log_mask.or_(alert.port_mapping_log_notification);
            log_mask = log_mask.or_(alert.picker_log_notification);
            mask = mask.and_(log_mask.inv());
        }
        return mask;
    }

    private static String defaultDHTBootstrapNodes() {
        StringBuilder sb = new StringBuilder();
        sb.append("dht.libtorrent.org:25401").append(",");
        sb.append("router.bittorrent.com:6881").append(",");
        sb.append("router.utorrent.com:6881").append(",");
        sb.append("dht.transmissionbt.com:6881").append(",");
        sb.append("router.silotis.us:6881");
        return sb.toString();
    }

    private static boolean isSpecialType(int type) {
        return type == AlertType.SESSION_STATS.swig() || type == AlertType.STATE_UPDATE.swig() || type == AlertType.SESSION_STATS_HEADER.swig();
    }

    private void alertsLoop() {
        Runnable r = new Runnable(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void run() {
                alert_ptr_vector v = new alert_ptr_vector();
                while (true) {
                    long now;
                    block17: {
                        if (SessionManager.this.session == null) {
                            return;
                        }
                        alert ptr = SessionManager.this.session.wait_for_alert_ms(500L);
                        if (SessionManager.this.session == null) {
                            return;
                        }
                        if (ptr == null) break block17;
                        SessionManager.this.session.pop_alerts(v);
                        long size = v.size();
                        int i = 0;
                        while ((long)i < size) {
                            block18: {
                                alert a = v.get(i);
                                int type = a.type();
                                Alert alert2 = null;
                                switch (AlertType.fromSwig(type)) {
                                    case SESSION_STATS: {
                                        alert2 = Alerts.cast(a);
                                        SessionManager.this.stats.update((SessionStatsAlert)alert2);
                                        break;
                                    }
                                    case PORTMAP: {
                                        SessionManager.this.firewalled = false;
                                        break;
                                    }
                                    case PORTMAP_ERROR: {
                                        SessionManager.this.firewalled = true;
                                        break;
                                    }
                                    case LISTEN_SUCCEEDED: {
                                        alert2 = Alerts.cast(a);
                                        SessionManager.this.onListenSucceeded((ListenSucceededAlert)alert2);
                                        break;
                                    }
                                    case LISTEN_FAILED: {
                                        alert2 = Alerts.cast(a);
                                        SessionManager.this.onListenFailed((ListenFailedAlert)alert2);
                                        break;
                                    }
                                    case EXTERNAL_IP: {
                                        alert2 = Alerts.cast(a);
                                        SessionManager.this.onExternalIpAlert((ExternalIpAlert)alert2);
                                        break;
                                    }
                                    case ADD_TORRENT: {
                                        alert2 = Alerts.cast(a);
                                        if (SessionManager.this.isFetchMagnetDownload((AddTorrentAlert)alert2)) break block18;
                                    }
                                }
                                if (SessionManager.this.listeners[type] != null) {
                                    if (alert2 == null) {
                                        alert2 = Alerts.cast(a);
                                    }
                                    SessionManager.this.fireAlert(alert2, type);
                                }
                                if (!SessionManager.isSpecialType(type) && SessionManager.this.listeners[Alerts.NUM_ALERT_TYPES] != null) {
                                    if (alert2 == null) {
                                        alert2 = Alerts.cast(a);
                                    }
                                    SessionManager.this.fireAlert(alert2, Alerts.NUM_ALERT_TYPES);
                                }
                            }
                            ++i;
                        }
                        v.clear();
                    }
                    if ((now = System.currentTimeMillis()) - SessionManager.this.lastStatsRequestTime < 1000L) continue;
                    SessionManager.this.lastStatsRequestTime = now;
                    SessionManager.this.postSessionStats();
                    SessionManager.this.postTorrentUpdates();
                }
            }
        };
        Thread t = new Thread(r, "SessionManager-alertsLoop");
        t.setDaemon(true);
        t.start();
        this.alertsLoop = t;
    }

    public static final class MutableItem {
        public final Entry item;
        public final byte[] signature;
        public final long seq;

        private MutableItem(Entry item, byte[] signature, long seq) {
            this.item = item;
            this.signature = signature;
            this.seq = seq;
        }
    }
}

