/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.jlibtorrent;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

final class Files {
    private static final int EOF = -1;

    private Files() {
    }

    public static byte[] bytes(File file) throws IOException {
        FileInputStream in = null;
        try {
            in = Files.openInputStream(file);
            byte[] byArray = Files.toByteArray((InputStream)in, file.length());
            return byArray;
        }
        finally {
            Files.closeQuietly(in);
        }
    }

    private static FileInputStream openInputStream(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canRead()) {
                throw new IOException("File '" + file + "' cannot be read");
            }
        } else {
            throw new FileNotFoundException("File '" + file + "' does not exist");
        }
        return new FileInputStream(file);
    }

    private static byte[] toByteArray(InputStream input, long size) throws IOException {
        if (size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Size cannot be greater than Integer max value: " + size);
        }
        return Files.toByteArray(input, (int)size);
    }

    private static byte[] toByteArray(InputStream input, int size) throws IOException {
        int offset;
        int readed;
        if (size < 0) {
            throw new IllegalArgumentException("Size must be equal or greater than zero: " + size);
        }
        if (size == 0) {
            return new byte[0];
        }
        byte[] data = new byte[size];
        for (offset = 0; offset < size && (readed = input.read(data, offset, size - offset)) != -1; offset += readed) {
        }
        if (offset != size) {
            throw new IOException("Unexpected readed size. current: " + offset + ", excepted: " + size);
        }
        return data;
    }

    static void closeQuietly(InputStream input) {
        Files.closeQuietly((Closeable)input);
    }

    static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

